/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessPointsRequest extends S3ControlRequest implements
        ToCopyableBuilder<ListAccessPointsRequest.Builder, ListAccessPointsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(ListAccessPointsRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Bucket")
            .getter(getter(ListAccessPointsRequest::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("bucket")
                    .unmarshallLocationName("bucket").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListAccessPointsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(ListAccessPointsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults")
                    .unmarshallLocationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            BUCKET_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String accountId;

    private final String bucket;

    private final String nextToken;

    private final Integer maxResults;

    private ListAccessPointsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.bucket = builder.bucket;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Web Services account ID for owner of the bucket whose access points you want to list.
     * </p>
     * 
     * @return The Amazon Web Services account ID for owner of the bucket whose access points you want to list.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The name of the bucket whose associated access points you want to list.
     * </p>
     * <p>
     * For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the
     * x-amz-outpost-id as well.
     * </p>
     * <p>
     * For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN
     * of the bucket accessed in the format
     * <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>
     * . For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account
     * <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of
     * <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL
     * encoded.
     * </p>
     * 
     * @return The name of the bucket whose associated access points you want to list.</p>
     *         <p>
     *         For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the
     *         x-amz-outpost-id as well.
     *         </p>
     *         <p>
     *         For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify
     *         the ARN of the bucket accessed in the format
     *         <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>
     *         . For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by
     *         account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of
     *         <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must
     *         be URL encoded.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * A continuation token. If a previous call to <code>ListAccessPoints</code> returned a continuation token in the
     * <code>NextToken</code> field, then providing that value here causes Amazon S3 to retrieve the next page of
     * results.
     * </p>
     * 
     * @return A continuation token. If a previous call to <code>ListAccessPoints</code> returned a continuation token
     *         in the <code>NextToken</code> field, then providing that value here causes Amazon S3 to retrieve the next
     *         page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of access points that you want to include in the list. If the specified bucket has more than
     * this number of access points, then the response will include a continuation token in the <code>NextToken</code>
     * field that you can use to retrieve the next page of access points.
     * </p>
     * 
     * @return The maximum number of access points that you want to include in the list. If the specified bucket has
     *         more than this number of access points, then the response will include a continuation token in the
     *         <code>NextToken</code> field that you can use to retrieve the next page of access points.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessPointsRequest)) {
            return false;
        }
        ListAccessPointsRequest other = (ListAccessPointsRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(bucket(), other.bucket())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessPointsRequest").add("AccountId", accountId()).add("Bucket", bucket())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessPointsRequest, T> g) {
        return obj -> g.apply((ListAccessPointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAccessPointsRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID for owner of the bucket whose access points you want to list.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID for owner of the bucket whose access points you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The name of the bucket whose associated access points you want to list.
         * </p>
         * <p>
         * For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the
         * x-amz-outpost-id as well.
         * </p>
         * <p>
         * For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the
         * ARN of the bucket accessed in the format
         * <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>
         * . For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by
         * account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of
         * <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be
         * URL encoded.
         * </p>
         * 
         * @param bucket
         *        The name of the bucket whose associated access points you want to list.</p>
         *        <p>
         *        For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and
         *        the x-amz-outpost-id as well.
         *        </p>
         *        <p>
         *        For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must
         *        specify the ARN of the bucket accessed in the format
         *        <code>arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;</code>
         *        . For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned
         *        by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of
         *        <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value
         *        must be URL encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * A continuation token. If a previous call to <code>ListAccessPoints</code> returned a continuation token in
         * the <code>NextToken</code> field, then providing that value here causes Amazon S3 to retrieve the next page
         * of results.
         * </p>
         * 
         * @param nextToken
         *        A continuation token. If a previous call to <code>ListAccessPoints</code> returned a continuation
         *        token in the <code>NextToken</code> field, then providing that value here causes Amazon S3 to retrieve
         *        the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of access points that you want to include in the list. If the specified bucket has more
         * than this number of access points, then the response will include a continuation token in the
         * <code>NextToken</code> field that you can use to retrieve the next page of access points.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of access points that you want to include in the list. If the specified bucket has
         *        more than this number of access points, then the response will include a continuation token in the
         *        <code>NextToken</code> field that you can use to retrieve the next page of access points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private String bucket;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessPointsRequest model) {
            super(model);
            accountId(model.accountId);
            bucket(model.bucket);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccessPointsRequest build() {
            return new ListAccessPointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
