/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the specified job's generated manifest. Batch Operations jobs created with a ManifestGenerator populate
 * details of this descriptor after execution of the ManifestGenerator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3GeneratedManifestDescriptor implements SdkPojo, Serializable,
        ToCopyableBuilder<S3GeneratedManifestDescriptor.Builder, S3GeneratedManifestDescriptor> {
    private static final SdkField<String> FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Format")
            .getter(getter(S3GeneratedManifestDescriptor::formatAsString))
            .setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format")
                    .unmarshallLocationName("Format").build()).build();

    private static final SdkField<JobManifestLocation> LOCATION_FIELD = SdkField
            .<JobManifestLocation> builder(MarshallingType.SDK_POJO)
            .memberName("Location")
            .getter(getter(S3GeneratedManifestDescriptor::location))
            .setter(setter(Builder::location))
            .constructor(JobManifestLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String format;

    private final JobManifestLocation location;

    private S3GeneratedManifestDescriptor(BuilderImpl builder) {
        this.format = builder.format;
        this.location = builder.location;
    }

    /**
     * <p>
     * The format of the generated manifest.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link GeneratedManifestFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the generated manifest.
     * @see GeneratedManifestFormat
     */
    public final GeneratedManifestFormat format() {
        return GeneratedManifestFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the generated manifest.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link GeneratedManifestFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the generated manifest.
     * @see GeneratedManifestFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * Returns the value of the Location property for this object.
     * 
     * @return The value of the Location property for this object.
     */
    public final JobManifestLocation location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3GeneratedManifestDescriptor)) {
            return false;
        }
        S3GeneratedManifestDescriptor other = (S3GeneratedManifestDescriptor) obj;
        return Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3GeneratedManifestDescriptor").add("Format", formatAsString()).add("Location", location())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3GeneratedManifestDescriptor, T> g) {
        return obj -> g.apply((S3GeneratedManifestDescriptor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3GeneratedManifestDescriptor> {
        /**
         * <p>
         * The format of the generated manifest.
         * </p>
         * 
         * @param format
         *        The format of the generated manifest.
         * @see GeneratedManifestFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedManifestFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the generated manifest.
         * </p>
         * 
         * @param format
         *        The format of the generated manifest.
         * @see GeneratedManifestFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedManifestFormat
         */
        Builder format(GeneratedManifestFormat format);

        /**
         * Sets the value of the Location property for this object.
         *
         * @param location
         *        The new value for the Location property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(JobManifestLocation location);

        /**
         * Sets the value of the Location property for this object.
         *
         * This is a convenience method that creates an instance of the {@link JobManifestLocation.Builder} avoiding the
         * need to create one manually via {@link JobManifestLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobManifestLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #location(JobManifestLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link JobManifestLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(JobManifestLocation)
         */
        default Builder location(Consumer<JobManifestLocation.Builder> location) {
            return location(JobManifestLocation.builder().applyMutation(location).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private JobManifestLocation location;

        private BuilderImpl() {
        }

        private BuilderImpl(S3GeneratedManifestDescriptor model) {
            format(model.format);
            location(model.location);
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(GeneratedManifestFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final JobManifestLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(JobManifestLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(JobManifestLocation location) {
            this.location = location;
            return this;
        }

        @Override
        public S3GeneratedManifestDescriptor build() {
            return new S3GeneratedManifestDescriptor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
