/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container for the filter of the lifecycle rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecycleRuleFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecycleRuleFilter.Builder, LifecycleRuleFilter> {
    private static final SdkField<String> PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Prefix")
            .getter(getter(LifecycleRuleFilter::prefix))
            .setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix")
                    .unmarshallLocationName("Prefix").build()).build();

    private static final SdkField<S3Tag> TAG_FIELD = SdkField
            .<S3Tag> builder(MarshallingType.SDK_POJO)
            .memberName("Tag")
            .getter(getter(LifecycleRuleFilter::tag))
            .setter(setter(Builder::tag))
            .constructor(S3Tag::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").unmarshallLocationName("Tag")
                    .build()).build();

    private static final SdkField<LifecycleRuleAndOperator> AND_FIELD = SdkField
            .<LifecycleRuleAndOperator> builder(MarshallingType.SDK_POJO)
            .memberName("And")
            .getter(getter(LifecycleRuleFilter::and))
            .setter(setter(Builder::and))
            .constructor(LifecycleRuleAndOperator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("And").unmarshallLocationName("And")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_FIELD, TAG_FIELD,
            AND_FIELD));

    private static final long serialVersionUID = 1L;

    private final String prefix;

    private final S3Tag tag;

    private final LifecycleRuleAndOperator and;

    private LifecycleRuleFilter(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.tag = builder.tag;
        this.and = builder.and;
    }

    /**
     * <p>
     * Prefix identifying one or more objects to which the rule applies.
     * </p>
     * <important>
     * <p>
     * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML
     * requests. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML
     * related object key constraints</a>.
     * </p>
     * </important>
     * 
     * @return Prefix identifying one or more objects to which the rule applies.</p> <important>
     *         <p>
     *         Replacement must be made for object keys containing special characters (such as carriage returns) when
     *         using XML requests. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"
     *         > XML related object key constraints</a>.
     *         </p>
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * Returns the value of the Tag property for this object.
     * 
     * @return The value of the Tag property for this object.
     */
    public final S3Tag tag() {
        return tag;
    }

    /**
     * <p>
     * The container for the <code>AND</code> condition for the lifecycle rule.
     * </p>
     * 
     * @return The container for the <code>AND</code> condition for the lifecycle rule.
     */
    public final LifecycleRuleAndOperator and() {
        return and;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(tag());
        hashCode = 31 * hashCode + Objects.hashCode(and());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleRuleFilter)) {
            return false;
        }
        LifecycleRuleFilter other = (LifecycleRuleFilter) obj;
        return Objects.equals(prefix(), other.prefix()) && Objects.equals(tag(), other.tag())
                && Objects.equals(and(), other.and());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecycleRuleFilter").add("Prefix", prefix()).add("Tag", tag()).add("And", and()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "Tag":
            return Optional.ofNullable(clazz.cast(tag()));
        case "And":
            return Optional.ofNullable(clazz.cast(and()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecycleRuleFilter, T> g) {
        return obj -> g.apply((LifecycleRuleFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecycleRuleFilter> {
        /**
         * <p>
         * Prefix identifying one or more objects to which the rule applies.
         * </p>
         * <important>
         * <p>
         * Replacement must be made for object keys containing special characters (such as carriage returns) when using
         * XML requests. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">
         * XML related object key constraints</a>.
         * </p>
         * </important>
         * 
         * @param prefix
         *        Prefix identifying one or more objects to which the rule applies.</p> <important>
         *        <p>
         *        Replacement must be made for object keys containing special characters (such as carriage returns) when
         *        using XML requests. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"
         *        > XML related object key constraints</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * Sets the value of the Tag property for this object.
         *
         * @param tag
         *        The new value for the Tag property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tag(S3Tag tag);

        /**
         * Sets the value of the Tag property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3Tag.Builder} avoiding the need to
         * create one manually via {@link S3Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Tag.Builder#build()} is called immediately and its result is
         * passed to {@link #tag(S3Tag)}.
         * 
         * @param tag
         *        a consumer that will call methods on {@link S3Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tag(S3Tag)
         */
        default Builder tag(Consumer<S3Tag.Builder> tag) {
            return tag(S3Tag.builder().applyMutation(tag).build());
        }

        /**
         * <p>
         * The container for the <code>AND</code> condition for the lifecycle rule.
         * </p>
         * 
         * @param and
         *        The container for the <code>AND</code> condition for the lifecycle rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(LifecycleRuleAndOperator and);

        /**
         * <p>
         * The container for the <code>AND</code> condition for the lifecycle rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifecycleRuleAndOperator.Builder}
         * avoiding the need to create one manually via {@link LifecycleRuleAndOperator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecycleRuleAndOperator.Builder#build()} is called immediately
         * and its result is passed to {@link #and(LifecycleRuleAndOperator)}.
         * 
         * @param and
         *        a consumer that will call methods on {@link LifecycleRuleAndOperator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #and(LifecycleRuleAndOperator)
         */
        default Builder and(Consumer<LifecycleRuleAndOperator.Builder> and) {
            return and(LifecycleRuleAndOperator.builder().applyMutation(and).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String prefix;

        private S3Tag tag;

        private LifecycleRuleAndOperator and;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleRuleFilter model) {
            prefix(model.prefix);
            tag(model.tag);
            and(model.and);
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final S3Tag.Builder getTag() {
            return tag != null ? tag.toBuilder() : null;
        }

        public final void setTag(S3Tag.BuilderImpl tag) {
            this.tag = tag != null ? tag.build() : null;
        }

        @Override
        public final Builder tag(S3Tag tag) {
            this.tag = tag;
            return this;
        }

        public final LifecycleRuleAndOperator.Builder getAnd() {
            return and != null ? and.toBuilder() : null;
        }

        public final void setAnd(LifecycleRuleAndOperator.BuilderImpl and) {
            this.and = and != null ? and.build() : null;
        }

        @Override
        public final Builder and(LifecycleRuleAndOperator and) {
            this.and = and;
            return this;
        }

        @Override
        public LifecycleRuleFilter build() {
            return new LifecycleRuleFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
