/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for the bucket-level configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketLevel implements SdkPojo, Serializable, ToCopyableBuilder<BucketLevel.Builder, BucketLevel> {
    private static final SdkField<ActivityMetrics> ACTIVITY_METRICS_FIELD = SdkField
            .<ActivityMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("ActivityMetrics")
            .getter(getter(BucketLevel::activityMetrics))
            .setter(setter(Builder::activityMetrics))
            .constructor(ActivityMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityMetrics")
                    .unmarshallLocationName("ActivityMetrics").build()).build();

    private static final SdkField<PrefixLevel> PREFIX_LEVEL_FIELD = SdkField
            .<PrefixLevel> builder(MarshallingType.SDK_POJO)
            .memberName("PrefixLevel")
            .getter(getter(BucketLevel::prefixLevel))
            .setter(setter(Builder::prefixLevel))
            .constructor(PrefixLevel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixLevel")
                    .unmarshallLocationName("PrefixLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_METRICS_FIELD,
            PREFIX_LEVEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final ActivityMetrics activityMetrics;

    private final PrefixLevel prefixLevel;

    private BucketLevel(BuilderImpl builder) {
        this.activityMetrics = builder.activityMetrics;
        this.prefixLevel = builder.prefixLevel;
    }

    /**
     * <p>
     * A container for the bucket-level activity metrics for Amazon S3 Storage Lens
     * </p>
     * 
     * @return A container for the bucket-level activity metrics for Amazon S3 Storage Lens
     */
    public final ActivityMetrics activityMetrics() {
        return activityMetrics;
    }

    /**
     * <p>
     * A container for the bucket-level prefix-level metrics for S3 Storage Lens
     * </p>
     * 
     * @return A container for the bucket-level prefix-level metrics for S3 Storage Lens
     */
    public final PrefixLevel prefixLevel() {
        return prefixLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activityMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(prefixLevel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketLevel)) {
            return false;
        }
        BucketLevel other = (BucketLevel) obj;
        return Objects.equals(activityMetrics(), other.activityMetrics()) && Objects.equals(prefixLevel(), other.prefixLevel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BucketLevel").add("ActivityMetrics", activityMetrics()).add("PrefixLevel", prefixLevel())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivityMetrics":
            return Optional.ofNullable(clazz.cast(activityMetrics()));
        case "PrefixLevel":
            return Optional.ofNullable(clazz.cast(prefixLevel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketLevel, T> g) {
        return obj -> g.apply((BucketLevel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketLevel> {
        /**
         * <p>
         * A container for the bucket-level activity metrics for Amazon S3 Storage Lens
         * </p>
         * 
         * @param activityMetrics
         *        A container for the bucket-level activity metrics for Amazon S3 Storage Lens
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityMetrics(ActivityMetrics activityMetrics);

        /**
         * <p>
         * A container for the bucket-level activity metrics for Amazon S3 Storage Lens
         * </p>
         * This is a convenience that creates an instance of the {@link ActivityMetrics.Builder} avoiding the need to
         * create one manually via {@link ActivityMetrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActivityMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #activityMetrics(ActivityMetrics)}.
         * 
         * @param activityMetrics
         *        a consumer that will call methods on {@link ActivityMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityMetrics(ActivityMetrics)
         */
        default Builder activityMetrics(Consumer<ActivityMetrics.Builder> activityMetrics) {
            return activityMetrics(ActivityMetrics.builder().applyMutation(activityMetrics).build());
        }

        /**
         * <p>
         * A container for the bucket-level prefix-level metrics for S3 Storage Lens
         * </p>
         * 
         * @param prefixLevel
         *        A container for the bucket-level prefix-level metrics for S3 Storage Lens
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixLevel(PrefixLevel prefixLevel);

        /**
         * <p>
         * A container for the bucket-level prefix-level metrics for S3 Storage Lens
         * </p>
         * This is a convenience that creates an instance of the {@link PrefixLevel.Builder} avoiding the need to create
         * one manually via {@link PrefixLevel#builder()}.
         *
         * When the {@link Consumer} completes, {@link PrefixLevel.Builder#build()} is called immediately and its result
         * is passed to {@link #prefixLevel(PrefixLevel)}.
         * 
         * @param prefixLevel
         *        a consumer that will call methods on {@link PrefixLevel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prefixLevel(PrefixLevel)
         */
        default Builder prefixLevel(Consumer<PrefixLevel.Builder> prefixLevel) {
            return prefixLevel(PrefixLevel.builder().applyMutation(prefixLevel).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ActivityMetrics activityMetrics;

        private PrefixLevel prefixLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketLevel model) {
            activityMetrics(model.activityMetrics);
            prefixLevel(model.prefixLevel);
        }

        public final ActivityMetrics.Builder getActivityMetrics() {
            return activityMetrics != null ? activityMetrics.toBuilder() : null;
        }

        public final void setActivityMetrics(ActivityMetrics.BuilderImpl activityMetrics) {
            this.activityMetrics = activityMetrics != null ? activityMetrics.build() : null;
        }

        @Override
        @Transient
        public final Builder activityMetrics(ActivityMetrics activityMetrics) {
            this.activityMetrics = activityMetrics;
            return this;
        }

        public final PrefixLevel.Builder getPrefixLevel() {
            return prefixLevel != null ? prefixLevel.toBuilder() : null;
        }

        public final void setPrefixLevel(PrefixLevel.BuilderImpl prefixLevel) {
            this.prefixLevel = prefixLevel != null ? prefixLevel.build() : null;
        }

        @Override
        @Transient
        public final Builder prefixLevel(PrefixLevel prefixLevel) {
            this.prefixLevel = prefixLevel;
            return this;
        }

        @Override
        public BucketLevel build() {
            return new BucketLevel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
