/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMultiRegionAccessPointRequest extends S3ControlRequest implements
        ToCopyableBuilder<CreateMultiRegionAccessPointRequest.Builder, CreateMultiRegionAccessPointRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(CreateMultiRegionAccessPointRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateMultiRegionAccessPointRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<CreateMultiRegionAccessPointInput> DETAILS_FIELD = SdkField
            .<CreateMultiRegionAccessPointInput> builder(MarshallingType.SDK_POJO)
            .memberName("Details")
            .getter(getter(CreateMultiRegionAccessPointRequest::details))
            .setter(setter(Builder::details))
            .constructor(CreateMultiRegionAccessPointInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details")
                    .unmarshallLocationName("Details").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            CLIENT_TOKEN_FIELD, DETAILS_FIELD));

    private final String accountId;

    private final String clientToken;

    private final CreateMultiRegionAccessPointInput details;

    private CreateMultiRegionAccessPointRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.clientToken = builder.clientToken;
        this.details = builder.details;
    }

    /**
     * <p>
     * The Amazon Web Services account ID for the owner of the Multi-Region Access Point. The owner of the Multi-Region
     * Access Point also must own the underlying buckets.
     * </p>
     * 
     * @return The Amazon Web Services account ID for the owner of the Multi-Region Access Point. The owner of the
     *         Multi-Region Access Point also must own the underlying buckets.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * An idempotency token used to identify the request and guarantee that requests are unique.
     * </p>
     * 
     * @return An idempotency token used to identify the request and guarantee that requests are unique.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A container element containing details about the Multi-Region Access Point.
     * </p>
     * 
     * @return A container element containing details about the Multi-Region Access Point.
     */
    public final CreateMultiRegionAccessPointInput details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultiRegionAccessPointRequest)) {
            return false;
        }
        CreateMultiRegionAccessPointRequest other = (CreateMultiRegionAccessPointRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMultiRegionAccessPointRequest").add("AccountId", accountId())
                .add("ClientToken", clientToken()).add("Details", details()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMultiRegionAccessPointRequest, T> g) {
        return obj -> g.apply((CreateMultiRegionAccessPointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMultiRegionAccessPointRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID for the owner of the Multi-Region Access Point. The owner of the
         * Multi-Region Access Point also must own the underlying buckets.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID for the owner of the Multi-Region Access Point. The owner of the
         *        Multi-Region Access Point also must own the underlying buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * An idempotency token used to identify the request and guarantee that requests are unique.
         * </p>
         * 
         * @param clientToken
         *        An idempotency token used to identify the request and guarantee that requests are unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A container element containing details about the Multi-Region Access Point.
         * </p>
         * 
         * @param details
         *        A container element containing details about the Multi-Region Access Point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(CreateMultiRegionAccessPointInput details);

        /**
         * <p>
         * A container element containing details about the Multi-Region Access Point.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateMultiRegionAccessPointInput.Builder}
         * avoiding the need to create one manually via {@link CreateMultiRegionAccessPointInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateMultiRegionAccessPointInput.Builder#build()} is called
         * immediately and its result is passed to {@link #details(CreateMultiRegionAccessPointInput)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link CreateMultiRegionAccessPointInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(CreateMultiRegionAccessPointInput)
         */
        default Builder details(Consumer<CreateMultiRegionAccessPointInput.Builder> details) {
            return details(CreateMultiRegionAccessPointInput.builder().applyMutation(details).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private String clientToken;

        private CreateMultiRegionAccessPointInput details;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultiRegionAccessPointRequest model) {
            super(model);
            accountId(model.accountId);
            clientToken(model.clientToken);
            details(model.details);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final CreateMultiRegionAccessPointInput.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        public final void setDetails(CreateMultiRegionAccessPointInput.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        @Transient
        public final Builder details(CreateMultiRegionAccessPointInput details) {
            this.details = details;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMultiRegionAccessPointRequest build() {
            return new CreateMultiRegionAccessPointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
