/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMultiRegionAccessPointOperationResponse extends S3ControlResponse
        implements
        ToCopyableBuilder<DescribeMultiRegionAccessPointOperationResponse.Builder, DescribeMultiRegionAccessPointOperationResponse> {
    private static final SdkField<AsyncOperation> ASYNC_OPERATION_FIELD = SdkField
            .<AsyncOperation> builder(MarshallingType.SDK_POJO)
            .memberName("AsyncOperation")
            .getter(getter(DescribeMultiRegionAccessPointOperationResponse::asyncOperation))
            .setter(setter(Builder::asyncOperation))
            .constructor(AsyncOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsyncOperation")
                    .unmarshallLocationName("AsyncOperation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASYNC_OPERATION_FIELD));

    private final AsyncOperation asyncOperation;

    private DescribeMultiRegionAccessPointOperationResponse(BuilderImpl builder) {
        super(builder);
        this.asyncOperation = builder.asyncOperation;
    }

    /**
     * <p>
     * A container element containing the details of the asynchronous operation.
     * </p>
     * 
     * @return A container element containing the details of the asynchronous operation.
     */
    public final AsyncOperation asyncOperation() {
        return asyncOperation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(asyncOperation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMultiRegionAccessPointOperationResponse)) {
            return false;
        }
        DescribeMultiRegionAccessPointOperationResponse other = (DescribeMultiRegionAccessPointOperationResponse) obj;
        return Objects.equals(asyncOperation(), other.asyncOperation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMultiRegionAccessPointOperationResponse").add("AsyncOperation", asyncOperation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AsyncOperation":
            return Optional.ofNullable(clazz.cast(asyncOperation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMultiRegionAccessPointOperationResponse, T> g) {
        return obj -> g.apply((DescribeMultiRegionAccessPointOperationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMultiRegionAccessPointOperationResponse> {
        /**
         * <p>
         * A container element containing the details of the asynchronous operation.
         * </p>
         * 
         * @param asyncOperation
         *        A container element containing the details of the asynchronous operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asyncOperation(AsyncOperation asyncOperation);

        /**
         * <p>
         * A container element containing the details of the asynchronous operation.
         * </p>
         * This is a convenience that creates an instance of the {@link AsyncOperation.Builder} avoiding the need to
         * create one manually via {@link AsyncOperation#builder()}.
         *
         * When the {@link Consumer} completes, {@link AsyncOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #asyncOperation(AsyncOperation)}.
         * 
         * @param asyncOperation
         *        a consumer that will call methods on {@link AsyncOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #asyncOperation(AsyncOperation)
         */
        default Builder asyncOperation(Consumer<AsyncOperation.Builder> asyncOperation) {
            return asyncOperation(AsyncOperation.builder().applyMutation(asyncOperation).build());
        }
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private AsyncOperation asyncOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMultiRegionAccessPointOperationResponse model) {
            super(model);
            asyncOperation(model.asyncOperation);
        }

        public final AsyncOperation.Builder getAsyncOperation() {
            return asyncOperation != null ? asyncOperation.toBuilder() : null;
        }

        public final void setAsyncOperation(AsyncOperation.BuilderImpl asyncOperation) {
            this.asyncOperation = asyncOperation != null ? asyncOperation.build() : null;
        }

        @Override
        @Transient
        public final Builder asyncOperation(AsyncOperation asyncOperation) {
            this.asyncOperation = asyncOperation;
            return this;
        }

        @Override
        public DescribeMultiRegionAccessPointOperationResponse build() {
            return new DescribeMultiRegionAccessPointOperationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
