/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccessPointForObjectLambdaResponse extends S3ControlResponse implements
        ToCopyableBuilder<GetAccessPointForObjectLambdaResponse.Builder, GetAccessPointForObjectLambdaResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(GetAccessPointForObjectLambdaResponse::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<PublicAccessBlockConfiguration> PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD = SdkField
            .<PublicAccessBlockConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("PublicAccessBlockConfiguration")
            .getter(getter(GetAccessPointForObjectLambdaResponse::publicAccessBlockConfiguration))
            .setter(setter(Builder::publicAccessBlockConfiguration))
            .constructor(PublicAccessBlockConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlockConfiguration")
                    .unmarshallLocationName("PublicAccessBlockConfiguration").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate")
            .getter(getter(GetAccessPointForObjectLambdaResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate")
                    .unmarshallLocationName("CreationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD, CREATION_DATE_FIELD));

    private final String name;

    private final PublicAccessBlockConfiguration publicAccessBlockConfiguration;

    private final Instant creationDate;

    private GetAccessPointForObjectLambdaResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.publicAccessBlockConfiguration = builder.publicAccessBlockConfiguration;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The name of the Object Lambda Access Point.
     * </p>
     * 
     * @return The name of the Object Lambda Access Point.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Configuration to block all public access. This setting is turned on and can not be edited.
     * </p>
     * 
     * @return Configuration to block all public access. This setting is turned on and can not be edited.
     */
    public final PublicAccessBlockConfiguration publicAccessBlockConfiguration() {
        return publicAccessBlockConfiguration;
    }

    /**
     * <p>
     * The date and time when the specified Object Lambda Access Point was created.
     * </p>
     * 
     * @return The date and time when the specified Object Lambda Access Point was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(publicAccessBlockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessPointForObjectLambdaResponse)) {
            return false;
        }
        GetAccessPointForObjectLambdaResponse other = (GetAccessPointForObjectLambdaResponse) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(publicAccessBlockConfiguration(), other.publicAccessBlockConfiguration())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccessPointForObjectLambdaResponse").add("Name", name())
                .add("PublicAccessBlockConfiguration", publicAccessBlockConfiguration()).add("CreationDate", creationDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PublicAccessBlockConfiguration":
            return Optional.ofNullable(clazz.cast(publicAccessBlockConfiguration()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccessPointForObjectLambdaResponse, T> g) {
        return obj -> g.apply((GetAccessPointForObjectLambdaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAccessPointForObjectLambdaResponse> {
        /**
         * <p>
         * The name of the Object Lambda Access Point.
         * </p>
         * 
         * @param name
         *        The name of the Object Lambda Access Point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Configuration to block all public access. This setting is turned on and can not be edited.
         * </p>
         * 
         * @param publicAccessBlockConfiguration
         *        Configuration to block all public access. This setting is turned on and can not be edited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAccessBlockConfiguration(PublicAccessBlockConfiguration publicAccessBlockConfiguration);

        /**
         * <p>
         * Configuration to block all public access. This setting is turned on and can not be edited.
         * </p>
         * This is a convenience that creates an instance of the {@link PublicAccessBlockConfiguration.Builder} avoiding
         * the need to create one manually via {@link PublicAccessBlockConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link PublicAccessBlockConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #publicAccessBlockConfiguration(PublicAccessBlockConfiguration)}.
         * 
         * @param publicAccessBlockConfiguration
         *        a consumer that will call methods on {@link PublicAccessBlockConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicAccessBlockConfiguration(PublicAccessBlockConfiguration)
         */
        default Builder publicAccessBlockConfiguration(
                Consumer<PublicAccessBlockConfiguration.Builder> publicAccessBlockConfiguration) {
            return publicAccessBlockConfiguration(PublicAccessBlockConfiguration.builder()
                    .applyMutation(publicAccessBlockConfiguration).build());
        }

        /**
         * <p>
         * The date and time when the specified Object Lambda Access Point was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time when the specified Object Lambda Access Point was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private String name;

        private PublicAccessBlockConfiguration publicAccessBlockConfiguration;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessPointForObjectLambdaResponse model) {
            super(model);
            name(model.name);
            publicAccessBlockConfiguration(model.publicAccessBlockConfiguration);
            creationDate(model.creationDate);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PublicAccessBlockConfiguration.Builder getPublicAccessBlockConfiguration() {
            return publicAccessBlockConfiguration != null ? publicAccessBlockConfiguration.toBuilder() : null;
        }

        public final void setPublicAccessBlockConfiguration(
                PublicAccessBlockConfiguration.BuilderImpl publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration != null ? publicAccessBlockConfiguration.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder publicAccessBlockConfiguration(PublicAccessBlockConfiguration publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public GetAccessPointForObjectLambdaResponse build() {
            return new GetAccessPointForObjectLambdaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
