/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the format of a manifest. If the manifest is in CSV format, also describes the columns contained within the
 * manifest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobManifestSpec implements SdkPojo, Serializable, ToCopyableBuilder<JobManifestSpec.Builder, JobManifestSpec> {
    private static final SdkField<String> FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Format")
            .getter(getter(JobManifestSpec::formatAsString))
            .setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format")
                    .unmarshallLocationName("Format").build()).build();

    private static final SdkField<List<String>> FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Fields")
            .getter(getter(JobManifestSpec::fieldsAsStrings))
            .setter(setter(Builder::fieldsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields")
                    .unmarshallLocationName("Fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, FIELDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String format;

    private final List<String> fields;

    private JobManifestSpec(BuilderImpl builder) {
        this.format = builder.format;
        this.fields = builder.fields;
    }

    /**
     * <p>
     * Indicates which of the available formats the specified manifest uses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link JobManifestFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return Indicates which of the available formats the specified manifest uses.
     * @see JobManifestFormat
     */
    public final JobManifestFormat format() {
        return JobManifestFormat.fromValue(format);
    }

    /**
     * <p>
     * Indicates which of the available formats the specified manifest uses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link JobManifestFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return Indicates which of the available formats the specified manifest uses.
     * @see JobManifestFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this element
     * describes which columns contain the required data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this
     *         element describes which columns contain the required data.
     */
    public final List<JobManifestFieldName> fields() {
        return JobManifestFieldListCopier.copyStringToEnum(fields);
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this element
     * describes which columns contain the required data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this
     *         element describes which columns contain the required data.
     */
    public final List<String> fieldsAsStrings() {
        return fields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fieldsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobManifestSpec)) {
            return false;
        }
        JobManifestSpec other = (JobManifestSpec) obj;
        return Objects.equals(formatAsString(), other.formatAsString()) && hasFields() == other.hasFields()
                && Objects.equals(fieldsAsStrings(), other.fieldsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobManifestSpec").add("Format", formatAsString())
                .add("Fields", hasFields() ? fieldsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "Fields":
            return Optional.ofNullable(clazz.cast(fieldsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobManifestSpec, T> g) {
        return obj -> g.apply((JobManifestSpec) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobManifestSpec> {
        /**
         * <p>
         * Indicates which of the available formats the specified manifest uses.
         * </p>
         * 
         * @param format
         *        Indicates which of the available formats the specified manifest uses.
         * @see JobManifestFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobManifestFormat
         */
        Builder format(String format);

        /**
         * <p>
         * Indicates which of the available formats the specified manifest uses.
         * </p>
         * 
         * @param format
         *        Indicates which of the available formats the specified manifest uses.
         * @see JobManifestFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobManifestFormat
         */
        Builder format(JobManifestFormat format);

        /**
         * <p>
         * If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this element
         * describes which columns contain the required data.
         * </p>
         * 
         * @param fields
         *        If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this
         *        element describes which columns contain the required data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldsWithStrings(Collection<String> fields);

        /**
         * <p>
         * If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this element
         * describes which columns contain the required data.
         * </p>
         * 
         * @param fields
         *        If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this
         *        element describes which columns contain the required data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldsWithStrings(String... fields);

        /**
         * <p>
         * If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this element
         * describes which columns contain the required data.
         * </p>
         * 
         * @param fields
         *        If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this
         *        element describes which columns contain the required data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<JobManifestFieldName> fields);

        /**
         * <p>
         * If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this element
         * describes which columns contain the required data.
         * </p>
         * 
         * @param fields
         *        If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this
         *        element describes which columns contain the required data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(JobManifestFieldName... fields);
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private List<String> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobManifestSpec model) {
            format(model.format);
            fieldsWithStrings(model.fields);
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        @Transient
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        @Transient
        public final Builder format(JobManifestFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Collection<String> getFields() {
            if (fields instanceof SdkAutoConstructList) {
                return null;
            }
            return fields;
        }

        public final void setFields(Collection<String> fields) {
            this.fields = JobManifestFieldListCopier.copy(fields);
        }

        @Override
        @Transient
        public final Builder fieldsWithStrings(Collection<String> fields) {
            this.fields = JobManifestFieldListCopier.copy(fields);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fieldsWithStrings(String... fields) {
            fieldsWithStrings(Arrays.asList(fields));
            return this;
        }

        @Override
        @Transient
        public final Builder fields(Collection<JobManifestFieldName> fields) {
            this.fields = JobManifestFieldListCopier.copyEnumToString(fields);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fields(JobManifestFieldName... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        public JobManifestSpec build() {
            return new JobManifestSpec(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
