/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status information for a single Multi-Region Access Point Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiRegionAccessPointRegionalResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiRegionAccessPointRegionalResponse.Builder, MultiRegionAccessPointRegionalResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(MultiRegionAccessPointRegionalResponse::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> REQUEST_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequestStatus")
            .getter(getter(MultiRegionAccessPointRegionalResponse::requestStatus))
            .setter(setter(Builder::requestStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestStatus")
                    .unmarshallLocationName("RequestStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            REQUEST_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String requestStatus;

    private MultiRegionAccessPointRegionalResponse(BuilderImpl builder) {
        this.name = builder.name;
        this.requestStatus = builder.requestStatus;
    }

    /**
     * <p>
     * The name of the Region in the Multi-Region Access Point.
     * </p>
     * 
     * @return The name of the Region in the Multi-Region Access Point.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the Multi-Region Access Point in this Region.
     * </p>
     * 
     * @return The current status of the Multi-Region Access Point in this Region.
     */
    public final String requestStatus() {
        return requestStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(requestStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiRegionAccessPointRegionalResponse)) {
            return false;
        }
        MultiRegionAccessPointRegionalResponse other = (MultiRegionAccessPointRegionalResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(requestStatus(), other.requestStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiRegionAccessPointRegionalResponse").add("Name", name())
                .add("RequestStatus", requestStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RequestStatus":
            return Optional.ofNullable(clazz.cast(requestStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiRegionAccessPointRegionalResponse, T> g) {
        return obj -> g.apply((MultiRegionAccessPointRegionalResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiRegionAccessPointRegionalResponse> {
        /**
         * <p>
         * The name of the Region in the Multi-Region Access Point.
         * </p>
         * 
         * @param name
         *        The name of the Region in the Multi-Region Access Point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the Multi-Region Access Point in this Region.
         * </p>
         * 
         * @param requestStatus
         *        The current status of the Multi-Region Access Point in this Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestStatus(String requestStatus);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String requestStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiRegionAccessPointRegionalResponse model) {
            name(model.name);
            requestStatus(model.requestStatus);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRequestStatus() {
            return requestStatus;
        }

        public final void setRequestStatus(String requestStatus) {
            this.requestStatus = requestStatus;
        }

        @Override
        @Transient
        public final Builder requestStatus(String requestStatus) {
            this.requestStatus = requestStatus;
            return this;
        }

        @Override
        public MultiRegionAccessPointRegionalResponse build() {
            return new MultiRegionAccessPointRegionalResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
