/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for the prefix-level storage metrics for S3 Storage Lens.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrefixLevelStorageMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<PrefixLevelStorageMetrics.Builder, PrefixLevelStorageMetrics> {
    private static final SdkField<Boolean> IS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsEnabled")
            .getter(getter(PrefixLevelStorageMetrics::isEnabled))
            .setter(setter(Builder::isEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEnabled")
                    .unmarshallLocationName("IsEnabled").build()).build();

    private static final SdkField<SelectionCriteria> SELECTION_CRITERIA_FIELD = SdkField
            .<SelectionCriteria> builder(MarshallingType.SDK_POJO)
            .memberName("SelectionCriteria")
            .getter(getter(PrefixLevelStorageMetrics::selectionCriteria))
            .setter(setter(Builder::selectionCriteria))
            .constructor(SelectionCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionCriteria")
                    .unmarshallLocationName("SelectionCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_ENABLED_FIELD,
            SELECTION_CRITERIA_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isEnabled;

    private final SelectionCriteria selectionCriteria;

    private PrefixLevelStorageMetrics(BuilderImpl builder) {
        this.isEnabled = builder.isEnabled;
        this.selectionCriteria = builder.selectionCriteria;
    }

    /**
     * <p>
     * A container for whether prefix-level storage metrics are enabled.
     * </p>
     * 
     * @return A container for whether prefix-level storage metrics are enabled.
     */
    public final Boolean isEnabled() {
        return isEnabled;
    }

    /**
     * Returns the value of the SelectionCriteria property for this object.
     * 
     * @return The value of the SelectionCriteria property for this object.
     */
    public final SelectionCriteria selectionCriteria() {
        return selectionCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(selectionCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefixLevelStorageMetrics)) {
            return false;
        }
        PrefixLevelStorageMetrics other = (PrefixLevelStorageMetrics) obj;
        return Objects.equals(isEnabled(), other.isEnabled()) && Objects.equals(selectionCriteria(), other.selectionCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrefixLevelStorageMetrics").add("IsEnabled", isEnabled())
                .add("SelectionCriteria", selectionCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsEnabled":
            return Optional.ofNullable(clazz.cast(isEnabled()));
        case "SelectionCriteria":
            return Optional.ofNullable(clazz.cast(selectionCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrefixLevelStorageMetrics, T> g) {
        return obj -> g.apply((PrefixLevelStorageMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrefixLevelStorageMetrics> {
        /**
         * <p>
         * A container for whether prefix-level storage metrics are enabled.
         * </p>
         * 
         * @param isEnabled
         *        A container for whether prefix-level storage metrics are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEnabled(Boolean isEnabled);

        /**
         * Sets the value of the SelectionCriteria property for this object.
         *
         * @param selectionCriteria
         *        The new value for the SelectionCriteria property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionCriteria(SelectionCriteria selectionCriteria);

        /**
         * Sets the value of the SelectionCriteria property for this object.
         *
         * This is a convenience that creates an instance of the {@link SelectionCriteria.Builder} avoiding the need to
         * create one manually via {@link SelectionCriteria#builder()}.
         *
         * When the {@link Consumer} completes, {@link SelectionCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #selectionCriteria(SelectionCriteria)}.
         * 
         * @param selectionCriteria
         *        a consumer that will call methods on {@link SelectionCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectionCriteria(SelectionCriteria)
         */
        default Builder selectionCriteria(Consumer<SelectionCriteria.Builder> selectionCriteria) {
            return selectionCriteria(SelectionCriteria.builder().applyMutation(selectionCriteria).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean isEnabled;

        private SelectionCriteria selectionCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(PrefixLevelStorageMetrics model) {
            isEnabled(model.isEnabled);
            selectionCriteria(model.selectionCriteria);
        }

        public final Boolean getIsEnabled() {
            return isEnabled;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        @Override
        @Transient
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public final SelectionCriteria.Builder getSelectionCriteria() {
            return selectionCriteria != null ? selectionCriteria.toBuilder() : null;
        }

        public final void setSelectionCriteria(SelectionCriteria.BuilderImpl selectionCriteria) {
            this.selectionCriteria = selectionCriteria != null ? selectionCriteria.build() : null;
        }

        @Override
        @Transient
        public final Builder selectionCriteria(SelectionCriteria selectionCriteria) {
            this.selectionCriteria = selectionCriteria;
            return this;
        }

        @Override
        public PrefixLevelStorageMetrics build() {
            return new PrefixLevelStorageMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
