/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateJobStatusRequest extends S3ControlRequest implements
        ToCopyableBuilder<UpdateJobStatusRequest.Builder, UpdateJobStatusRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(UpdateJobStatusRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("JobId")
            .getter(getter(UpdateJobStatusRequest::jobId))
            .setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").unmarshallLocationName("id")
                    .build()).build();

    private static final SdkField<String> REQUESTED_JOB_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequestedJobStatus")
            .getter(getter(UpdateJobStatusRequest::requestedJobStatusAsString))
            .setter(setter(Builder::requestedJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("requestedJobStatus")
                    .unmarshallLocationName("requestedJobStatus").build()).build();

    private static final SdkField<String> STATUS_UPDATE_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StatusUpdateReason")
            .getter(getter(UpdateJobStatusRequest::statusUpdateReason))
            .setter(setter(Builder::statusUpdateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("statusUpdateReason")
                    .unmarshallLocationName("statusUpdateReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            JOB_ID_FIELD, REQUESTED_JOB_STATUS_FIELD, STATUS_UPDATE_REASON_FIELD));

    private final String accountId;

    private final String jobId;

    private final String requestedJobStatus;

    private final String statusUpdateReason;

    private UpdateJobStatusRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.jobId = builder.jobId;
        this.requestedJobStatus = builder.requestedJobStatus;
        this.statusUpdateReason = builder.statusUpdateReason;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the S3 Batch Operations job.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the S3 Batch Operations job.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The ID of the job whose status you want to update.
     * </p>
     * 
     * @return The ID of the job whose status you want to update.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The status that you want to move the specified job to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #requestedJobStatus} will return {@link RequestedJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #requestedJobStatusAsString}.
     * </p>
     * 
     * @return The status that you want to move the specified job to.
     * @see RequestedJobStatus
     */
    public final RequestedJobStatus requestedJobStatus() {
        return RequestedJobStatus.fromValue(requestedJobStatus);
    }

    /**
     * <p>
     * The status that you want to move the specified job to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #requestedJobStatus} will return {@link RequestedJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #requestedJobStatusAsString}.
     * </p>
     * 
     * @return The status that you want to move the specified job to.
     * @see RequestedJobStatus
     */
    public final String requestedJobStatusAsString() {
        return requestedJobStatus;
    }

    /**
     * <p>
     * A description of the reason why you want to change the specified job's status. This field can be any string up to
     * the maximum length.
     * </p>
     * 
     * @return A description of the reason why you want to change the specified job's status. This field can be any
     *         string up to the maximum length.
     */
    public final String statusUpdateReason() {
        return statusUpdateReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(requestedJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusUpdateReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobStatusRequest)) {
            return false;
        }
        UpdateJobStatusRequest other = (UpdateJobStatusRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(requestedJobStatusAsString(), other.requestedJobStatusAsString())
                && Objects.equals(statusUpdateReason(), other.statusUpdateReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateJobStatusRequest").add("AccountId", accountId()).add("JobId", jobId())
                .add("RequestedJobStatus", requestedJobStatusAsString()).add("StatusUpdateReason", statusUpdateReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "RequestedJobStatus":
            return Optional.ofNullable(clazz.cast(requestedJobStatusAsString()));
        case "StatusUpdateReason":
            return Optional.ofNullable(clazz.cast(statusUpdateReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobStatusRequest, T> g) {
        return obj -> g.apply((UpdateJobStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateJobStatusRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID associated with the S3 Batch Operations job.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID associated with the S3 Batch Operations job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The ID of the job whose status you want to update.
         * </p>
         * 
         * @param jobId
         *        The ID of the job whose status you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The status that you want to move the specified job to.
         * </p>
         * 
         * @param requestedJobStatus
         *        The status that you want to move the specified job to.
         * @see RequestedJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestedJobStatus
         */
        Builder requestedJobStatus(String requestedJobStatus);

        /**
         * <p>
         * The status that you want to move the specified job to.
         * </p>
         * 
         * @param requestedJobStatus
         *        The status that you want to move the specified job to.
         * @see RequestedJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestedJobStatus
         */
        Builder requestedJobStatus(RequestedJobStatus requestedJobStatus);

        /**
         * <p>
         * A description of the reason why you want to change the specified job's status. This field can be any string
         * up to the maximum length.
         * </p>
         * 
         * @param statusUpdateReason
         *        A description of the reason why you want to change the specified job's status. This field can be any
         *        string up to the maximum length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusUpdateReason(String statusUpdateReason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private String jobId;

        private String requestedJobStatus;

        private String statusUpdateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobStatusRequest model) {
            super(model);
            accountId(model.accountId);
            jobId(model.jobId);
            requestedJobStatus(model.requestedJobStatus);
            statusUpdateReason(model.statusUpdateReason);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getRequestedJobStatus() {
            return requestedJobStatus;
        }

        public final void setRequestedJobStatus(String requestedJobStatus) {
            this.requestedJobStatus = requestedJobStatus;
        }

        @Override
        @Transient
        public final Builder requestedJobStatus(String requestedJobStatus) {
            this.requestedJobStatus = requestedJobStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder requestedJobStatus(RequestedJobStatus requestedJobStatus) {
            this.requestedJobStatus(requestedJobStatus == null ? null : requestedJobStatus.toString());
            return this;
        }

        public final String getStatusUpdateReason() {
            return statusUpdateReason;
        }

        public final void setStatusUpdateReason(String statusUpdateReason) {
            this.statusUpdateReason = statusUpdateReason;
        }

        @Override
        @Transient
        public final Builder statusUpdateReason(String statusUpdateReason) {
            this.statusUpdateReason = statusUpdateReason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJobStatusRequest build() {
            return new UpdateJobStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
