/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NetworkOrigin {
    INTERNET("Internet"),
    VPC("VPC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkOrigin> VALUE_MAP;
    private final String value;

    private NetworkOrigin(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkOrigin fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkOrigin> knownValues() {
        EnumSet<NetworkOrigin> knownValues = EnumSet.allOf(NetworkOrigin.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NetworkOrigin.class, NetworkOrigin::toString);
    }
}

