/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessGrantsLocationsRequest extends S3ControlRequest implements
        ToCopyableBuilder<ListAccessGrantsLocationsRequest.Builder, ListAccessGrantsLocationsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(ListAccessGrantsLocationsRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListAccessGrantsLocationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(ListAccessGrantsLocationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults")
                    .unmarshallLocationName("maxResults").build()).build();

    private static final SdkField<String> LOCATION_SCOPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocationScope")
            .getter(getter(ListAccessGrantsLocationsRequest::locationScope))
            .setter(setter(Builder::locationScope))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("locationscope")
                    .unmarshallLocationName("locationscope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LOCATION_SCOPE_FIELD));

    private final String accountId;

    private final String nextToken;

    private final Integer maxResults;

    private final String locationScope;

    private ListAccessGrantsLocationsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.locationScope = builder.locationScope;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that is making this request.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that is making this request.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * A pagination token to request the next page of results. Pass this value into a subsequent
     * <code>List Access Grants Locations</code> request in order to retrieve the next page of results.
     * </p>
     * 
     * @return A pagination token to request the next page of results. Pass this value into a subsequent
     *         <code>List Access Grants Locations</code> request in order to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of access grants that you would like returned in the <code>List Access Grants</code> response.
     * If the results include the pagination token <code>NextToken</code>, make another call using the
     * <code>NextToken</code> to determine if there are more results.
     * </p>
     * 
     * @return The maximum number of access grants that you would like returned in the <code>List Access Grants</code>
     *         response. If the results include the pagination token <code>NextToken</code>, make another call using the
     *         <code>NextToken</code> to determine if there are more results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The S3 path to the location that you are registering. The location scope can be the default S3 location
     * <code>s3://</code>, the S3 path to a bucket <code>s3://&lt;bucket&gt;</code>, or the S3 path to a bucket and
     * prefix <code>s3://&lt;bucket&gt;/&lt;prefix&gt;</code>. A prefix in S3 is a string of characters at the beginning
     * of an object key name used to organize the objects that you store in your S3 buckets. For example, object key
     * names that start with the <code>engineering/</code> prefix or object key names that start with the
     * <code>marketing/campaigns/</code> prefix.
     * </p>
     * 
     * @return The S3 path to the location that you are registering. The location scope can be the default S3 location
     *         <code>s3://</code>, the S3 path to a bucket <code>s3://&lt;bucket&gt;</code>, or the S3 path to a bucket
     *         and prefix <code>s3://&lt;bucket&gt;/&lt;prefix&gt;</code>. A prefix in S3 is a string of characters at
     *         the beginning of an object key name used to organize the objects that you store in your S3 buckets. For
     *         example, object key names that start with the <code>engineering/</code> prefix or object key names that
     *         start with the <code>marketing/campaigns/</code> prefix.
     */
    public final String locationScope() {
        return locationScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(locationScope());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessGrantsLocationsRequest)) {
            return false;
        }
        ListAccessGrantsLocationsRequest other = (ListAccessGrantsLocationsRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(locationScope(), other.locationScope());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessGrantsLocationsRequest").add("AccountId", accountId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("LocationScope", locationScope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "LocationScope":
            return Optional.ofNullable(clazz.cast(locationScope()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessGrantsLocationsRequest, T> g) {
        return obj -> g.apply((ListAccessGrantsLocationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAccessGrantsLocationsRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that is making this request.
         * </p>
         * 
         * @param accountId
         *        The ID of the Amazon Web Services account that is making this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * A pagination token to request the next page of results. Pass this value into a subsequent
         * <code>List Access Grants Locations</code> request in order to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A pagination token to request the next page of results. Pass this value into a subsequent
         *        <code>List Access Grants Locations</code> request in order to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of access grants that you would like returned in the <code>List Access Grants</code>
         * response. If the results include the pagination token <code>NextToken</code>, make another call using the
         * <code>NextToken</code> to determine if there are more results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of access grants that you would like returned in the
         *        <code>List Access Grants</code> response. If the results include the pagination token
         *        <code>NextToken</code>, make another call using the <code>NextToken</code> to determine if there are
         *        more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The S3 path to the location that you are registering. The location scope can be the default S3 location
         * <code>s3://</code>, the S3 path to a bucket <code>s3://&lt;bucket&gt;</code>, or the S3 path to a bucket and
         * prefix <code>s3://&lt;bucket&gt;/&lt;prefix&gt;</code>. A prefix in S3 is a string of characters at the
         * beginning of an object key name used to organize the objects that you store in your S3 buckets. For example,
         * object key names that start with the <code>engineering/</code> prefix or object key names that start with the
         * <code>marketing/campaigns/</code> prefix.
         * </p>
         * 
         * @param locationScope
         *        The S3 path to the location that you are registering. The location scope can be the default S3
         *        location <code>s3://</code>, the S3 path to a bucket <code>s3://&lt;bucket&gt;</code>, or the S3 path
         *        to a bucket and prefix <code>s3://&lt;bucket&gt;/&lt;prefix&gt;</code>. A prefix in S3 is a string of
         *        characters at the beginning of an object key name used to organize the objects that you store in your
         *        S3 buckets. For example, object key names that start with the <code>engineering/</code> prefix or
         *        object key names that start with the <code>marketing/campaigns/</code> prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationScope(String locationScope);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private String nextToken;

        private Integer maxResults;

        private String locationScope;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessGrantsLocationsRequest model) {
            super(model);
            accountId(model.accountId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            locationScope(model.locationScope);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getLocationScope() {
            return locationScope;
        }

        public final void setLocationScope(String locationScope) {
            this.locationScope = locationScope;
        }

        @Override
        public final Builder locationScope(String locationScope) {
            this.locationScope = locationScope;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccessGrantsLocationsRequest build() {
            return new ListAccessGrantsLocationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
