/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessGrantsInstanceResponse extends S3ControlResponse implements
        ToCopyableBuilder<CreateAccessGrantsInstanceResponse.Builder, CreateAccessGrantsInstanceResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(CreateAccessGrantsInstanceResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt")
                    .unmarshallLocationName("CreatedAt").build()).build();

    private static final SdkField<String> ACCESS_GRANTS_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessGrantsInstanceId")
            .getter(getter(CreateAccessGrantsInstanceResponse::accessGrantsInstanceId))
            .setter(setter(Builder::accessGrantsInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsInstanceId")
                    .unmarshallLocationName("AccessGrantsInstanceId").build()).build();

    private static final SdkField<String> ACCESS_GRANTS_INSTANCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessGrantsInstanceArn")
            .getter(getter(CreateAccessGrantsInstanceResponse::accessGrantsInstanceArn))
            .setter(setter(Builder::accessGrantsInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsInstanceArn")
                    .unmarshallLocationName("AccessGrantsInstanceArn").build()).build();

    private static final SdkField<String> IDENTITY_CENTER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdentityCenterArn")
            .getter(getter(CreateAccessGrantsInstanceResponse::identityCenterArn))
            .setter(setter(Builder::identityCenterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterArn")
                    .unmarshallLocationName("IdentityCenterArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            ACCESS_GRANTS_INSTANCE_ID_FIELD, ACCESS_GRANTS_INSTANCE_ARN_FIELD, IDENTITY_CENTER_ARN_FIELD));

    private final Instant createdAt;

    private final String accessGrantsInstanceId;

    private final String accessGrantsInstanceArn;

    private final String identityCenterArn;

    private CreateAccessGrantsInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.accessGrantsInstanceId = builder.accessGrantsInstanceId;
        this.accessGrantsInstanceArn = builder.accessGrantsInstanceArn;
        this.identityCenterArn = builder.identityCenterArn;
    }

    /**
     * <p>
     * The date and time when you created the S3 Access Grants instance.
     * </p>
     * 
     * @return The date and time when you created the S3 Access Grants instance.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ID of the S3 Access Grants instance. The ID is <code>default</code>. You can have one S3 Access Grants
     * instance per Region per account.
     * </p>
     * 
     * @return The ID of the S3 Access Grants instance. The ID is <code>default</code>. You can have one S3 Access
     *         Grants instance per Region per account.
     */
    public final String accessGrantsInstanceId() {
        return accessGrantsInstanceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the S3 Access Grants instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the S3 Access Grants instance.
     */
    public final String accessGrantsInstanceArn() {
        return accessGrantsInstanceArn;
    }

    /**
     * <p>
     * If you associated your S3 Access Grants instance with an Amazon Web Services IAM Identity Center instance, this
     * field returns the Amazon Resource Name (ARN) of the IAM Identity Center instance application; a subresource of
     * the original Identity Center instance passed in the request. S3 Access Grants creates this Identity Center
     * application for this specific S3 Access Grants instance.
     * </p>
     * 
     * @return If you associated your S3 Access Grants instance with an Amazon Web Services IAM Identity Center
     *         instance, this field returns the Amazon Resource Name (ARN) of the IAM Identity Center instance
     *         application; a subresource of the original Identity Center instance passed in the request. S3 Access
     *         Grants creates this Identity Center application for this specific S3 Access Grants instance.
     */
    public final String identityCenterArn() {
        return identityCenterArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(accessGrantsInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(accessGrantsInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessGrantsInstanceResponse)) {
            return false;
        }
        CreateAccessGrantsInstanceResponse other = (CreateAccessGrantsInstanceResponse) obj;
        return Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(accessGrantsInstanceId(), other.accessGrantsInstanceId())
                && Objects.equals(accessGrantsInstanceArn(), other.accessGrantsInstanceArn())
                && Objects.equals(identityCenterArn(), other.identityCenterArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessGrantsInstanceResponse").add("CreatedAt", createdAt())
                .add("AccessGrantsInstanceId", accessGrantsInstanceId())
                .add("AccessGrantsInstanceArn", accessGrantsInstanceArn()).add("IdentityCenterArn", identityCenterArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "AccessGrantsInstanceId":
            return Optional.ofNullable(clazz.cast(accessGrantsInstanceId()));
        case "AccessGrantsInstanceArn":
            return Optional.ofNullable(clazz.cast(accessGrantsInstanceArn()));
        case "IdentityCenterArn":
            return Optional.ofNullable(clazz.cast(identityCenterArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessGrantsInstanceResponse, T> g) {
        return obj -> g.apply((CreateAccessGrantsInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAccessGrantsInstanceResponse> {
        /**
         * <p>
         * The date and time when you created the S3 Access Grants instance.
         * </p>
         * 
         * @param createdAt
         *        The date and time when you created the S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ID of the S3 Access Grants instance. The ID is <code>default</code>. You can have one S3 Access Grants
         * instance per Region per account.
         * </p>
         * 
         * @param accessGrantsInstanceId
         *        The ID of the S3 Access Grants instance. The ID is <code>default</code>. You can have one S3 Access
         *        Grants instance per Region per account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsInstanceId(String accessGrantsInstanceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the S3 Access Grants instance.
         * </p>
         * 
         * @param accessGrantsInstanceArn
         *        The Amazon Resource Name (ARN) of the S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsInstanceArn(String accessGrantsInstanceArn);

        /**
         * <p>
         * If you associated your S3 Access Grants instance with an Amazon Web Services IAM Identity Center instance,
         * this field returns the Amazon Resource Name (ARN) of the IAM Identity Center instance application; a
         * subresource of the original Identity Center instance passed in the request. S3 Access Grants creates this
         * Identity Center application for this specific S3 Access Grants instance.
         * </p>
         * 
         * @param identityCenterArn
         *        If you associated your S3 Access Grants instance with an Amazon Web Services IAM Identity Center
         *        instance, this field returns the Amazon Resource Name (ARN) of the IAM Identity Center instance
         *        application; a subresource of the original Identity Center instance passed in the request. S3 Access
         *        Grants creates this Identity Center application for this specific S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterArn(String identityCenterArn);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private String accessGrantsInstanceId;

        private String accessGrantsInstanceArn;

        private String identityCenterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessGrantsInstanceResponse model) {
            super(model);
            createdAt(model.createdAt);
            accessGrantsInstanceId(model.accessGrantsInstanceId);
            accessGrantsInstanceArn(model.accessGrantsInstanceArn);
            identityCenterArn(model.identityCenterArn);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getAccessGrantsInstanceId() {
            return accessGrantsInstanceId;
        }

        public final void setAccessGrantsInstanceId(String accessGrantsInstanceId) {
            this.accessGrantsInstanceId = accessGrantsInstanceId;
        }

        @Override
        public final Builder accessGrantsInstanceId(String accessGrantsInstanceId) {
            this.accessGrantsInstanceId = accessGrantsInstanceId;
            return this;
        }

        public final String getAccessGrantsInstanceArn() {
            return accessGrantsInstanceArn;
        }

        public final void setAccessGrantsInstanceArn(String accessGrantsInstanceArn) {
            this.accessGrantsInstanceArn = accessGrantsInstanceArn;
        }

        @Override
        public final Builder accessGrantsInstanceArn(String accessGrantsInstanceArn) {
            this.accessGrantsInstanceArn = accessGrantsInstanceArn;
            return this;
        }

        public final String getIdentityCenterArn() {
            return identityCenterArn;
        }

        public final void setIdentityCenterArn(String identityCenterArn) {
            this.identityCenterArn = identityCenterArn;
        }

        @Override
        public final Builder identityCenterArn(String identityCenterArn) {
            this.identityCenterArn = identityCenterArn;
            return this;
        }

        @Override
        public CreateAccessGrantsInstanceResponse build() {
            return new CreateAccessGrantsInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
