/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.Response;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.interceptor.trait.HttpChecksumRequired;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.s3control.internal.S3ControlServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.s3control.model.AssociateAccessGrantsIdentityCenterRequest;
import software.amazon.awssdk.services.s3control.model.AssociateAccessGrantsIdentityCenterResponse;
import software.amazon.awssdk.services.s3control.model.BadRequestException;
import software.amazon.awssdk.services.s3control.model.BucketAlreadyExistsException;
import software.amazon.awssdk.services.s3control.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3control.model.CreateAccessGrantRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessGrantResponse;
import software.amazon.awssdk.services.s3control.model.CreateAccessGrantsInstanceRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessGrantsInstanceResponse;
import software.amazon.awssdk.services.s3control.model.CreateAccessGrantsLocationRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessGrantsLocationResponse;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3control.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3control.model.CreateJobRequest;
import software.amazon.awssdk.services.s3control.model.CreateJobResponse;
import software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.CreateStorageLensGroupRequest;
import software.amazon.awssdk.services.s3control.model.CreateStorageLensGroupResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessGrantRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessGrantResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessGrantsInstanceRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessGrantsInstanceResourcePolicyRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessGrantsInstanceResourcePolicyResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessGrantsInstanceResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessGrantsLocationRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessGrantsLocationResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketPolicyResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketReplicationRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketReplicationResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketTaggingResponse;
import software.amazon.awssdk.services.s3control.model.DeleteJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationTaggingResponse;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensGroupRequest;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensGroupResponse;
import software.amazon.awssdk.services.s3control.model.DescribeJobRequest;
import software.amazon.awssdk.services.s3control.model.DescribeJobResponse;
import software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationRequest;
import software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationResponse;
import software.amazon.awssdk.services.s3control.model.DissociateAccessGrantsIdentityCenterRequest;
import software.amazon.awssdk.services.s3control.model.DissociateAccessGrantsIdentityCenterResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantsInstanceForPrefixRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantsInstanceForPrefixResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantsInstanceRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantsInstanceResourcePolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantsInstanceResourcePolicyResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantsInstanceResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantsLocationRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessGrantsLocationResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointConfigurationForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketPolicyResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketReplicationRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketReplicationResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketTaggingResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketVersioningRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketVersioningResponse;
import software.amazon.awssdk.services.s3control.model.GetDataAccessRequest;
import software.amazon.awssdk.services.s3control.model.GetDataAccessResponse;
import software.amazon.awssdk.services.s3control.model.GetJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRoutesRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRoutesResponse;
import software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationTaggingResponse;
import software.amazon.awssdk.services.s3control.model.GetStorageLensGroupRequest;
import software.amazon.awssdk.services.s3control.model.GetStorageLensGroupResponse;
import software.amazon.awssdk.services.s3control.model.IdempotencyException;
import software.amazon.awssdk.services.s3control.model.InternalServiceException;
import software.amazon.awssdk.services.s3control.model.InvalidNextTokenException;
import software.amazon.awssdk.services.s3control.model.InvalidRequestException;
import software.amazon.awssdk.services.s3control.model.JobStatusException;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsInstancesRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsInstancesResponse;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsLocationsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsLocationsResponse;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantsResponse;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsResponse;
import software.amazon.awssdk.services.s3control.model.ListJobsRequest;
import software.amazon.awssdk.services.s3control.model.ListJobsResponse;
import software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsRequest;
import software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsResponse;
import software.amazon.awssdk.services.s3control.model.ListRegionalBucketsRequest;
import software.amazon.awssdk.services.s3control.model.ListRegionalBucketsResponse;
import software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsRequest;
import software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsResponse;
import software.amazon.awssdk.services.s3control.model.ListStorageLensGroupsRequest;
import software.amazon.awssdk.services.s3control.model.ListStorageLensGroupsResponse;
import software.amazon.awssdk.services.s3control.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.s3control.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.s3control.model.NoSuchPublicAccessBlockConfigurationException;
import software.amazon.awssdk.services.s3control.model.NotFoundException;
import software.amazon.awssdk.services.s3control.model.PutAccessGrantsInstanceResourcePolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessGrantsInstanceResourcePolicyResponse;
import software.amazon.awssdk.services.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointConfigurationForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketPolicyResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketReplicationRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketReplicationResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketTaggingResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketVersioningRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketVersioningResponse;
import software.amazon.awssdk.services.s3control.model.PutJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationTaggingResponse;
import software.amazon.awssdk.services.s3control.model.S3ControlException;
import software.amazon.awssdk.services.s3control.model.SubmitMultiRegionAccessPointRoutesRequest;
import software.amazon.awssdk.services.s3control.model.SubmitMultiRegionAccessPointRoutesResponse;
import software.amazon.awssdk.services.s3control.model.TagResourceRequest;
import software.amazon.awssdk.services.s3control.model.TagResourceResponse;
import software.amazon.awssdk.services.s3control.model.TooManyRequestsException;
import software.amazon.awssdk.services.s3control.model.TooManyTagsException;
import software.amazon.awssdk.services.s3control.model.UntagResourceRequest;
import software.amazon.awssdk.services.s3control.model.UntagResourceResponse;
import software.amazon.awssdk.services.s3control.model.UpdateAccessGrantsLocationRequest;
import software.amazon.awssdk.services.s3control.model.UpdateAccessGrantsLocationResponse;
import software.amazon.awssdk.services.s3control.model.UpdateJobPriorityRequest;
import software.amazon.awssdk.services.s3control.model.UpdateJobPriorityResponse;
import software.amazon.awssdk.services.s3control.model.UpdateJobStatusRequest;
import software.amazon.awssdk.services.s3control.model.UpdateJobStatusResponse;
import software.amazon.awssdk.services.s3control.model.UpdateStorageLensGroupRequest;
import software.amazon.awssdk.services.s3control.model.UpdateStorageLensGroupResponse;
import software.amazon.awssdk.services.s3control.transform.AssociateAccessGrantsIdentityCenterRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateAccessGrantRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateAccessGrantsInstanceRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateAccessGrantsLocationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateAccessPointForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateBucketRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateMultiRegionAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateStorageLensGroupRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessGrantRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessGrantsInstanceRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessGrantsInstanceResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessGrantsLocationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointPolicyForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteMultiRegionAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeletePublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteStorageLensConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteStorageLensConfigurationTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteStorageLensGroupRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DescribeJobRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DescribeMultiRegionAccessPointOperationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DissociateAccessGrantsIdentityCenterRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessGrantRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessGrantsInstanceForPrefixRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessGrantsInstanceRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessGrantsInstanceResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessGrantsLocationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointConfigurationForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyStatusForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyStatusRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketVersioningRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetDataAccessRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetMultiRegionAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetMultiRegionAccessPointPolicyStatusRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetMultiRegionAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetMultiRegionAccessPointRoutesRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetStorageLensConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetStorageLensConfigurationTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetStorageLensGroupRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListAccessGrantsInstancesRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListAccessGrantsLocationsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListAccessGrantsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListAccessPointsForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListAccessPointsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListMultiRegionAccessPointsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListRegionalBucketsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListStorageLensConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListStorageLensGroupsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutAccessGrantsInstanceResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutAccessPointConfigurationForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutAccessPointPolicyForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketVersioningRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutMultiRegionAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutStorageLensConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutStorageLensConfigurationTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.SubmitMultiRegionAccessPointRoutesRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.UpdateAccessGrantsLocationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.UpdateJobPriorityRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.UpdateJobStatusRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.UpdateStorageLensGroupRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link S3ControlAsyncClient}.
 *
 * @see S3ControlAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultS3ControlAsyncClient implements S3ControlAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultS3ControlAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_XML).build();

    private final AsyncClientHandler clientHandler;

    private final AwsXmlProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultS3ControlAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Associate your S3 Access Grants instance with an Amazon Web Services IAM Identity Center instance. Use this
     * action if you want to create access grants for users or groups from your corporate identity directory. First, you
     * must add your corporate identity directory to Amazon Web Services IAM Identity Center. Then, you can associate
     * this IAM Identity Center instance with your S3 Access Grants instance.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:AssociateAccessGrantsIdentityCenter</code> permission to use this operation.
     * </p>
     * </dd>
     * <dt>Additional Permissions</dt>
     * <dd>
     * <p>
     * You must also have the following permissions: <code>sso:CreateApplication</code>,
     * <code>sso:PutApplicationGrant</code>, and <code>sso:PutApplicationAuthenticationMethod</code>.
     * </p>
     * </dd>
     * </dl>
     *
     * @param associateAccessGrantsIdentityCenterRequest
     * @return A Java Future containing the result of the AssociateAccessGrantsIdentityCenter operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.AssociateAccessGrantsIdentityCenter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/AssociateAccessGrantsIdentityCenter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateAccessGrantsIdentityCenterResponse> associateAccessGrantsIdentityCenter(
            AssociateAccessGrantsIdentityCenterRequest associateAccessGrantsIdentityCenterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateAccessGrantsIdentityCenterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateAccessGrantsIdentityCenterRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateAccessGrantsIdentityCenter");

            HttpResponseHandler<Response<AssociateAccessGrantsIdentityCenterResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(AssociateAccessGrantsIdentityCenterResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<AssociateAccessGrantsIdentityCenterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateAccessGrantsIdentityCenterRequest, AssociateAccessGrantsIdentityCenterResponse>()
                            .withOperationName("AssociateAccessGrantsIdentityCenter")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateAccessGrantsIdentityCenterRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(associateAccessGrantsIdentityCenterRequest));
            CompletableFuture<AssociateAccessGrantsIdentityCenterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an access grant that gives a grantee access to your S3 data. The grantee can be an IAM user or role or a
     * directory user, or group. Before you can create a grant, you must have an S3 Access Grants instance in the same
     * Region as the S3 data. You can create an S3 Access Grants instance using the <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessGrantsInstance.html"
     * >CreateAccessGrantsInstance</a>. You must also have registered at least one S3 data location in your S3 Access
     * Grants instance using <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessGrantsLocation.html"
     * >CreateAccessGrantsLocation</a>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:CreateAccessGrant</code> permission to use this operation.
     * </p>
     * </dd>
     * <dt>Additional Permissions</dt>
     * <dd>
     * <p>
     * For any directory identity - <code>sso:DescribeInstance</code> and <code>sso:DescribeApplication</code>
     * </p>
     * <p>
     * For directory users - <code>identitystore:DescribeUser</code>
     * </p>
     * <p>
     * For directory groups - <code>identitystore:DescribeGroup</code>
     * </p>
     * </dd>
     * </dl>
     *
     * @param createAccessGrantRequest
     * @return A Java Future containing the result of the CreateAccessGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.CreateAccessGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessGrant" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAccessGrantResponse> createAccessGrant(CreateAccessGrantRequest createAccessGrantRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccessGrantRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccessGrantRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccessGrant");

            HttpResponseHandler<Response<CreateAccessGrantResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateAccessGrantResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateAccessGrantResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAccessGrantRequest, CreateAccessGrantResponse>()
                            .withOperationName("CreateAccessGrant")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAccessGrantRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(createAccessGrantRequest));
            CompletableFuture<CreateAccessGrantResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an S3 Access Grants instance, which serves as a logical grouping for access grants. You can create one S3
     * Access Grants instance per Region per account.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:CreateAccessGrantsInstance</code> permission to use this operation.
     * </p>
     * </dd>
     * <dt>Additional Permissions</dt>
     * <dd>
     * <p>
     * To associate an IAM Identity Center instance with your S3 Access Grants instance, you must also have the
     * <code>sso:DescribeInstance</code>, <code>sso:CreateApplication</code>, <code>sso:PutApplicationGrant</code>, and
     * <code>sso:PutApplicationAuthenticationMethod</code> permissions.
     * </p>
     * </dd>
     * </dl>
     *
     * @param createAccessGrantsInstanceRequest
     * @return A Java Future containing the result of the CreateAccessGrantsInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.CreateAccessGrantsInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessGrantsInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAccessGrantsInstanceResponse> createAccessGrantsInstance(
            CreateAccessGrantsInstanceRequest createAccessGrantsInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccessGrantsInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccessGrantsInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccessGrantsInstance");

            HttpResponseHandler<Response<CreateAccessGrantsInstanceResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateAccessGrantsInstanceResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateAccessGrantsInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAccessGrantsInstanceRequest, CreateAccessGrantsInstanceResponse>()
                            .withOperationName("CreateAccessGrantsInstance")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAccessGrantsInstanceRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(createAccessGrantsInstanceRequest));
            CompletableFuture<CreateAccessGrantsInstanceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The S3 data location that you would like to register in your S3 Access Grants instance. Your S3 data must be in
     * the same Region as your S3 Access Grants instance. The location can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The default S3 location <code>s3://</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * A bucket - <code>S3://&lt;bucket-name&gt;</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * A bucket and prefix - <code>S3://&lt;bucket-name&gt;/&lt;prefix&gt;</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you register a location, you must include the IAM role that has permission to manage the S3 location that
     * you are registering. Give S3 Access Grants permission to assume this role <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-location.html">using a policy</a>. S3
     * Access Grants assumes this role to manage access to the location and to vend temporary credentials to grantees or
     * client applications.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:CreateAccessGrantsLocation</code> permission to use this operation.
     * </p>
     * </dd>
     * <dt>Additional Permissions</dt>
     * <dd>
     * <p>
     * You must also have the following permission for the specified IAM role: <code>iam:PassRole</code>
     * </p>
     * </dd>
     * </dl>
     *
     * @param createAccessGrantsLocationRequest
     * @return A Java Future containing the result of the CreateAccessGrantsLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.CreateAccessGrantsLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessGrantsLocation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAccessGrantsLocationResponse> createAccessGrantsLocation(
            CreateAccessGrantsLocationRequest createAccessGrantsLocationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccessGrantsLocationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccessGrantsLocationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccessGrantsLocation");

            HttpResponseHandler<Response<CreateAccessGrantsLocationResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateAccessGrantsLocationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateAccessGrantsLocationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAccessGrantsLocationRequest, CreateAccessGrantsLocationResponse>()
                            .withOperationName("CreateAccessGrantsLocation")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAccessGrantsLocationRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(createAccessGrantsLocationRequest));
            CompletableFuture<CreateAccessGrantsLocationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Creates an access point and associates it with the specified bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing Data Access with Amazon
     * S3 Access Points</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p/>
     * <note>
     * <p>
     * S3 on Outposts only supports VPC-style access points.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">
     * Accessing Amazon S3 on Outposts using virtual private cloud (VPC) only access points</a> in the <i>Amazon S3 User
     * Guide</i>.
     * </p>
     * </note>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html#API_control_CreateAccessPoint_Examples"
     * >Examples</a> section.
     * </p>
     * <p/>
     * <p>
     * The following actions are related to <code>CreateAccessPoint</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html">GetAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html">DeleteAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html">ListAccessPoints</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createAccessPointRequest
     * @return A Java Future containing the result of the CreateAccessPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.CreateAccessPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessPoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAccessPointResponse> createAccessPoint(CreateAccessPointRequest createAccessPointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccessPointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccessPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccessPoint");

            HttpResponseHandler<Response<CreateAccessPointResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateAccessPointResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateAccessPointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAccessPointRequest, CreateAccessPointResponse>()
                            .withOperationName("CreateAccessPoint").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAccessPointRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAccessPointRequest));
            CompletableFuture<CreateAccessPointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Creates an Object Lambda Access Point. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/transforming-objects.html">Transforming objects with
     * Object Lambda Access Points</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * The following actions are related to <code>CreateAccessPointForObjectLambda</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html">
     * DeleteAccessPointForObjectLambda</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html">
     * GetAccessPointForObjectLambda</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html">
     * ListAccessPointsForObjectLambda</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createAccessPointForObjectLambdaRequest
     * @return A Java Future containing the result of the CreateAccessPointForObjectLambda operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.CreateAccessPointForObjectLambda
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessPointForObjectLambda"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAccessPointForObjectLambdaResponse> createAccessPointForObjectLambda(
            CreateAccessPointForObjectLambdaRequest createAccessPointForObjectLambdaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccessPointForObjectLambdaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createAccessPointForObjectLambdaRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccessPointForObjectLambda");

            HttpResponseHandler<Response<CreateAccessPointForObjectLambdaResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateAccessPointForObjectLambdaResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateAccessPointForObjectLambdaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAccessPointForObjectLambdaRequest, CreateAccessPointForObjectLambdaResponse>()
                            .withOperationName("CreateAccessPointForObjectLambda").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAccessPointForObjectLambdaRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAccessPointForObjectLambdaRequest));
            CompletableFuture<CreateAccessPointForObjectLambdaResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action creates an Amazon S3 on Outposts bucket. To create an S3 bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">Create Bucket</a> in the <i>Amazon
     * S3 API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Creates a new Outposts bucket. By creating the bucket, you become the bucket owner. To create an Outposts bucket,
     * you must have S3 on Outposts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * Not every string is an acceptable bucket name. For information on bucket naming restrictions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html#bucketnamingrules">Working
     * with Amazon S3 Buckets</a>.
     * </p>
     * <p>
     * S3 on Outposts buckets support:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Tags
     * </p>
     * </li>
     * <li>
     * <p>
     * LifecycleConfigurations for deleting expired objects
     * </p>
     * </li>
     * </ul>
     * <p>
     * For a complete list of restrictions and Amazon S3 feature limitations on S3 on Outposts, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OnOutpostsRestrictionsLimitations.html"> Amazon S3
     * on Outposts Restrictions and Limitations</a>.
     * </p>
     * <p>
     * For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname
     * prefix and <code>x-amz-outpost-id</code> in your API request, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html#API_control_CreateBucket_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * The following actions are related to <code>CreateBucket</code> for Amazon S3 on Outposts:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html">GetBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html">DeleteBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html">
     * PutAccessPointPolicy</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createBucketRequest
     * @return A Java Future containing the result of the CreateBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BucketAlreadyExistsException The requested Outposts bucket name is not available. The bucket
     *         namespace is shared by all users of the Outposts in this Region. Select a different name and try again.</li>
     *         <li>BucketAlreadyOwnedByYouException The Outposts bucket you tried to create already exists, and you own
     *         it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.CreateBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateBucket" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBucketResponse> createBucket(CreateBucketRequest createBucketRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBucketRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBucket");

            HttpResponseHandler<Response<CreateBucketResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    CreateBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateBucketResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBucketRequest, CreateBucketResponse>()
                            .withOperationName("CreateBucket")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBucketRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(createBucketRequest));
            CompletableFuture<CreateBucketResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This operation creates an S3 Batch Operations job.
     * </p>
     * <p>
     * You can use S3 Batch Operations to perform large-scale batch actions on Amazon S3 objects. Batch Operations can
     * run a single action on lists of Amazon S3 objects that you specify. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html">S3 Batch Operations</a> in the
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * For information about permissions required to use the Batch Operations, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops-iam-role-policies.html">Granting
     * permissions for S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * </dl>
     * <p/>
     * <p>
     * Related actions include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html">UpdateJobPriority</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_JobOperation.html">JobOperation</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createJobRequest
     * @return A Java Future containing the result of the CreateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException</li>
     *         <li>BadRequestException</li>
     *         <li>IdempotencyException</li>
     *         <li>InternalServiceException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateJobResponse> createJob(CreateJobRequest createJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateJob");

            HttpResponseHandler<Response<CreateJobResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    CreateJobResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateJobRequest, CreateJobResponse>().withOperationName("CreateJob")
                            .withRequestConfiguration(clientConfiguration).withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateJobRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createJobRequest));
            CompletableFuture<CreateJobResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Creates a Multi-Region Access Point and associates it with the specified buckets. For more information about
     * creating Multi-Region Access Points, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html">Creating
     * Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions
     * around working with Multi-Region Access Points, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html">Multi-Region
     * Access Point restrictions and limitations</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * This request is asynchronous, meaning that you might receive a response before the command has completed. When
     * this request provides a response, it provides a token that you can use to monitor the status of the request with
     * <code>DescribeMultiRegionAccessPointOperation</code>.
     * </p>
     * <p>
     * The following actions are related to <code>CreateMultiRegionAccessPoint</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">
     * DeleteMultiRegionAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html"
     * >DescribeMultiRegionAccessPointOperation</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">
     * GetMultiRegionAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">
     * ListMultiRegionAccessPoints</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createMultiRegionAccessPointRequest
     * @return A Java Future containing the result of the CreateMultiRegionAccessPoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.CreateMultiRegionAccessPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateMultiRegionAccessPoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMultiRegionAccessPointResponse> createMultiRegionAccessPoint(
            CreateMultiRegionAccessPointRequest createMultiRegionAccessPointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMultiRegionAccessPointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMultiRegionAccessPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMultiRegionAccessPoint");

            HttpResponseHandler<Response<CreateMultiRegionAccessPointResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateMultiRegionAccessPointResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateMultiRegionAccessPointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMultiRegionAccessPointRequest, CreateMultiRegionAccessPointResponse>()
                            .withOperationName("CreateMultiRegionAccessPoint")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMultiRegionAccessPointRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(createMultiRegionAccessPointRequest));
            CompletableFuture<CreateMultiRegionAccessPointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new S3 Storage Lens group and associates it with the specified Amazon Web Services account ID. An S3
     * Storage Lens group is a custom grouping of objects based on prefix, suffix, object tags, object size, object age,
     * or a combination of these filters. For each Storage Lens group that you’ve created, you can also optionally add
     * Amazon Web Services resource tags. For more information about S3 Storage Lens groups, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups-overview.html">Working with S3
     * Storage Lens groups</a>.
     * </p>
     * <p>
     * To use this operation, you must have the permission to perform the <code>s3:CreateStorageLensGroup</code> action.
     * If you’re trying to create a Storage Lens group with Amazon Web Services resource tags, you must also have
     * permission to perform the <code>s3:TagResource</code> action. For more information about the required Storage
     * Lens Groups permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions"
     * >Setting account permissions to use S3 Storage Lens groups</a>.
     * </p>
     * <p>
     * For information about Storage Lens groups errors, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList">List of Amazon S3
     * Storage Lens error codes</a>.
     * </p>
     *
     * @param createStorageLensGroupRequest
     * @return A Java Future containing the result of the CreateStorageLensGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.CreateStorageLensGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateStorageLensGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStorageLensGroupResponse> createStorageLensGroup(
            CreateStorageLensGroupRequest createStorageLensGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStorageLensGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStorageLensGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStorageLensGroup");

            HttpResponseHandler<Response<CreateStorageLensGroupResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateStorageLensGroupResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateStorageLensGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStorageLensGroupRequest, CreateStorageLensGroupResponse>()
                            .withOperationName("CreateStorageLensGroup").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateStorageLensGroupRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createStorageLensGroupRequest));
            CompletableFuture<CreateStorageLensGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the access grant from the S3 Access Grants instance. You cannot undo an access grant deletion and the
     * grantee will no longer have access to the S3 data.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:DeleteAccessGrant</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param deleteAccessGrantRequest
     * @return A Java Future containing the result of the DeleteAccessGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteAccessGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessGrant" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccessGrantResponse> deleteAccessGrant(DeleteAccessGrantRequest deleteAccessGrantRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccessGrantRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccessGrantRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessGrant");

            HttpResponseHandler<Response<DeleteAccessGrantResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteAccessGrantResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteAccessGrantResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccessGrantRequest, DeleteAccessGrantResponse>()
                            .withOperationName("DeleteAccessGrant")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccessGrantRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(deleteAccessGrantRequest));
            CompletableFuture<DeleteAccessGrantResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes your S3 Access Grants instance. You must first delete the access grants and locations before S3 Access
     * Grants can delete the instance. See <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessGrant.html">DeleteAccessGrant</a>
     * and <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessGrantsLocation.html">
     * DeleteAccessGrantsLocation</a>. If you have associated an IAM Identity Center instance with your S3 Access Grants
     * instance, you must first dissassociate the Identity Center instance from the S3 Access Grants instance before you
     * can delete the S3 Access Grants instance. See <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_AssociateAccessGrantsIdentityCenter.html"
     * >AssociateAccessGrantsIdentityCenter</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DissociateAccessGrantsIdentityCenter.html"
     * >DissociateAccessGrantsIdentityCenter</a>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:DeleteAccessGrantsInstance</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param deleteAccessGrantsInstanceRequest
     * @return A Java Future containing the result of the DeleteAccessGrantsInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteAccessGrantsInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessGrantsInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccessGrantsInstanceResponse> deleteAccessGrantsInstance(
            DeleteAccessGrantsInstanceRequest deleteAccessGrantsInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccessGrantsInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccessGrantsInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessGrantsInstance");

            HttpResponseHandler<Response<DeleteAccessGrantsInstanceResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteAccessGrantsInstanceResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteAccessGrantsInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccessGrantsInstanceRequest, DeleteAccessGrantsInstanceResponse>()
                            .withOperationName("DeleteAccessGrantsInstance")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccessGrantsInstanceRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(deleteAccessGrantsInstanceRequest));
            CompletableFuture<DeleteAccessGrantsInstanceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the resource policy of the S3 Access Grants instance. The resource policy is used to manage cross-account
     * access to your S3 Access Grants instance. By deleting the resource policy, you delete any cross-account
     * permissions to your S3 Access Grants instance.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:DeleteAccessGrantsInstanceResourcePolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param deleteAccessGrantsInstanceResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteAccessGrantsInstanceResourcePolicy operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteAccessGrantsInstanceResourcePolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessGrantsInstanceResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccessGrantsInstanceResourcePolicyResponse> deleteAccessGrantsInstanceResourcePolicy(
            DeleteAccessGrantsInstanceResourcePolicyRequest deleteAccessGrantsInstanceResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteAccessGrantsInstanceResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAccessGrantsInstanceResourcePolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessGrantsInstanceResourcePolicy");

            HttpResponseHandler<Response<DeleteAccessGrantsInstanceResourcePolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteAccessGrantsInstanceResourcePolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteAccessGrantsInstanceResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccessGrantsInstanceResourcePolicyRequest, DeleteAccessGrantsInstanceResourcePolicyResponse>()
                            .withOperationName("DeleteAccessGrantsInstanceResourcePolicy")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccessGrantsInstanceResourcePolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(deleteAccessGrantsInstanceResourcePolicyRequest));
            CompletableFuture<DeleteAccessGrantsInstanceResourcePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters a location from your S3 Access Grants instance. You can only delete a location registration from an
     * S3 Access Grants instance if there are no grants associated with this location. See <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessGrant.html">Delete a grant</a> for
     * information on how to delete grants. You need to have at least one registered location in your S3 Access Grants
     * instance in order to create access grants.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:DeleteAccessGrantsLocation</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param deleteAccessGrantsLocationRequest
     * @return A Java Future containing the result of the DeleteAccessGrantsLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteAccessGrantsLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessGrantsLocation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccessGrantsLocationResponse> deleteAccessGrantsLocation(
            DeleteAccessGrantsLocationRequest deleteAccessGrantsLocationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccessGrantsLocationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccessGrantsLocationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessGrantsLocation");

            HttpResponseHandler<Response<DeleteAccessGrantsLocationResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteAccessGrantsLocationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteAccessGrantsLocationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccessGrantsLocationRequest, DeleteAccessGrantsLocationResponse>()
                            .withOperationName("DeleteAccessGrantsLocation")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccessGrantsLocationRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(deleteAccessGrantsLocationRequest));
            CompletableFuture<DeleteAccessGrantsLocationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes the specified access point.
     * </p>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html#API_control_DeleteAccessPoint_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * The following actions are related to <code>DeleteAccessPoint</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html">GetAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html">ListAccessPoints</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteAccessPointRequest
     * @return A Java Future containing the result of the DeleteAccessPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteAccessPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccessPointResponse> deleteAccessPoint(DeleteAccessPointRequest deleteAccessPointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccessPointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccessPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessPoint");

            HttpResponseHandler<Response<DeleteAccessPointResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteAccessPointResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteAccessPointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccessPointRequest, DeleteAccessPointResponse>()
                            .withOperationName("DeleteAccessPoint").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccessPointRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAccessPointRequest));
            CompletableFuture<DeleteAccessPointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes the specified Object Lambda Access Point.
     * </p>
     * <p>
     * The following actions are related to <code>DeleteAccessPointForObjectLambda</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html">
     * CreateAccessPointForObjectLambda</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html">
     * GetAccessPointForObjectLambda</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html">
     * ListAccessPointsForObjectLambda</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteAccessPointForObjectLambdaRequest
     * @return A Java Future containing the result of the DeleteAccessPointForObjectLambda operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteAccessPointForObjectLambda
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPointForObjectLambda"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccessPointForObjectLambdaResponse> deleteAccessPointForObjectLambda(
            DeleteAccessPointForObjectLambdaRequest deleteAccessPointForObjectLambdaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccessPointForObjectLambdaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAccessPointForObjectLambdaRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessPointForObjectLambda");

            HttpResponseHandler<Response<DeleteAccessPointForObjectLambdaResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteAccessPointForObjectLambdaResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteAccessPointForObjectLambdaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccessPointForObjectLambdaRequest, DeleteAccessPointForObjectLambdaResponse>()
                            .withOperationName("DeleteAccessPointForObjectLambda").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccessPointForObjectLambdaRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAccessPointForObjectLambdaRequest));
            CompletableFuture<DeleteAccessPointForObjectLambdaResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes the access point policy for the specified access point.
     * </p>
     * <p/>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html#API_control_DeleteAccessPointPolicy_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * The following actions are related to <code>DeleteAccessPointPolicy</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html">
     * PutAccessPointPolicy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html">
     * GetAccessPointPolicy</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteAccessPointPolicyRequest
     * @return A Java Future containing the result of the DeleteAccessPointPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteAccessPointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccessPointPolicyResponse> deleteAccessPointPolicy(
            DeleteAccessPointPolicyRequest deleteAccessPointPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccessPointPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccessPointPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessPointPolicy");

            HttpResponseHandler<Response<DeleteAccessPointPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteAccessPointPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteAccessPointPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccessPointPolicyRequest, DeleteAccessPointPolicyResponse>()
                            .withOperationName("DeleteAccessPointPolicy").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccessPointPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAccessPointPolicyRequest));
            CompletableFuture<DeleteAccessPointPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Removes the resource policy for an Object Lambda Access Point.
     * </p>
     * <p>
     * The following actions are related to <code>DeleteAccessPointPolicyForObjectLambda</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyForObjectLambda.html">
     * GetAccessPointPolicyForObjectLambda</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicyForObjectLambda.html">
     * PutAccessPointPolicyForObjectLambda</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteAccessPointPolicyForObjectLambdaRequest
     * @return A Java Future containing the result of the DeleteAccessPointPolicyForObjectLambda operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteAccessPointPolicyForObjectLambda
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPointPolicyForObjectLambda"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccessPointPolicyForObjectLambdaResponse> deleteAccessPointPolicyForObjectLambda(
            DeleteAccessPointPolicyForObjectLambdaRequest deleteAccessPointPolicyForObjectLambdaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccessPointPolicyForObjectLambdaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAccessPointPolicyForObjectLambdaRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessPointPolicyForObjectLambda");

            HttpResponseHandler<Response<DeleteAccessPointPolicyForObjectLambdaResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteAccessPointPolicyForObjectLambdaResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteAccessPointPolicyForObjectLambdaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccessPointPolicyForObjectLambdaRequest, DeleteAccessPointPolicyForObjectLambdaResponse>()
                            .withOperationName("DeleteAccessPointPolicyForObjectLambda")
                            .withRequestConfiguration(clientConfiguration).withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccessPointPolicyForObjectLambdaRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAccessPointPolicyForObjectLambdaRequest));
            CompletableFuture<DeleteAccessPointPolicyForObjectLambdaResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action deletes an Amazon S3 on Outposts bucket. To delete an S3 bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a> in the <i>Amazon S3
     * API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Deletes the Amazon S3 on Outposts bucket. All objects (including all object versions and delete markers) in the
     * bucket must be deleted before the bucket itself can be deleted. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html#API_control_DeleteBucket_Examples"
     * >Examples</a> section.
     * </p>
     * <p class="title">
     * <b>Related Resources</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html">GetBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketRequest
     * @return A Java Future containing the result of the DeleteBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucket" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBucketResponse> deleteBucket(DeleteBucketRequest deleteBucketRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBucketRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucket");

            HttpResponseHandler<Response<DeleteBucketResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    DeleteBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteBucketResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBucketRequest, DeleteBucketResponse>()
                            .withOperationName("DeleteBucket").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBucketRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBucketRequest));
            CompletableFuture<DeleteBucketResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action deletes an Amazon S3 on Outposts bucket's lifecycle configuration. To delete an S3 bucket's lifecycle
     * configuration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html">DeleteBucketLifecycle</a>
     * in the <i>Amazon S3 API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Deletes the lifecycle configuration from the specified Outposts bucket. Amazon S3 on Outposts removes all the
     * lifecycle configuration rules in the lifecycle subresource associated with the bucket. Your objects never expire,
     * and Amazon S3 on Outposts no longer automatically deletes any objects on the basis of rules contained in the
     * deleted lifecycle configuration. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>s3-outposts:PutLifecycleConfiguration</code>
     * action. By default, the bucket owner has this permission and the Outposts bucket owner can grant this permission
     * to others.
     * </p>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html#API_control_DeleteBucketLifecycleConfiguration_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * For more information about object expiration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#intro-lifecycle-rules-actions"
     * >Elements to Describe Lifecycle Actions</a>.
     * </p>
     * <p>
     * Related actions include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html">
     * PutBucketLifecycleConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html">
     * GetBucketLifecycleConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketLifecycleConfigurationRequest
     * @return A Java Future containing the result of the DeleteBucketLifecycleConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteBucketLifecycleConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketLifecycleConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBucketLifecycleConfigurationResponse> deleteBucketLifecycleConfiguration(
            DeleteBucketLifecycleConfigurationRequest deleteBucketLifecycleConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBucketLifecycleConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketLifecycleConfiguration");

            HttpResponseHandler<Response<DeleteBucketLifecycleConfigurationResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteBucketLifecycleConfigurationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteBucketLifecycleConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBucketLifecycleConfigurationRequest, DeleteBucketLifecycleConfigurationResponse>()
                            .withOperationName("DeleteBucketLifecycleConfiguration")
                            .withRequestConfiguration(clientConfiguration).withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBucketLifecycleConfigurationRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBucketLifecycleConfigurationRequest));
            CompletableFuture<DeleteBucketLifecycleConfigurationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action deletes an Amazon S3 on Outposts bucket policy. To delete an S3 bucket policy, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketPolicy.html">DeleteBucketPolicy</a> in the
     * <i>Amazon S3 API Reference</i>.
     * </p>
     * </note>
     * <p>
     * This implementation of the DELETE action uses the policy subresource to delete the policy of a specified Amazon
     * S3 on Outposts bucket. If you are using an identity other than the root user of the Amazon Web Services account
     * that owns the bucket, the calling identity must have the <code>s3-outposts:DeleteBucketPolicy</code> permissions
     * on the specified Outposts bucket and belong to the bucket owner's account to use this action. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon
     * S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If you don't have <code>DeleteBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code>
     * error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's
     * account, Amazon S3 returns a <code>405 Method Not Allowed</code> error.
     * </p>
     * <important>
     * <p>
     * As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this
     * action, even if the policy explicitly denies the root user the ability to perform this action.
     * </p>
     * </important>
     * <p>
     * For more information about bucket policies, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User
     * Policies</a>.
     * </p>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html#API_control_DeleteBucketPolicy_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * The following actions are related to <code>DeleteBucketPolicy</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html">GetBucketPolicy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html">PutBucketPolicy</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketPolicyRequest
     * @return A Java Future containing the result of the DeleteBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBucketPolicyResponse> deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBucketPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBucketPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketPolicy");

            HttpResponseHandler<Response<DeleteBucketPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteBucketPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteBucketPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBucketPolicyRequest, DeleteBucketPolicyResponse>()
                            .withOperationName("DeleteBucketPolicy").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBucketPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBucketPolicyRequest));
            CompletableFuture<DeleteBucketPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation deletes an Amazon S3 on Outposts bucket's replication configuration. To delete an S3 bucket's
     * replication configuration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketReplication.html"
     * >DeleteBucketReplication</a> in the <i>Amazon S3 API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Deletes the replication configuration from the specified S3 on Outposts bucket.
     * </p>
     * <p>
     * To use this operation, you must have permissions to perform the
     * <code>s3-outposts:PutReplicationConfiguration</code> action. The Outposts bucket owner has this permission by
     * default and can grant it to others. For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsIAM.html">Setting up IAM with S3 on
     * Outposts</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsBucketPolicy.html">Managing access to S3 on
     * Outposts buckets</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * It can take a while to propagate <code>PUT</code> or <code>DELETE</code> requests for a replication configuration
     * to all S3 on Outposts systems. Therefore, the replication configuration that's returned by a <code>GET</code>
     * request soon after a <code>PUT</code> or <code>DELETE</code> request might return a more recent result than
     * what's on the Outpost. If an Outpost is offline, the delay in updating the replication configuration on that
     * Outpost can be significant.
     * </p>
     * </note>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketReplication.html#API_control_DeleteBucketReplication_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * For information about S3 replication on Outposts configuration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html">Replicating objects for
     * S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * The following operations are related to <code>DeleteBucketReplication</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketReplication.html">
     * PutBucketReplication</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketReplication.html">
     * GetBucketReplication</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketReplicationRequest
     * @return A Java Future containing the result of the DeleteBucketReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteBucketReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketReplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBucketReplicationResponse> deleteBucketReplication(
            DeleteBucketReplicationRequest deleteBucketReplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBucketReplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBucketReplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketReplication");

            HttpResponseHandler<Response<DeleteBucketReplicationResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteBucketReplicationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteBucketReplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBucketReplicationRequest, DeleteBucketReplicationResponse>()
                            .withOperationName("DeleteBucketReplication").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBucketReplicationRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBucketReplicationRequest));
            CompletableFuture<DeleteBucketReplicationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action deletes an Amazon S3 on Outposts bucket's tags. To delete an S3 bucket tags, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html">DeleteBucketTagging</a> in
     * the <i>Amazon S3 API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Deletes the tags from the Outposts bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * To use this action, you must have permission to perform the <code>PutBucketTagging</code> action. By default, the
     * bucket owner has this permission and can grant this permission to others.
     * </p>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html#API_control_DeleteBucketTagging_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * The following actions are related to <code>DeleteBucketTagging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html">GetBucketTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html">PutBucketTagging</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteBucketTaggingRequest
     * @return A Java Future containing the result of the DeleteBucketTagging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteBucketTagging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketTagging" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBucketTaggingResponse> deleteBucketTagging(
            DeleteBucketTaggingRequest deleteBucketTaggingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBucketTaggingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBucketTaggingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBucketTagging");

            HttpResponseHandler<Response<DeleteBucketTaggingResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteBucketTaggingResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteBucketTaggingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBucketTaggingRequest, DeleteBucketTaggingResponse>()
                            .withOperationName("DeleteBucketTagging").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBucketTaggingRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBucketTaggingRequest));
            CompletableFuture<DeleteBucketTaggingResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the entire tag set from the specified S3 Batch Operations job.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * To use the <code>DeleteJobTagging</code> operation, you must have permission to perform the
     * <code>s3:DeleteJobTagging</code> action. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags"
     * >Controlling access and labeling jobs using tags</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Related actions include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html">GetJobTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html">PutJobTagging</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteJobTaggingRequest
     * @return A Java Future containing the result of the DeleteJobTagging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException</li>
     *         <li>TooManyRequestsException</li>
     *         <li>NotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteJobTagging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteJobTagging" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteJobTaggingResponse> deleteJobTagging(DeleteJobTaggingRequest deleteJobTaggingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteJobTaggingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteJobTaggingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteJobTagging");

            HttpResponseHandler<Response<DeleteJobTaggingResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteJobTaggingResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteJobTaggingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteJobTaggingRequest, DeleteJobTaggingResponse>()
                            .withOperationName("DeleteJobTagging").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteJobTaggingRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteJobTaggingRequest));
            CompletableFuture<DeleteJobTaggingResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes a Multi-Region Access Point. This action does not delete the buckets associated with the Multi-Region
     * Access Point, only the Multi-Region Access Point itself.
     * </p>
     * <p>
     * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions
     * around working with Multi-Region Access Points, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html">Multi-Region
     * Access Point restrictions and limitations</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * This request is asynchronous, meaning that you might receive a response before the command has completed. When
     * this request provides a response, it provides a token that you can use to monitor the status of the request with
     * <code>DescribeMultiRegionAccessPointOperation</code>.
     * </p>
     * <p>
     * The following actions are related to <code>DeleteMultiRegionAccessPoint</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">
     * CreateMultiRegionAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html"
     * >DescribeMultiRegionAccessPointOperation</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">
     * GetMultiRegionAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">
     * ListMultiRegionAccessPoints</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteMultiRegionAccessPointRequest
     * @return A Java Future containing the result of the DeleteMultiRegionAccessPoint operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteMultiRegionAccessPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteMultiRegionAccessPoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMultiRegionAccessPointResponse> deleteMultiRegionAccessPoint(
            DeleteMultiRegionAccessPointRequest deleteMultiRegionAccessPointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMultiRegionAccessPointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMultiRegionAccessPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMultiRegionAccessPoint");

            HttpResponseHandler<Response<DeleteMultiRegionAccessPointResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteMultiRegionAccessPointResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteMultiRegionAccessPointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMultiRegionAccessPointRequest, DeleteMultiRegionAccessPointResponse>()
                            .withOperationName("DeleteMultiRegionAccessPoint")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMultiRegionAccessPointRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(deleteMultiRegionAccessPointRequest));
            CompletableFuture<DeleteMultiRegionAccessPointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Removes the <code>PublicAccessBlock</code> configuration for an Amazon Web Services account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html"> Using Amazon S3
     * block public access</a>.
     * </p>
     * <p>
     * Related actions include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html">
     * GetPublicAccessBlock</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html">
     * PutPublicAccessBlock</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deletePublicAccessBlockRequest
     * @return A Java Future containing the result of the DeletePublicAccessBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeletePublicAccessBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeletePublicAccessBlock"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePublicAccessBlockResponse> deletePublicAccessBlock(
            DeletePublicAccessBlockRequest deletePublicAccessBlockRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePublicAccessBlockRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePublicAccessBlockRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePublicAccessBlock");

            HttpResponseHandler<Response<DeletePublicAccessBlockResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeletePublicAccessBlockResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeletePublicAccessBlockResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePublicAccessBlockRequest, DeletePublicAccessBlockResponse>()
                            .withOperationName("DeletePublicAccessBlock").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePublicAccessBlockRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePublicAccessBlockRequest));
            CompletableFuture<DeletePublicAccessBlockResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes the Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and
     * usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * To use this action, you must have permission to perform the <code>s3:DeleteStorageLensConfiguration</code>
     * action. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to
     * use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     *
     * @param deleteStorageLensConfigurationRequest
     * @return A Java Future containing the result of the DeleteStorageLensConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteStorageLensConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteStorageLensConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStorageLensConfigurationResponse> deleteStorageLensConfiguration(
            DeleteStorageLensConfigurationRequest deleteStorageLensConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteStorageLensConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteStorageLensConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStorageLensConfiguration");

            HttpResponseHandler<Response<DeleteStorageLensConfigurationResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteStorageLensConfigurationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteStorageLensConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStorageLensConfigurationRequest, DeleteStorageLensConfigurationResponse>()
                            .withOperationName("DeleteStorageLensConfiguration").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteStorageLensConfigurationRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteStorageLensConfigurationRequest));
            CompletableFuture<DeleteStorageLensConfigurationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Deletes the Amazon S3 Storage Lens configuration tags. For more information about S3 Storage Lens, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and
     * usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * To use this action, you must have permission to perform the <code>s3:DeleteStorageLensConfigurationTagging</code>
     * action. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to
     * use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     *
     * @param deleteStorageLensConfigurationTaggingRequest
     * @return A Java Future containing the result of the DeleteStorageLensConfigurationTagging operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteStorageLensConfigurationTagging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteStorageLensConfigurationTagging"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStorageLensConfigurationTaggingResponse> deleteStorageLensConfigurationTagging(
            DeleteStorageLensConfigurationTaggingRequest deleteStorageLensConfigurationTaggingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteStorageLensConfigurationTaggingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteStorageLensConfigurationTaggingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStorageLensConfigurationTagging");

            HttpResponseHandler<Response<DeleteStorageLensConfigurationTaggingResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteStorageLensConfigurationTaggingResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteStorageLensConfigurationTaggingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStorageLensConfigurationTaggingRequest, DeleteStorageLensConfigurationTaggingResponse>()
                            .withOperationName("DeleteStorageLensConfigurationTagging")
                            .withRequestConfiguration(clientConfiguration).withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteStorageLensConfigurationTaggingRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteStorageLensConfigurationTaggingRequest));
            CompletableFuture<DeleteStorageLensConfigurationTaggingResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing S3 Storage Lens group.
     * </p>
     * <p>
     * To use this operation, you must have the permission to perform the <code>s3:DeleteStorageLensGroup</code> action.
     * For more information about the required Storage Lens Groups permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions"
     * >Setting account permissions to use S3 Storage Lens groups</a>.
     * </p>
     * <p>
     * For information about Storage Lens groups errors, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList">List of Amazon S3
     * Storage Lens error codes</a>.
     * </p>
     *
     * @param deleteStorageLensGroupRequest
     * @return A Java Future containing the result of the DeleteStorageLensGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DeleteStorageLensGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteStorageLensGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStorageLensGroupResponse> deleteStorageLensGroup(
            DeleteStorageLensGroupRequest deleteStorageLensGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteStorageLensGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStorageLensGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStorageLensGroup");

            HttpResponseHandler<Response<DeleteStorageLensGroupResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteStorageLensGroupResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteStorageLensGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStorageLensGroupRequest, DeleteStorageLensGroupResponse>()
                            .withOperationName("DeleteStorageLensGroup").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteStorageLensGroupRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteStorageLensGroupRequest));
            CompletableFuture<DeleteStorageLensGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the configuration parameters and status for a Batch Operations job. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html">S3 Batch Operations</a> in the
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * To use the <code>DescribeJob</code> operation, you must have permission to perform the
     * <code>s3:DescribeJob</code> action.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Related actions include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html">UpdateJobPriority</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeJobRequest
     * @return A Java Future containing the result of the DescribeJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>TooManyRequestsException</li>
     *         <li>NotFoundException</li>
     *         <li>InternalServiceException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DescribeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DescribeJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeJobResponse> describeJob(DescribeJobRequest describeJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeJob");

            HttpResponseHandler<Response<DescribeJobResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    DescribeJobResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DescribeJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeJobRequest, DescribeJobResponse>()
                            .withOperationName("DescribeJob").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeJobRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeJobRequest));
            CompletableFuture<DescribeJobResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Retrieves the status of an asynchronous request to manage a Multi-Region Access Point. For more information about
     * managing Multi-Region Access Points and how asynchronous requests work, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/MrapOperations.html">Using Multi-Region Access
     * Points</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * The following actions are related to <code>GetMultiRegionAccessPoint</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">
     * CreateMultiRegionAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">
     * DeleteMultiRegionAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">
     * GetMultiRegionAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">
     * ListMultiRegionAccessPoints</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeMultiRegionAccessPointOperationRequest
     * @return A Java Future containing the result of the DescribeMultiRegionAccessPointOperation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DescribeMultiRegionAccessPointOperation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DescribeMultiRegionAccessPointOperation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMultiRegionAccessPointOperationResponse> describeMultiRegionAccessPointOperation(
            DescribeMultiRegionAccessPointOperationRequest describeMultiRegionAccessPointOperationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMultiRegionAccessPointOperationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMultiRegionAccessPointOperationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMultiRegionAccessPointOperation");

            HttpResponseHandler<Response<DescribeMultiRegionAccessPointOperationResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DescribeMultiRegionAccessPointOperationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DescribeMultiRegionAccessPointOperationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMultiRegionAccessPointOperationRequest, DescribeMultiRegionAccessPointOperationResponse>()
                            .withOperationName("DescribeMultiRegionAccessPointOperation")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMultiRegionAccessPointOperationRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(describeMultiRegionAccessPointOperationRequest));
            CompletableFuture<DescribeMultiRegionAccessPointOperationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Dissociates the Amazon Web Services IAM Identity Center instance from the S3 Access Grants instance.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:DissociateAccessGrantsIdentityCenter</code> permission to use this operation.
     * </p>
     * </dd>
     * <dt>Additional Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>sso:DeleteApplication</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param dissociateAccessGrantsIdentityCenterRequest
     * @return A Java Future containing the result of the DissociateAccessGrantsIdentityCenter operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.DissociateAccessGrantsIdentityCenter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DissociateAccessGrantsIdentityCenter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DissociateAccessGrantsIdentityCenterResponse> dissociateAccessGrantsIdentityCenter(
            DissociateAccessGrantsIdentityCenterRequest dissociateAccessGrantsIdentityCenterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(dissociateAccessGrantsIdentityCenterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                dissociateAccessGrantsIdentityCenterRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DissociateAccessGrantsIdentityCenter");

            HttpResponseHandler<Response<DissociateAccessGrantsIdentityCenterResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DissociateAccessGrantsIdentityCenterResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DissociateAccessGrantsIdentityCenterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DissociateAccessGrantsIdentityCenterRequest, DissociateAccessGrantsIdentityCenterResponse>()
                            .withOperationName("DissociateAccessGrantsIdentityCenter")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DissociateAccessGrantsIdentityCenterRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(dissociateAccessGrantsIdentityCenterRequest));
            CompletableFuture<DissociateAccessGrantsIdentityCenterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the details of an access grant from your S3 Access Grants instance.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:GetAccessGrant</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getAccessGrantRequest
     * @return A Java Future containing the result of the GetAccessGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetAccessGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessGrant" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccessGrantResponse> getAccessGrant(GetAccessGrantRequest getAccessGrantRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccessGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccessGrantRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessGrant");

            HttpResponseHandler<Response<GetAccessGrantResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetAccessGrantResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetAccessGrantResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccessGrantRequest, GetAccessGrantResponse>()
                            .withOperationName("GetAccessGrant")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccessGrantRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(getAccessGrantRequest));
            CompletableFuture<GetAccessGrantResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the S3 Access Grants instance for a Region in your account.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:GetAccessGrantsInstance</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getAccessGrantsInstanceRequest
     * @return A Java Future containing the result of the GetAccessGrantsInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetAccessGrantsInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessGrantsInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccessGrantsInstanceResponse> getAccessGrantsInstance(
            GetAccessGrantsInstanceRequest getAccessGrantsInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccessGrantsInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccessGrantsInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessGrantsInstance");

            HttpResponseHandler<Response<GetAccessGrantsInstanceResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetAccessGrantsInstanceResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetAccessGrantsInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccessGrantsInstanceRequest, GetAccessGrantsInstanceResponse>()
                            .withOperationName("GetAccessGrantsInstance")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccessGrantsInstanceRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(getAccessGrantsInstanceRequest));
            CompletableFuture<GetAccessGrantsInstanceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieve the S3 Access Grants instance that contains a particular prefix.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:GetAccessGrantsInstanceForPrefix</code> permission for the caller account to use this
     * operation.
     * </p>
     * </dd>
     * <dt>Additional Permissions</dt>
     * <dd>
     * <p>
     * The prefix owner account must grant you the following permissions to their S3 Access Grants instance:
     * <code>s3:GetAccessGrantsInstanceForPrefix</code>.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getAccessGrantsInstanceForPrefixRequest
     * @return A Java Future containing the result of the GetAccessGrantsInstanceForPrefix operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetAccessGrantsInstanceForPrefix
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessGrantsInstanceForPrefix"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccessGrantsInstanceForPrefixResponse> getAccessGrantsInstanceForPrefix(
            GetAccessGrantsInstanceForPrefixRequest getAccessGrantsInstanceForPrefixRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccessGrantsInstanceForPrefixRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAccessGrantsInstanceForPrefixRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessGrantsInstanceForPrefix");

            HttpResponseHandler<Response<GetAccessGrantsInstanceForPrefixResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetAccessGrantsInstanceForPrefixResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetAccessGrantsInstanceForPrefixResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccessGrantsInstanceForPrefixRequest, GetAccessGrantsInstanceForPrefixResponse>()
                            .withOperationName("GetAccessGrantsInstanceForPrefix")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccessGrantsInstanceForPrefixRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(getAccessGrantsInstanceForPrefixRequest));
            CompletableFuture<GetAccessGrantsInstanceForPrefixResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the resource policy of the S3 Access Grants instance.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:GetAccessGrantsInstanceResourcePolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getAccessGrantsInstanceResourcePolicyRequest
     * @return A Java Future containing the result of the GetAccessGrantsInstanceResourcePolicy operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetAccessGrantsInstanceResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessGrantsInstanceResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccessGrantsInstanceResourcePolicyResponse> getAccessGrantsInstanceResourcePolicy(
            GetAccessGrantsInstanceResourcePolicyRequest getAccessGrantsInstanceResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccessGrantsInstanceResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAccessGrantsInstanceResourcePolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessGrantsInstanceResourcePolicy");

            HttpResponseHandler<Response<GetAccessGrantsInstanceResourcePolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetAccessGrantsInstanceResourcePolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetAccessGrantsInstanceResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccessGrantsInstanceResourcePolicyRequest, GetAccessGrantsInstanceResourcePolicyResponse>()
                            .withOperationName("GetAccessGrantsInstanceResourcePolicy")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccessGrantsInstanceResourcePolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(getAccessGrantsInstanceResourcePolicyRequest));
            CompletableFuture<GetAccessGrantsInstanceResourcePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the details of a particular location registered in your S3 Access Grants instance.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:GetAccessGrantsLocation</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getAccessGrantsLocationRequest
     * @return A Java Future containing the result of the GetAccessGrantsLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetAccessGrantsLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessGrantsLocation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccessGrantsLocationResponse> getAccessGrantsLocation(
            GetAccessGrantsLocationRequest getAccessGrantsLocationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccessGrantsLocationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccessGrantsLocationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessGrantsLocation");

            HttpResponseHandler<Response<GetAccessGrantsLocationResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetAccessGrantsLocationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetAccessGrantsLocationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccessGrantsLocationRequest, GetAccessGrantsLocationResponse>()
                            .withOperationName("GetAccessGrantsLocation")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccessGrantsLocationRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(getAccessGrantsLocationRequest));
            CompletableFuture<GetAccessGrantsLocationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns configuration information about the specified access point.
     * </p>
     * <p/>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * The following actions are related to <code>GetAccessPoint</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html">DeleteAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html">ListAccessPoints</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getAccessPointRequest
     * @return A Java Future containing the result of the GetAccessPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetAccessPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccessPointResponse> getAccessPoint(GetAccessPointRequest getAccessPointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccessPointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccessPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessPoint");

            HttpResponseHandler<Response<GetAccessPointResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetAccessPointResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetAccessPointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccessPointRequest, GetAccessPointResponse>()
                            .withOperationName("GetAccessPoint").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccessPointRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAccessPointRequest));
            CompletableFuture<GetAccessPointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns configuration for an Object Lambda Access Point.
     * </p>
     * <p>
     * The following actions are related to <code>GetAccessPointConfigurationForObjectLambda</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointConfigurationForObjectLambda.html"
     * >PutAccessPointConfigurationForObjectLambda</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getAccessPointConfigurationForObjectLambdaRequest
     * @return A Java Future containing the result of the GetAccessPointConfigurationForObjectLambda operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetAccessPointConfigurationForObjectLambda
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointConfigurationForObjectLambda"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccessPointConfigurationForObjectLambdaResponse> getAccessPointConfigurationForObjectLambda(
            GetAccessPointConfigurationForObjectLambdaRequest getAccessPointConfigurationForObjectLambdaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                getAccessPointConfigurationForObjectLambdaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAccessPointConfigurationForObjectLambdaRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessPointConfigurationForObjectLambda");

            HttpResponseHandler<Response<GetAccessPointConfigurationForObjectLambdaResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetAccessPointConfigurationForObjectLambdaResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetAccessPointConfigurationForObjectLambdaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccessPointConfigurationForObjectLambdaRequest, GetAccessPointConfigurationForObjectLambdaResponse>()
                            .withOperationName("GetAccessPointConfigurationForObjectLambda")
                            .withRequestConfiguration(clientConfiguration).withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccessPointConfigurationForObjectLambdaRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAccessPointConfigurationForObjectLambdaRequest));
            CompletableFuture<GetAccessPointConfigurationForObjectLambdaResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns configuration information about the specified Object Lambda Access Point
     * </p>
     * <p>
     * The following actions are related to <code>GetAccessPointForObjectLambda</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html">
     * CreateAccessPointForObjectLambda</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html">
     * DeleteAccessPointForObjectLambda</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html">
     * ListAccessPointsForObjectLambda</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getAccessPointForObjectLambdaRequest
     * @return A Java Future containing the result of the GetAccessPointForObjectLambda operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetAccessPointForObjectLambda
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointForObjectLambda"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccessPointForObjectLambdaResponse> getAccessPointForObjectLambda(
            GetAccessPointForObjectLambdaRequest getAccessPointForObjectLambdaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccessPointForObjectLambdaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAccessPointForObjectLambdaRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessPointForObjectLambda");

            HttpResponseHandler<Response<GetAccessPointForObjectLambdaResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetAccessPointForObjectLambdaResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetAccessPointForObjectLambdaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccessPointForObjectLambdaRequest, GetAccessPointForObjectLambdaResponse>()
                            .withOperationName("GetAccessPointForObjectLambda").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccessPointForObjectLambdaRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAccessPointForObjectLambdaRequest));
            CompletableFuture<GetAccessPointForObjectLambdaResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the access point policy associated with the specified access point.
     * </p>
     * <p>
     * The following actions are related to <code>GetAccessPointPolicy</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html">
     * PutAccessPointPolicy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html">
     * DeleteAccessPointPolicy</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getAccessPointPolicyRequest
     * @return A Java Future containing the result of the GetAccessPointPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetAccessPointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccessPointPolicyResponse> getAccessPointPolicy(
            GetAccessPointPolicyRequest getAccessPointPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccessPointPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccessPointPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessPointPolicy");

            HttpResponseHandler<Response<GetAccessPointPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetAccessPointPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetAccessPointPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccessPointPolicyRequest, GetAccessPointPolicyResponse>()
                            .withOperationName("GetAccessPointPolicy").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccessPointPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAccessPointPolicyRequest));
            CompletableFuture<GetAccessPointPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the resource policy for an Object Lambda Access Point.
     * </p>
     * <p>
     * The following actions are related to <code>GetAccessPointPolicyForObjectLambda</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicyForObjectLambda.html">
     * DeleteAccessPointPolicyForObjectLambda</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicyForObjectLambda.html">
     * PutAccessPointPolicyForObjectLambda</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getAccessPointPolicyForObjectLambdaRequest
     * @return A Java Future containing the result of the GetAccessPointPolicyForObjectLambda operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetAccessPointPolicyForObjectLambda
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicyForObjectLambda"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccessPointPolicyForObjectLambdaResponse> getAccessPointPolicyForObjectLambda(
            GetAccessPointPolicyForObjectLambdaRequest getAccessPointPolicyForObjectLambdaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccessPointPolicyForObjectLambdaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAccessPointPolicyForObjectLambdaRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessPointPolicyForObjectLambda");

            HttpResponseHandler<Response<GetAccessPointPolicyForObjectLambdaResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetAccessPointPolicyForObjectLambdaResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetAccessPointPolicyForObjectLambdaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccessPointPolicyForObjectLambdaRequest, GetAccessPointPolicyForObjectLambdaResponse>()
                            .withOperationName("GetAccessPointPolicyForObjectLambda")
                            .withRequestConfiguration(clientConfiguration).withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccessPointPolicyForObjectLambdaRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAccessPointPolicyForObjectLambdaRequest));
            CompletableFuture<GetAccessPointPolicyForObjectLambdaResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Indicates whether the specified access point currently has a policy that allows public access. For more
     * information about public access through access points, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing Data Access with Amazon
     * S3 access points</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     *
     * @param getAccessPointPolicyStatusRequest
     * @return A Java Future containing the result of the GetAccessPointPolicyStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetAccessPointPolicyStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicyStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccessPointPolicyStatusResponse> getAccessPointPolicyStatus(
            GetAccessPointPolicyStatusRequest getAccessPointPolicyStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccessPointPolicyStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccessPointPolicyStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessPointPolicyStatus");

            HttpResponseHandler<Response<GetAccessPointPolicyStatusResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetAccessPointPolicyStatusResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetAccessPointPolicyStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccessPointPolicyStatusRequest, GetAccessPointPolicyStatusResponse>()
                            .withOperationName("GetAccessPointPolicyStatus").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccessPointPolicyStatusRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAccessPointPolicyStatusRequest));
            CompletableFuture<GetAccessPointPolicyStatusResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the status of the resource policy associated with an Object Lambda Access Point.
     * </p>
     *
     * @param getAccessPointPolicyStatusForObjectLambdaRequest
     * @return A Java Future containing the result of the GetAccessPointPolicyStatusForObjectLambda operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetAccessPointPolicyStatusForObjectLambda
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicyStatusForObjectLambda"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccessPointPolicyStatusForObjectLambdaResponse> getAccessPointPolicyStatusForObjectLambda(
            GetAccessPointPolicyStatusForObjectLambdaRequest getAccessPointPolicyStatusForObjectLambdaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                getAccessPointPolicyStatusForObjectLambdaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAccessPointPolicyStatusForObjectLambdaRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessPointPolicyStatusForObjectLambda");

            HttpResponseHandler<Response<GetAccessPointPolicyStatusForObjectLambdaResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetAccessPointPolicyStatusForObjectLambdaResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetAccessPointPolicyStatusForObjectLambdaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccessPointPolicyStatusForObjectLambdaRequest, GetAccessPointPolicyStatusForObjectLambdaResponse>()
                            .withOperationName("GetAccessPointPolicyStatusForObjectLambda")
                            .withRequestConfiguration(clientConfiguration).withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccessPointPolicyStatusForObjectLambdaRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAccessPointPolicyStatusForObjectLambdaRequest));
            CompletableFuture<GetAccessPointPolicyStatusForObjectLambdaResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an Amazon S3 on Outposts bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html"> Using Amazon S3 on Outposts</a>
     * in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If you are using an identity other than the root user of the Amazon Web Services account that owns the Outposts
     * bucket, the calling identity must have the <code>s3-outposts:GetBucket</code> permissions on the specified
     * Outposts bucket and belong to the Outposts bucket owner's account in order to use this action. Only users from
     * Outposts bucket owner account with the right permissions can perform actions on an Outposts bucket.
     * </p>
     * <p>
     * If you don't have <code>s3-outposts:GetBucket</code> permissions or you're not using an identity that belongs to
     * the bucket owner's account, Amazon S3 returns a <code>403 Access Denied</code> error.
     * </p>
     * <p>
     * The following actions are related to <code>GetBucket</code> for Amazon S3 on Outposts:
     * </p>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html#API_control_GetBucket_Examples"
     * >Examples</a> section.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html">CreateBucket</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html">DeleteBucket</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketRequest
     * @return A Java Future containing the result of the GetBucket operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucket" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBucketResponse> getBucket(GetBucketRequest getBucketRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBucketRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBucketRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucket");

            HttpResponseHandler<Response<GetBucketResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    GetBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetBucketResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBucketRequest, GetBucketResponse>().withOperationName("GetBucket")
                            .withRequestConfiguration(clientConfiguration).withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBucketRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBucketRequest));
            CompletableFuture<GetBucketResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action gets an Amazon S3 on Outposts bucket's lifecycle configuration. To get an S3 bucket's lifecycle
     * configuration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html"
     * >GetBucketLifecycleConfiguration</a> in the <i>Amazon S3 API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Returns the lifecycle configuration information set on the Outposts bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a>
     * and for information about lifecycle configuration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html"> Object Lifecycle
     * Management</a> in <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * To use this action, you must have permission to perform the <code>s3-outposts:GetLifecycleConfiguration</code>
     * action. The Outposts bucket owner has this permission, by default. The bucket owner can grant this permission to
     * others. For more information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * >Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions
     * to Your Amazon S3 Resources</a>.
     * </p>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html#API_control_GetBucketLifecycleConfiguration_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * <code>GetBucketLifecycleConfiguration</code> has the following special error:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Error code: <code>NoSuchLifecycleConfiguration</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: The lifecycle configuration does not exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * HTTP Status Code: 404 Not Found
     * </p>
     * </li>
     * <li>
     * <p>
     * SOAP Fault Code Prefix: Client
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * The following actions are related to <code>GetBucketLifecycleConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html">
     * PutBucketLifecycleConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html">
     * DeleteBucketLifecycleConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketLifecycleConfigurationRequest
     * @return A Java Future containing the result of the GetBucketLifecycleConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetBucketLifecycleConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketLifecycleConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBucketLifecycleConfigurationResponse> getBucketLifecycleConfiguration(
            GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBucketLifecycleConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketLifecycleConfiguration");

            HttpResponseHandler<Response<GetBucketLifecycleConfigurationResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetBucketLifecycleConfigurationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetBucketLifecycleConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBucketLifecycleConfigurationRequest, GetBucketLifecycleConfigurationResponse>()
                            .withOperationName("GetBucketLifecycleConfiguration").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBucketLifecycleConfigurationRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBucketLifecycleConfigurationRequest));
            CompletableFuture<GetBucketLifecycleConfigurationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action gets a bucket policy for an Amazon S3 on Outposts bucket. To get a policy for an S3 bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicy.html">GetBucketPolicy</a> in the
     * <i>Amazon S3 API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Returns the policy of a specified Outposts bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in
     * the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket,
     * the calling identity must have the <code>GetBucketPolicy</code> permissions on the specified bucket and belong to
     * the bucket owner's account in order to use this action.
     * </p>
     * <p>
     * Only users from Outposts bucket owner account with the right permissions can perform actions on an Outposts
     * bucket. If you don't have <code>s3-outposts:GetBucketPolicy</code> permissions or you're not using an identity
     * that belongs to the bucket owner's account, Amazon S3 returns a <code>403 Access Denied</code> error.
     * </p>
     * <important>
     * <p>
     * As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this
     * action, even if the policy explicitly denies the root user the ability to perform this action.
     * </p>
     * </important>
     * <p>
     * For more information about bucket policies, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User
     * Policies</a>.
     * </p>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html#API_control_GetBucketPolicy_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * The following actions are related to <code>GetBucketPolicy</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html">PutBucketPolicy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html">DeleteBucketPolicy</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketPolicyRequest
     * @return A Java Future containing the result of the GetBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBucketPolicyResponse> getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBucketPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBucketPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketPolicy");

            HttpResponseHandler<Response<GetBucketPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetBucketPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetBucketPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBucketPolicyRequest, GetBucketPolicyResponse>()
                            .withOperationName("GetBucketPolicy").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBucketPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBucketPolicyRequest));
            CompletableFuture<GetBucketPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation gets an Amazon S3 on Outposts bucket's replication configuration. To get an S3 bucket's
     * replication configuration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketReplication.html">GetBucketReplication</a> in
     * the <i>Amazon S3 API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Returns the replication configuration of an S3 on Outposts bucket. For more information about S3 on Outposts, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a>
     * in the <i>Amazon S3 User Guide</i>. For information about S3 replication on Outposts configuration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html">Replicating objects for
     * S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * It can take a while to propagate <code>PUT</code> or <code>DELETE</code> requests for a replication configuration
     * to all S3 on Outposts systems. Therefore, the replication configuration that's returned by a <code>GET</code>
     * request soon after a <code>PUT</code> or <code>DELETE</code> request might return a more recent result than
     * what's on the Outpost. If an Outpost is offline, the delay in updating the replication configuration on that
     * Outpost can be significant.
     * </p>
     * </note>
     * <p>
     * This action requires permissions for the <code>s3-outposts:GetReplicationConfiguration</code> action. The
     * Outposts bucket owner has this permission by default and can grant it to others. For more information about
     * permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsIAM.html">Setting up
     * IAM with S3 on Outposts</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsBucketPolicy.html">Managing access to S3 on
     * Outposts bucket</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketReplication.html#API_control_GetBucketReplication_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * If you include the <code>Filter</code> element in a replication configuration, you must also include the
     * <code>DeleteMarkerReplication</code>, <code>Status</code>, and <code>Priority</code> elements. The response also
     * returns those elements.
     * </p>
     * <p>
     * For information about S3 on Outposts replication failure reasons, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/outposts-replication-eventbridge.html#outposts-replication-failure-codes"
     * >Replication failure reasons</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketReplication</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketReplication.html">
     * PutBucketReplication</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketReplication.html">
     * DeleteBucketReplication</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketReplicationRequest
     * @return A Java Future containing the result of the GetBucketReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetBucketReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketReplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBucketReplicationResponse> getBucketReplication(
            GetBucketReplicationRequest getBucketReplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBucketReplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBucketReplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketReplication");

            HttpResponseHandler<Response<GetBucketReplicationResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetBucketReplicationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetBucketReplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBucketReplicationRequest, GetBucketReplicationResponse>()
                            .withOperationName("GetBucketReplication").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBucketReplicationRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBucketReplicationRequest));
            CompletableFuture<GetBucketReplicationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action gets an Amazon S3 on Outposts bucket's tags. To get an S3 bucket tags, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html">GetBucketTagging</a> in the
     * <i>Amazon S3 API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Returns the tag set associated with the Outposts bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in
     * the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * To use this action, you must have permission to perform the <code>GetBucketTagging</code> action. By default, the
     * bucket owner has this permission and can grant this permission to others.
     * </p>
     * <p>
     * <code>GetBucketTagging</code> has the following special error:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Error code: <code>NoSuchTagSetError</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: There is no tag set associated with the bucket.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html#API_control_GetBucketTagging_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * The following actions are related to <code>GetBucketTagging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html">PutBucketTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html">DeleteBucketTagging
     * </a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketTaggingRequest
     * @return A Java Future containing the result of the GetBucketTagging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetBucketTagging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketTagging" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBucketTaggingResponse> getBucketTagging(GetBucketTaggingRequest getBucketTaggingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBucketTaggingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBucketTaggingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketTagging");

            HttpResponseHandler<Response<GetBucketTaggingResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetBucketTaggingResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetBucketTaggingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBucketTaggingRequest, GetBucketTaggingResponse>()
                            .withOperationName("GetBucketTagging").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBucketTaggingRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBucketTaggingRequest));
            CompletableFuture<GetBucketTaggingResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation returns the versioning state for S3 on Outposts buckets only. To return the versioning state for
     * an S3 bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html">GetBucketVersioning</a> in
     * the <i>Amazon S3 API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Returns the versioning state for an S3 on Outposts bucket. With S3 Versioning, you can save multiple distinct
     * copies of your objects and recover from unintended user actions and application failures.
     * </p>
     * <p>
     * If you've never set versioning on your bucket, it has no versioning state. In that case, the
     * <code>GetBucketVersioning</code> request does not return a versioning state value.
     * </p>
     * <p>
     * For more information about versioning, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Versioning.html">Versioning</a> in the <i>Amazon S3
     * User Guide</i>.
     * </p>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketVersioning.html#API_control_GetBucketVersioning_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * The following operations are related to <code>GetBucketVersioning</code> for S3 on Outposts.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketVersioning.html">PutBucketVersioning
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html">
     * PutBucketLifecycleConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html">
     * GetBucketLifecycleConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getBucketVersioningRequest
     * @return A Java Future containing the result of the GetBucketVersioning operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetBucketVersioning
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketVersioning" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBucketVersioningResponse> getBucketVersioning(
            GetBucketVersioningRequest getBucketVersioningRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBucketVersioningRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBucketVersioningRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketVersioning");

            HttpResponseHandler<Response<GetBucketVersioningResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetBucketVersioningResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetBucketVersioningResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBucketVersioningRequest, GetBucketVersioningResponse>()
                            .withOperationName("GetBucketVersioning").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBucketVersioningRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBucketVersioningRequest));
            CompletableFuture<GetBucketVersioningResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a temporary access credential from S3 Access Grants to the grantee or client application. The <a
     * href="https://docs.aws.amazon.com/STS/latest/APIReference/API_Credentials.html">temporary credential</a> is an
     * Amazon Web Services STS token that grants them access to the S3 data.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:GetDataAccess</code> permission to use this operation.
     * </p>
     * </dd>
     * <dt>Additional Permissions</dt>
     * <dd>
     * <p>
     * The IAM role that S3 Access Grants assumes must have the following permissions specified in the trust policy when
     * registering the location: <code>sts:AssumeRole</code>, for directory users or groups <code>sts:SetContext</code>,
     * and for IAM users or roles <code>sts:SetSourceIdentity</code>.
     * </p>
     * </dd>
     * </dl>
     *
     * @param getDataAccessRequest
     * @return A Java Future containing the result of the GetDataAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetDataAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetDataAccess" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDataAccessResponse> getDataAccess(GetDataAccessRequest getDataAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDataAccessRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDataAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataAccess");

            HttpResponseHandler<Response<GetDataAccessResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    GetDataAccessResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetDataAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDataAccessRequest, GetDataAccessResponse>()
                            .withOperationName("GetDataAccess")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDataAccessRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(getDataAccessRequest));
            CompletableFuture<GetDataAccessResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the tags on an S3 Batch Operations job.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * To use the <code>GetJobTagging</code> operation, you must have permission to perform the
     * <code>s3:GetJobTagging</code> action. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags"
     * >Controlling access and labeling jobs using tags</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Related actions include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html">PutJobTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html">DeleteJobTagging</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getJobTaggingRequest
     * @return A Java Future containing the result of the GetJobTagging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException</li>
     *         <li>TooManyRequestsException</li>
     *         <li>NotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetJobTagging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetJobTagging" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetJobTaggingResponse> getJobTagging(GetJobTaggingRequest getJobTaggingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJobTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getJobTaggingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJobTagging");

            HttpResponseHandler<Response<GetJobTaggingResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    GetJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetJobTaggingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetJobTaggingRequest, GetJobTaggingResponse>()
                            .withOperationName("GetJobTagging").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetJobTaggingRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getJobTaggingRequest));
            CompletableFuture<GetJobTaggingResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns configuration information about the specified Multi-Region Access Point.
     * </p>
     * <p>
     * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions
     * around working with Multi-Region Access Points, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html">Multi-Region
     * Access Point restrictions and limitations</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * The following actions are related to <code>GetMultiRegionAccessPoint</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">
     * CreateMultiRegionAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">
     * DeleteMultiRegionAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html"
     * >DescribeMultiRegionAccessPointOperation</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">
     * ListMultiRegionAccessPoints</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getMultiRegionAccessPointRequest
     * @return A Java Future containing the result of the GetMultiRegionAccessPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetMultiRegionAccessPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetMultiRegionAccessPoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMultiRegionAccessPointResponse> getMultiRegionAccessPoint(
            GetMultiRegionAccessPointRequest getMultiRegionAccessPointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMultiRegionAccessPointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMultiRegionAccessPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMultiRegionAccessPoint");

            HttpResponseHandler<Response<GetMultiRegionAccessPointResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetMultiRegionAccessPointResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetMultiRegionAccessPointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMultiRegionAccessPointRequest, GetMultiRegionAccessPointResponse>()
                            .withOperationName("GetMultiRegionAccessPoint")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMultiRegionAccessPointRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(getMultiRegionAccessPointRequest));
            CompletableFuture<GetMultiRegionAccessPointResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the access control policy of the specified Multi-Region Access Point.
     * </p>
     * <p>
     * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions
     * around working with Multi-Region Access Points, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html">Multi-Region
     * Access Point restrictions and limitations</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * The following actions are related to <code>GetMultiRegionAccessPointPolicy</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicyStatus.html">
     * GetMultiRegionAccessPointPolicyStatus</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPointPolicy.html">
     * PutMultiRegionAccessPointPolicy</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getMultiRegionAccessPointPolicyRequest
     * @return A Java Future containing the result of the GetMultiRegionAccessPointPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetMultiRegionAccessPointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetMultiRegionAccessPointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMultiRegionAccessPointPolicyResponse> getMultiRegionAccessPointPolicy(
            GetMultiRegionAccessPointPolicyRequest getMultiRegionAccessPointPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMultiRegionAccessPointPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getMultiRegionAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMultiRegionAccessPointPolicy");

            HttpResponseHandler<Response<GetMultiRegionAccessPointPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetMultiRegionAccessPointPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetMultiRegionAccessPointPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMultiRegionAccessPointPolicyRequest, GetMultiRegionAccessPointPolicyResponse>()
                            .withOperationName("GetMultiRegionAccessPointPolicy")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMultiRegionAccessPointPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(getMultiRegionAccessPointPolicyRequest));
            CompletableFuture<GetMultiRegionAccessPointPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Indicates whether the specified Multi-Region Access Point has an access control policy that allows public access.
     * </p>
     * <p>
     * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions
     * around working with Multi-Region Access Points, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html">Multi-Region
     * Access Point restrictions and limitations</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * The following actions are related to <code>GetMultiRegionAccessPointPolicyStatus</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicy.html">
     * GetMultiRegionAccessPointPolicy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPointPolicy.html">
     * PutMultiRegionAccessPointPolicy</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getMultiRegionAccessPointPolicyStatusRequest
     * @return A Java Future containing the result of the GetMultiRegionAccessPointPolicyStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetMultiRegionAccessPointPolicyStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetMultiRegionAccessPointPolicyStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMultiRegionAccessPointPolicyStatusResponse> getMultiRegionAccessPointPolicyStatus(
            GetMultiRegionAccessPointPolicyStatusRequest getMultiRegionAccessPointPolicyStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMultiRegionAccessPointPolicyStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getMultiRegionAccessPointPolicyStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMultiRegionAccessPointPolicyStatus");

            HttpResponseHandler<Response<GetMultiRegionAccessPointPolicyStatusResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetMultiRegionAccessPointPolicyStatusResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetMultiRegionAccessPointPolicyStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMultiRegionAccessPointPolicyStatusRequest, GetMultiRegionAccessPointPolicyStatusResponse>()
                            .withOperationName("GetMultiRegionAccessPointPolicyStatus")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMultiRegionAccessPointPolicyStatusRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(getMultiRegionAccessPointPolicyStatusRequest));
            CompletableFuture<GetMultiRegionAccessPointPolicyStatusResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns the routing configuration for a Multi-Region Access Point, indicating which Regions are active or
     * passive.
     * </p>
     * <p>
     * To obtain routing control changes and failover requests, use the Amazon S3 failover control infrastructure
     * endpoints in these five Amazon Web Services Regions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>us-east-1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>us-west-2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ap-southeast-2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ap-northeast-1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>eu-west-1</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param getMultiRegionAccessPointRoutesRequest
     * @return A Java Future containing the result of the GetMultiRegionAccessPointRoutes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetMultiRegionAccessPointRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetMultiRegionAccessPointRoutes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMultiRegionAccessPointRoutesResponse> getMultiRegionAccessPointRoutes(
            GetMultiRegionAccessPointRoutesRequest getMultiRegionAccessPointRoutesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMultiRegionAccessPointRoutesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getMultiRegionAccessPointRoutesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMultiRegionAccessPointRoutes");

            HttpResponseHandler<Response<GetMultiRegionAccessPointRoutesResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetMultiRegionAccessPointRoutesResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetMultiRegionAccessPointRoutesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMultiRegionAccessPointRoutesRequest, GetMultiRegionAccessPointRoutesResponse>()
                            .withOperationName("GetMultiRegionAccessPointRoutes")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMultiRegionAccessPointRoutesRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(getMultiRegionAccessPointRoutesRequest));
            CompletableFuture<GetMultiRegionAccessPointRoutesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Retrieves the <code>PublicAccessBlock</code> configuration for an Amazon Web Services account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html"> Using Amazon S3
     * block public access</a>.
     * </p>
     * <p>
     * Related actions include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html">
     * DeletePublicAccessBlock</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html">
     * PutPublicAccessBlock</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getPublicAccessBlockRequest
     * @return A Java Future containing the result of the GetPublicAccessBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchPublicAccessBlockConfigurationException Amazon S3 throws this exception if you make a
     *         <code>GetPublicAccessBlock</code> request against an account that doesn't have a
     *         <code>PublicAccessBlockConfiguration</code> set.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetPublicAccessBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetPublicAccessBlock"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPublicAccessBlockResponse> getPublicAccessBlock(
            GetPublicAccessBlockRequest getPublicAccessBlockRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPublicAccessBlockRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPublicAccessBlockRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPublicAccessBlock");

            HttpResponseHandler<Response<GetPublicAccessBlockResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetPublicAccessBlockResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetPublicAccessBlockResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPublicAccessBlockRequest, GetPublicAccessBlockResponse>()
                            .withOperationName("GetPublicAccessBlock").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPublicAccessBlockRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPublicAccessBlockRequest));
            CompletableFuture<GetPublicAccessBlockResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Gets the Amazon S3 Storage Lens configuration. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and
     * usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>. For a complete list of S3 Storage Lens
     * metrics, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html">S3 Storage Lens
     * metrics glossary</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * To use this action, you must have permission to perform the <code>s3:GetStorageLensConfiguration</code> action.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to
     * use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     *
     * @param getStorageLensConfigurationRequest
     * @return A Java Future containing the result of the GetStorageLensConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetStorageLensConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetStorageLensConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetStorageLensConfigurationResponse> getStorageLensConfiguration(
            GetStorageLensConfigurationRequest getStorageLensConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getStorageLensConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStorageLensConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStorageLensConfiguration");

            HttpResponseHandler<Response<GetStorageLensConfigurationResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetStorageLensConfigurationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetStorageLensConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStorageLensConfigurationRequest, GetStorageLensConfigurationResponse>()
                            .withOperationName("GetStorageLensConfiguration").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetStorageLensConfigurationRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getStorageLensConfigurationRequest));
            CompletableFuture<GetStorageLensConfigurationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Gets the tags of Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and
     * usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * To use this action, you must have permission to perform the <code>s3:GetStorageLensConfigurationTagging</code>
     * action. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to
     * use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     *
     * @param getStorageLensConfigurationTaggingRequest
     * @return A Java Future containing the result of the GetStorageLensConfigurationTagging operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetStorageLensConfigurationTagging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetStorageLensConfigurationTagging"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetStorageLensConfigurationTaggingResponse> getStorageLensConfigurationTagging(
            GetStorageLensConfigurationTaggingRequest getStorageLensConfigurationTaggingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getStorageLensConfigurationTaggingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getStorageLensConfigurationTaggingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStorageLensConfigurationTagging");

            HttpResponseHandler<Response<GetStorageLensConfigurationTaggingResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetStorageLensConfigurationTaggingResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetStorageLensConfigurationTaggingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStorageLensConfigurationTaggingRequest, GetStorageLensConfigurationTaggingResponse>()
                            .withOperationName("GetStorageLensConfigurationTagging")
                            .withRequestConfiguration(clientConfiguration).withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetStorageLensConfigurationTaggingRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getStorageLensConfigurationTaggingRequest));
            CompletableFuture<GetStorageLensConfigurationTaggingResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the Storage Lens group configuration details.
     * </p>
     * <p>
     * To use this operation, you must have the permission to perform the <code>s3:GetStorageLensGroup</code> action.
     * For more information about the required Storage Lens Groups permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions"
     * >Setting account permissions to use S3 Storage Lens groups</a>.
     * </p>
     * <p>
     * For information about Storage Lens groups errors, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList">List of Amazon S3
     * Storage Lens error codes</a>.
     * </p>
     *
     * @param getStorageLensGroupRequest
     * @return A Java Future containing the result of the GetStorageLensGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.GetStorageLensGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetStorageLensGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetStorageLensGroupResponse> getStorageLensGroup(
            GetStorageLensGroupRequest getStorageLensGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getStorageLensGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStorageLensGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStorageLensGroup");

            HttpResponseHandler<Response<GetStorageLensGroupResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetStorageLensGroupResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetStorageLensGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStorageLensGroupRequest, GetStorageLensGroupResponse>()
                            .withOperationName("GetStorageLensGroup").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetStorageLensGroupRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getStorageLensGroupRequest));
            CompletableFuture<GetStorageLensGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of access grants in your S3 Access Grants instance.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:ListAccessGrants</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param listAccessGrantsRequest
     * @return A Java Future containing the result of the ListAccessGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.ListAccessGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessGrants" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccessGrantsResponse> listAccessGrants(ListAccessGrantsRequest listAccessGrantsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAccessGrantsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccessGrantsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccessGrants");

            HttpResponseHandler<Response<ListAccessGrantsResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListAccessGrantsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListAccessGrantsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccessGrantsRequest, ListAccessGrantsResponse>()
                            .withOperationName("ListAccessGrants")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAccessGrantsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(listAccessGrantsRequest));
            CompletableFuture<ListAccessGrantsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of S3 Access Grants instances. An S3 Access Grants instance serves as a logical grouping for your
     * individual access grants. You can only have one S3 Access Grants instance per Region per account.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:ListAccessGrantsInstances</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param listAccessGrantsInstancesRequest
     * @return A Java Future containing the result of the ListAccessGrantsInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.ListAccessGrantsInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessGrantsInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccessGrantsInstancesResponse> listAccessGrantsInstances(
            ListAccessGrantsInstancesRequest listAccessGrantsInstancesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAccessGrantsInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccessGrantsInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccessGrantsInstances");

            HttpResponseHandler<Response<ListAccessGrantsInstancesResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListAccessGrantsInstancesResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListAccessGrantsInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccessGrantsInstancesRequest, ListAccessGrantsInstancesResponse>()
                            .withOperationName("ListAccessGrantsInstances")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAccessGrantsInstancesRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(listAccessGrantsInstancesRequest));
            CompletableFuture<ListAccessGrantsInstancesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of the locations registered in your S3 Access Grants instance.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:ListAccessGrantsLocations</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param listAccessGrantsLocationsRequest
     * @return A Java Future containing the result of the ListAccessGrantsLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.ListAccessGrantsLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessGrantsLocations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccessGrantsLocationsResponse> listAccessGrantsLocations(
            ListAccessGrantsLocationsRequest listAccessGrantsLocationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAccessGrantsLocationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccessGrantsLocationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccessGrantsLocations");

            HttpResponseHandler<Response<ListAccessGrantsLocationsResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListAccessGrantsLocationsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListAccessGrantsLocationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccessGrantsLocationsRequest, ListAccessGrantsLocationsResponse>()
                            .withOperationName("ListAccessGrantsLocations")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAccessGrantsLocationsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(listAccessGrantsLocationsRequest));
            CompletableFuture<ListAccessGrantsLocationsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns a list of the access points that are owned by the current account that's associated with the specified
     * bucket. You can retrieve up to 1000 access points per call. If the specified bucket has more than 1,000 access
     * points (or the number specified in <code>maxResults</code>, whichever is less), the response will include a
     * continuation token that you can use to list the additional access points.
     * </p>
     * <p/>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * The following actions are related to <code>ListAccessPoints</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html">DeleteAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html">GetAccessPoint</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listAccessPointsRequest
     * @return A Java Future containing the result of the ListAccessPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.ListAccessPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessPoints" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccessPointsResponse> listAccessPoints(ListAccessPointsRequest listAccessPointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAccessPointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccessPointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccessPoints");

            HttpResponseHandler<Response<ListAccessPointsResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListAccessPointsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListAccessPointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccessPointsRequest, ListAccessPointsResponse>()
                            .withOperationName("ListAccessPoints").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAccessPointsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAccessPointsRequest));
            CompletableFuture<ListAccessPointsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns some or all (up to 1,000) access points associated with the Object Lambda Access Point per call. If there
     * are more access points than what can be returned in one call, the response will include a continuation token that
     * you can use to list the additional access points.
     * </p>
     * <p>
     * The following actions are related to <code>ListAccessPointsForObjectLambda</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html">
     * CreateAccessPointForObjectLambda</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html">
     * DeleteAccessPointForObjectLambda</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html">
     * GetAccessPointForObjectLambda</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listAccessPointsForObjectLambdaRequest
     * @return A Java Future containing the result of the ListAccessPointsForObjectLambda operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.ListAccessPointsForObjectLambda
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessPointsForObjectLambda"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccessPointsForObjectLambdaResponse> listAccessPointsForObjectLambda(
            ListAccessPointsForObjectLambdaRequest listAccessPointsForObjectLambdaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAccessPointsForObjectLambdaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAccessPointsForObjectLambdaRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccessPointsForObjectLambda");

            HttpResponseHandler<Response<ListAccessPointsForObjectLambdaResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListAccessPointsForObjectLambdaResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListAccessPointsForObjectLambdaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccessPointsForObjectLambdaRequest, ListAccessPointsForObjectLambdaResponse>()
                            .withOperationName("ListAccessPointsForObjectLambda").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAccessPointsForObjectLambdaRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAccessPointsForObjectLambdaRequest));
            CompletableFuture<ListAccessPointsForObjectLambdaResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists current S3 Batch Operations jobs as well as the jobs that have ended within the last 90 days for the Amazon
     * Web Services account making the request. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html">S3 Batch Operations</a> in the
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * To use the <code>ListJobs</code> operation, you must have permission to perform the <code>s3:ListJobs</code>
     * action.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Related actions include:
     * </p>
     * <p/>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html">UpdateJobPriority</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listJobsRequest
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException </li> <li>InternalServiceException </li> <li>InvalidNextTokenException </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs such as
     *         an IO related failure, failure to get credentials, etc.</li> <li>S3ControlException Base class for all
     *         service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest listJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListJobs");

            HttpResponseHandler<Response<ListJobsResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    ListJobsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListJobsRequest, ListJobsResponse>().withOperationName("ListJobs")
                            .withRequestConfiguration(clientConfiguration).withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListJobsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listJobsRequest));
            CompletableFuture<ListJobsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns a list of the Multi-Region Access Points currently associated with the specified Amazon Web Services
     * account. Each call can return up to 100 Multi-Region Access Points, the maximum number of Multi-Region Access
     * Points that can be associated with a single account.
     * </p>
     * <p>
     * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions
     * around working with Multi-Region Access Points, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html">Multi-Region
     * Access Point restrictions and limitations</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * The following actions are related to <code>ListMultiRegionAccessPoint</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">
     * CreateMultiRegionAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">
     * DeleteMultiRegionAccessPoint</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html"
     * >DescribeMultiRegionAccessPointOperation</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">
     * GetMultiRegionAccessPoint</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listMultiRegionAccessPointsRequest
     * @return A Java Future containing the result of the ListMultiRegionAccessPoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.ListMultiRegionAccessPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListMultiRegionAccessPoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMultiRegionAccessPointsResponse> listMultiRegionAccessPoints(
            ListMultiRegionAccessPointsRequest listMultiRegionAccessPointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMultiRegionAccessPointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMultiRegionAccessPointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMultiRegionAccessPoints");

            HttpResponseHandler<Response<ListMultiRegionAccessPointsResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListMultiRegionAccessPointsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListMultiRegionAccessPointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMultiRegionAccessPointsRequest, ListMultiRegionAccessPointsResponse>()
                            .withOperationName("ListMultiRegionAccessPoints")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMultiRegionAccessPointsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(listMultiRegionAccessPointsRequest));
            CompletableFuture<ListMultiRegionAccessPointsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Returns a list of all Outposts buckets in an Outpost that are owned by the authenticated sender of the request.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using
     * Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname
     * prefix and <code>x-amz-outpost-id</code> in your request, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListRegionalBuckets.html#API_control_ListRegionalBuckets_Examples"
     * >Examples</a> section.
     * </p>
     *
     * @param listRegionalBucketsRequest
     * @return A Java Future containing the result of the ListRegionalBuckets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.ListRegionalBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListRegionalBuckets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRegionalBucketsResponse> listRegionalBuckets(
            ListRegionalBucketsRequest listRegionalBucketsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRegionalBucketsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRegionalBucketsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRegionalBuckets");

            HttpResponseHandler<Response<ListRegionalBucketsResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListRegionalBucketsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListRegionalBucketsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRegionalBucketsRequest, ListRegionalBucketsResponse>()
                            .withOperationName("ListRegionalBuckets").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRegionalBucketsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRegionalBucketsRequest));
            CompletableFuture<ListRegionalBucketsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Gets a list of Amazon S3 Storage Lens configurations. For more information about S3 Storage Lens, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and
     * usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * To use this action, you must have permission to perform the <code>s3:ListStorageLensConfigurations</code> action.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to
     * use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     *
     * @param listStorageLensConfigurationsRequest
     * @return A Java Future containing the result of the ListStorageLensConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.ListStorageLensConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListStorageLensConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListStorageLensConfigurationsResponse> listStorageLensConfigurations(
            ListStorageLensConfigurationsRequest listStorageLensConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStorageLensConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listStorageLensConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStorageLensConfigurations");

            HttpResponseHandler<Response<ListStorageLensConfigurationsResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListStorageLensConfigurationsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListStorageLensConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStorageLensConfigurationsRequest, ListStorageLensConfigurationsResponse>()
                            .withOperationName("ListStorageLensConfigurations").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListStorageLensConfigurationsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listStorageLensConfigurationsRequest));
            CompletableFuture<ListStorageLensConfigurationsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the Storage Lens groups in the specified home Region.
     * </p>
     * <p>
     * To use this operation, you must have the permission to perform the <code>s3:ListStorageLensGroups</code> action.
     * For more information about the required Storage Lens Groups permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions"
     * >Setting account permissions to use S3 Storage Lens groups</a>.
     * </p>
     * <p>
     * For information about Storage Lens groups errors, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList">List of Amazon S3
     * Storage Lens error codes</a>.
     * </p>
     *
     * @param listStorageLensGroupsRequest
     * @return A Java Future containing the result of the ListStorageLensGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.ListStorageLensGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListStorageLensGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListStorageLensGroupsResponse> listStorageLensGroups(
            ListStorageLensGroupsRequest listStorageLensGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStorageLensGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStorageLensGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStorageLensGroups");

            HttpResponseHandler<Response<ListStorageLensGroupsResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListStorageLensGroupsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListStorageLensGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStorageLensGroupsRequest, ListStorageLensGroupsResponse>()
                            .withOperationName("ListStorageLensGroups").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListStorageLensGroupsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listStorageLensGroupsRequest));
            CompletableFuture<ListStorageLensGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This operation allows you to list all the Amazon Web Services resource tags for a specified resource. Each tag is
     * a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and
     * filter resources.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:ListTagsForResource</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <note>
     * <p>
     * This operation is only supported for <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups.html">S3 Storage Lens groups</a>
     * and for <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-tagging.html">S3 Access
     * Grants</a>. The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered
     * location, or grant.
     * </p>
     * </note>
     * <p>
     * For more information about the required Storage Lens Groups permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions"
     * >Setting account permissions to use S3 Storage Lens groups</a>.
     * </p>
     * <p>
     * For information about S3 Tagging errors, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3TaggingErrorCodeList">List of Amazon
     * S3 Tagging error codes</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            HttpResponseHandler<Response<ListTagsForResourceResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListTagsForResourceResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the resource policy of the S3 Access Grants instance.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:PutAccessGrantsInstanceResourcePolicy</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     *
     * @param putAccessGrantsInstanceResourcePolicyRequest
     * @return A Java Future containing the result of the PutAccessGrantsInstanceResourcePolicy operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.PutAccessGrantsInstanceResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessGrantsInstanceResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutAccessGrantsInstanceResourcePolicyResponse> putAccessGrantsInstanceResourcePolicy(
            PutAccessGrantsInstanceResourcePolicyRequest putAccessGrantsInstanceResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putAccessGrantsInstanceResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putAccessGrantsInstanceResourcePolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAccessGrantsInstanceResourcePolicy");

            HttpResponseHandler<Response<PutAccessGrantsInstanceResourcePolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(PutAccessGrantsInstanceResourcePolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<PutAccessGrantsInstanceResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutAccessGrantsInstanceResourcePolicyRequest, PutAccessGrantsInstanceResourcePolicyResponse>()
                            .withOperationName("PutAccessGrantsInstanceResourcePolicy")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutAccessGrantsInstanceResourcePolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(putAccessGrantsInstanceResourcePolicyRequest));
            CompletableFuture<PutAccessGrantsInstanceResourcePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Replaces configuration for an Object Lambda Access Point.
     * </p>
     * <p>
     * The following actions are related to <code>PutAccessPointConfigurationForObjectLambda</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointConfigurationForObjectLambda.html"
     * >GetAccessPointConfigurationForObjectLambda</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putAccessPointConfigurationForObjectLambdaRequest
     * @return A Java Future containing the result of the PutAccessPointConfigurationForObjectLambda operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.PutAccessPointConfigurationForObjectLambda
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessPointConfigurationForObjectLambda"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutAccessPointConfigurationForObjectLambdaResponse> putAccessPointConfigurationForObjectLambda(
            PutAccessPointConfigurationForObjectLambdaRequest putAccessPointConfigurationForObjectLambdaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                putAccessPointConfigurationForObjectLambdaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putAccessPointConfigurationForObjectLambdaRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAccessPointConfigurationForObjectLambda");

            HttpResponseHandler<Response<PutAccessPointConfigurationForObjectLambdaResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(PutAccessPointConfigurationForObjectLambdaResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<PutAccessPointConfigurationForObjectLambdaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutAccessPointConfigurationForObjectLambdaRequest, PutAccessPointConfigurationForObjectLambdaResponse>()
                            .withOperationName("PutAccessPointConfigurationForObjectLambda")
                            .withRequestConfiguration(clientConfiguration).withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutAccessPointConfigurationForObjectLambdaRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(putAccessPointConfigurationForObjectLambdaRequest));
            CompletableFuture<PutAccessPointConfigurationForObjectLambdaResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Associates an access policy with the specified access point. Each access point can have only one policy, so a
     * request made to this API replaces any existing policy associated with the specified access point.
     * </p>
     * <p/>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html#API_control_PutAccessPointPolicy_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * The following actions are related to <code>PutAccessPointPolicy</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html">
     * GetAccessPointPolicy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html">
     * DeleteAccessPointPolicy</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putAccessPointPolicyRequest
     * @return A Java Future containing the result of the PutAccessPointPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.PutAccessPointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessPointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutAccessPointPolicyResponse> putAccessPointPolicy(
            PutAccessPointPolicyRequest putAccessPointPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putAccessPointPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putAccessPointPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAccessPointPolicy");

            HttpResponseHandler<Response<PutAccessPointPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(PutAccessPointPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<PutAccessPointPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutAccessPointPolicyRequest, PutAccessPointPolicyResponse>()
                            .withOperationName("PutAccessPointPolicy").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutAccessPointPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(putAccessPointPolicyRequest));
            CompletableFuture<PutAccessPointPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Creates or replaces resource policy for an Object Lambda Access Point. For an example policy, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-create.html#olap-create-cli">Creating Object
     * Lambda Access Points</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * The following actions are related to <code>PutAccessPointPolicyForObjectLambda</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicyForObjectLambda.html">
     * DeleteAccessPointPolicyForObjectLambda</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyForObjectLambda.html">
     * GetAccessPointPolicyForObjectLambda</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putAccessPointPolicyForObjectLambdaRequest
     * @return A Java Future containing the result of the PutAccessPointPolicyForObjectLambda operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.PutAccessPointPolicyForObjectLambda
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessPointPolicyForObjectLambda"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutAccessPointPolicyForObjectLambdaResponse> putAccessPointPolicyForObjectLambda(
            PutAccessPointPolicyForObjectLambdaRequest putAccessPointPolicyForObjectLambdaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putAccessPointPolicyForObjectLambdaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putAccessPointPolicyForObjectLambdaRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAccessPointPolicyForObjectLambda");

            HttpResponseHandler<Response<PutAccessPointPolicyForObjectLambdaResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(PutAccessPointPolicyForObjectLambdaResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<PutAccessPointPolicyForObjectLambdaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutAccessPointPolicyForObjectLambdaRequest, PutAccessPointPolicyForObjectLambdaResponse>()
                            .withOperationName("PutAccessPointPolicyForObjectLambda")
                            .withRequestConfiguration(clientConfiguration).withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutAccessPointPolicyForObjectLambdaRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(putAccessPointPolicyForObjectLambdaRequest));
            CompletableFuture<PutAccessPointPolicyForObjectLambdaResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action puts a lifecycle configuration to an Amazon S3 on Outposts bucket. To put a lifecycle configuration
     * to an S3 bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html"
     * >PutBucketLifecycleConfiguration</a> in the <i>Amazon S3 API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Creates a new lifecycle configuration for the S3 on Outposts bucket or replaces an existing lifecycle
     * configuration. Outposts buckets only support lifecycle configurations that delete/expire objects after a certain
     * period of time and abort incomplete multipart uploads.
     * </p>
     * <p/>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html#API_control_PutBucketLifecycleConfiguration_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * The following actions are related to <code>PutBucketLifecycleConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html">
     * GetBucketLifecycleConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html">
     * DeleteBucketLifecycleConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketLifecycleConfigurationRequest
     * @return A Java Future containing the result of the PutBucketLifecycleConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.PutBucketLifecycleConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketLifecycleConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutBucketLifecycleConfigurationResponse> putBucketLifecycleConfiguration(
            PutBucketLifecycleConfigurationRequest putBucketLifecycleConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putBucketLifecycleConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketLifecycleConfiguration");

            HttpResponseHandler<Response<PutBucketLifecycleConfigurationResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(PutBucketLifecycleConfigurationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<PutBucketLifecycleConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutBucketLifecycleConfigurationRequest, PutBucketLifecycleConfigurationResponse>()
                            .withOperationName("PutBucketLifecycleConfiguration")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutBucketLifecycleConfigurationRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(putBucketLifecycleConfigurationRequest));
            CompletableFuture<PutBucketLifecycleConfigurationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action puts a bucket policy to an Amazon S3 on Outposts bucket. To put a policy on an S3 bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketPolicy.html">PutBucketPolicy</a> in the
     * <i>Amazon S3 API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Applies an Amazon S3 bucket policy to an Outposts bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in
     * the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If you are using an identity other than the root user of the Amazon Web Services account that owns the Outposts
     * bucket, the calling identity must have the <code>PutBucketPolicy</code> permissions on the specified Outposts
     * bucket and belong to the bucket owner's account in order to use this action.
     * </p>
     * <p>
     * If you don't have <code>PutBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code>
     * error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's
     * account, Amazon S3 returns a <code>405 Method Not Allowed</code> error.
     * </p>
     * <important>
     * <p>
     * As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this
     * action, even if the policy explicitly denies the root user the ability to perform this action.
     * </p>
     * </important>
     * <p>
     * For more information about bucket policies, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User
     * Policies</a>.
     * </p>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html#API_control_PutBucketPolicy_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * The following actions are related to <code>PutBucketPolicy</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html">GetBucketPolicy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html">DeleteBucketPolicy</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketPolicyRequest
     * @return A Java Future containing the result of the PutBucketPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.PutBucketPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutBucketPolicyResponse> putBucketPolicy(PutBucketPolicyRequest putBucketPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putBucketPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putBucketPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketPolicy");

            HttpResponseHandler<Response<PutBucketPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(PutBucketPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<PutBucketPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutBucketPolicyRequest, PutBucketPolicyResponse>()
                            .withOperationName("PutBucketPolicy")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutBucketPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(putBucketPolicyRequest));
            CompletableFuture<PutBucketPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action creates an Amazon S3 on Outposts bucket's replication configuration. To create an S3 bucket's
     * replication configuration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html">PutBucketReplication</a> in
     * the <i>Amazon S3 API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Creates a replication configuration or replaces an existing one. For information about S3 replication on Outposts
     * configuration, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html">Replicating objects for
     * S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * It can take a while to propagate <code>PUT</code> or <code>DELETE</code> requests for a replication configuration
     * to all S3 on Outposts systems. Therefore, the replication configuration that's returned by a <code>GET</code>
     * request soon after a <code>PUT</code> or <code>DELETE</code> request might return a more recent result than
     * what's on the Outpost. If an Outpost is offline, the delay in updating the replication configuration on that
     * Outpost can be significant.
     * </p>
     * </note>
     * <p>
     * Specify the replication configuration in the request body. In the replication configuration, you provide the
     * following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The name of the destination bucket or buckets where you want S3 on Outposts to replicate objects
     * </p>
     * </li>
     * <li>
     * <p>
     * The Identity and Access Management (IAM) role that S3 on Outposts can assume to replicate objects on your behalf
     * </p>
     * </li>
     * <li>
     * <p>
     * Other relevant information, such as replication rules
     * </p>
     * </li>
     * </ul>
     * <p>
     * A replication configuration must include at least one rule and can contain a maximum of 100. Each rule identifies
     * a subset of objects to replicate by filtering the objects in the source Outposts bucket. To choose additional
     * subsets of objects to replicate, add a rule for each subset.
     * </p>
     * <p>
     * To specify a subset of the objects in the source Outposts bucket to apply a replication rule to, add the
     * <code>Filter</code> element as a child of the <code>Rule</code> element. You can filter objects based on an
     * object key prefix, one or more object tags, or both. When you add the <code>Filter</code> element in the
     * configuration, you must also add the following elements: <code>DeleteMarkerReplication</code>,
     * <code>Status</code>, and <code>Priority</code>.
     * </p>
     * <p>
     * Using <code>PutBucketReplication</code> on Outposts requires that both the source and destination buckets must
     * have versioning enabled. For information about enabling versioning on a bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsManagingVersioning.html">Managing S3
     * Versioning for your S3 on Outposts bucket</a>.
     * </p>
     * <p>
     * For information about S3 on Outposts replication failure reasons, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/outposts-replication-eventbridge.html#outposts-replication-failure-codes"
     * >Replication failure reasons</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * <b>Handling Replication of Encrypted Objects</b>
     * </p>
     * <p>
     * Outposts buckets are encrypted at all times. All the objects in the source Outposts bucket are encrypted and can
     * be replicated. Also, all the replicas in the destination Outposts bucket are encrypted with the same encryption
     * key as the objects in the source Outposts bucket.
     * </p>
     * <p>
     * <b>Permissions</b>
     * </p>
     * <p>
     * To create a <code>PutBucketReplication</code> request, you must have
     * <code>s3-outposts:PutReplicationConfiguration</code> permissions for the bucket. The Outposts bucket owner has
     * this permission by default and can grant it to others. For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsIAM.html">Setting up IAM with S3 on
     * Outposts</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsBucketPolicy.html">Managing access to S3 on
     * Outposts buckets</a>.
     * </p>
     * <note>
     * <p>
     * To perform this operation, the user or role must also have the <code>iam:CreateRole</code> and
     * <code>iam:PassRole</code> permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a user permissions to
     * pass a role to an Amazon Web Services service</a>.
     * </p>
     * </note>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketReplication.html#API_control_PutBucketReplication_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * The following operations are related to <code>PutBucketReplication</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketReplication.html">
     * GetBucketReplication</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketReplication.html">
     * DeleteBucketReplication</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketReplicationRequest
     * @return A Java Future containing the result of the PutBucketReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.PutBucketReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketReplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutBucketReplicationResponse> putBucketReplication(
            PutBucketReplicationRequest putBucketReplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putBucketReplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putBucketReplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketReplication");

            HttpResponseHandler<Response<PutBucketReplicationResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(PutBucketReplicationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<PutBucketReplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutBucketReplicationRequest, PutBucketReplicationResponse>()
                            .withOperationName("PutBucketReplication")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutBucketReplicationRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(putBucketReplicationRequest));
            CompletableFuture<PutBucketReplicationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This action puts tags on an Amazon S3 on Outposts bucket. To put tags on an S3 bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html">PutBucketTagging</a> in the
     * <i>Amazon S3 API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Sets the tags for an S3 on Outposts bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in
     * the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * Use tags to organize your Amazon Web Services bill to reflect your own cost structure. To do this, sign up to get
     * your Amazon Web Services account bill with tag key values included. Then, to see the cost of combined resources,
     * organize your billing information according to resources with the same tag key values. For example, you can tag
     * several resources with a specific application name, and then organize your billing information to see the total
     * cost of that application across several services. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Cost allocation and
     * tagging</a>.
     * </p>
     * <note>
     * <p>
     * Within a bucket, if you add a tag that has the same key as an existing tag, the new value overwrites the old
     * value. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CostAllocTagging.html"> Using cost allocation in
     * Amazon S3 bucket tags</a>.
     * </p>
     * </note>
     * <p>
     * To use this action, you must have permissions to perform the <code>s3-outposts:PutBucketTagging</code> action.
     * The Outposts bucket owner has this permission by default and can grant this permission to others. For more
     * information about permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"
     * > Permissions Related to Bucket Subresource Operations</a> and <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing access permissions
     * to your Amazon S3 resources</a>.
     * </p>
     * <p>
     * <code>PutBucketTagging</code> has the following special errors:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Error code: <code>InvalidTagError</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: The tag provided was not a valid tag. This error can occur if the tag did not pass input validation.
     * For information about tag restrictions, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">
     * User-Defined Tag Restrictions</a> and <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/aws-tag-restrictions.html"> Amazon Web
     * Services-Generated Cost Allocation Tag Restrictions</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Error code: <code>MalformedXMLError</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: The XML provided does not match the schema.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Error code: <code>OperationAbortedError </code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: A conflicting conditional action is currently in progress against this resource. Try again.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Error code: <code>InternalError</code>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Description: The service was unable to apply the provided tag to the bucket.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html#API_control_PutBucketTagging_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * The following actions are related to <code>PutBucketTagging</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html">GetBucketTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html">DeleteBucketTagging
     * </a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketTaggingRequest
     * @return A Java Future containing the result of the PutBucketTagging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.PutBucketTagging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketTagging" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutBucketTaggingResponse> putBucketTagging(PutBucketTaggingRequest putBucketTaggingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putBucketTaggingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putBucketTaggingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketTagging");

            HttpResponseHandler<Response<PutBucketTaggingResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(PutBucketTaggingResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<PutBucketTaggingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutBucketTaggingRequest, PutBucketTaggingResponse>()
                            .withOperationName("PutBucketTagging")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutBucketTaggingRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(putBucketTaggingRequest));
            CompletableFuture<PutBucketTaggingResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation sets the versioning state for S3 on Outposts buckets only. To set the versioning state for an S3
     * bucket, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketVersioning.html">PutBucketVersioning</a> in
     * the <i>Amazon S3 API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Sets the versioning state for an S3 on Outposts bucket. With S3 Versioning, you can save multiple distinct copies
     * of your objects and recover from unintended user actions and application failures.
     * </p>
     * <p>
     * You can set the versioning state to one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Enabled</b> - Enables versioning for the objects in the bucket. All objects added to the bucket receive a
     * unique version ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Suspended</b> - Suspends versioning for the objects in the bucket. All objects added to the bucket receive the
     * version ID <code>null</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you've never set versioning on your bucket, it has no versioning state. In that case, a <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketVersioning.html">
     * GetBucketVersioning</a> request does not return a versioning state value.
     * </p>
     * <p>
     * When you enable S3 Versioning, for each object in your bucket, you have a current version and zero or more
     * noncurrent versions. You can configure your bucket S3 Lifecycle rules to expire noncurrent versions after a
     * specified time period. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsLifecycleManaging.html"> Creating and
     * managing a lifecycle configuration for your S3 on Outposts bucket</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * If you have an object expiration lifecycle configuration in your non-versioned bucket and you want to maintain
     * the same permanent delete behavior when you enable versioning, you must add a noncurrent expiration policy. The
     * noncurrent expiration lifecycle configuration will manage the deletes of the noncurrent object versions in the
     * version-enabled bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/Versioning.html">Versioning</a> in the <i>Amazon S3
     * User Guide</i>.
     * </p>
     * <p>
     * All Amazon S3 on Outposts REST API requests for this action require an additional parameter of
     * <code>x-amz-outpost-id</code> to be passed with the request. In addition, you must use an S3 on Outposts endpoint
     * hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on
     * Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived by
     * using the access point ARN, see the <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketVersioning.html#API_control_PutBucketVersioning_Examples"
     * >Examples</a> section.
     * </p>
     * <p>
     * The following operations are related to <code>PutBucketVersioning</code> for S3 on Outposts.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketVersioning.html">GetBucketVersioning
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html">
     * PutBucketLifecycleConfiguration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html">
     * GetBucketLifecycleConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putBucketVersioningRequest
     * @return A Java Future containing the result of the PutBucketVersioning operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.PutBucketVersioning
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketVersioning" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutBucketVersioningResponse> putBucketVersioning(
            PutBucketVersioningRequest putBucketVersioningRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putBucketVersioningRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putBucketVersioningRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBucketVersioning");

            HttpResponseHandler<Response<PutBucketVersioningResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(PutBucketVersioningResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<PutBucketVersioningResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutBucketVersioningRequest, PutBucketVersioningResponse>()
                            .withOperationName("PutBucketVersioning")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutBucketVersioningRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(putBucketVersioningRequest));
            CompletableFuture<PutBucketVersioningResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the supplied tag-set on an S3 Batch Operations job.
     * </p>
     * <p>
     * A tag is a key-value pair. You can associate S3 Batch Operations tags with any job by sending a PUT request
     * against the tagging subresource that is associated with the job. To modify the existing tag set, you can either
     * replace the existing tag set entirely, or make changes within the existing tag set by retrieving the existing tag
     * set using <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html">GetJobTagging</a>, modify
     * that tag set, and use this operation to replace the tag set with the one you modified. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags">
     * Controlling access and labeling jobs using tags</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * If you send this request with an empty tag set, Amazon S3 deletes the existing tag set on the Batch Operations
     * job. If you use this method, you are charged for a Tier 1 Request (PUT). For more information, see <a
     * href="http://aws.amazon.com/s3/pricing/">Amazon S3 pricing</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For deleting existing tags for your Batch Operations job, a <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html">DeleteJobTagging</a>
     * request is preferred because it achieves the same result without incurring charges.
     * </p>
     * </li>
     * <li>
     * <p>
     * A few things to consider about using tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon S3 limits the maximum number of tags to 50 tags per job.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can associate up to 50 tags with a job as long as they have unique tag keys.
     * </p>
     * </li>
     * <li>
     * <p>
     * A tag key can be up to 128 Unicode characters in length, and tag values can be up to 256 Unicode characters in
     * length.
     * </p>
     * </li>
     * <li>
     * <p>
     * The key and values are case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * For tagging-related restrictions related to characters and encodings, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined
     * Tag Restrictions</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * To use the <code>PutJobTagging</code> operation, you must have permission to perform the
     * <code>s3:PutJobTagging</code> action.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Related actions include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html">GetJobTagging</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html">DeleteJobTagging</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putJobTaggingRequest
     * @return A Java Future containing the result of the PutJobTagging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException</li>
     *         <li>TooManyRequestsException</li>
     *         <li>NotFoundException</li>
     *         <li>TooManyTagsException Amazon S3 throws this exception if you have too many tags in your tag set.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.PutJobTagging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutJobTagging" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutJobTaggingResponse> putJobTagging(PutJobTaggingRequest putJobTaggingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putJobTaggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putJobTaggingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutJobTagging");

            HttpResponseHandler<Response<PutJobTaggingResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    PutJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<PutJobTaggingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutJobTaggingRequest, PutJobTaggingResponse>()
                            .withOperationName("PutJobTagging").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutJobTaggingRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(putJobTaggingRequest));
            CompletableFuture<PutJobTaggingResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Associates an access control policy with the specified Multi-Region Access Point. Each Multi-Region Access Point
     * can have only one policy, so a request made to this action replaces any existing policy that is associated with
     * the specified Multi-Region Access Point.
     * </p>
     * <p>
     * This action will always be routed to the US West (Oregon) Region. For more information about the restrictions
     * around working with Multi-Region Access Points, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/MultiRegionAccessPointRestrictions.html">Multi-Region
     * Access Point restrictions and limitations</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <p>
     * The following actions are related to <code>PutMultiRegionAccessPointPolicy</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicy.html">
     * GetMultiRegionAccessPointPolicy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicyStatus.html">
     * GetMultiRegionAccessPointPolicyStatus</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putMultiRegionAccessPointPolicyRequest
     * @return A Java Future containing the result of the PutMultiRegionAccessPointPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.PutMultiRegionAccessPointPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutMultiRegionAccessPointPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutMultiRegionAccessPointPolicyResponse> putMultiRegionAccessPointPolicy(
            PutMultiRegionAccessPointPolicyRequest putMultiRegionAccessPointPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putMultiRegionAccessPointPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putMultiRegionAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMultiRegionAccessPointPolicy");

            HttpResponseHandler<Response<PutMultiRegionAccessPointPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(PutMultiRegionAccessPointPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<PutMultiRegionAccessPointPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutMultiRegionAccessPointPolicyRequest, PutMultiRegionAccessPointPolicyResponse>()
                            .withOperationName("PutMultiRegionAccessPointPolicy")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutMultiRegionAccessPointPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(putMultiRegionAccessPointPolicyRequest));
            CompletableFuture<PutMultiRegionAccessPointPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Creates or modifies the <code>PublicAccessBlock</code> configuration for an Amazon Web Services account. For this
     * operation, users must have the <code>s3:PutAccountPublicAccessBlock</code> permission. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html"> Using Amazon
     * S3 block public access</a>.
     * </p>
     * <p>
     * Related actions include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html">
     * GetPublicAccessBlock</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html">
     * DeletePublicAccessBlock</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putPublicAccessBlockRequest
     * @return A Java Future containing the result of the PutPublicAccessBlock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.PutPublicAccessBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutPublicAccessBlock"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutPublicAccessBlockResponse> putPublicAccessBlock(
            PutPublicAccessBlockRequest putPublicAccessBlockRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putPublicAccessBlockRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putPublicAccessBlockRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutPublicAccessBlock");

            HttpResponseHandler<Response<PutPublicAccessBlockResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(PutPublicAccessBlockResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<PutPublicAccessBlockResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutPublicAccessBlockRequest, PutPublicAccessBlockResponse>()
                            .withOperationName("PutPublicAccessBlock").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutPublicAccessBlockRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(putPublicAccessBlockRequest));
            CompletableFuture<PutPublicAccessBlockResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Puts an Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Working with Amazon S3 Storage Lens</a>
     * in the <i>Amazon S3 User Guide</i>. For a complete list of S3 Storage Lens metrics, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html">S3 Storage Lens
     * metrics glossary</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * To use this action, you must have permission to perform the <code>s3:PutStorageLensConfiguration</code> action.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to
     * use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     *
     * @param putStorageLensConfigurationRequest
     * @return A Java Future containing the result of the PutStorageLensConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.PutStorageLensConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutStorageLensConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutStorageLensConfigurationResponse> putStorageLensConfiguration(
            PutStorageLensConfigurationRequest putStorageLensConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putStorageLensConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putStorageLensConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutStorageLensConfiguration");

            HttpResponseHandler<Response<PutStorageLensConfigurationResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(PutStorageLensConfigurationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<PutStorageLensConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutStorageLensConfigurationRequest, PutStorageLensConfigurationResponse>()
                            .withOperationName("PutStorageLensConfiguration").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutStorageLensConfigurationRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(putStorageLensConfigurationRequest));
            CompletableFuture<PutStorageLensConfigurationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Put or replace tags on an existing Amazon S3 Storage Lens configuration. For more information about S3 Storage
     * Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage
     * activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * To use this action, you must have permission to perform the <code>s3:PutStorageLensConfigurationTagging</code>
     * action. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to
     * use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </note>
     *
     * @param putStorageLensConfigurationTaggingRequest
     * @return A Java Future containing the result of the PutStorageLensConfigurationTagging operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.PutStorageLensConfigurationTagging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutStorageLensConfigurationTagging"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutStorageLensConfigurationTaggingResponse> putStorageLensConfigurationTagging(
            PutStorageLensConfigurationTaggingRequest putStorageLensConfigurationTaggingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putStorageLensConfigurationTaggingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putStorageLensConfigurationTaggingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutStorageLensConfigurationTagging");

            HttpResponseHandler<Response<PutStorageLensConfigurationTaggingResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(PutStorageLensConfigurationTaggingResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<PutStorageLensConfigurationTaggingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutStorageLensConfigurationTaggingRequest, PutStorageLensConfigurationTaggingResponse>()
                            .withOperationName("PutStorageLensConfigurationTagging")
                            .withRequestConfiguration(clientConfiguration).withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutStorageLensConfigurationTaggingRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(putStorageLensConfigurationTaggingRequest));
            CompletableFuture<PutStorageLensConfigurationTaggingResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation is not supported by directory buckets.
     * </p>
     * </note>
     * <p>
     * Submits an updated route configuration for a Multi-Region Access Point. This API operation updates the routing
     * status for the specified Regions from active to passive, or from passive to active. A value of <code>0</code>
     * indicates a passive status, which means that traffic won't be routed to the specified Region. A value of
     * <code>100</code> indicates an active status, which means that traffic will be routed to the specified Region. At
     * least one Region must be active at all times.
     * </p>
     * <p>
     * When the routing configuration is changed, any in-progress operations (uploads, copies, deletes, and so on) to
     * formerly active Regions will continue to run to their final completion state (success or failure). The routing
     * configurations of any Regions that aren’t specified remain unchanged.
     * </p>
     * <note>
     * <p>
     * Updated routing configurations might not be immediately applied. It can take up to 2 minutes for your changes to
     * take effect.
     * </p>
     * </note>
     * <p>
     * To submit routing control changes and failover requests, use the Amazon S3 failover control infrastructure
     * endpoints in these five Amazon Web Services Regions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>us-east-1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>us-west-2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ap-southeast-2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ap-northeast-1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>eu-west-1</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param submitMultiRegionAccessPointRoutesRequest
     * @return A Java Future containing the result of the SubmitMultiRegionAccessPointRoutes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.SubmitMultiRegionAccessPointRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/SubmitMultiRegionAccessPointRoutes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SubmitMultiRegionAccessPointRoutesResponse> submitMultiRegionAccessPointRoutes(
            SubmitMultiRegionAccessPointRoutesRequest submitMultiRegionAccessPointRoutesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(submitMultiRegionAccessPointRoutesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                submitMultiRegionAccessPointRoutesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SubmitMultiRegionAccessPointRoutes");

            HttpResponseHandler<Response<SubmitMultiRegionAccessPointRoutesResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(SubmitMultiRegionAccessPointRoutesResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<SubmitMultiRegionAccessPointRoutesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SubmitMultiRegionAccessPointRoutesRequest, SubmitMultiRegionAccessPointRoutesResponse>()
                            .withOperationName("SubmitMultiRegionAccessPointRoutes")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SubmitMultiRegionAccessPointRoutesRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(submitMultiRegionAccessPointRoutesRequest));
            CompletableFuture<SubmitMultiRegionAccessPointRoutesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Amazon Web Services resource tag or updates an existing resource tag. Each tag is a label
     * consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter
     * resources. You can add up to 50 Amazon Web Services resource tags for each S3 resource.
     * </p>
     * <note>
     * <p>
     * This operation is only supported for <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups.html">S3 Storage Lens groups</a>
     * and for <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-tagging.html">S3 Access
     * Grants</a>. The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered
     * location, or grant.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:TagResource</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * For more information about the required Storage Lens Groups permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions"
     * >Setting account permissions to use S3 Storage Lens groups</a>.
     * </p>
     * <p>
     * For information about S3 Tagging errors, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3TaggingErrorCodeList">List of Amazon
     * S3 Tagging error codes</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            HttpResponseHandler<Response<TagResourceResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    TagResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This operation removes the specified Amazon Web Services resource tags from an S3 resource. Each tag is a label
     * consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter
     * resources.
     * </p>
     * <note>
     * <p>
     * This operation is only supported for <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups.html">S3 Storage Lens groups</a>
     * and for <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-tagging.html">S3 Access
     * Grants</a>. The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance, registered
     * location, or grant.
     * </p>
     * </note>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:UntagResource</code> permission to use this operation.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * For more information about the required Storage Lens Groups permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions"
     * >Setting account permissions to use S3 Storage Lens groups</a>.
     * </p>
     * <p>
     * For information about S3 Tagging errors, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3TaggingErrorCodeList">List of Amazon
     * S3 Tagging error codes</a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            HttpResponseHandler<Response<UntagResourceResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    UntagResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the IAM role of a registered location in your S3 Access Grants instance.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * You must have the <code>s3:UpdateAccessGrantsLocation</code> permission to use this operation.
     * </p>
     * </dd>
     * <dt>Additional Permissions</dt>
     * <dd>
     * <p>
     * You must also have the following permission: <code>iam:PassRole</code>
     * </p>
     * </dd>
     * </dl>
     *
     * @param updateAccessGrantsLocationRequest
     * @return A Java Future containing the result of the UpdateAccessGrantsLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.UpdateAccessGrantsLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateAccessGrantsLocation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAccessGrantsLocationResponse> updateAccessGrantsLocation(
            UpdateAccessGrantsLocationRequest updateAccessGrantsLocationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAccessGrantsLocationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccessGrantsLocationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccessGrantsLocation");

            HttpResponseHandler<Response<UpdateAccessGrantsLocationResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateAccessGrantsLocationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateAccessGrantsLocationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAccessGrantsLocationRequest, UpdateAccessGrantsLocationResponse>()
                            .withOperationName("UpdateAccessGrantsLocation")
                            .withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAccessGrantsLocationRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED,
                                    HttpChecksumRequired.create()).withInput(updateAccessGrantsLocationRequest));
            CompletableFuture<UpdateAccessGrantsLocationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing S3 Batch Operations job's priority. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html">S3 Batch Operations</a> in the
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * To use the <code>UpdateJobPriority</code> operation, you must have permission to perform the
     * <code>s3:UpdateJobPriority</code> action.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Related actions include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param updateJobPriorityRequest
     * @return A Java Future containing the result of the UpdateJobPriority operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>TooManyRequestsException</li>
     *         <li>NotFoundException</li>
     *         <li>InternalServiceException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.UpdateJobPriority
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateJobPriority" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateJobPriorityResponse> updateJobPriority(UpdateJobPriorityRequest updateJobPriorityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateJobPriorityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateJobPriorityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateJobPriority");

            HttpResponseHandler<Response<UpdateJobPriorityResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateJobPriorityResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateJobPriorityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateJobPriorityRequest, UpdateJobPriorityResponse>()
                            .withOperationName("UpdateJobPriority").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateJobPriorityRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateJobPriorityRequest));
            CompletableFuture<UpdateJobPriorityResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the status for the specified job. Use this operation to confirm that you want to run a job or to cancel
     * an existing job. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html">S3 Batch Operations</a> in the
     * <i>Amazon S3 User Guide</i>.
     * </p>
     * <dl>
     * <dt>Permissions</dt>
     * <dd>
     * <p>
     * To use the <code>UpdateJobStatus</code> operation, you must have permission to perform the
     * <code>s3:UpdateJobStatus</code> action.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Related actions include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param updateJobStatusRequest
     * @return A Java Future containing the result of the UpdateJobStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException</li>
     *         <li>TooManyRequestsException</li>
     *         <li>NotFoundException</li>
     *         <li>JobStatusException</li>
     *         <li>InternalServiceException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.UpdateJobStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateJobStatus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateJobStatusResponse> updateJobStatus(UpdateJobStatusRequest updateJobStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateJobStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateJobStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateJobStatus");

            HttpResponseHandler<Response<UpdateJobStatusResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateJobStatusResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateJobStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateJobStatusRequest, UpdateJobStatusResponse>()
                            .withOperationName("UpdateJobStatus").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateJobStatusRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateJobStatusRequest));
            CompletableFuture<UpdateJobStatusResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the existing Storage Lens group.
     * </p>
     * <p>
     * To use this operation, you must have the permission to perform the <code>s3:UpdateStorageLensGroup</code> action.
     * For more information about the required Storage Lens Groups permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions"
     * >Setting account permissions to use S3 Storage Lens groups</a>.
     * </p>
     * <p>
     * For information about Storage Lens groups errors, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList">List of Amazon S3
     * Storage Lens error codes</a>.
     * </p>
     *
     * @param updateStorageLensGroupRequest
     * @return A Java Future containing the result of the UpdateStorageLensGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>S3ControlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample S3ControlAsyncClient.UpdateStorageLensGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateStorageLensGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateStorageLensGroupResponse> updateStorageLensGroup(
            UpdateStorageLensGroupRequest updateStorageLensGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateStorageLensGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStorageLensGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStorageLensGroup");

            HttpResponseHandler<Response<UpdateStorageLensGroupResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateStorageLensGroupResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateStorageLensGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateStorageLensGroupRequest, UpdateStorageLensGroupResponse>()
                            .withOperationName("UpdateStorageLensGroup").withRequestConfiguration(clientConfiguration)
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateStorageLensGroupRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateStorageLensGroupRequest));
            CompletableFuture<UpdateStorageLensGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final S3ControlServiceClientConfiguration serviceClientConfiguration() {
        return new S3ControlServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextTokenException")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("JobStatusException")
                                .exceptionBuilderSupplier(JobStatusException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchPublicAccessBlockConfiguration")
                                .exceptionBuilderSupplier(NoSuchPublicAccessBlockConfigurationException::builder)
                                .httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServiceException")
                                .exceptionBuilderSupplier(InternalServiceException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BucketAlreadyExists")
                                .exceptionBuilderSupplier(BucketAlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IdempotencyException")
                                .exceptionBuilderSupplier(IdempotencyException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BucketAlreadyOwnedByYou")
                                .exceptionBuilderSupplier(BucketAlreadyOwnedByYouException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).build())
                .clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(S3ControlException::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        S3ControlServiceClientConfigurationBuilder serviceConfigBuilder = new S3ControlServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
