/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccessGrantsLocationRequest extends S3ControlRequest implements
        ToCopyableBuilder<UpdateAccessGrantsLocationRequest.Builder, UpdateAccessGrantsLocationRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(UpdateAccessGrantsLocationRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<String> ACCESS_GRANTS_LOCATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessGrantsLocationId")
            .getter(getter(UpdateAccessGrantsLocationRequest::accessGrantsLocationId))
            .setter(setter(Builder::accessGrantsLocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").unmarshallLocationName("id")
                    .build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IAMRoleArn")
            .getter(getter(UpdateAccessGrantsLocationRequest::iamRoleArn))
            .setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMRoleArn")
                    .unmarshallLocationName("IAMRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ACCESS_GRANTS_LOCATION_ID_FIELD, IAM_ROLE_ARN_FIELD));

    private final String accountId;

    private final String accessGrantsLocationId;

    private final String iamRoleArn;

    private UpdateAccessGrantsLocationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.accessGrantsLocationId = builder.accessGrantsLocationId;
        this.iamRoleArn = builder.iamRoleArn;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that is making this request.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that is making this request.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The ID of the registered location that you are updating. S3 Access Grants assigns this ID when you register the
     * location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code> and
     * assigns an auto-generated ID to other locations that you register.
     * </p>
     * <p>
     * The ID of the registered location to which you are granting access. S3 Access Grants assigned this ID when you
     * registered the location. S3 Access Grants assigns the ID <code>default</code> to the default location
     * <code>s3://</code> and assigns an auto-generated ID to other locations that you register.
     * </p>
     * <p>
     * If you are passing the <code>default</code> location, you cannot create an access grant for the entire default
     * location. You must also specify a bucket or a bucket and prefix in the <code>Subprefix</code> field.
     * </p>
     * 
     * @return The ID of the registered location that you are updating. S3 Access Grants assigns this ID when you
     *         register the location. S3 Access Grants assigns the ID <code>default</code> to the default location
     *         <code>s3://</code> and assigns an auto-generated ID to other locations that you register. </p>
     *         <p>
     *         The ID of the registered location to which you are granting access. S3 Access Grants assigned this ID
     *         when you registered the location. S3 Access Grants assigns the ID <code>default</code> to the default
     *         location <code>s3://</code> and assigns an auto-generated ID to other locations that you register.
     *         </p>
     *         <p>
     *         If you are passing the <code>default</code> location, you cannot create an access grant for the entire
     *         default location. You must also specify a bucket or a bucket and prefix in the <code>Subprefix</code>
     *         field.
     */
    public final String accessGrantsLocationId() {
        return accessGrantsLocationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this role to
     * manage access to the registered location.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this
     *         role to manage access to the registered location.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(accessGrantsLocationId());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccessGrantsLocationRequest)) {
            return false;
        }
        UpdateAccessGrantsLocationRequest other = (UpdateAccessGrantsLocationRequest) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(accessGrantsLocationId(), other.accessGrantsLocationId())
                && Objects.equals(iamRoleArn(), other.iamRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccessGrantsLocationRequest").add("AccountId", accountId())
                .add("AccessGrantsLocationId", accessGrantsLocationId()).add("IAMRoleArn", iamRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AccessGrantsLocationId":
            return Optional.ofNullable(clazz.cast(accessGrantsLocationId()));
        case "IAMRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccessGrantsLocationRequest, T> g) {
        return obj -> g.apply((UpdateAccessGrantsLocationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAccessGrantsLocationRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that is making this request.
         * </p>
         * 
         * @param accountId
         *        The ID of the Amazon Web Services account that is making this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The ID of the registered location that you are updating. S3 Access Grants assigns this ID when you register
         * the location. S3 Access Grants assigns the ID <code>default</code> to the default location <code>s3://</code>
         * and assigns an auto-generated ID to other locations that you register.
         * </p>
         * <p>
         * The ID of the registered location to which you are granting access. S3 Access Grants assigned this ID when
         * you registered the location. S3 Access Grants assigns the ID <code>default</code> to the default location
         * <code>s3://</code> and assigns an auto-generated ID to other locations that you register.
         * </p>
         * <p>
         * If you are passing the <code>default</code> location, you cannot create an access grant for the entire
         * default location. You must also specify a bucket or a bucket and prefix in the <code>Subprefix</code> field.
         * </p>
         * 
         * @param accessGrantsLocationId
         *        The ID of the registered location that you are updating. S3 Access Grants assigns this ID when you
         *        register the location. S3 Access Grants assigns the ID <code>default</code> to the default location
         *        <code>s3://</code> and assigns an auto-generated ID to other locations that you register. </p>
         *        <p>
         *        The ID of the registered location to which you are granting access. S3 Access Grants assigned this ID
         *        when you registered the location. S3 Access Grants assigns the ID <code>default</code> to the default
         *        location <code>s3://</code> and assigns an auto-generated ID to other locations that you register.
         *        </p>
         *        <p>
         *        If you are passing the <code>default</code> location, you cannot create an access grant for the entire
         *        default location. You must also specify a bucket or a bucket and prefix in the <code>Subprefix</code>
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsLocationId(String accessGrantsLocationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes this
         * role to manage access to the registered location.
         * </p>
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role for the registered location. S3 Access Grants assumes
         *        this role to manage access to the registered location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private String accessGrantsLocationId;

        private String iamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccessGrantsLocationRequest model) {
            super(model);
            accountId(model.accountId);
            accessGrantsLocationId(model.accessGrantsLocationId);
            iamRoleArn(model.iamRoleArn);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAccessGrantsLocationId() {
            return accessGrantsLocationId;
        }

        public final void setAccessGrantsLocationId(String accessGrantsLocationId) {
            this.accessGrantsLocationId = accessGrantsLocationId;
        }

        @Override
        public final Builder accessGrantsLocationId(String accessGrantsLocationId) {
            this.accessGrantsLocationId = accessGrantsLocationId;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccessGrantsLocationRequest build() {
            return new UpdateAccessGrantsLocationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
