/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStorageLensGroupRequest extends S3ControlRequest implements
        ToCopyableBuilder<CreateStorageLensGroupRequest.Builder, CreateStorageLensGroupRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(CreateStorageLensGroupRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<StorageLensGroup> STORAGE_LENS_GROUP_FIELD = SdkField
            .<StorageLensGroup> builder(MarshallingType.SDK_POJO)
            .memberName("StorageLensGroup")
            .getter(getter(CreateStorageLensGroupRequest::storageLensGroup))
            .setter(setter(Builder::storageLensGroup))
            .constructor(StorageLensGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensGroup")
                    .unmarshallLocationName("StorageLensGroup").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateStorageLensGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags")
                    .unmarshallLocationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").unmarshallLocationName("Tag").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            STORAGE_LENS_GROUP_FIELD, TAGS_FIELD));

    private final String accountId;

    private final StorageLensGroup storageLensGroup;

    private final List<Tag> tags;

    private CreateStorageLensGroupRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.storageLensGroup = builder.storageLensGroup;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that the Storage Lens group is created from and associated with.
     * </p>
     * 
     * @return The Amazon Web Services account ID that the Storage Lens group is created from and associated with.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Storage Lens group configuration.
     * </p>
     * 
     * @return The Storage Lens group configuration.
     */
    public final StorageLensGroup storageLensGroup() {
        return storageLensGroup;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services resource tags that you're adding to your Storage Lens group. This parameter is optional.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The Amazon Web Services resource tags that you're adding to your Storage Lens group. This parameter is
     *         optional.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(storageLensGroup());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStorageLensGroupRequest)) {
            return false;
        }
        CreateStorageLensGroupRequest other = (CreateStorageLensGroupRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(storageLensGroup(), other.storageLensGroup())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStorageLensGroupRequest").add("AccountId", accountId())
                .add("StorageLensGroup", storageLensGroup()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "StorageLensGroup":
            return Optional.ofNullable(clazz.cast(storageLensGroup()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStorageLensGroupRequest, T> g) {
        return obj -> g.apply((CreateStorageLensGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStorageLensGroupRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID that the Storage Lens group is created from and associated with.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID that the Storage Lens group is created from and associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Storage Lens group configuration.
         * </p>
         * 
         * @param storageLensGroup
         *        The Storage Lens group configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLensGroup(StorageLensGroup storageLensGroup);

        /**
         * <p>
         * The Storage Lens group configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageLensGroup.Builder} avoiding the
         * need to create one manually via {@link StorageLensGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageLensGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #storageLensGroup(StorageLensGroup)}.
         * 
         * @param storageLensGroup
         *        a consumer that will call methods on {@link StorageLensGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageLensGroup(StorageLensGroup)
         */
        default Builder storageLensGroup(Consumer<StorageLensGroup.Builder> storageLensGroup) {
            return storageLensGroup(StorageLensGroup.builder().applyMutation(storageLensGroup).build());
        }

        /**
         * <p>
         * The Amazon Web Services resource tags that you're adding to your Storage Lens group. This parameter is
         * optional.
         * </p>
         * 
         * @param tags
         *        The Amazon Web Services resource tags that you're adding to your Storage Lens group. This parameter is
         *        optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The Amazon Web Services resource tags that you're adding to your Storage Lens group. This parameter is
         * optional.
         * </p>
         * 
         * @param tags
         *        The Amazon Web Services resource tags that you're adding to your Storage Lens group. This parameter is
         *        optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The Amazon Web Services resource tags that you're adding to your Storage Lens group. This parameter is
         * optional.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3control.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.s3control.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3control.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3control.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private StorageLensGroup storageLensGroup;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStorageLensGroupRequest model) {
            super(model);
            accountId(model.accountId);
            storageLensGroup(model.storageLensGroup);
            tags(model.tags);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final StorageLensGroup.Builder getStorageLensGroup() {
            return storageLensGroup != null ? storageLensGroup.toBuilder() : null;
        }

        public final void setStorageLensGroup(StorageLensGroup.BuilderImpl storageLensGroup) {
            this.storageLensGroup = storageLensGroup != null ? storageLensGroup.build() : null;
        }

        @Override
        public final Builder storageLensGroup(StorageLensGroup storageLensGroup) {
            this.storageLensGroup = storageLensGroup;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStorageLensGroupRequest build() {
            return new CreateStorageLensGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
