/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccessGrantRequest extends S3ControlRequest implements
        ToCopyableBuilder<GetAccessGrantRequest.Builder, GetAccessGrantRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(GetAccessGrantRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<String> ACCESS_GRANT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessGrantId")
            .getter(getter(GetAccessGrantRequest::accessGrantId))
            .setter(setter(Builder::accessGrantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").unmarshallLocationName("id")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ACCESS_GRANT_ID_FIELD));

    private final String accountId;

    private final String accessGrantId;

    private GetAccessGrantRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.accessGrantId = builder.accessGrantId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the S3 Access Grants instance.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the S3 Access Grants instance.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The ID of the access grant. S3 Access Grants auto-generates this ID when you create the access grant.
     * </p>
     * 
     * @return The ID of the access grant. S3 Access Grants auto-generates this ID when you create the access grant.
     */
    public final String accessGrantId() {
        return accessGrantId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(accessGrantId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessGrantRequest)) {
            return false;
        }
        GetAccessGrantRequest other = (GetAccessGrantRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(accessGrantId(), other.accessGrantId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccessGrantRequest").add("AccountId", accountId()).add("AccessGrantId", accessGrantId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AccessGrantId":
            return Optional.ofNullable(clazz.cast(accessGrantId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccessGrantRequest, T> g) {
        return obj -> g.apply((GetAccessGrantRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetAccessGrantRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID of the S3 Access Grants instance.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The ID of the access grant. S3 Access Grants auto-generates this ID when you create the access grant.
         * </p>
         * 
         * @param accessGrantId
         *        The ID of the access grant. S3 Access Grants auto-generates this ID when you create the access grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantId(String accessGrantId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private String accessGrantId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessGrantRequest model) {
            super(model);
            accountId(model.accountId);
            accessGrantId(model.accessGrantId);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAccessGrantId() {
            return accessGrantId;
        }

        public final void setAccessGrantId(String accessGrantId) {
            this.accessGrantId = accessGrantId;
        }

        @Override
        public final Builder accessGrantId(String accessGrantId) {
            this.accessGrantId = accessGrantId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAccessGrantRequest build() {
            return new GetAccessGrantRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
