/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If provided, the generated manifest includes only source bucket objects whose object keys match the string
 * constraints specified for <code>MatchAnyPrefix</code>, <code>MatchAnySuffix</code>, and
 * <code>MatchAnySubstring</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyNameConstraint implements SdkPojo, Serializable,
        ToCopyableBuilder<KeyNameConstraint.Builder, KeyNameConstraint> {
    private static final SdkField<List<String>> MATCH_ANY_PREFIX_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MatchAnyPrefix")
            .getter(getter(KeyNameConstraint::matchAnyPrefix))
            .setter(setter(Builder::matchAnyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchAnyPrefix")
                    .unmarshallLocationName("MatchAnyPrefix").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> MATCH_ANY_SUFFIX_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MatchAnySuffix")
            .getter(getter(KeyNameConstraint::matchAnySuffix))
            .setter(setter(Builder::matchAnySuffix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchAnySuffix")
                    .unmarshallLocationName("MatchAnySuffix").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> MATCH_ANY_SUBSTRING_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MatchAnySubstring")
            .getter(getter(KeyNameConstraint::matchAnySubstring))
            .setter(setter(Builder::matchAnySubstring))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchAnySubstring")
                    .unmarshallLocationName("MatchAnySubstring").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_ANY_PREFIX_FIELD,
            MATCH_ANY_SUFFIX_FIELD, MATCH_ANY_SUBSTRING_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> matchAnyPrefix;

    private final List<String> matchAnySuffix;

    private final List<String> matchAnySubstring;

    private KeyNameConstraint(BuilderImpl builder) {
        this.matchAnyPrefix = builder.matchAnyPrefix;
        this.matchAnySuffix = builder.matchAnySuffix;
        this.matchAnySubstring = builder.matchAnySubstring;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchAnyPrefix property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchAnyPrefix() {
        return matchAnyPrefix != null && !(matchAnyPrefix instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If provided, the generated manifest includes objects where the specified string appears at the start of the
     * object key string. Each KeyNameConstraint filter accepts an array of strings with a length of 1 string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchAnyPrefix} method.
     * </p>
     * 
     * @return If provided, the generated manifest includes objects where the specified string appears at the start of
     *         the object key string. Each KeyNameConstraint filter accepts an array of strings with a length of 1
     *         string.
     */
    public final List<String> matchAnyPrefix() {
        return matchAnyPrefix;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchAnySuffix property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchAnySuffix() {
        return matchAnySuffix != null && !(matchAnySuffix instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If provided, the generated manifest includes objects where the specified string appears at the end of the object
     * key string. Each KeyNameConstraint filter accepts an array of strings with a length of 1 string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchAnySuffix} method.
     * </p>
     * 
     * @return If provided, the generated manifest includes objects where the specified string appears at the end of the
     *         object key string. Each KeyNameConstraint filter accepts an array of strings with a length of 1 string.
     */
    public final List<String> matchAnySuffix() {
        return matchAnySuffix;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchAnySubstring property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchAnySubstring() {
        return matchAnySubstring != null && !(matchAnySubstring instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If provided, the generated manifest includes objects where the specified string appears anywhere within the
     * object key string. Each KeyNameConstraint filter accepts an array of strings with a length of 1 string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchAnySubstring} method.
     * </p>
     * 
     * @return If provided, the generated manifest includes objects where the specified string appears anywhere within
     *         the object key string. Each KeyNameConstraint filter accepts an array of strings with a length of 1
     *         string.
     */
    public final List<String> matchAnySubstring() {
        return matchAnySubstring;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchAnyPrefix() ? matchAnyPrefix() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchAnySuffix() ? matchAnySuffix() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchAnySubstring() ? matchAnySubstring() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyNameConstraint)) {
            return false;
        }
        KeyNameConstraint other = (KeyNameConstraint) obj;
        return hasMatchAnyPrefix() == other.hasMatchAnyPrefix() && Objects.equals(matchAnyPrefix(), other.matchAnyPrefix())
                && hasMatchAnySuffix() == other.hasMatchAnySuffix() && Objects.equals(matchAnySuffix(), other.matchAnySuffix())
                && hasMatchAnySubstring() == other.hasMatchAnySubstring()
                && Objects.equals(matchAnySubstring(), other.matchAnySubstring());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyNameConstraint").add("MatchAnyPrefix", hasMatchAnyPrefix() ? matchAnyPrefix() : null)
                .add("MatchAnySuffix", hasMatchAnySuffix() ? matchAnySuffix() : null)
                .add("MatchAnySubstring", hasMatchAnySubstring() ? matchAnySubstring() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MatchAnyPrefix":
            return Optional.ofNullable(clazz.cast(matchAnyPrefix()));
        case "MatchAnySuffix":
            return Optional.ofNullable(clazz.cast(matchAnySuffix()));
        case "MatchAnySubstring":
            return Optional.ofNullable(clazz.cast(matchAnySubstring()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyNameConstraint, T> g) {
        return obj -> g.apply((KeyNameConstraint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyNameConstraint> {
        /**
         * <p>
         * If provided, the generated manifest includes objects where the specified string appears at the start of the
         * object key string. Each KeyNameConstraint filter accepts an array of strings with a length of 1 string.
         * </p>
         * 
         * @param matchAnyPrefix
         *        If provided, the generated manifest includes objects where the specified string appears at the start
         *        of the object key string. Each KeyNameConstraint filter accepts an array of strings with a length of 1
         *        string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchAnyPrefix(Collection<String> matchAnyPrefix);

        /**
         * <p>
         * If provided, the generated manifest includes objects where the specified string appears at the start of the
         * object key string. Each KeyNameConstraint filter accepts an array of strings with a length of 1 string.
         * </p>
         * 
         * @param matchAnyPrefix
         *        If provided, the generated manifest includes objects where the specified string appears at the start
         *        of the object key string. Each KeyNameConstraint filter accepts an array of strings with a length of 1
         *        string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchAnyPrefix(String... matchAnyPrefix);

        /**
         * <p>
         * If provided, the generated manifest includes objects where the specified string appears at the end of the
         * object key string. Each KeyNameConstraint filter accepts an array of strings with a length of 1 string.
         * </p>
         * 
         * @param matchAnySuffix
         *        If provided, the generated manifest includes objects where the specified string appears at the end of
         *        the object key string. Each KeyNameConstraint filter accepts an array of strings with a length of 1
         *        string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchAnySuffix(Collection<String> matchAnySuffix);

        /**
         * <p>
         * If provided, the generated manifest includes objects where the specified string appears at the end of the
         * object key string. Each KeyNameConstraint filter accepts an array of strings with a length of 1 string.
         * </p>
         * 
         * @param matchAnySuffix
         *        If provided, the generated manifest includes objects where the specified string appears at the end of
         *        the object key string. Each KeyNameConstraint filter accepts an array of strings with a length of 1
         *        string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchAnySuffix(String... matchAnySuffix);

        /**
         * <p>
         * If provided, the generated manifest includes objects where the specified string appears anywhere within the
         * object key string. Each KeyNameConstraint filter accepts an array of strings with a length of 1 string.
         * </p>
         * 
         * @param matchAnySubstring
         *        If provided, the generated manifest includes objects where the specified string appears anywhere
         *        within the object key string. Each KeyNameConstraint filter accepts an array of strings with a length
         *        of 1 string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchAnySubstring(Collection<String> matchAnySubstring);

        /**
         * <p>
         * If provided, the generated manifest includes objects where the specified string appears anywhere within the
         * object key string. Each KeyNameConstraint filter accepts an array of strings with a length of 1 string.
         * </p>
         * 
         * @param matchAnySubstring
         *        If provided, the generated manifest includes objects where the specified string appears anywhere
         *        within the object key string. Each KeyNameConstraint filter accepts an array of strings with a length
         *        of 1 string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchAnySubstring(String... matchAnySubstring);
    }

    static final class BuilderImpl implements Builder {
        private List<String> matchAnyPrefix = DefaultSdkAutoConstructList.getInstance();

        private List<String> matchAnySuffix = DefaultSdkAutoConstructList.getInstance();

        private List<String> matchAnySubstring = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KeyNameConstraint model) {
            matchAnyPrefix(model.matchAnyPrefix);
            matchAnySuffix(model.matchAnySuffix);
            matchAnySubstring(model.matchAnySubstring);
        }

        public final Collection<String> getMatchAnyPrefix() {
            if (matchAnyPrefix instanceof SdkAutoConstructList) {
                return null;
            }
            return matchAnyPrefix;
        }

        public final void setMatchAnyPrefix(Collection<String> matchAnyPrefix) {
            this.matchAnyPrefix = NonEmptyMaxLength1024StringListCopier.copy(matchAnyPrefix);
        }

        @Override
        public final Builder matchAnyPrefix(Collection<String> matchAnyPrefix) {
            this.matchAnyPrefix = NonEmptyMaxLength1024StringListCopier.copy(matchAnyPrefix);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchAnyPrefix(String... matchAnyPrefix) {
            matchAnyPrefix(Arrays.asList(matchAnyPrefix));
            return this;
        }

        public final Collection<String> getMatchAnySuffix() {
            if (matchAnySuffix instanceof SdkAutoConstructList) {
                return null;
            }
            return matchAnySuffix;
        }

        public final void setMatchAnySuffix(Collection<String> matchAnySuffix) {
            this.matchAnySuffix = NonEmptyMaxLength1024StringListCopier.copy(matchAnySuffix);
        }

        @Override
        public final Builder matchAnySuffix(Collection<String> matchAnySuffix) {
            this.matchAnySuffix = NonEmptyMaxLength1024StringListCopier.copy(matchAnySuffix);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchAnySuffix(String... matchAnySuffix) {
            matchAnySuffix(Arrays.asList(matchAnySuffix));
            return this;
        }

        public final Collection<String> getMatchAnySubstring() {
            if (matchAnySubstring instanceof SdkAutoConstructList) {
                return null;
            }
            return matchAnySubstring;
        }

        public final void setMatchAnySubstring(Collection<String> matchAnySubstring) {
            this.matchAnySubstring = NonEmptyMaxLength1024StringListCopier.copy(matchAnySubstring);
        }

        @Override
        public final Builder matchAnySubstring(Collection<String> matchAnySubstring) {
            this.matchAnySubstring = NonEmptyMaxLength1024StringListCopier.copy(matchAnySubstring);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchAnySubstring(String... matchAnySubstring) {
            matchAnySubstring(Arrays.asList(matchAnySubstring));
            return this;
        }

        @Override
        public KeyNameConstraint build() {
            return new KeyNameConstraint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
