/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCallerAccessGrantsResponse extends S3ControlResponse implements
        ToCopyableBuilder<ListCallerAccessGrantsResponse.Builder, ListCallerAccessGrantsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListCallerAccessGrantsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<List<ListCallerAccessGrantsEntry>> CALLER_ACCESS_GRANTS_LIST_FIELD = SdkField
            .<List<ListCallerAccessGrantsEntry>> builder(MarshallingType.LIST)
            .memberName("CallerAccessGrantsList")
            .getter(getter(ListCallerAccessGrantsResponse::callerAccessGrantsList))
            .setter(setter(Builder::callerAccessGrantsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerAccessGrantsList")
                    .unmarshallLocationName("CallerAccessGrantsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AccessGrant")
                            .memberFieldInfo(
                                    SdkField.<ListCallerAccessGrantsEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListCallerAccessGrantsEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AccessGrant").unmarshallLocationName("AccessGrant").build())
                                            .build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CALLER_ACCESS_GRANTS_LIST_FIELD));

    private final String nextToken;

    private final List<ListCallerAccessGrantsEntry> callerAccessGrantsList;

    private ListCallerAccessGrantsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.callerAccessGrantsList = builder.callerAccessGrantsList;
    }

    /**
     * <p>
     * A pagination token that you can use to request the next page of results. Pass this value into a subsequent
     * <code>List Caller Access Grants</code> request in order to retrieve the next page of results.
     * </p>
     * 
     * @return A pagination token that you can use to request the next page of results. Pass this value into a
     *         subsequent <code>List Caller Access Grants</code> request in order to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CallerAccessGrantsList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCallerAccessGrantsList() {
        return callerAccessGrantsList != null && !(callerAccessGrantsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the caller's access grants that were created using S3 Access Grants and that grant the caller access to
     * the S3 data of the Amazon Web Services account ID that was specified in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCallerAccessGrantsList} method.
     * </p>
     * 
     * @return A list of the caller's access grants that were created using S3 Access Grants and that grant the caller
     *         access to the S3 data of the Amazon Web Services account ID that was specified in the request.
     */
    public final List<ListCallerAccessGrantsEntry> callerAccessGrantsList() {
        return callerAccessGrantsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCallerAccessGrantsList() ? callerAccessGrantsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCallerAccessGrantsResponse)) {
            return false;
        }
        ListCallerAccessGrantsResponse other = (ListCallerAccessGrantsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasCallerAccessGrantsList() == other.hasCallerAccessGrantsList()
                && Objects.equals(callerAccessGrantsList(), other.callerAccessGrantsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCallerAccessGrantsResponse").add("NextToken", nextToken())
                .add("CallerAccessGrantsList", hasCallerAccessGrantsList() ? callerAccessGrantsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "CallerAccessGrantsList":
            return Optional.ofNullable(clazz.cast(callerAccessGrantsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCallerAccessGrantsResponse, T> g) {
        return obj -> g.apply((ListCallerAccessGrantsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCallerAccessGrantsResponse> {
        /**
         * <p>
         * A pagination token that you can use to request the next page of results. Pass this value into a subsequent
         * <code>List Caller Access Grants</code> request in order to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that you can use to request the next page of results. Pass this value into a
         *        subsequent <code>List Caller Access Grants</code> request in order to retrieve the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of the caller's access grants that were created using S3 Access Grants and that grant the caller
         * access to the S3 data of the Amazon Web Services account ID that was specified in the request.
         * </p>
         * 
         * @param callerAccessGrantsList
         *        A list of the caller's access grants that were created using S3 Access Grants and that grant the
         *        caller access to the S3 data of the Amazon Web Services account ID that was specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerAccessGrantsList(Collection<ListCallerAccessGrantsEntry> callerAccessGrantsList);

        /**
         * <p>
         * A list of the caller's access grants that were created using S3 Access Grants and that grant the caller
         * access to the S3 data of the Amazon Web Services account ID that was specified in the request.
         * </p>
         * 
         * @param callerAccessGrantsList
         *        A list of the caller's access grants that were created using S3 Access Grants and that grant the
         *        caller access to the S3 data of the Amazon Web Services account ID that was specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerAccessGrantsList(ListCallerAccessGrantsEntry... callerAccessGrantsList);

        /**
         * <p>
         * A list of the caller's access grants that were created using S3 Access Grants and that grant the caller
         * access to the S3 data of the Amazon Web Services account ID that was specified in the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3control.model.ListCallerAccessGrantsEntry.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.s3control.model.ListCallerAccessGrantsEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3control.model.ListCallerAccessGrantsEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #callerAccessGrantsList(List<ListCallerAccessGrantsEntry>)}.
         * 
         * @param callerAccessGrantsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3control.model.ListCallerAccessGrantsEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #callerAccessGrantsList(java.util.Collection<ListCallerAccessGrantsEntry>)
         */
        Builder callerAccessGrantsList(Consumer<ListCallerAccessGrantsEntry.Builder>... callerAccessGrantsList);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ListCallerAccessGrantsEntry> callerAccessGrantsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCallerAccessGrantsResponse model) {
            super(model);
            nextToken(model.nextToken);
            callerAccessGrantsList(model.callerAccessGrantsList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListCallerAccessGrantsEntry.Builder> getCallerAccessGrantsList() {
            List<ListCallerAccessGrantsEntry.Builder> result = CallerAccessGrantsListCopier
                    .copyToBuilder(this.callerAccessGrantsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCallerAccessGrantsList(Collection<ListCallerAccessGrantsEntry.BuilderImpl> callerAccessGrantsList) {
            this.callerAccessGrantsList = CallerAccessGrantsListCopier.copyFromBuilder(callerAccessGrantsList);
        }

        @Override
        public final Builder callerAccessGrantsList(Collection<ListCallerAccessGrantsEntry> callerAccessGrantsList) {
            this.callerAccessGrantsList = CallerAccessGrantsListCopier.copy(callerAccessGrantsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callerAccessGrantsList(ListCallerAccessGrantsEntry... callerAccessGrantsList) {
            callerAccessGrantsList(Arrays.asList(callerAccessGrantsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callerAccessGrantsList(Consumer<ListCallerAccessGrantsEntry.Builder>... callerAccessGrantsList) {
            callerAccessGrantsList(Stream.of(callerAccessGrantsList)
                    .map(c -> ListCallerAccessGrantsEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCallerAccessGrantsResponse build() {
            return new ListCallerAccessGrantsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
