/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container for the service that will create the S3 manifest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3JobManifestGenerator implements SdkPojo, Serializable,
        ToCopyableBuilder<S3JobManifestGenerator.Builder, S3JobManifestGenerator> {
    private static final SdkField<String> EXPECTED_BUCKET_OWNER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExpectedBucketOwner")
            .getter(getter(S3JobManifestGenerator::expectedBucketOwner))
            .setter(setter(Builder::expectedBucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedBucketOwner")
                    .unmarshallLocationName("ExpectedBucketOwner").build()).build();

    private static final SdkField<String> SOURCE_BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceBucket")
            .getter(getter(S3JobManifestGenerator::sourceBucket))
            .setter(setter(Builder::sourceBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBucket")
                    .unmarshallLocationName("SourceBucket").build()).build();

    private static final SdkField<S3ManifestOutputLocation> MANIFEST_OUTPUT_LOCATION_FIELD = SdkField
            .<S3ManifestOutputLocation> builder(MarshallingType.SDK_POJO)
            .memberName("ManifestOutputLocation")
            .getter(getter(S3JobManifestGenerator::manifestOutputLocation))
            .setter(setter(Builder::manifestOutputLocation))
            .constructor(S3ManifestOutputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestOutputLocation")
                    .unmarshallLocationName("ManifestOutputLocation").build()).build();

    private static final SdkField<JobManifestGeneratorFilter> FILTER_FIELD = SdkField
            .<JobManifestGeneratorFilter> builder(MarshallingType.SDK_POJO)
            .memberName("Filter")
            .getter(getter(S3JobManifestGenerator::filter))
            .setter(setter(Builder::filter))
            .constructor(JobManifestGeneratorFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build()).build();

    private static final SdkField<Boolean> ENABLE_MANIFEST_OUTPUT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableManifestOutput")
            .getter(getter(S3JobManifestGenerator::enableManifestOutput))
            .setter(setter(Builder::enableManifestOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableManifestOutput")
                    .unmarshallLocationName("EnableManifestOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPECTED_BUCKET_OWNER_FIELD,
            SOURCE_BUCKET_FIELD, MANIFEST_OUTPUT_LOCATION_FIELD, FILTER_FIELD, ENABLE_MANIFEST_OUTPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String expectedBucketOwner;

    private final String sourceBucket;

    private final S3ManifestOutputLocation manifestOutputLocation;

    private final JobManifestGeneratorFilter filter;

    private final Boolean enableManifestOutput;

    private S3JobManifestGenerator(BuilderImpl builder) {
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.sourceBucket = builder.sourceBucket;
        this.manifestOutputLocation = builder.manifestOutputLocation;
        this.filter = builder.filter;
        this.enableManifestOutput = builder.enableManifestOutput;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the bucket the generated manifest is written to. If provided the
     * generated manifest bucket's owner Amazon Web Services account ID must match this value, else the job fails.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the bucket the generated manifest is written to. If provided
     *         the generated manifest bucket's owner Amazon Web Services account ID must match this value, else the job
     *         fails.
     */
    public final String expectedBucketOwner() {
        return expectedBucketOwner;
    }

    /**
     * <p>
     * The ARN of the source bucket used by the ManifestGenerator.
     * </p>
     * <note>
     * <p>
     * <b>Directory buckets</b> - Directory buckets aren't supported as the source buckets used by
     * <code>S3JobManifestGenerator</code> to generate the job manifest.
     * </p>
     * </note>
     * 
     * @return The ARN of the source bucket used by the ManifestGenerator.</p> <note>
     *         <p>
     *         <b>Directory buckets</b> - Directory buckets aren't supported as the source buckets used by
     *         <code>S3JobManifestGenerator</code> to generate the job manifest.
     *         </p>
     */
    public final String sourceBucket() {
        return sourceBucket;
    }

    /**
     * <p>
     * Specifies the location the generated manifest will be written to. Manifests can't be written to directory
     * buckets. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">Directory
     * buckets</a>.
     * </p>
     * 
     * @return Specifies the location the generated manifest will be written to. Manifests can't be written to directory
     *         buckets. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">Directory
     *         buckets</a>.
     */
    public final S3ManifestOutputLocation manifestOutputLocation() {
        return manifestOutputLocation;
    }

    /**
     * <p>
     * Specifies rules the S3JobManifestGenerator should use to decide whether an object in the source bucket should or
     * should not be included in the generated job manifest.
     * </p>
     * 
     * @return Specifies rules the S3JobManifestGenerator should use to decide whether an object in the source bucket
     *         should or should not be included in the generated job manifest.
     */
    public final JobManifestGeneratorFilter filter() {
        return filter;
    }

    /**
     * <p>
     * Determines whether or not to write the job's generated manifest to a bucket.
     * </p>
     * 
     * @return Determines whether or not to write the job's generated manifest to a bucket.
     */
    public final Boolean enableManifestOutput() {
        return enableManifestOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expectedBucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBucket());
        hashCode = 31 * hashCode + Objects.hashCode(manifestOutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(enableManifestOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3JobManifestGenerator)) {
            return false;
        }
        S3JobManifestGenerator other = (S3JobManifestGenerator) obj;
        return Objects.equals(expectedBucketOwner(), other.expectedBucketOwner())
                && Objects.equals(sourceBucket(), other.sourceBucket())
                && Objects.equals(manifestOutputLocation(), other.manifestOutputLocation())
                && Objects.equals(filter(), other.filter())
                && Objects.equals(enableManifestOutput(), other.enableManifestOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3JobManifestGenerator").add("ExpectedBucketOwner", expectedBucketOwner())
                .add("SourceBucket", sourceBucket()).add("ManifestOutputLocation", manifestOutputLocation())
                .add("Filter", filter()).add("EnableManifestOutput", enableManifestOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExpectedBucketOwner":
            return Optional.ofNullable(clazz.cast(expectedBucketOwner()));
        case "SourceBucket":
            return Optional.ofNullable(clazz.cast(sourceBucket()));
        case "ManifestOutputLocation":
            return Optional.ofNullable(clazz.cast(manifestOutputLocation()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "EnableManifestOutput":
            return Optional.ofNullable(clazz.cast(enableManifestOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3JobManifestGenerator, T> g) {
        return obj -> g.apply((S3JobManifestGenerator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3JobManifestGenerator> {
        /**
         * <p>
         * The Amazon Web Services account ID that owns the bucket the generated manifest is written to. If provided the
         * generated manifest bucket's owner Amazon Web Services account ID must match this value, else the job fails.
         * </p>
         * 
         * @param expectedBucketOwner
         *        The Amazon Web Services account ID that owns the bucket the generated manifest is written to. If
         *        provided the generated manifest bucket's owner Amazon Web Services account ID must match this value,
         *        else the job fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedBucketOwner(String expectedBucketOwner);

        /**
         * <p>
         * The ARN of the source bucket used by the ManifestGenerator.
         * </p>
         * <note>
         * <p>
         * <b>Directory buckets</b> - Directory buckets aren't supported as the source buckets used by
         * <code>S3JobManifestGenerator</code> to generate the job manifest.
         * </p>
         * </note>
         * 
         * @param sourceBucket
         *        The ARN of the source bucket used by the ManifestGenerator.</p> <note>
         *        <p>
         *        <b>Directory buckets</b> - Directory buckets aren't supported as the source buckets used by
         *        <code>S3JobManifestGenerator</code> to generate the job manifest.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBucket(String sourceBucket);

        /**
         * <p>
         * Specifies the location the generated manifest will be written to. Manifests can't be written to directory
         * buckets. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">Directory
         * buckets</a>.
         * </p>
         * 
         * @param manifestOutputLocation
         *        Specifies the location the generated manifest will be written to. Manifests can't be written to
         *        directory buckets. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">Directory
         *        buckets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestOutputLocation(S3ManifestOutputLocation manifestOutputLocation);

        /**
         * <p>
         * Specifies the location the generated manifest will be written to. Manifests can't be written to directory
         * buckets. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">Directory
         * buckets</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ManifestOutputLocation.Builder}
         * avoiding the need to create one manually via {@link S3ManifestOutputLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ManifestOutputLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #manifestOutputLocation(S3ManifestOutputLocation)}.
         * 
         * @param manifestOutputLocation
         *        a consumer that will call methods on {@link S3ManifestOutputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifestOutputLocation(S3ManifestOutputLocation)
         */
        default Builder manifestOutputLocation(Consumer<S3ManifestOutputLocation.Builder> manifestOutputLocation) {
            return manifestOutputLocation(S3ManifestOutputLocation.builder().applyMutation(manifestOutputLocation).build());
        }

        /**
         * <p>
         * Specifies rules the S3JobManifestGenerator should use to decide whether an object in the source bucket should
         * or should not be included in the generated job manifest.
         * </p>
         * 
         * @param filter
         *        Specifies rules the S3JobManifestGenerator should use to decide whether an object in the source bucket
         *        should or should not be included in the generated job manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(JobManifestGeneratorFilter filter);

        /**
         * <p>
         * Specifies rules the S3JobManifestGenerator should use to decide whether an object in the source bucket should
         * or should not be included in the generated job manifest.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobManifestGeneratorFilter.Builder}
         * avoiding the need to create one manually via {@link JobManifestGeneratorFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobManifestGeneratorFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #filter(JobManifestGeneratorFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link JobManifestGeneratorFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(JobManifestGeneratorFilter)
         */
        default Builder filter(Consumer<JobManifestGeneratorFilter.Builder> filter) {
            return filter(JobManifestGeneratorFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * Determines whether or not to write the job's generated manifest to a bucket.
         * </p>
         * 
         * @param enableManifestOutput
         *        Determines whether or not to write the job's generated manifest to a bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableManifestOutput(Boolean enableManifestOutput);
    }

    static final class BuilderImpl implements Builder {
        private String expectedBucketOwner;

        private String sourceBucket;

        private S3ManifestOutputLocation manifestOutputLocation;

        private JobManifestGeneratorFilter filter;

        private Boolean enableManifestOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(S3JobManifestGenerator model) {
            expectedBucketOwner(model.expectedBucketOwner);
            sourceBucket(model.sourceBucket);
            manifestOutputLocation(model.manifestOutputLocation);
            filter(model.filter);
            enableManifestOutput(model.enableManifestOutput);
        }

        public final String getExpectedBucketOwner() {
            return expectedBucketOwner;
        }

        public final void setExpectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public final String getSourceBucket() {
            return sourceBucket;
        }

        public final void setSourceBucket(String sourceBucket) {
            this.sourceBucket = sourceBucket;
        }

        @Override
        public final Builder sourceBucket(String sourceBucket) {
            this.sourceBucket = sourceBucket;
            return this;
        }

        public final S3ManifestOutputLocation.Builder getManifestOutputLocation() {
            return manifestOutputLocation != null ? manifestOutputLocation.toBuilder() : null;
        }

        public final void setManifestOutputLocation(S3ManifestOutputLocation.BuilderImpl manifestOutputLocation) {
            this.manifestOutputLocation = manifestOutputLocation != null ? manifestOutputLocation.build() : null;
        }

        @Override
        public final Builder manifestOutputLocation(S3ManifestOutputLocation manifestOutputLocation) {
            this.manifestOutputLocation = manifestOutputLocation;
            return this;
        }

        public final JobManifestGeneratorFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(JobManifestGeneratorFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(JobManifestGeneratorFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Boolean getEnableManifestOutput() {
            return enableManifestOutput;
        }

        public final void setEnableManifestOutput(Boolean enableManifestOutput) {
            this.enableManifestOutput = enableManifestOutput;
        }

        @Override
        public final Builder enableManifestOutput(Boolean enableManifestOutput) {
            this.enableManifestOutput = enableManifestOutput;
            return this;
        }

        @Override
        public S3JobManifestGenerator build() {
            return new S3JobManifestGenerator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
