/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.ListStorageLensGroupEntry;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.services.s3control.model.StorageLensGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStorageLensGroupsResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, ListStorageLensGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStorageLensGroupsResponse.getter(ListStorageLensGroupsResponse::nextToken)).setter(ListStorageLensGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<List<ListStorageLensGroupEntry>> STORAGE_LENS_GROUP_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StorageLensGroupList").getter(ListStorageLensGroupsResponse.getter(ListStorageLensGroupsResponse::storageLensGroupList)).setter(ListStorageLensGroupsResponse.setter(Builder::storageLensGroupList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensGroup").unmarshallLocationName("StorageLensGroup").build(), ListTrait.builder().memberLocationName("StorageLensGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListStorageLensGroupEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensGroup").unmarshallLocationName("StorageLensGroup").build()}).build()).isFlattened(true).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, STORAGE_LENS_GROUP_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("StorageLensGroup", STORAGE_LENS_GROUP_LIST_FIELD);
        }
    });
    private final String nextToken;
    private final List<ListStorageLensGroupEntry> storageLensGroupList;

    private ListStorageLensGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.storageLensGroupList = builder.storageLensGroupList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasStorageLensGroupList() {
        return this.storageLensGroupList != null && !(this.storageLensGroupList instanceof SdkAutoConstructList);
    }

    public final List<ListStorageLensGroupEntry> storageLensGroupList() {
        return this.storageLensGroupList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageLensGroupList() ? this.storageLensGroupList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStorageLensGroupsResponse)) {
            return false;
        }
        ListStorageLensGroupsResponse other = (ListStorageLensGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasStorageLensGroupList() == other.hasStorageLensGroupList() && Objects.equals(this.storageLensGroupList(), other.storageLensGroupList());
    }

    public final String toString() {
        return ToString.builder((String)"ListStorageLensGroupsResponse").add("NextToken", (Object)this.nextToken()).add("StorageLensGroupList", this.hasStorageLensGroupList() ? this.storageLensGroupList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "StorageLensGroupList": {
                return Optional.ofNullable(clazz.cast(this.storageLensGroupList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListStorageLensGroupsResponse, T> g) {
        return obj -> g.apply((ListStorageLensGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ListStorageLensGroupEntry> storageLensGroupList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStorageLensGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.storageLensGroupList(model.storageLensGroupList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListStorageLensGroupEntry.Builder> getStorageLensGroupList() {
            List<ListStorageLensGroupEntry.Builder> result = StorageLensGroupListCopier.copyToBuilder(this.storageLensGroupList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageLensGroupList(Collection<ListStorageLensGroupEntry.BuilderImpl> storageLensGroupList) {
            this.storageLensGroupList = StorageLensGroupListCopier.copyFromBuilder(storageLensGroupList);
        }

        @Override
        public final Builder storageLensGroupList(Collection<ListStorageLensGroupEntry> storageLensGroupList) {
            this.storageLensGroupList = StorageLensGroupListCopier.copy(storageLensGroupList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageLensGroupList(ListStorageLensGroupEntry ... storageLensGroupList) {
            this.storageLensGroupList(Arrays.asList(storageLensGroupList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageLensGroupList(Consumer<ListStorageLensGroupEntry.Builder> ... storageLensGroupList) {
            this.storageLensGroupList(Stream.of(storageLensGroupList).map(c -> (ListStorageLensGroupEntry)((ListStorageLensGroupEntry.Builder)ListStorageLensGroupEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStorageLensGroupsResponse build() {
            return new ListStorageLensGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStorageLensGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder storageLensGroupList(Collection<ListStorageLensGroupEntry> var1);

        public Builder storageLensGroupList(ListStorageLensGroupEntry ... var1);

        public Builder storageLensGroupList(Consumer<ListStorageLensGroupEntry.Builder> ... var1);
    }
}

