/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for the response details that are returned when querying about an asynchronous request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AsyncResponseDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AsyncResponseDetails.Builder, AsyncResponseDetails> {
    private static final SdkField<MultiRegionAccessPointsAsyncResponse> MULTI_REGION_ACCESS_POINT_DETAILS_FIELD = SdkField
            .<MultiRegionAccessPointsAsyncResponse> builder(MarshallingType.SDK_POJO)
            .memberName("MultiRegionAccessPointDetails")
            .getter(getter(AsyncResponseDetails::multiRegionAccessPointDetails))
            .setter(setter(Builder::multiRegionAccessPointDetails))
            .constructor(MultiRegionAccessPointsAsyncResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionAccessPointDetails")
                    .unmarshallLocationName("MultiRegionAccessPointDetails").build()).build();

    private static final SdkField<AsyncErrorDetails> ERROR_DETAILS_FIELD = SdkField
            .<AsyncErrorDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ErrorDetails")
            .getter(getter(AsyncResponseDetails::errorDetails))
            .setter(setter(Builder::errorDetails))
            .constructor(AsyncErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails")
                    .unmarshallLocationName("ErrorDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MULTI_REGION_ACCESS_POINT_DETAILS_FIELD, ERROR_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MultiRegionAccessPointsAsyncResponse multiRegionAccessPointDetails;

    private final AsyncErrorDetails errorDetails;

    private AsyncResponseDetails(BuilderImpl builder) {
        this.multiRegionAccessPointDetails = builder.multiRegionAccessPointDetails;
        this.errorDetails = builder.errorDetails;
    }

    /**
     * <p>
     * The details for the Multi-Region Access Point.
     * </p>
     * 
     * @return The details for the Multi-Region Access Point.
     */
    public final MultiRegionAccessPointsAsyncResponse multiRegionAccessPointDetails() {
        return multiRegionAccessPointDetails;
    }

    /**
     * <p>
     * Error details for an asynchronous request.
     * </p>
     * 
     * @return Error details for an asynchronous request.
     */
    public final AsyncErrorDetails errorDetails() {
        return errorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionAccessPointDetails());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsyncResponseDetails)) {
            return false;
        }
        AsyncResponseDetails other = (AsyncResponseDetails) obj;
        return Objects.equals(multiRegionAccessPointDetails(), other.multiRegionAccessPointDetails())
                && Objects.equals(errorDetails(), other.errorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AsyncResponseDetails").add("MultiRegionAccessPointDetails", multiRegionAccessPointDetails())
                .add("ErrorDetails", errorDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultiRegionAccessPointDetails":
            return Optional.ofNullable(clazz.cast(multiRegionAccessPointDetails()));
        case "ErrorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MultiRegionAccessPointDetails", MULTI_REGION_ACCESS_POINT_DETAILS_FIELD);
        map.put("ErrorDetails", ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AsyncResponseDetails, T> g) {
        return obj -> g.apply((AsyncResponseDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AsyncResponseDetails> {
        /**
         * <p>
         * The details for the Multi-Region Access Point.
         * </p>
         * 
         * @param multiRegionAccessPointDetails
         *        The details for the Multi-Region Access Point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionAccessPointDetails(MultiRegionAccessPointsAsyncResponse multiRegionAccessPointDetails);

        /**
         * <p>
         * The details for the Multi-Region Access Point.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MultiRegionAccessPointsAsyncResponse.Builder} avoiding the need to create one manually via
         * {@link MultiRegionAccessPointsAsyncResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiRegionAccessPointsAsyncResponse.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #multiRegionAccessPointDetails(MultiRegionAccessPointsAsyncResponse)}.
         * 
         * @param multiRegionAccessPointDetails
         *        a consumer that will call methods on {@link MultiRegionAccessPointsAsyncResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiRegionAccessPointDetails(MultiRegionAccessPointsAsyncResponse)
         */
        default Builder multiRegionAccessPointDetails(
                Consumer<MultiRegionAccessPointsAsyncResponse.Builder> multiRegionAccessPointDetails) {
            return multiRegionAccessPointDetails(MultiRegionAccessPointsAsyncResponse.builder()
                    .applyMutation(multiRegionAccessPointDetails).build());
        }

        /**
         * <p>
         * Error details for an asynchronous request.
         * </p>
         * 
         * @param errorDetails
         *        Error details for an asynchronous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(AsyncErrorDetails errorDetails);

        /**
         * <p>
         * Error details for an asynchronous request.
         * </p>
         * This is a convenience method that creates an instance of the {@link AsyncErrorDetails.Builder} avoiding the
         * need to create one manually via {@link AsyncErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AsyncErrorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #errorDetails(AsyncErrorDetails)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link AsyncErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(AsyncErrorDetails)
         */
        default Builder errorDetails(Consumer<AsyncErrorDetails.Builder> errorDetails) {
            return errorDetails(AsyncErrorDetails.builder().applyMutation(errorDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MultiRegionAccessPointsAsyncResponse multiRegionAccessPointDetails;

        private AsyncErrorDetails errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(AsyncResponseDetails model) {
            multiRegionAccessPointDetails(model.multiRegionAccessPointDetails);
            errorDetails(model.errorDetails);
        }

        public final MultiRegionAccessPointsAsyncResponse.Builder getMultiRegionAccessPointDetails() {
            return multiRegionAccessPointDetails != null ? multiRegionAccessPointDetails.toBuilder() : null;
        }

        public final void setMultiRegionAccessPointDetails(
                MultiRegionAccessPointsAsyncResponse.BuilderImpl multiRegionAccessPointDetails) {
            this.multiRegionAccessPointDetails = multiRegionAccessPointDetails != null ? multiRegionAccessPointDetails.build()
                    : null;
        }

        @Override
        public final Builder multiRegionAccessPointDetails(MultiRegionAccessPointsAsyncResponse multiRegionAccessPointDetails) {
            this.multiRegionAccessPointDetails = multiRegionAccessPointDetails;
            return this;
        }

        public final AsyncErrorDetails.Builder getErrorDetails() {
            return errorDetails != null ? errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(AsyncErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(AsyncErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        @Override
        public AsyncResponseDetails build() {
            return new AsyncResponseDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
