/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lambda function used to transform objects through an Object Lambda Access Point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsLambdaTransformation implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsLambdaTransformation.Builder, AwsLambdaTransformation> {
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FunctionArn")
            .getter(getter(AwsLambdaTransformation::functionArn))
            .setter(setter(Builder::functionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn")
                    .unmarshallLocationName("FunctionArn").build()).build();

    private static final SdkField<String> FUNCTION_PAYLOAD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FunctionPayload")
            .getter(getter(AwsLambdaTransformation::functionPayload))
            .setter(setter(Builder::functionPayload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionPayload")
                    .unmarshallLocationName("FunctionPayload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARN_FIELD,
            FUNCTION_PAYLOAD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String functionArn;

    private final String functionPayload;

    private AwsLambdaTransformation(BuilderImpl builder) {
        this.functionArn = builder.functionArn;
        this.functionPayload = builder.functionPayload;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function.
     */
    public final String functionArn() {
        return functionArn;
    }

    /**
     * <p>
     * Additional JSON that provides supplemental data to the Lambda function used to transform objects.
     * </p>
     * 
     * @return Additional JSON that provides supplemental data to the Lambda function used to transform objects.
     */
    public final String functionPayload() {
        return functionPayload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(functionPayload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLambdaTransformation)) {
            return false;
        }
        AwsLambdaTransformation other = (AwsLambdaTransformation) obj;
        return Objects.equals(functionArn(), other.functionArn()) && Objects.equals(functionPayload(), other.functionPayload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsLambdaTransformation").add("FunctionArn", functionArn())
                .add("FunctionPayload", functionPayload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionArn":
            return Optional.ofNullable(clazz.cast(functionArn()));
        case "FunctionPayload":
            return Optional.ofNullable(clazz.cast(functionPayload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FunctionArn", FUNCTION_ARN_FIELD);
        map.put("FunctionPayload", FUNCTION_PAYLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsLambdaTransformation, T> g) {
        return obj -> g.apply((AwsLambdaTransformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsLambdaTransformation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function.
         * </p>
         * 
         * @param functionArn
         *        The Amazon Resource Name (ARN) of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        /**
         * <p>
         * Additional JSON that provides supplemental data to the Lambda function used to transform objects.
         * </p>
         * 
         * @param functionPayload
         *        Additional JSON that provides supplemental data to the Lambda function used to transform objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionPayload(String functionPayload);
    }

    static final class BuilderImpl implements Builder {
        private String functionArn;

        private String functionPayload;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsLambdaTransformation model) {
            functionArn(model.functionArn);
            functionPayload(model.functionPayload);
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final String getFunctionPayload() {
            return functionPayload;
        }

        public final void setFunctionPayload(String functionPayload) {
            this.functionPayload = functionPayload;
        }

        @Override
        public final Builder functionPayload(String functionPayload) {
            this.functionPayload = functionPayload;
            return this;
        }

        @Override
        public AwsLambdaTransformation build() {
            return new AwsLambdaTransformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
