/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStorageLensGroupResponse extends S3ControlResponse implements
        ToCopyableBuilder<GetStorageLensGroupResponse.Builder, GetStorageLensGroupResponse> {
    private static final SdkField<StorageLensGroup> STORAGE_LENS_GROUP_FIELD = SdkField
            .<StorageLensGroup> builder(MarshallingType.SDK_POJO)
            .memberName("StorageLensGroup")
            .getter(getter(GetStorageLensGroupResponse::storageLensGroup))
            .setter(setter(Builder::storageLensGroup))
            .constructor(StorageLensGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensGroup")
                    .unmarshallLocationName("StorageLensGroup").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_LENS_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final StorageLensGroup storageLensGroup;

    private GetStorageLensGroupResponse(BuilderImpl builder) {
        super(builder);
        this.storageLensGroup = builder.storageLensGroup;
    }

    /**
     * <p>
     * The name of the Storage Lens group that you're trying to retrieve the configuration details for.
     * </p>
     * 
     * @return The name of the Storage Lens group that you're trying to retrieve the configuration details for.
     */
    public final StorageLensGroup storageLensGroup() {
        return storageLensGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storageLensGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStorageLensGroupResponse)) {
            return false;
        }
        GetStorageLensGroupResponse other = (GetStorageLensGroupResponse) obj;
        return Objects.equals(storageLensGroup(), other.storageLensGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStorageLensGroupResponse").add("StorageLensGroup", storageLensGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageLensGroup":
            return Optional.ofNullable(clazz.cast(storageLensGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StorageLensGroup", STORAGE_LENS_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStorageLensGroupResponse, T> g) {
        return obj -> g.apply((GetStorageLensGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStorageLensGroupResponse> {
        /**
         * <p>
         * The name of the Storage Lens group that you're trying to retrieve the configuration details for.
         * </p>
         * 
         * @param storageLensGroup
         *        The name of the Storage Lens group that you're trying to retrieve the configuration details for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLensGroup(StorageLensGroup storageLensGroup);

        /**
         * <p>
         * The name of the Storage Lens group that you're trying to retrieve the configuration details for.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageLensGroup.Builder} avoiding the
         * need to create one manually via {@link StorageLensGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageLensGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #storageLensGroup(StorageLensGroup)}.
         * 
         * @param storageLensGroup
         *        a consumer that will call methods on {@link StorageLensGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageLensGroup(StorageLensGroup)
         */
        default Builder storageLensGroup(Consumer<StorageLensGroup.Builder> storageLensGroup) {
            return storageLensGroup(StorageLensGroup.builder().applyMutation(storageLensGroup).build());
        }
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private StorageLensGroup storageLensGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStorageLensGroupResponse model) {
            super(model);
            storageLensGroup(model.storageLensGroup);
        }

        public final StorageLensGroup.Builder getStorageLensGroup() {
            return storageLensGroup != null ? storageLensGroup.toBuilder() : null;
        }

        public final void setStorageLensGroup(StorageLensGroup.BuilderImpl storageLensGroup) {
            this.storageLensGroup = storageLensGroup != null ? storageLensGroup.build() : null;
        }

        @Override
        public final Builder storageLensGroup(StorageLensGroup storageLensGroup) {
            this.storageLensGroup = storageLensGroup;
            return this;
        }

        @Override
        public GetStorageLensGroupResponse build() {
            return new GetStorageLensGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
