/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The user, group, or role to which you are granting access. You can grant access to an IAM user or role. If you have
 * added your corporate directory to Amazon Web Services IAM Identity Center and associated your Identity Center
 * instance with your S3 Access Grants instance, the grantee can also be a corporate directory user or group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Grantee implements SdkPojo, Serializable, ToCopyableBuilder<Grantee.Builder, Grantee> {
    private static final SdkField<String> GRANTEE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GranteeType")
            .getter(getter(Grantee::granteeTypeAsString))
            .setter(setter(Builder::granteeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteeType")
                    .unmarshallLocationName("GranteeType").build()).build();

    private static final SdkField<String> GRANTEE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GranteeIdentifier")
            .getter(getter(Grantee::granteeIdentifier))
            .setter(setter(Builder::granteeIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteeIdentifier")
                    .unmarshallLocationName("GranteeIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANTEE_TYPE_FIELD,
            GRANTEE_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String granteeType;

    private final String granteeIdentifier;

    private Grantee(BuilderImpl builder) {
        this.granteeType = builder.granteeType;
        this.granteeIdentifier = builder.granteeIdentifier;
    }

    /**
     * <p>
     * The type of the grantee to which access has been granted. It can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IAM</code> - An IAM user or role.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DIRECTORY_USER</code> - Your corporate directory user. You can use this option if you have added your
     * corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3
     * Access Grants instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DIRECTORY_GROUP</code> - Your corporate directory group. You can use this option if you have added your
     * corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3
     * Access Grants instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granteeType} will
     * return {@link GranteeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granteeTypeAsString}.
     * </p>
     * 
     * @return The type of the grantee to which access has been granted. It can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IAM</code> - An IAM user or role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DIRECTORY_USER</code> - Your corporate directory user. You can use this option if you have added
     *         your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance
     *         with your S3 Access Grants instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DIRECTORY_GROUP</code> - Your corporate directory group. You can use this option if you have added
     *         your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance
     *         with your S3 Access Grants instance.
     *         </p>
     *         </li>
     * @see GranteeType
     */
    public final GranteeType granteeType() {
        return GranteeType.fromValue(granteeType);
    }

    /**
     * <p>
     * The type of the grantee to which access has been granted. It can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IAM</code> - An IAM user or role.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DIRECTORY_USER</code> - Your corporate directory user. You can use this option if you have added your
     * corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3
     * Access Grants instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DIRECTORY_GROUP</code> - Your corporate directory group. You can use this option if you have added your
     * corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your S3
     * Access Grants instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granteeType} will
     * return {@link GranteeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granteeTypeAsString}.
     * </p>
     * 
     * @return The type of the grantee to which access has been granted. It can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IAM</code> - An IAM user or role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DIRECTORY_USER</code> - Your corporate directory user. You can use this option if you have added
     *         your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance
     *         with your S3 Access Grants instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DIRECTORY_GROUP</code> - Your corporate directory group. You can use this option if you have added
     *         your corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance
     *         with your S3 Access Grants instance.
     *         </p>
     *         </li>
     * @see GranteeType
     */
    public final String granteeTypeAsString() {
        return granteeType;
    }

    /**
     * <p>
     * The unique identifier of the <code>Grantee</code>. If the grantee type is <code>IAM</code>, the identifier is the
     * IAM Amazon Resource Name (ARN) of the user or role. If the grantee type is a directory user or group, the
     * identifier is 128-bit universally unique identifier (UUID) in the format
     * <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>. You can obtain this UUID from your Amazon Web Services IAM
     * Identity Center instance.
     * </p>
     * 
     * @return The unique identifier of the <code>Grantee</code>. If the grantee type is <code>IAM</code>, the
     *         identifier is the IAM Amazon Resource Name (ARN) of the user or role. If the grantee type is a directory
     *         user or group, the identifier is 128-bit universally unique identifier (UUID) in the format
     *         <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>. You can obtain this UUID from your Amazon Web Services
     *         IAM Identity Center instance.
     */
    public final String granteeIdentifier() {
        return granteeIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(granteeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(granteeIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Grantee)) {
            return false;
        }
        Grantee other = (Grantee) obj;
        return Objects.equals(granteeTypeAsString(), other.granteeTypeAsString())
                && Objects.equals(granteeIdentifier(), other.granteeIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Grantee").add("GranteeType", granteeTypeAsString())
                .add("GranteeIdentifier", granteeIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GranteeType":
            return Optional.ofNullable(clazz.cast(granteeTypeAsString()));
        case "GranteeIdentifier":
            return Optional.ofNullable(clazz.cast(granteeIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GranteeType", GRANTEE_TYPE_FIELD);
        map.put("GranteeIdentifier", GRANTEE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Grantee, T> g) {
        return obj -> g.apply((Grantee) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Grantee> {
        /**
         * <p>
         * The type of the grantee to which access has been granted. It can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IAM</code> - An IAM user or role.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DIRECTORY_USER</code> - Your corporate directory user. You can use this option if you have added your
         * corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your
         * S3 Access Grants instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DIRECTORY_GROUP</code> - Your corporate directory group. You can use this option if you have added your
         * corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your
         * S3 Access Grants instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param granteeType
         *        The type of the grantee to which access has been granted. It can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IAM</code> - An IAM user or role.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DIRECTORY_USER</code> - Your corporate directory user. You can use this option if you have added
         *        your corporate identity directory to IAM Identity Center and associated the IAM Identity Center
         *        instance with your S3 Access Grants instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DIRECTORY_GROUP</code> - Your corporate directory group. You can use this option if you have
         *        added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center
         *        instance with your S3 Access Grants instance.
         *        </p>
         *        </li>
         * @see GranteeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GranteeType
         */
        Builder granteeType(String granteeType);

        /**
         * <p>
         * The type of the grantee to which access has been granted. It can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IAM</code> - An IAM user or role.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DIRECTORY_USER</code> - Your corporate directory user. You can use this option if you have added your
         * corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your
         * S3 Access Grants instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DIRECTORY_GROUP</code> - Your corporate directory group. You can use this option if you have added your
         * corporate identity directory to IAM Identity Center and associated the IAM Identity Center instance with your
         * S3 Access Grants instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param granteeType
         *        The type of the grantee to which access has been granted. It can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IAM</code> - An IAM user or role.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DIRECTORY_USER</code> - Your corporate directory user. You can use this option if you have added
         *        your corporate identity directory to IAM Identity Center and associated the IAM Identity Center
         *        instance with your S3 Access Grants instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DIRECTORY_GROUP</code> - Your corporate directory group. You can use this option if you have
         *        added your corporate identity directory to IAM Identity Center and associated the IAM Identity Center
         *        instance with your S3 Access Grants instance.
         *        </p>
         *        </li>
         * @see GranteeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GranteeType
         */
        Builder granteeType(GranteeType granteeType);

        /**
         * <p>
         * The unique identifier of the <code>Grantee</code>. If the grantee type is <code>IAM</code>, the identifier is
         * the IAM Amazon Resource Name (ARN) of the user or role. If the grantee type is a directory user or group, the
         * identifier is 128-bit universally unique identifier (UUID) in the format
         * <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>. You can obtain this UUID from your Amazon Web Services IAM
         * Identity Center instance.
         * </p>
         * 
         * @param granteeIdentifier
         *        The unique identifier of the <code>Grantee</code>. If the grantee type is <code>IAM</code>, the
         *        identifier is the IAM Amazon Resource Name (ARN) of the user or role. If the grantee type is a
         *        directory user or group, the identifier is 128-bit universally unique identifier (UUID) in the format
         *        <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>. You can obtain this UUID from your Amazon Web
         *        Services IAM Identity Center instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granteeIdentifier(String granteeIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String granteeType;

        private String granteeIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(Grantee model) {
            granteeType(model.granteeType);
            granteeIdentifier(model.granteeIdentifier);
        }

        public final String getGranteeType() {
            return granteeType;
        }

        public final void setGranteeType(String granteeType) {
            this.granteeType = granteeType;
        }

        @Override
        public final Builder granteeType(String granteeType) {
            this.granteeType = granteeType;
            return this;
        }

        @Override
        public final Builder granteeType(GranteeType granteeType) {
            this.granteeType(granteeType == null ? null : granteeType.toString());
            return this;
        }

        public final String getGranteeIdentifier() {
            return granteeIdentifier;
        }

        public final void setGranteeIdentifier(String granteeIdentifier) {
            this.granteeIdentifier = granteeIdentifier;
        }

        @Override
        public final Builder granteeIdentifier(String granteeIdentifier) {
            this.granteeIdentifier = granteeIdentifier;
            return this;
        }

        @Override
        public Grantee build() {
            return new Grantee(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
