/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides timing details for the job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobTimers implements SdkPojo, Serializable, ToCopyableBuilder<JobTimers.Builder, JobTimers> {
    private static final SdkField<Long> ELAPSED_TIME_IN_ACTIVE_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ElapsedTimeInActiveSeconds")
            .getter(getter(JobTimers::elapsedTimeInActiveSeconds))
            .setter(setter(Builder::elapsedTimeInActiveSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeInActiveSeconds")
                    .unmarshallLocationName("ElapsedTimeInActiveSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ELAPSED_TIME_IN_ACTIVE_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long elapsedTimeInActiveSeconds;

    private JobTimers(BuilderImpl builder) {
        this.elapsedTimeInActiveSeconds = builder.elapsedTimeInActiveSeconds;
    }

    /**
     * <p>
     * Indicates the elapsed time in seconds the job has been in the Active job state.
     * </p>
     * 
     * @return Indicates the elapsed time in seconds the job has been in the Active job state.
     */
    public final Long elapsedTimeInActiveSeconds() {
        return elapsedTimeInActiveSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elapsedTimeInActiveSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobTimers)) {
            return false;
        }
        JobTimers other = (JobTimers) obj;
        return Objects.equals(elapsedTimeInActiveSeconds(), other.elapsedTimeInActiveSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobTimers").add("ElapsedTimeInActiveSeconds", elapsedTimeInActiveSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElapsedTimeInActiveSeconds":
            return Optional.ofNullable(clazz.cast(elapsedTimeInActiveSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ElapsedTimeInActiveSeconds", ELAPSED_TIME_IN_ACTIVE_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobTimers, T> g) {
        return obj -> g.apply((JobTimers) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobTimers> {
        /**
         * <p>
         * Indicates the elapsed time in seconds the job has been in the Active job state.
         * </p>
         * 
         * @param elapsedTimeInActiveSeconds
         *        Indicates the elapsed time in seconds the job has been in the Active job state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elapsedTimeInActiveSeconds(Long elapsedTimeInActiveSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Long elapsedTimeInActiveSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(JobTimers model) {
            elapsedTimeInActiveSeconds(model.elapsedTimeInActiveSeconds);
        }

        public final Long getElapsedTimeInActiveSeconds() {
            return elapsedTimeInActiveSeconds;
        }

        public final void setElapsedTimeInActiveSeconds(Long elapsedTimeInActiveSeconds) {
            this.elapsedTimeInActiveSeconds = elapsedTimeInActiveSeconds;
        }

        @Override
        public final Builder elapsedTimeInActiveSeconds(Long elapsedTimeInActiveSeconds) {
            this.elapsedTimeInActiveSeconds = elapsedTimeInActiveSeconds;
            return this;
        }

        @Override
        public JobTimers build() {
            return new JobTimers(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
