/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Each entry contains a Storage Lens group that exists in the specified home Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStorageLensGroupEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ListStorageLensGroupEntry.Builder, ListStorageLensGroupEntry> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(ListStorageLensGroupEntry::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> STORAGE_LENS_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StorageLensGroupArn")
            .getter(getter(ListStorageLensGroupEntry::storageLensGroupArn))
            .setter(setter(Builder::storageLensGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensGroupArn")
                    .unmarshallLocationName("StorageLensGroupArn").build()).build();

    private static final SdkField<String> HOME_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HomeRegion")
            .getter(getter(ListStorageLensGroupEntry::homeRegion))
            .setter(setter(Builder::homeRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeRegion")
                    .unmarshallLocationName("HomeRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            STORAGE_LENS_GROUP_ARN_FIELD, HOME_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String storageLensGroupArn;

    private final String homeRegion;

    private ListStorageLensGroupEntry(BuilderImpl builder) {
        this.name = builder.name;
        this.storageLensGroupArn = builder.storageLensGroupArn;
        this.homeRegion = builder.homeRegion;
    }

    /**
     * <p>
     * Contains the name of the Storage Lens group that exists in the specified home Region.
     * </p>
     * 
     * @return Contains the name of the Storage Lens group that exists in the specified home Region.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Contains the Amazon Resource Name (ARN) of the Storage Lens group. This property is read-only.
     * </p>
     * 
     * @return Contains the Amazon Resource Name (ARN) of the Storage Lens group. This property is read-only.
     */
    public final String storageLensGroupArn() {
        return storageLensGroupArn;
    }

    /**
     * <p>
     * Contains the Amazon Web Services Region where the Storage Lens group was created.
     * </p>
     * 
     * @return Contains the Amazon Web Services Region where the Storage Lens group was created.
     */
    public final String homeRegion() {
        return homeRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(storageLensGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(homeRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStorageLensGroupEntry)) {
            return false;
        }
        ListStorageLensGroupEntry other = (ListStorageLensGroupEntry) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(storageLensGroupArn(), other.storageLensGroupArn())
                && Objects.equals(homeRegion(), other.homeRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStorageLensGroupEntry").add("Name", name())
                .add("StorageLensGroupArn", storageLensGroupArn()).add("HomeRegion", homeRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "StorageLensGroupArn":
            return Optional.ofNullable(clazz.cast(storageLensGroupArn()));
        case "HomeRegion":
            return Optional.ofNullable(clazz.cast(homeRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("StorageLensGroupArn", STORAGE_LENS_GROUP_ARN_FIELD);
        map.put("HomeRegion", HOME_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStorageLensGroupEntry, T> g) {
        return obj -> g.apply((ListStorageLensGroupEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListStorageLensGroupEntry> {
        /**
         * <p>
         * Contains the name of the Storage Lens group that exists in the specified home Region.
         * </p>
         * 
         * @param name
         *        Contains the name of the Storage Lens group that exists in the specified home Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Contains the Amazon Resource Name (ARN) of the Storage Lens group. This property is read-only.
         * </p>
         * 
         * @param storageLensGroupArn
         *        Contains the Amazon Resource Name (ARN) of the Storage Lens group. This property is read-only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLensGroupArn(String storageLensGroupArn);

        /**
         * <p>
         * Contains the Amazon Web Services Region where the Storage Lens group was created.
         * </p>
         * 
         * @param homeRegion
         *        Contains the Amazon Web Services Region where the Storage Lens group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeRegion(String homeRegion);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String storageLensGroupArn;

        private String homeRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStorageLensGroupEntry model) {
            name(model.name);
            storageLensGroupArn(model.storageLensGroupArn);
            homeRegion(model.homeRegion);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStorageLensGroupArn() {
            return storageLensGroupArn;
        }

        public final void setStorageLensGroupArn(String storageLensGroupArn) {
            this.storageLensGroupArn = storageLensGroupArn;
        }

        @Override
        public final Builder storageLensGroupArn(String storageLensGroupArn) {
            this.storageLensGroupArn = storageLensGroupArn;
            return this;
        }

        public final String getHomeRegion() {
            return homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        @Override
        public ListStorageLensGroupEntry build() {
            return new ListStorageLensGroupEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
