/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3AccessControlList implements SdkPojo, Serializable,
        ToCopyableBuilder<S3AccessControlList.Builder, S3AccessControlList> {
    private static final SdkField<S3ObjectOwner> OWNER_FIELD = SdkField
            .<S3ObjectOwner> builder(MarshallingType.SDK_POJO)
            .memberName("Owner")
            .getter(getter(S3AccessControlList::owner))
            .setter(setter(Builder::owner))
            .constructor(S3ObjectOwner::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner")
                    .unmarshallLocationName("Owner").build()).build();

    private static final SdkField<List<S3Grant>> GRANTS_FIELD = SdkField
            .<List<S3Grant>> builder(MarshallingType.LIST)
            .memberName("Grants")
            .getter(getter(S3AccessControlList::grants))
            .setter(setter(Builder::grants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grants")
                    .unmarshallLocationName("Grants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3Grant> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3Grant::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_FIELD, GRANTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3ObjectOwner owner;

    private final List<S3Grant> grants;

    private S3AccessControlList(BuilderImpl builder) {
        this.owner = builder.owner;
        this.grants = builder.grants;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final S3ObjectOwner owner() {
        return owner;
    }

    /**
     * For responses, this returns true if the service returned a value for the Grants property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGrants() {
        return grants != null && !(grants instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGrants} method.
     * </p>
     * 
     * @return
     */
    public final List<S3Grant> grants() {
        return grants;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(hasGrants() ? grants() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3AccessControlList)) {
            return false;
        }
        S3AccessControlList other = (S3AccessControlList) obj;
        return Objects.equals(owner(), other.owner()) && hasGrants() == other.hasGrants()
                && Objects.equals(grants(), other.grants());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3AccessControlList").add("Owner", owner()).add("Grants", hasGrants() ? grants() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "Grants":
            return Optional.ofNullable(clazz.cast(grants()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Owner", OWNER_FIELD);
        map.put("Grants", GRANTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3AccessControlList, T> g) {
        return obj -> g.apply((S3AccessControlList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3AccessControlList> {
        /**
         * <p/>
         * 
         * @param owner
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(S3ObjectOwner owner);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link S3ObjectOwner.Builder} avoiding the need
         * to create one manually via {@link S3ObjectOwner#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ObjectOwner.Builder#build()} is called immediately and its
         * result is passed to {@link #owner(S3ObjectOwner)}.
         * 
         * @param owner
         *        a consumer that will call methods on {@link S3ObjectOwner.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #owner(S3ObjectOwner)
         */
        default Builder owner(Consumer<S3ObjectOwner.Builder> owner) {
            return owner(S3ObjectOwner.builder().applyMutation(owner).build());
        }

        /**
         * <p/>
         * 
         * @param grants
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grants(Collection<S3Grant> grants);

        /**
         * <p/>
         * 
         * @param grants
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grants(S3Grant... grants);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3control.model.S3Grant.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.s3control.model.S3Grant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3control.model.S3Grant.Builder#build()} is called immediately and its
         * result is passed to {@link #grants(List<S3Grant>)}.
         * 
         * @param grants
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3control.model.S3Grant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grants(java.util.Collection<S3Grant>)
         */
        Builder grants(Consumer<S3Grant.Builder>... grants);
    }

    static final class BuilderImpl implements Builder {
        private S3ObjectOwner owner;

        private List<S3Grant> grants = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3AccessControlList model) {
            owner(model.owner);
            grants(model.grants);
        }

        public final S3ObjectOwner.Builder getOwner() {
            return owner != null ? owner.toBuilder() : null;
        }

        public final void setOwner(S3ObjectOwner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        @Override
        public final Builder owner(S3ObjectOwner owner) {
            this.owner = owner;
            return this;
        }

        public final List<S3Grant.Builder> getGrants() {
            List<S3Grant.Builder> result = S3GrantListCopier.copyToBuilder(this.grants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGrants(Collection<S3Grant.BuilderImpl> grants) {
            this.grants = S3GrantListCopier.copyFromBuilder(grants);
        }

        @Override
        public final Builder grants(Collection<S3Grant> grants) {
            this.grants = S3GrantListCopier.copy(grants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(S3Grant... grants) {
            grants(Arrays.asList(grants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(Consumer<S3Grant.Builder>... grants) {
            grants(Stream.of(grants).map(c -> S3Grant.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public S3AccessControlList build() {
            return new S3AccessControlList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
