/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for the bucket where the Amazon S3 Storage Lens metrics export files are located.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3BucketDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<S3BucketDestination.Builder, S3BucketDestination> {
    private static final SdkField<String> FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Format")
            .getter(getter(S3BucketDestination::formatAsString))
            .setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format")
                    .unmarshallLocationName("Format").build()).build();

    private static final SdkField<String> OUTPUT_SCHEMA_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutputSchemaVersion")
            .getter(getter(S3BucketDestination::outputSchemaVersionAsString))
            .setter(setter(Builder::outputSchemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSchemaVersion")
                    .unmarshallLocationName("OutputSchemaVersion").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(S3BucketDestination::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId")
                    .unmarshallLocationName("AccountId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Arn")
            .getter(getter(S3BucketDestination::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").unmarshallLocationName("Arn")
                    .build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Prefix")
            .getter(getter(S3BucketDestination::prefix))
            .setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix")
                    .unmarshallLocationName("Prefix").build()).build();

    private static final SdkField<StorageLensDataExportEncryption> ENCRYPTION_FIELD = SdkField
            .<StorageLensDataExportEncryption> builder(MarshallingType.SDK_POJO)
            .memberName("Encryption")
            .getter(getter(S3BucketDestination::encryption))
            .setter(setter(Builder::encryption))
            .constructor(StorageLensDataExportEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption")
                    .unmarshallLocationName("Encryption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD,
            OUTPUT_SCHEMA_VERSION_FIELD, ACCOUNT_ID_FIELD, ARN_FIELD, PREFIX_FIELD, ENCRYPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String format;

    private final String outputSchemaVersion;

    private final String accountId;

    private final String arn;

    private final String prefix;

    private final StorageLensDataExportEncryption encryption;

    private S3BucketDestination(BuilderImpl builder) {
        this.format = builder.format;
        this.outputSchemaVersion = builder.outputSchemaVersion;
        this.accountId = builder.accountId;
        this.arn = builder.arn;
        this.prefix = builder.prefix;
        this.encryption = builder.encryption;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return
     * @see Format
     */
    public final Format format() {
        return Format.fromValue(format);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return
     * @see Format
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The schema version of the export file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outputSchemaVersion} will return {@link OutputSchemaVersion#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #outputSchemaVersionAsString}.
     * </p>
     * 
     * @return The schema version of the export file.
     * @see OutputSchemaVersion
     */
    public final OutputSchemaVersion outputSchemaVersion() {
        return OutputSchemaVersion.fromValue(outputSchemaVersion);
    }

    /**
     * <p>
     * The schema version of the export file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outputSchemaVersion} will return {@link OutputSchemaVersion#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #outputSchemaVersionAsString}.
     * </p>
     * 
     * @return The schema version of the export file.
     * @see OutputSchemaVersion
     */
    public final String outputSchemaVersionAsString() {
        return outputSchemaVersion;
    }

    /**
     * <p>
     * The account ID of the owner of the S3 Storage Lens metrics export bucket.
     * </p>
     * 
     * @return The account ID of the owner of the S3 Storage Lens metrics export bucket.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the bucket. This property is read-only and follows the following format:
     * <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:bucket/<i>your-destination-bucket-name</i> </code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the bucket. This property is read-only and follows the following
     *         format:
     *         <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:bucket/<i>your-destination-bucket-name</i> </code>
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The prefix of the destination bucket where the metrics export will be delivered.
     * </p>
     * 
     * @return The prefix of the destination bucket where the metrics export will be delivered.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The container for the type encryption of the metrics exports in this bucket.
     * </p>
     * 
     * @return The container for the type encryption of the metrics exports in this bucket.
     */
    public final StorageLensDataExportEncryption encryption() {
        return encryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputSchemaVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketDestination)) {
            return false;
        }
        S3BucketDestination other = (S3BucketDestination) obj;
        return Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(outputSchemaVersionAsString(), other.outputSchemaVersionAsString())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(prefix(), other.prefix()) && Objects.equals(encryption(), other.encryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3BucketDestination").add("Format", formatAsString())
                .add("OutputSchemaVersion", outputSchemaVersionAsString()).add("AccountId", accountId()).add("Arn", arn())
                .add("Prefix", prefix()).add("Encryption", encryption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "OutputSchemaVersion":
            return Optional.ofNullable(clazz.cast(outputSchemaVersionAsString()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Format", FORMAT_FIELD);
        map.put("OutputSchemaVersion", OUTPUT_SCHEMA_VERSION_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Prefix", PREFIX_FIELD);
        map.put("Encryption", ENCRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3BucketDestination, T> g) {
        return obj -> g.apply((S3BucketDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3BucketDestination> {
        /**
         * <p/>
         * 
         * @param format
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(String format);

        /**
         * <p/>
         * 
         * @param format
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(Format format);

        /**
         * <p>
         * The schema version of the export file.
         * </p>
         * 
         * @param outputSchemaVersion
         *        The schema version of the export file.
         * @see OutputSchemaVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputSchemaVersion
         */
        Builder outputSchemaVersion(String outputSchemaVersion);

        /**
         * <p>
         * The schema version of the export file.
         * </p>
         * 
         * @param outputSchemaVersion
         *        The schema version of the export file.
         * @see OutputSchemaVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputSchemaVersion
         */
        Builder outputSchemaVersion(OutputSchemaVersion outputSchemaVersion);

        /**
         * <p>
         * The account ID of the owner of the S3 Storage Lens metrics export bucket.
         * </p>
         * 
         * @param accountId
         *        The account ID of the owner of the S3 Storage Lens metrics export bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the bucket. This property is read-only and follows the following format:
         * <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:bucket/<i>your-destination-bucket-name</i> </code>
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the bucket. This property is read-only and follows the following
         *        format:
         *        <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:bucket/<i>your-destination-bucket-name</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The prefix of the destination bucket where the metrics export will be delivered.
         * </p>
         * 
         * @param prefix
         *        The prefix of the destination bucket where the metrics export will be delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The container for the type encryption of the metrics exports in this bucket.
         * </p>
         * 
         * @param encryption
         *        The container for the type encryption of the metrics exports in this bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(StorageLensDataExportEncryption encryption);

        /**
         * <p>
         * The container for the type encryption of the metrics exports in this bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageLensDataExportEncryption.Builder}
         * avoiding the need to create one manually via {@link StorageLensDataExportEncryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageLensDataExportEncryption.Builder#build()} is called
         * immediately and its result is passed to {@link #encryption(StorageLensDataExportEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link StorageLensDataExportEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(StorageLensDataExportEncryption)
         */
        default Builder encryption(Consumer<StorageLensDataExportEncryption.Builder> encryption) {
            return encryption(StorageLensDataExportEncryption.builder().applyMutation(encryption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private String outputSchemaVersion;

        private String accountId;

        private String arn;

        private String prefix;

        private StorageLensDataExportEncryption encryption;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketDestination model) {
            format(model.format);
            outputSchemaVersion(model.outputSchemaVersion);
            accountId(model.accountId);
            arn(model.arn);
            prefix(model.prefix);
            encryption(model.encryption);
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getOutputSchemaVersion() {
            return outputSchemaVersion;
        }

        public final void setOutputSchemaVersion(String outputSchemaVersion) {
            this.outputSchemaVersion = outputSchemaVersion;
        }

        @Override
        public final Builder outputSchemaVersion(String outputSchemaVersion) {
            this.outputSchemaVersion = outputSchemaVersion;
            return this;
        }

        @Override
        public final Builder outputSchemaVersion(OutputSchemaVersion outputSchemaVersion) {
            this.outputSchemaVersion(outputSchemaVersion == null ? null : outputSchemaVersion.toString());
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final StorageLensDataExportEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(StorageLensDataExportEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(StorageLensDataExportEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        @Override
        public S3BucketDestination build() {
            return new S3BucketDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
