/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Grant implements SdkPojo, Serializable, ToCopyableBuilder<S3Grant.Builder, S3Grant> {
    private static final SdkField<S3Grantee> GRANTEE_FIELD = SdkField
            .<S3Grantee> builder(MarshallingType.SDK_POJO)
            .memberName("Grantee")
            .getter(getter(S3Grant::grantee))
            .setter(setter(Builder::grantee))
            .constructor(S3Grantee::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grantee")
                    .unmarshallLocationName("Grantee").build()).build();

    private static final SdkField<String> PERMISSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Permission")
            .getter(getter(S3Grant::permissionAsString))
            .setter(setter(Builder::permission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permission")
                    .unmarshallLocationName("Permission").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANTEE_FIELD,
            PERMISSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3Grantee grantee;

    private final String permission;

    private S3Grant(BuilderImpl builder) {
        this.grantee = builder.grantee;
        this.permission = builder.permission;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final S3Grantee grantee() {
        return grantee;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link S3Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionAsString}.
     * </p>
     * 
     * @return
     * @see S3Permission
     */
    public final S3Permission permission() {
        return S3Permission.fromValue(permission);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link S3Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionAsString}.
     * </p>
     * 
     * @return
     * @see S3Permission
     */
    public final String permissionAsString() {
        return permission;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(grantee());
        hashCode = 31 * hashCode + Objects.hashCode(permissionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Grant)) {
            return false;
        }
        S3Grant other = (S3Grant) obj;
        return Objects.equals(grantee(), other.grantee()) && Objects.equals(permissionAsString(), other.permissionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Grant").add("Grantee", grantee()).add("Permission", permissionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Grantee":
            return Optional.ofNullable(clazz.cast(grantee()));
        case "Permission":
            return Optional.ofNullable(clazz.cast(permissionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Grantee", GRANTEE_FIELD);
        map.put("Permission", PERMISSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Grant, T> g) {
        return obj -> g.apply((S3Grant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Grant> {
        /**
         * <p/>
         * 
         * @param grantee
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantee(S3Grantee grantee);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link S3Grantee.Builder} avoiding the need to
         * create one manually via {@link S3Grantee#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Grantee.Builder#build()} is called immediately and its result
         * is passed to {@link #grantee(S3Grantee)}.
         * 
         * @param grantee
         *        a consumer that will call methods on {@link S3Grantee.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grantee(S3Grantee)
         */
        default Builder grantee(Consumer<S3Grantee.Builder> grantee) {
            return grantee(S3Grantee.builder().applyMutation(grantee).build());
        }

        /**
         * <p/>
         * 
         * @param permission
         * @see S3Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3Permission
         */
        Builder permission(String permission);

        /**
         * <p/>
         * 
         * @param permission
         * @see S3Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3Permission
         */
        Builder permission(S3Permission permission);
    }

    static final class BuilderImpl implements Builder {
        private S3Grantee grantee;

        private String permission;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Grant model) {
            grantee(model.grantee);
            permission(model.permission);
        }

        public final S3Grantee.Builder getGrantee() {
            return grantee != null ? grantee.toBuilder() : null;
        }

        public final void setGrantee(S3Grantee.BuilderImpl grantee) {
            this.grantee = grantee != null ? grantee.build() : null;
        }

        @Override
        public final Builder grantee(S3Grantee grantee) {
            this.grantee = grantee;
            return this;
        }

        public final String getPermission() {
            return permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(S3Permission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        @Override
        public S3Grant build() {
            return new S3Grant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
