/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom grouping of objects that include filters for prefixes, suffixes, object tags, object size, or object age.
 * You can create an S3 Storage Lens group that includes a single filter or multiple filter conditions. To specify
 * multiple filter conditions, you use <code>AND</code> or <code>OR</code> logical operators.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageLensGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<StorageLensGroup.Builder, StorageLensGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(StorageLensGroup::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<StorageLensGroupFilter> FILTER_FIELD = SdkField
            .<StorageLensGroupFilter> builder(MarshallingType.SDK_POJO)
            .memberName("Filter")
            .getter(getter(StorageLensGroup::filter))
            .setter(setter(Builder::filter))
            .constructor(StorageLensGroupFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build()).build();

    private static final SdkField<String> STORAGE_LENS_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StorageLensGroupArn")
            .getter(getter(StorageLensGroup::storageLensGroupArn))
            .setter(setter(Builder::storageLensGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensGroupArn")
                    .unmarshallLocationName("StorageLensGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FILTER_FIELD,
            STORAGE_LENS_GROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final StorageLensGroupFilter filter;

    private final String storageLensGroupArn;

    private StorageLensGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.filter = builder.filter;
        this.storageLensGroupArn = builder.storageLensGroupArn;
    }

    /**
     * <p>
     * Contains the name of the Storage Lens group.
     * </p>
     * 
     * @return Contains the name of the Storage Lens group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Sets the criteria for the Storage Lens group data that is displayed. For multiple filter conditions, the
     * <code>AND</code> or <code>OR</code> logical operator is used.
     * </p>
     * 
     * @return Sets the criteria for the Storage Lens group data that is displayed. For multiple filter conditions, the
     *         <code>AND</code> or <code>OR</code> logical operator is used.
     */
    public final StorageLensGroupFilter filter() {
        return filter;
    }

    /**
     * <p>
     * Contains the Amazon Resource Name (ARN) of the Storage Lens group. This property is read-only.
     * </p>
     * 
     * @return Contains the Amazon Resource Name (ARN) of the Storage Lens group. This property is read-only.
     */
    public final String storageLensGroupArn() {
        return storageLensGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(storageLensGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageLensGroup)) {
            return false;
        }
        StorageLensGroup other = (StorageLensGroup) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(filter(), other.filter())
                && Objects.equals(storageLensGroupArn(), other.storageLensGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageLensGroup").add("Name", name()).add("Filter", filter())
                .add("StorageLensGroupArn", storageLensGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "StorageLensGroupArn":
            return Optional.ofNullable(clazz.cast(storageLensGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("StorageLensGroupArn", STORAGE_LENS_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StorageLensGroup, T> g) {
        return obj -> g.apply((StorageLensGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageLensGroup> {
        /**
         * <p>
         * Contains the name of the Storage Lens group.
         * </p>
         * 
         * @param name
         *        Contains the name of the Storage Lens group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Sets the criteria for the Storage Lens group data that is displayed. For multiple filter conditions, the
         * <code>AND</code> or <code>OR</code> logical operator is used.
         * </p>
         * 
         * @param filter
         *        Sets the criteria for the Storage Lens group data that is displayed. For multiple filter conditions,
         *        the <code>AND</code> or <code>OR</code> logical operator is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(StorageLensGroupFilter filter);

        /**
         * <p>
         * Sets the criteria for the Storage Lens group data that is displayed. For multiple filter conditions, the
         * <code>AND</code> or <code>OR</code> logical operator is used.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageLensGroupFilter.Builder} avoiding
         * the need to create one manually via {@link StorageLensGroupFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageLensGroupFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #filter(StorageLensGroupFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link StorageLensGroupFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(StorageLensGroupFilter)
         */
        default Builder filter(Consumer<StorageLensGroupFilter.Builder> filter) {
            return filter(StorageLensGroupFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * Contains the Amazon Resource Name (ARN) of the Storage Lens group. This property is read-only.
         * </p>
         * 
         * @param storageLensGroupArn
         *        Contains the Amazon Resource Name (ARN) of the Storage Lens group. This property is read-only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLensGroupArn(String storageLensGroupArn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private StorageLensGroupFilter filter;

        private String storageLensGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageLensGroup model) {
            name(model.name);
            filter(model.filter);
            storageLensGroupArn(model.storageLensGroupArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StorageLensGroupFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(StorageLensGroupFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(StorageLensGroupFilter filter) {
            this.filter = filter;
            return this;
        }

        public final String getStorageLensGroupArn() {
            return storageLensGroupArn;
        }

        public final void setStorageLensGroupArn(String storageLensGroupArn) {
            this.storageLensGroupArn = storageLensGroupArn;
        }

        @Override
        public final Builder storageLensGroupArn(String storageLensGroupArn) {
            this.storageLensGroupArn = storageLensGroupArn;
            return this;
        }

        @Override
        public StorageLensGroup build() {
            return new StorageLensGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
