/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.GeneratedManifestFormat;
import software.amazon.awssdk.services.s3control.model.JobManifestLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3GeneratedManifestDescriptor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3GeneratedManifestDescriptor> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(S3GeneratedManifestDescriptor.getter(S3GeneratedManifestDescriptor::formatAsString)).setter(S3GeneratedManifestDescriptor.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").unmarshallLocationName("Format").build()}).build();
    private static final SdkField<JobManifestLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Location").getter(S3GeneratedManifestDescriptor.getter(S3GeneratedManifestDescriptor::location)).setter(S3GeneratedManifestDescriptor.setter(Builder::location)).constructor(JobManifestLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").unmarshallLocationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3GeneratedManifestDescriptor.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String format;
    private final JobManifestLocation location;

    private S3GeneratedManifestDescriptor(BuilderImpl builder) {
        this.format = builder.format;
        this.location = builder.location;
    }

    public final GeneratedManifestFormat format() {
        return GeneratedManifestFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final JobManifestLocation location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3GeneratedManifestDescriptor)) {
            return false;
        }
        S3GeneratedManifestDescriptor other = (S3GeneratedManifestDescriptor)obj;
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"S3GeneratedManifestDescriptor").add("Format", (Object)this.formatAsString()).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Format", FORMAT_FIELD);
        map.put("Location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3GeneratedManifestDescriptor, T> g) {
        return obj -> g.apply((S3GeneratedManifestDescriptor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private JobManifestLocation location;

        private BuilderImpl() {
        }

        private BuilderImpl(S3GeneratedManifestDescriptor model) {
            this.format(model.format);
            this.location(model.location);
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(GeneratedManifestFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final JobManifestLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(JobManifestLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(JobManifestLocation location) {
            this.location = location;
            return this;
        }

        public S3GeneratedManifestDescriptor build() {
            return new S3GeneratedManifestDescriptor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3GeneratedManifestDescriptor> {
        public Builder format(String var1);

        public Builder format(GeneratedManifestFormat var1);

        public Builder location(JobManifestLocation var1);

        default public Builder location(Consumer<JobManifestLocation.Builder> location) {
            return this.location((JobManifestLocation)((JobManifestLocation.Builder)JobManifestLocation.builder().applyMutation(location)).build());
        }
    }
}

