/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointRoute;
import software.amazon.awssdk.services.s3control.model.RouteListCopier;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubmitMultiRegionAccessPointRoutesRequest
extends S3ControlRequest
implements ToCopyableBuilder<Builder, SubmitMultiRegionAccessPointRoutesRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(SubmitMultiRegionAccessPointRoutesRequest.getter(SubmitMultiRegionAccessPointRoutesRequest::accountId)).setter(SubmitMultiRegionAccessPointRoutesRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id").unmarshallLocationName("x-amz-account-id").build()}).build();
    private static final SdkField<String> MRAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mrap").getter(SubmitMultiRegionAccessPointRoutesRequest.getter(SubmitMultiRegionAccessPointRoutesRequest::mrap)).setter(SubmitMultiRegionAccessPointRoutesRequest.setter(Builder::mrap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("mrap").unmarshallLocationName("mrap").build()}).build();
    private static final SdkField<List<MultiRegionAccessPointRoute>> ROUTE_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouteUpdates").getter(SubmitMultiRegionAccessPointRoutesRequest.getter(SubmitMultiRegionAccessPointRoutesRequest::routeUpdates)).setter(SubmitMultiRegionAccessPointRoutesRequest.setter(Builder::routeUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteUpdates").unmarshallLocationName("RouteUpdates").build(), ListTrait.builder().memberLocationName("Route").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiRegionAccessPointRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Route").unmarshallLocationName("Route").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, MRAP_FIELD, ROUTE_UPDATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubmitMultiRegionAccessPointRoutesRequest.memberNameToFieldInitializer();
    private final String accountId;
    private final String mrap;
    private final List<MultiRegionAccessPointRoute> routeUpdates;

    private SubmitMultiRegionAccessPointRoutesRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.mrap = builder.mrap;
        this.routeUpdates = builder.routeUpdates;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String mrap() {
        return this.mrap;
    }

    public final boolean hasRouteUpdates() {
        return this.routeUpdates != null && !(this.routeUpdates instanceof SdkAutoConstructList);
    }

    public final List<MultiRegionAccessPointRoute> routeUpdates() {
        return this.routeUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mrap());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteUpdates() ? this.routeUpdates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitMultiRegionAccessPointRoutesRequest)) {
            return false;
        }
        SubmitMultiRegionAccessPointRoutesRequest other = (SubmitMultiRegionAccessPointRoutesRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.mrap(), other.mrap()) && this.hasRouteUpdates() == other.hasRouteUpdates() && Objects.equals(this.routeUpdates(), other.routeUpdates());
    }

    public final String toString() {
        return ToString.builder((String)"SubmitMultiRegionAccessPointRoutesRequest").add("AccountId", (Object)this.accountId()).add("Mrap", (Object)this.mrap()).add("RouteUpdates", this.hasRouteUpdates() ? this.routeUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Mrap": {
                return Optional.ofNullable(clazz.cast(this.mrap()));
            }
            case "RouteUpdates": {
                return Optional.ofNullable(clazz.cast(this.routeUpdates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x-amz-account-id", ACCOUNT_ID_FIELD);
        map.put("mrap", MRAP_FIELD);
        map.put("RouteUpdates", ROUTE_UPDATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubmitMultiRegionAccessPointRoutesRequest, T> g) {
        return obj -> g.apply((SubmitMultiRegionAccessPointRoutesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String mrap;
        private List<MultiRegionAccessPointRoute> routeUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitMultiRegionAccessPointRoutesRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.mrap(model.mrap);
            this.routeUpdates(model.routeUpdates);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getMrap() {
            return this.mrap;
        }

        public final void setMrap(String mrap) {
            this.mrap = mrap;
        }

        @Override
        public final Builder mrap(String mrap) {
            this.mrap = mrap;
            return this;
        }

        public final List<MultiRegionAccessPointRoute.Builder> getRouteUpdates() {
            List<MultiRegionAccessPointRoute.Builder> result = RouteListCopier.copyToBuilder(this.routeUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteUpdates(Collection<MultiRegionAccessPointRoute.BuilderImpl> routeUpdates) {
            this.routeUpdates = RouteListCopier.copyFromBuilder(routeUpdates);
        }

        @Override
        public final Builder routeUpdates(Collection<MultiRegionAccessPointRoute> routeUpdates) {
            this.routeUpdates = RouteListCopier.copy(routeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeUpdates(MultiRegionAccessPointRoute ... routeUpdates) {
            this.routeUpdates(Arrays.asList(routeUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeUpdates(Consumer<MultiRegionAccessPointRoute.Builder> ... routeUpdates) {
            this.routeUpdates(Stream.of(routeUpdates).map(c -> (MultiRegionAccessPointRoute)((MultiRegionAccessPointRoute.Builder)MultiRegionAccessPointRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitMultiRegionAccessPointRoutesRequest build() {
            return new SubmitMultiRegionAccessPointRoutesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3ControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SubmitMultiRegionAccessPointRoutesRequest> {
        public Builder accountId(String var1);

        public Builder mrap(String var1);

        public Builder routeUpdates(Collection<MultiRegionAccessPointRoute> var1);

        public Builder routeUpdates(MultiRegionAccessPointRoute ... var1);

        public Builder routeUpdates(Consumer<MultiRegionAccessPointRoute.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

