/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateAccessGrantsIdentityCenterRequest extends S3ControlRequest implements
        ToCopyableBuilder<AssociateAccessGrantsIdentityCenterRequest.Builder, AssociateAccessGrantsIdentityCenterRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(AssociateAccessGrantsIdentityCenterRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<String> IDENTITY_CENTER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdentityCenterArn")
            .getter(getter(AssociateAccessGrantsIdentityCenterRequest::identityCenterArn))
            .setter(setter(Builder::identityCenterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterArn")
                    .unmarshallLocationName("IdentityCenterArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            IDENTITY_CENTER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String identityCenterArn;

    private AssociateAccessGrantsIdentityCenterRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.identityCenterArn = builder.identityCenterArn;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the S3 Access Grants instance.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the S3 Access Grants instance.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center instance that you are associating
     * with your S3 Access Grants instance. An IAM Identity Center instance is your corporate identity directory that
     * you added to the IAM Identity Center. You can use the <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html">ListInstances</a> API
     * operation to retrieve a list of your Identity Center instances and their ARNs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center instance that you are
     *         associating with your S3 Access Grants instance. An IAM Identity Center instance is your corporate
     *         identity directory that you added to the IAM Identity Center. You can use the <a
     *         href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html"
     *         >ListInstances</a> API operation to retrieve a list of your Identity Center instances and their ARNs.
     */
    public final String identityCenterArn() {
        return identityCenterArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAccessGrantsIdentityCenterRequest)) {
            return false;
        }
        AssociateAccessGrantsIdentityCenterRequest other = (AssociateAccessGrantsIdentityCenterRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(identityCenterArn(), other.identityCenterArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateAccessGrantsIdentityCenterRequest").add("AccountId", accountId())
                .add("IdentityCenterArn", identityCenterArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "IdentityCenterArn":
            return Optional.ofNullable(clazz.cast(identityCenterArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x-amz-account-id", ACCOUNT_ID_FIELD);
        map.put("IdentityCenterArn", IDENTITY_CENTER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateAccessGrantsIdentityCenterRequest, T> g) {
        return obj -> g.apply((AssociateAccessGrantsIdentityCenterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateAccessGrantsIdentityCenterRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID of the S3 Access Grants instance.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center instance that you are
         * associating with your S3 Access Grants instance. An IAM Identity Center instance is your corporate identity
         * directory that you added to the IAM Identity Center. You can use the <a
         * href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html">ListInstances</a>
         * API operation to retrieve a list of your Identity Center instances and their ARNs.
         * </p>
         * 
         * @param identityCenterArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center instance that you are
         *        associating with your S3 Access Grants instance. An IAM Identity Center instance is your corporate
         *        identity directory that you added to the IAM Identity Center. You can use the <a
         *        href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html"
         *        >ListInstances</a> API operation to retrieve a list of your Identity Center instances and their ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterArn(String identityCenterArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private String identityCenterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAccessGrantsIdentityCenterRequest model) {
            super(model);
            accountId(model.accountId);
            identityCenterArn(model.identityCenterArn);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getIdentityCenterArn() {
            return identityCenterArn;
        }

        public final void setIdentityCenterArn(String identityCenterArn) {
            this.identityCenterArn = identityCenterArn;
        }

        @Override
        public final Builder identityCenterArn(String identityCenterArn) {
            this.identityCenterArn = identityCenterArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateAccessGrantsIdentityCenterRequest build() {
            return new AssociateAccessGrantsIdentityCenterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
