/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessPointResponse extends S3ControlResponse implements
        ToCopyableBuilder<CreateAccessPointResponse.Builder, CreateAccessPointResponse> {
    private static final SdkField<String> ACCESS_POINT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessPointArn")
            .getter(getter(CreateAccessPointResponse::accessPointArn))
            .setter(setter(Builder::accessPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointArn")
                    .unmarshallLocationName("AccessPointArn").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Alias")
            .getter(getter(CreateAccessPointResponse::alias))
            .setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias")
                    .unmarshallLocationName("Alias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_ARN_FIELD,
            ALIAS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accessPointArn;

    private final String alias;

    private CreateAccessPointResponse(BuilderImpl builder) {
        super(builder);
        this.accessPointArn = builder.accessPointArn;
        this.alias = builder.alias;
    }

    /**
     * <p>
     * The ARN of the access point.
     * </p>
     * <note>
     * <p>
     * This is only supported by Amazon S3 on Outposts.
     * </p>
     * </note>
     * 
     * @return The ARN of the access point.</p> <note>
     *         <p>
     *         This is only supported by Amazon S3 on Outposts.
     *         </p>
     */
    public final String accessPointArn() {
        return accessPointArn;
    }

    /**
     * <p>
     * The name or alias of the access point.
     * </p>
     * 
     * @return The name or alias of the access point.
     */
    public final String alias() {
        return alias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessPointResponse)) {
            return false;
        }
        CreateAccessPointResponse other = (CreateAccessPointResponse) obj;
        return Objects.equals(accessPointArn(), other.accessPointArn()) && Objects.equals(alias(), other.alias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessPointResponse").add("AccessPointArn", accessPointArn()).add("Alias", alias())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessPointArn":
            return Optional.ofNullable(clazz.cast(accessPointArn()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccessPointArn", ACCESS_POINT_ARN_FIELD);
        map.put("Alias", ALIAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessPointResponse, T> g) {
        return obj -> g.apply((CreateAccessPointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAccessPointResponse> {
        /**
         * <p>
         * The ARN of the access point.
         * </p>
         * <note>
         * <p>
         * This is only supported by Amazon S3 on Outposts.
         * </p>
         * </note>
         * 
         * @param accessPointArn
         *        The ARN of the access point.</p> <note>
         *        <p>
         *        This is only supported by Amazon S3 on Outposts.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointArn(String accessPointArn);

        /**
         * <p>
         * The name or alias of the access point.
         * </p>
         * 
         * @param alias
         *        The name or alias of the access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private String accessPointArn;

        private String alias;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessPointResponse model) {
            super(model);
            accessPointArn(model.accessPointArn);
            alias(model.alias);
        }

        public final String getAccessPointArn() {
            return accessPointArn;
        }

        public final void setAccessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
        }

        @Override
        public final Builder accessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @Override
        public CreateAccessPointResponse build() {
            return new CreateAccessPointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
