/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The encryption configuration to use when storing the generated manifest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeneratedManifestEncryption implements SdkPojo, Serializable,
        ToCopyableBuilder<GeneratedManifestEncryption.Builder, GeneratedManifestEncryption> {
    private static final SdkField<SSES3Encryption> SSES3_FIELD = SdkField
            .<SSES3Encryption> builder(MarshallingType.SDK_POJO)
            .memberName("SSES3")
            .getter(getter(GeneratedManifestEncryption::sses3))
            .setter(setter(Builder::sses3))
            .constructor(SSES3Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSE-S3")
                    .unmarshallLocationName("SSE-S3").build()).build();

    private static final SdkField<SSEKMSEncryption> SSEKMS_FIELD = SdkField
            .<SSEKMSEncryption> builder(MarshallingType.SDK_POJO)
            .memberName("SSEKMS")
            .getter(getter(GeneratedManifestEncryption::ssekms))
            .setter(setter(Builder::ssekms))
            .constructor(SSEKMSEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSE-KMS")
                    .unmarshallLocationName("SSE-KMS").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSES3_FIELD, SSEKMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SSES3Encryption sses3;

    private final SSEKMSEncryption ssekms;

    private GeneratedManifestEncryption(BuilderImpl builder) {
        this.sses3 = builder.sses3;
        this.ssekms = builder.ssekms;
    }

    /**
     * <p>
     * Specifies the use of SSE-S3 to encrypt generated manifest objects.
     * </p>
     * 
     * @return Specifies the use of SSE-S3 to encrypt generated manifest objects.
     */
    public final SSES3Encryption sses3() {
        return sses3;
    }

    /**
     * <p>
     * Configuration details on how SSE-KMS is used to encrypt generated manifest objects.
     * </p>
     * 
     * @return Configuration details on how SSE-KMS is used to encrypt generated manifest objects.
     */
    public final SSEKMSEncryption ssekms() {
        return ssekms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sses3());
        hashCode = 31 * hashCode + Objects.hashCode(ssekms());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratedManifestEncryption)) {
            return false;
        }
        GeneratedManifestEncryption other = (GeneratedManifestEncryption) obj;
        return Objects.equals(sses3(), other.sses3()) && Objects.equals(ssekms(), other.ssekms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeneratedManifestEncryption").add("SSES3", sses3()).add("SSEKMS", ssekms()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SSES3":
            return Optional.ofNullable(clazz.cast(sses3()));
        case "SSEKMS":
            return Optional.ofNullable(clazz.cast(ssekms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SSE-S3", SSES3_FIELD);
        map.put("SSE-KMS", SSEKMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeneratedManifestEncryption, T> g) {
        return obj -> g.apply((GeneratedManifestEncryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeneratedManifestEncryption> {
        /**
         * <p>
         * Specifies the use of SSE-S3 to encrypt generated manifest objects.
         * </p>
         * 
         * @param sses3
         *        Specifies the use of SSE-S3 to encrypt generated manifest objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sses3(SSES3Encryption sses3);

        /**
         * <p>
         * Specifies the use of SSE-S3 to encrypt generated manifest objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link SSES3Encryption.Builder} avoiding the
         * need to create one manually via {@link SSES3Encryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SSES3Encryption.Builder#build()} is called immediately and its
         * result is passed to {@link #sses3(SSES3Encryption)}.
         * 
         * @param sses3
         *        a consumer that will call methods on {@link SSES3Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sses3(SSES3Encryption)
         */
        default Builder sses3(Consumer<SSES3Encryption.Builder> sses3) {
            return sses3(SSES3Encryption.builder().applyMutation(sses3).build());
        }

        /**
         * <p>
         * Configuration details on how SSE-KMS is used to encrypt generated manifest objects.
         * </p>
         * 
         * @param ssekms
         *        Configuration details on how SSE-KMS is used to encrypt generated manifest objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssekms(SSEKMSEncryption ssekms);

        /**
         * <p>
         * Configuration details on how SSE-KMS is used to encrypt generated manifest objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link SSEKMSEncryption.Builder} avoiding the
         * need to create one manually via {@link SSEKMSEncryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SSEKMSEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #ssekms(SSEKMSEncryption)}.
         * 
         * @param ssekms
         *        a consumer that will call methods on {@link SSEKMSEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssekms(SSEKMSEncryption)
         */
        default Builder ssekms(Consumer<SSEKMSEncryption.Builder> ssekms) {
            return ssekms(SSEKMSEncryption.builder().applyMutation(ssekms).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SSES3Encryption sses3;

        private SSEKMSEncryption ssekms;

        private BuilderImpl() {
        }

        private BuilderImpl(GeneratedManifestEncryption model) {
            sses3(model.sses3);
            ssekms(model.ssekms);
        }

        public final SSES3Encryption.Builder getSses3() {
            return sses3 != null ? sses3.toBuilder() : null;
        }

        public final void setSses3(SSES3Encryption.BuilderImpl sses3) {
            this.sses3 = sses3 != null ? sses3.build() : null;
        }

        @Override
        public final Builder sses3(SSES3Encryption sses3) {
            this.sses3 = sses3;
            return this;
        }

        public final SSEKMSEncryption.Builder getSsekms() {
            return ssekms != null ? ssekms.toBuilder() : null;
        }

        public final void setSsekms(SSEKMSEncryption.BuilderImpl ssekms) {
            this.ssekms = ssekms != null ? ssekms.build() : null;
        }

        @Override
        public final Builder ssekms(SSEKMSEncryption ssekms) {
            this.ssekms = ssekms;
            return this;
        }

        @Override
        public GeneratedManifestEncryption build() {
            return new GeneratedManifestEncryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
