/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMultiRegionAccessPointPolicyStatusResponse extends S3ControlResponse implements
        ToCopyableBuilder<GetMultiRegionAccessPointPolicyStatusResponse.Builder, GetMultiRegionAccessPointPolicyStatusResponse> {
    private static final SdkField<PolicyStatus> ESTABLISHED_FIELD = SdkField
            .<PolicyStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Established")
            .getter(getter(GetMultiRegionAccessPointPolicyStatusResponse::established))
            .setter(setter(Builder::established))
            .constructor(PolicyStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Established")
                    .unmarshallLocationName("Established").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ESTABLISHED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final PolicyStatus established;

    private GetMultiRegionAccessPointPolicyStatusResponse(BuilderImpl builder) {
        super(builder);
        this.established = builder.established;
    }

    /**
     * Returns the value of the Established property for this object.
     * 
     * @return The value of the Established property for this object.
     */
    public final PolicyStatus established() {
        return established;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(established());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMultiRegionAccessPointPolicyStatusResponse)) {
            return false;
        }
        GetMultiRegionAccessPointPolicyStatusResponse other = (GetMultiRegionAccessPointPolicyStatusResponse) obj;
        return Objects.equals(established(), other.established());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMultiRegionAccessPointPolicyStatusResponse").add("Established", established()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Established":
            return Optional.ofNullable(clazz.cast(established()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Established", ESTABLISHED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMultiRegionAccessPointPolicyStatusResponse, T> g) {
        return obj -> g.apply((GetMultiRegionAccessPointPolicyStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMultiRegionAccessPointPolicyStatusResponse> {
        /**
         * Sets the value of the Established property for this object.
         *
         * @param established
         *        The new value for the Established property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder established(PolicyStatus established);

        /**
         * Sets the value of the Established property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PolicyStatus.Builder} avoiding the need
         * to create one manually via {@link PolicyStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PolicyStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #established(PolicyStatus)}.
         * 
         * @param established
         *        a consumer that will call methods on {@link PolicyStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #established(PolicyStatus)
         */
        default Builder established(Consumer<PolicyStatus.Builder> established) {
            return established(PolicyStatus.builder().applyMutation(established).build());
        }
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private PolicyStatus established;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMultiRegionAccessPointPolicyStatusResponse model) {
            super(model);
            established(model.established);
        }

        public final PolicyStatus.Builder getEstablished() {
            return established != null ? established.toBuilder() : null;
        }

        public final void setEstablished(PolicyStatus.BuilderImpl established) {
            this.established = established != null ? established.build() : null;
        }

        @Override
        public final Builder established(PolicyStatus established) {
            this.established = established;
            return this;
        }

        @Override
        public GetMultiRegionAccessPointPolicyStatusResponse build() {
            return new GetMultiRegionAccessPointPolicyStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
