/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the information required to locate a manifest object. Manifests can't be imported from directory buckets.
 * For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">Directory buckets</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobManifestLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<JobManifestLocation.Builder, JobManifestLocation> {
    private static final SdkField<String> OBJECT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ObjectArn")
            .getter(getter(JobManifestLocation::objectArn))
            .setter(setter(Builder::objectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectArn")
                    .unmarshallLocationName("ObjectArn").build()).build();

    private static final SdkField<String> OBJECT_VERSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ObjectVersionId")
            .getter(getter(JobManifestLocation::objectVersionId))
            .setter(setter(Builder::objectVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectVersionId")
                    .unmarshallLocationName("ObjectVersionId").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(JobManifestLocation::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag")
                    .unmarshallLocationName("ETag").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_ARN_FIELD,
            OBJECT_VERSION_ID_FIELD, E_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String objectArn;

    private final String objectVersionId;

    private final String eTag;

    private JobManifestLocation(BuilderImpl builder) {
        this.objectArn = builder.objectArn;
        this.objectVersionId = builder.objectVersionId;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for a manifest object.
     * </p>
     * <important>
     * <p>
     * When you're using XML requests, you must replace special characters (such as carriage returns) in object keys
     * with their equivalent XML entity codes. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">
     * XML-related object key constraints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </important>
     * 
     * @return The Amazon Resource Name (ARN) for a manifest object.</p> <important>
     *         <p>
     *         When you're using XML requests, you must replace special characters (such as carriage returns) in object
     *         keys with their equivalent XML entity codes. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"
     *         > XML-related object key constraints</a> in the <i>Amazon S3 User Guide</i>.
     *         </p>
     */
    public final String objectArn() {
        return objectArn;
    }

    /**
     * <p>
     * The optional version ID to identify a specific version of the manifest object.
     * </p>
     * 
     * @return The optional version ID to identify a specific version of the manifest object.
     */
    public final String objectVersionId() {
        return objectVersionId;
    }

    /**
     * <p>
     * The ETag for the specified manifest object.
     * </p>
     * 
     * @return The ETag for the specified manifest object.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectArn());
        hashCode = 31 * hashCode + Objects.hashCode(objectVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobManifestLocation)) {
            return false;
        }
        JobManifestLocation other = (JobManifestLocation) obj;
        return Objects.equals(objectArn(), other.objectArn()) && Objects.equals(objectVersionId(), other.objectVersionId())
                && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobManifestLocation").add("ObjectArn", objectArn()).add("ObjectVersionId", objectVersionId())
                .add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectArn":
            return Optional.ofNullable(clazz.cast(objectArn()));
        case "ObjectVersionId":
            return Optional.ofNullable(clazz.cast(objectVersionId()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ObjectArn", OBJECT_ARN_FIELD);
        map.put("ObjectVersionId", OBJECT_VERSION_ID_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobManifestLocation, T> g) {
        return obj -> g.apply((JobManifestLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobManifestLocation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for a manifest object.
         * </p>
         * <important>
         * <p>
         * When you're using XML requests, you must replace special characters (such as carriage returns) in object keys
         * with their equivalent XML entity codes. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">
         * XML-related object key constraints</a> in the <i>Amazon S3 User Guide</i>.
         * </p>
         * </important>
         * 
         * @param objectArn
         *        The Amazon Resource Name (ARN) for a manifest object.</p> <important>
         *        <p>
         *        When you're using XML requests, you must replace special characters (such as carriage returns) in
         *        object keys with their equivalent XML entity codes. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"
         *        > XML-related object key constraints</a> in the <i>Amazon S3 User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectArn(String objectArn);

        /**
         * <p>
         * The optional version ID to identify a specific version of the manifest object.
         * </p>
         * 
         * @param objectVersionId
         *        The optional version ID to identify a specific version of the manifest object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectVersionId(String objectVersionId);

        /**
         * <p>
         * The ETag for the specified manifest object.
         * </p>
         * 
         * @param eTag
         *        The ETag for the specified manifest object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl implements Builder {
        private String objectArn;

        private String objectVersionId;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(JobManifestLocation model) {
            objectArn(model.objectArn);
            objectVersionId(model.objectVersionId);
            eTag(model.eTag);
        }

        public final String getObjectArn() {
            return objectArn;
        }

        public final void setObjectArn(String objectArn) {
            this.objectArn = objectArn;
        }

        @Override
        public final Builder objectArn(String objectArn) {
            this.objectArn = objectArn;
            return this;
        }

        public final String getObjectVersionId() {
            return objectVersionId;
        }

        public final void setObjectVersionId(String objectVersionId) {
            this.objectVersionId = objectVersionId;
        }

        @Override
        public final Builder objectVersionId(String objectVersionId) {
            this.objectVersionId = objectVersionId;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public JobManifestLocation build() {
            return new JobManifestLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
