/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the S3 Access Grants instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessGrantsInstanceEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ListAccessGrantsInstanceEntry.Builder, ListAccessGrantsInstanceEntry> {
    private static final SdkField<String> ACCESS_GRANTS_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessGrantsInstanceId")
            .getter(getter(ListAccessGrantsInstanceEntry::accessGrantsInstanceId))
            .setter(setter(Builder::accessGrantsInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsInstanceId")
                    .unmarshallLocationName("AccessGrantsInstanceId").build()).build();

    private static final SdkField<String> ACCESS_GRANTS_INSTANCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessGrantsInstanceArn")
            .getter(getter(ListAccessGrantsInstanceEntry::accessGrantsInstanceArn))
            .setter(setter(Builder::accessGrantsInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsInstanceArn")
                    .unmarshallLocationName("AccessGrantsInstanceArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(ListAccessGrantsInstanceEntry::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt")
                    .unmarshallLocationName("CreatedAt").build()).build();

    private static final SdkField<String> IDENTITY_CENTER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdentityCenterArn")
            .getter(getter(ListAccessGrantsInstanceEntry::identityCenterArn))
            .setter(setter(Builder::identityCenterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterArn")
                    .unmarshallLocationName("IdentityCenterArn").build()).build();

    private static final SdkField<String> IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdentityCenterInstanceArn")
            .getter(getter(ListAccessGrantsInstanceEntry::identityCenterInstanceArn))
            .setter(setter(Builder::identityCenterInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterInstanceArn")
                    .unmarshallLocationName("IdentityCenterInstanceArn").build()).build();

    private static final SdkField<String> IDENTITY_CENTER_APPLICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdentityCenterApplicationArn")
            .getter(getter(ListAccessGrantsInstanceEntry::identityCenterApplicationArn))
            .setter(setter(Builder::identityCenterApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterApplicationArn")
                    .unmarshallLocationName("IdentityCenterApplicationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACCESS_GRANTS_INSTANCE_ID_FIELD, ACCESS_GRANTS_INSTANCE_ARN_FIELD, CREATED_AT_FIELD, IDENTITY_CENTER_ARN_FIELD,
            IDENTITY_CENTER_INSTANCE_ARN_FIELD, IDENTITY_CENTER_APPLICATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessGrantsInstanceId;

    private final String accessGrantsInstanceArn;

    private final Instant createdAt;

    private final String identityCenterArn;

    private final String identityCenterInstanceArn;

    private final String identityCenterApplicationArn;

    private ListAccessGrantsInstanceEntry(BuilderImpl builder) {
        this.accessGrantsInstanceId = builder.accessGrantsInstanceId;
        this.accessGrantsInstanceArn = builder.accessGrantsInstanceArn;
        this.createdAt = builder.createdAt;
        this.identityCenterArn = builder.identityCenterArn;
        this.identityCenterInstanceArn = builder.identityCenterInstanceArn;
        this.identityCenterApplicationArn = builder.identityCenterApplicationArn;
    }

    /**
     * <p>
     * The ID of the S3 Access Grants instance. The ID is <code>default</code>. You can have one S3 Access Grants
     * instance per Region per account.
     * </p>
     * 
     * @return The ID of the S3 Access Grants instance. The ID is <code>default</code>. You can have one S3 Access
     *         Grants instance per Region per account.
     */
    public final String accessGrantsInstanceId() {
        return accessGrantsInstanceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the S3 Access Grants instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the S3 Access Grants instance.
     */
    public final String accessGrantsInstanceArn() {
        return accessGrantsInstanceArn;
    }

    /**
     * <p>
     * The date and time when you created the S3 Access Grants instance.
     * </p>
     * 
     * @return The date and time when you created the S3 Access Grants instance.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * If you associated your S3 Access Grants instance with an Amazon Web Services IAM Identity Center instance, this
     * field returns the Amazon Resource Name (ARN) of the IAM Identity Center instance application; a subresource of
     * the original Identity Center instance. S3 Access Grants creates this Identity Center application for the specific
     * S3 Access Grants instance.
     * </p>
     * 
     * @return If you associated your S3 Access Grants instance with an Amazon Web Services IAM Identity Center
     *         instance, this field returns the Amazon Resource Name (ARN) of the IAM Identity Center instance
     *         application; a subresource of the original Identity Center instance. S3 Access Grants creates this
     *         Identity Center application for the specific S3 Access Grants instance.
     * @deprecated IdentityCenterArn has been deprecated. Use IdentityCenterInstanceArn or IdentityCenterApplicationArn.
     */
    @Deprecated
    public final String identityCenterArn() {
        return identityCenterArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center instance that you are associating
     * with your S3 Access Grants instance. An IAM Identity Center instance is your corporate identity directory that
     * you added to the IAM Identity Center. You can use the <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html">ListInstances</a> API
     * operation to retrieve a list of your Identity Center instances and their ARNs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center instance that you are
     *         associating with your S3 Access Grants instance. An IAM Identity Center instance is your corporate
     *         identity directory that you added to the IAM Identity Center. You can use the <a
     *         href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html"
     *         >ListInstances</a> API operation to retrieve a list of your Identity Center instances and their ARNs.
     */
    public final String identityCenterInstanceArn() {
        return identityCenterInstanceArn;
    }

    /**
     * <p>
     * If you associated your S3 Access Grants instance with an Amazon Web Services IAM Identity Center instance, this
     * field returns the Amazon Resource Name (ARN) of the IAM Identity Center instance application; a subresource of
     * the original Identity Center instance. S3 Access Grants creates this Identity Center application for the specific
     * S3 Access Grants instance.
     * </p>
     * 
     * @return If you associated your S3 Access Grants instance with an Amazon Web Services IAM Identity Center
     *         instance, this field returns the Amazon Resource Name (ARN) of the IAM Identity Center instance
     *         application; a subresource of the original Identity Center instance. S3 Access Grants creates this
     *         Identity Center application for the specific S3 Access Grants instance.
     */
    public final String identityCenterApplicationArn() {
        return identityCenterApplicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessGrantsInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(accessGrantsInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterArn());
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterApplicationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessGrantsInstanceEntry)) {
            return false;
        }
        ListAccessGrantsInstanceEntry other = (ListAccessGrantsInstanceEntry) obj;
        return Objects.equals(accessGrantsInstanceId(), other.accessGrantsInstanceId())
                && Objects.equals(accessGrantsInstanceArn(), other.accessGrantsInstanceArn())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(identityCenterArn(), other.identityCenterArn())
                && Objects.equals(identityCenterInstanceArn(), other.identityCenterInstanceArn())
                && Objects.equals(identityCenterApplicationArn(), other.identityCenterApplicationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessGrantsInstanceEntry").add("AccessGrantsInstanceId", accessGrantsInstanceId())
                .add("AccessGrantsInstanceArn", accessGrantsInstanceArn()).add("CreatedAt", createdAt())
                .add("IdentityCenterArn", identityCenterArn()).add("IdentityCenterInstanceArn", identityCenterInstanceArn())
                .add("IdentityCenterApplicationArn", identityCenterApplicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessGrantsInstanceId":
            return Optional.ofNullable(clazz.cast(accessGrantsInstanceId()));
        case "AccessGrantsInstanceArn":
            return Optional.ofNullable(clazz.cast(accessGrantsInstanceArn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "IdentityCenterArn":
            return Optional.ofNullable(clazz.cast(identityCenterArn()));
        case "IdentityCenterInstanceArn":
            return Optional.ofNullable(clazz.cast(identityCenterInstanceArn()));
        case "IdentityCenterApplicationArn":
            return Optional.ofNullable(clazz.cast(identityCenterApplicationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccessGrantsInstanceId", ACCESS_GRANTS_INSTANCE_ID_FIELD);
        map.put("AccessGrantsInstanceArn", ACCESS_GRANTS_INSTANCE_ARN_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("IdentityCenterArn", IDENTITY_CENTER_ARN_FIELD);
        map.put("IdentityCenterInstanceArn", IDENTITY_CENTER_INSTANCE_ARN_FIELD);
        map.put("IdentityCenterApplicationArn", IDENTITY_CENTER_APPLICATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccessGrantsInstanceEntry, T> g) {
        return obj -> g.apply((ListAccessGrantsInstanceEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListAccessGrantsInstanceEntry> {
        /**
         * <p>
         * The ID of the S3 Access Grants instance. The ID is <code>default</code>. You can have one S3 Access Grants
         * instance per Region per account.
         * </p>
         * 
         * @param accessGrantsInstanceId
         *        The ID of the S3 Access Grants instance. The ID is <code>default</code>. You can have one S3 Access
         *        Grants instance per Region per account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsInstanceId(String accessGrantsInstanceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the S3 Access Grants instance.
         * </p>
         * 
         * @param accessGrantsInstanceArn
         *        The Amazon Resource Name (ARN) of the S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsInstanceArn(String accessGrantsInstanceArn);

        /**
         * <p>
         * The date and time when you created the S3 Access Grants instance.
         * </p>
         * 
         * @param createdAt
         *        The date and time when you created the S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * If you associated your S3 Access Grants instance with an Amazon Web Services IAM Identity Center instance,
         * this field returns the Amazon Resource Name (ARN) of the IAM Identity Center instance application; a
         * subresource of the original Identity Center instance. S3 Access Grants creates this Identity Center
         * application for the specific S3 Access Grants instance.
         * </p>
         * 
         * @param identityCenterArn
         *        If you associated your S3 Access Grants instance with an Amazon Web Services IAM Identity Center
         *        instance, this field returns the Amazon Resource Name (ARN) of the IAM Identity Center instance
         *        application; a subresource of the original Identity Center instance. S3 Access Grants creates this
         *        Identity Center application for the specific S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated IdentityCenterArn has been deprecated. Use IdentityCenterInstanceArn or
         *             IdentityCenterApplicationArn.
         */
        @Deprecated
        Builder identityCenterArn(String identityCenterArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center instance that you are
         * associating with your S3 Access Grants instance. An IAM Identity Center instance is your corporate identity
         * directory that you added to the IAM Identity Center. You can use the <a
         * href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html">ListInstances</a>
         * API operation to retrieve a list of your Identity Center instances and their ARNs.
         * </p>
         * 
         * @param identityCenterInstanceArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center instance that you are
         *        associating with your S3 Access Grants instance. An IAM Identity Center instance is your corporate
         *        identity directory that you added to the IAM Identity Center. You can use the <a
         *        href="https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html"
         *        >ListInstances</a> API operation to retrieve a list of your Identity Center instances and their ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterInstanceArn(String identityCenterInstanceArn);

        /**
         * <p>
         * If you associated your S3 Access Grants instance with an Amazon Web Services IAM Identity Center instance,
         * this field returns the Amazon Resource Name (ARN) of the IAM Identity Center instance application; a
         * subresource of the original Identity Center instance. S3 Access Grants creates this Identity Center
         * application for the specific S3 Access Grants instance.
         * </p>
         * 
         * @param identityCenterApplicationArn
         *        If you associated your S3 Access Grants instance with an Amazon Web Services IAM Identity Center
         *        instance, this field returns the Amazon Resource Name (ARN) of the IAM Identity Center instance
         *        application; a subresource of the original Identity Center instance. S3 Access Grants creates this
         *        Identity Center application for the specific S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterApplicationArn(String identityCenterApplicationArn);
    }

    static final class BuilderImpl implements Builder {
        private String accessGrantsInstanceId;

        private String accessGrantsInstanceArn;

        private Instant createdAt;

        private String identityCenterArn;

        private String identityCenterInstanceArn;

        private String identityCenterApplicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessGrantsInstanceEntry model) {
            accessGrantsInstanceId(model.accessGrantsInstanceId);
            accessGrantsInstanceArn(model.accessGrantsInstanceArn);
            createdAt(model.createdAt);
            identityCenterArn(model.identityCenterArn);
            identityCenterInstanceArn(model.identityCenterInstanceArn);
            identityCenterApplicationArn(model.identityCenterApplicationArn);
        }

        public final String getAccessGrantsInstanceId() {
            return accessGrantsInstanceId;
        }

        public final void setAccessGrantsInstanceId(String accessGrantsInstanceId) {
            this.accessGrantsInstanceId = accessGrantsInstanceId;
        }

        @Override
        public final Builder accessGrantsInstanceId(String accessGrantsInstanceId) {
            this.accessGrantsInstanceId = accessGrantsInstanceId;
            return this;
        }

        public final String getAccessGrantsInstanceArn() {
            return accessGrantsInstanceArn;
        }

        public final void setAccessGrantsInstanceArn(String accessGrantsInstanceArn) {
            this.accessGrantsInstanceArn = accessGrantsInstanceArn;
        }

        @Override
        public final Builder accessGrantsInstanceArn(String accessGrantsInstanceArn) {
            this.accessGrantsInstanceArn = accessGrantsInstanceArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Deprecated
        public final String getIdentityCenterArn() {
            return identityCenterArn;
        }

        @Deprecated
        public final void setIdentityCenterArn(String identityCenterArn) {
            this.identityCenterArn = identityCenterArn;
        }

        @Override
        @Deprecated
        public final Builder identityCenterArn(String identityCenterArn) {
            this.identityCenterArn = identityCenterArn;
            return this;
        }

        public final String getIdentityCenterInstanceArn() {
            return identityCenterInstanceArn;
        }

        public final void setIdentityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
        }

        @Override
        public final Builder identityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
            return this;
        }

        public final String getIdentityCenterApplicationArn() {
            return identityCenterApplicationArn;
        }

        public final void setIdentityCenterApplicationArn(String identityCenterApplicationArn) {
            this.identityCenterApplicationArn = identityCenterApplicationArn;
        }

        @Override
        public final Builder identityCenterApplicationArn(String identityCenterApplicationArn) {
            this.identityCenterApplicationArn = identityCenterApplicationArn;
            return this;
        }

        @Override
        public ListAccessGrantsInstanceEntry build() {
            return new ListAccessGrantsInstanceEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
