/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter condition that specifies the object age range of included objects in days. Only integers are supported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatchObjectAge implements SdkPojo, Serializable, ToCopyableBuilder<MatchObjectAge.Builder, MatchObjectAge> {
    private static final SdkField<Integer> DAYS_GREATER_THAN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DaysGreaterThan")
            .getter(getter(MatchObjectAge::daysGreaterThan))
            .setter(setter(Builder::daysGreaterThan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DaysGreaterThan")
                    .unmarshallLocationName("DaysGreaterThan").build()).build();

    private static final SdkField<Integer> DAYS_LESS_THAN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DaysLessThan")
            .getter(getter(MatchObjectAge::daysLessThan))
            .setter(setter(Builder::daysLessThan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DaysLessThan")
                    .unmarshallLocationName("DaysLessThan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAYS_GREATER_THAN_FIELD,
            DAYS_LESS_THAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer daysGreaterThan;

    private final Integer daysLessThan;

    private MatchObjectAge(BuilderImpl builder) {
        this.daysGreaterThan = builder.daysGreaterThan;
        this.daysLessThan = builder.daysLessThan;
    }

    /**
     * <p>
     * Specifies the maximum object age in days. Must be a positive whole number, greater than the minimum object age
     * and less than or equal to 2,147,483,647.
     * </p>
     * 
     * @return Specifies the maximum object age in days. Must be a positive whole number, greater than the minimum
     *         object age and less than or equal to 2,147,483,647.
     */
    public final Integer daysGreaterThan() {
        return daysGreaterThan;
    }

    /**
     * <p>
     * Specifies the minimum object age in days. The value must be a positive whole number, greater than 0 and less than
     * or equal to 2,147,483,647.
     * </p>
     * 
     * @return Specifies the minimum object age in days. The value must be a positive whole number, greater than 0 and
     *         less than or equal to 2,147,483,647.
     */
    public final Integer daysLessThan() {
        return daysLessThan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(daysGreaterThan());
        hashCode = 31 * hashCode + Objects.hashCode(daysLessThan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchObjectAge)) {
            return false;
        }
        MatchObjectAge other = (MatchObjectAge) obj;
        return Objects.equals(daysGreaterThan(), other.daysGreaterThan()) && Objects.equals(daysLessThan(), other.daysLessThan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatchObjectAge").add("DaysGreaterThan", daysGreaterThan()).add("DaysLessThan", daysLessThan())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DaysGreaterThan":
            return Optional.ofNullable(clazz.cast(daysGreaterThan()));
        case "DaysLessThan":
            return Optional.ofNullable(clazz.cast(daysLessThan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DaysGreaterThan", DAYS_GREATER_THAN_FIELD);
        map.put("DaysLessThan", DAYS_LESS_THAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatchObjectAge, T> g) {
        return obj -> g.apply((MatchObjectAge) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatchObjectAge> {
        /**
         * <p>
         * Specifies the maximum object age in days. Must be a positive whole number, greater than the minimum object
         * age and less than or equal to 2,147,483,647.
         * </p>
         * 
         * @param daysGreaterThan
         *        Specifies the maximum object age in days. Must be a positive whole number, greater than the minimum
         *        object age and less than or equal to 2,147,483,647.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daysGreaterThan(Integer daysGreaterThan);

        /**
         * <p>
         * Specifies the minimum object age in days. The value must be a positive whole number, greater than 0 and less
         * than or equal to 2,147,483,647.
         * </p>
         * 
         * @param daysLessThan
         *        Specifies the minimum object age in days. The value must be a positive whole number, greater than 0
         *        and less than or equal to 2,147,483,647.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daysLessThan(Integer daysLessThan);
    }

    static final class BuilderImpl implements Builder {
        private Integer daysGreaterThan;

        private Integer daysLessThan;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchObjectAge model) {
            daysGreaterThan(model.daysGreaterThan);
            daysLessThan(model.daysLessThan);
        }

        public final Integer getDaysGreaterThan() {
            return daysGreaterThan;
        }

        public final void setDaysGreaterThan(Integer daysGreaterThan) {
            this.daysGreaterThan = daysGreaterThan;
        }

        @Override
        public final Builder daysGreaterThan(Integer daysGreaterThan) {
            this.daysGreaterThan = daysGreaterThan;
            return this;
        }

        public final Integer getDaysLessThan() {
            return daysLessThan;
        }

        public final void setDaysLessThan(Integer daysLessThan) {
            this.daysLessThan = daysLessThan;
        }

        @Override
        public final Builder daysLessThan(Integer daysLessThan) {
            this.daysLessThan = daysLessThan;
            return this;
        }

        @Override
        public MatchObjectAge build() {
            return new MatchObjectAge(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
