/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAccessGrantsInstanceResourcePolicyResponse extends S3ControlResponse implements
        ToCopyableBuilder<PutAccessGrantsInstanceResourcePolicyResponse.Builder, PutAccessGrantsInstanceResourcePolicyResponse> {
    private static final SdkField<String> POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Policy")
            .getter(getter(PutAccessGrantsInstanceResourcePolicyResponse::policy))
            .setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy")
                    .unmarshallLocationName("Policy").build()).build();

    private static final SdkField<String> ORGANIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Organization")
            .getter(getter(PutAccessGrantsInstanceResourcePolicyResponse::organization))
            .setter(setter(Builder::organization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Organization")
                    .unmarshallLocationName("Organization").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(PutAccessGrantsInstanceResourcePolicyResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt")
                    .unmarshallLocationName("CreatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD,
            ORGANIZATION_FIELD, CREATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policy;

    private final String organization;

    private final Instant createdAt;

    private PutAccessGrantsInstanceResourcePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
        this.organization = builder.organization;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The updated resource policy of the S3 Access Grants instance.
     * </p>
     * 
     * @return The updated resource policy of the S3 Access Grants instance.
     */
    public final String policy() {
        return policy;
    }

    /**
     * <p>
     * The Organization of the resource policy of the S3 Access Grants instance.
     * </p>
     * 
     * @return The Organization of the resource policy of the S3 Access Grants instance.
     */
    public final String organization() {
        return organization;
    }

    /**
     * <p>
     * The date and time when you created the S3 Access Grants instance resource policy.
     * </p>
     * 
     * @return The date and time when you created the S3 Access Grants instance resource policy.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(organization());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccessGrantsInstanceResourcePolicyResponse)) {
            return false;
        }
        PutAccessGrantsInstanceResourcePolicyResponse other = (PutAccessGrantsInstanceResourcePolicyResponse) obj;
        return Objects.equals(policy(), other.policy()) && Objects.equals(organization(), other.organization())
                && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAccessGrantsInstanceResourcePolicyResponse").add("Policy", policy())
                .add("Organization", organization()).add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "Organization":
            return Optional.ofNullable(clazz.cast(organization()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Policy", POLICY_FIELD);
        map.put("Organization", ORGANIZATION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAccessGrantsInstanceResourcePolicyResponse, T> g) {
        return obj -> g.apply((PutAccessGrantsInstanceResourcePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutAccessGrantsInstanceResourcePolicyResponse> {
        /**
         * <p>
         * The updated resource policy of the S3 Access Grants instance.
         * </p>
         * 
         * @param policy
         *        The updated resource policy of the S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * The Organization of the resource policy of the S3 Access Grants instance.
         * </p>
         * 
         * @param organization
         *        The Organization of the resource policy of the S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organization(String organization);

        /**
         * <p>
         * The date and time when you created the S3 Access Grants instance resource policy.
         * </p>
         * 
         * @param createdAt
         *        The date and time when you created the S3 Access Grants instance resource policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private String policy;

        private String organization;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccessGrantsInstanceResourcePolicyResponse model) {
            super(model);
            policy(model.policy);
            organization(model.organization);
            createdAt(model.createdAt);
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final String getOrganization() {
            return organization;
        }

        public final void setOrganization(String organization) {
            this.organization = organization;
        }

        @Override
        public final Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public PutAccessGrantsInstanceResourcePolicyResponse build() {
            return new PutAccessGrantsInstanceResourcePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
