/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class RegionalBucketListCopier {
    static List<RegionalBucket> copy(Collection<? extends RegionalBucket> regionalBucketListParam) {
        List<RegionalBucket> list;
        if (regionalBucketListParam == null || regionalBucketListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RegionalBucket> modifiableList = new ArrayList<>(regionalBucketListParam.size());
            regionalBucketListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<RegionalBucket> copyFromBuilder(Collection<? extends RegionalBucket.Builder> regionalBucketListParam) {
        List<RegionalBucket> list;
        if (regionalBucketListParam == null || regionalBucketListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RegionalBucket> modifiableList = new ArrayList<>(regionalBucketListParam.size());
            regionalBucketListParam.forEach(entry -> {
                RegionalBucket member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<RegionalBucket.Builder> copyToBuilder(Collection<? extends RegionalBucket> regionalBucketListParam) {
        List<RegionalBucket.Builder> list;
        if (regionalBucketListParam == null || regionalBucketListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RegionalBucket.Builder> modifiableList = new ArrayList<>(regionalBucketListParam.size());
            regionalBucketListParam.forEach(entry -> {
                RegionalBucket.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
