/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter that identifies the subset of objects to which the replication rule applies. A <code>Filter</code> element
 * must specify exactly one <code>Prefix</code>, <code>Tag</code>, or <code>And</code> child element.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationRuleFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationRuleFilter.Builder, ReplicationRuleFilter> {
    private static final SdkField<String> PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Prefix")
            .getter(getter(ReplicationRuleFilter::prefix))
            .setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix")
                    .unmarshallLocationName("Prefix").build()).build();

    private static final SdkField<S3Tag> TAG_FIELD = SdkField
            .<S3Tag> builder(MarshallingType.SDK_POJO)
            .memberName("Tag")
            .getter(getter(ReplicationRuleFilter::tag))
            .setter(setter(Builder::tag))
            .constructor(S3Tag::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").unmarshallLocationName("Tag")
                    .build()).build();

    private static final SdkField<ReplicationRuleAndOperator> AND_FIELD = SdkField
            .<ReplicationRuleAndOperator> builder(MarshallingType.SDK_POJO)
            .memberName("And")
            .getter(getter(ReplicationRuleFilter::and))
            .setter(setter(Builder::and))
            .constructor(ReplicationRuleAndOperator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("And").unmarshallLocationName("And")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_FIELD, TAG_FIELD,
            AND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String prefix;

    private final S3Tag tag;

    private final ReplicationRuleAndOperator and;

    private ReplicationRuleFilter(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.tag = builder.tag;
        this.and = builder.and;
    }

    /**
     * <p>
     * An object key name prefix that identifies the subset of objects that the rule applies to.
     * </p>
     * <important>
     * <p>
     * When you're using XML requests, you must replace special characters (such as carriage returns) in object keys
     * with their equivalent XML entity codes. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">
     * XML-related object key constraints</a> in the <i>Amazon S3 User Guide</i>.
     * </p>
     * </important>
     * 
     * @return An object key name prefix that identifies the subset of objects that the rule applies to.</p> <important>
     *         <p>
     *         When you're using XML requests, you must replace special characters (such as carriage returns) in object
     *         keys with their equivalent XML entity codes. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"
     *         > XML-related object key constraints</a> in the <i>Amazon S3 User Guide</i>.
     *         </p>
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * Returns the value of the Tag property for this object.
     * 
     * @return The value of the Tag property for this object.
     */
    public final S3Tag tag() {
        return tag;
    }

    /**
     * <p>
     * A container for specifying rule filters. The filters determine the subset of objects that the rule applies to.
     * This element is required only if you specify more than one filter. For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify both a <code>Prefix</code> and a <code>Tag</code> filter, wrap these filters in an
     * <code>And</code> element.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a filter based on multiple tags, wrap the <code>Tag</code> elements in an <code>And</code>
     * element.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A container for specifying rule filters. The filters determine the subset of objects that the rule
     *         applies to. This element is required only if you specify more than one filter. For example: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify both a <code>Prefix</code> and a <code>Tag</code> filter, wrap these filters in an
     *         <code>And</code> element.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify a filter based on multiple tags, wrap the <code>Tag</code> elements in an <code>And</code>
     *         element.
     *         </p>
     *         </li>
     */
    public final ReplicationRuleAndOperator and() {
        return and;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(tag());
        hashCode = 31 * hashCode + Objects.hashCode(and());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationRuleFilter)) {
            return false;
        }
        ReplicationRuleFilter other = (ReplicationRuleFilter) obj;
        return Objects.equals(prefix(), other.prefix()) && Objects.equals(tag(), other.tag())
                && Objects.equals(and(), other.and());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationRuleFilter").add("Prefix", prefix()).add("Tag", tag()).add("And", and()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "Tag":
            return Optional.ofNullable(clazz.cast(tag()));
        case "And":
            return Optional.ofNullable(clazz.cast(and()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Prefix", PREFIX_FIELD);
        map.put("Tag", TAG_FIELD);
        map.put("And", AND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicationRuleFilter, T> g) {
        return obj -> g.apply((ReplicationRuleFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationRuleFilter> {
        /**
         * <p>
         * An object key name prefix that identifies the subset of objects that the rule applies to.
         * </p>
         * <important>
         * <p>
         * When you're using XML requests, you must replace special characters (such as carriage returns) in object keys
         * with their equivalent XML entity codes. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">
         * XML-related object key constraints</a> in the <i>Amazon S3 User Guide</i>.
         * </p>
         * </important>
         * 
         * @param prefix
         *        An object key name prefix that identifies the subset of objects that the rule applies to.</p>
         *        <important>
         *        <p>
         *        When you're using XML requests, you must replace special characters (such as carriage returns) in
         *        object keys with their equivalent XML entity codes. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"
         *        > XML-related object key constraints</a> in the <i>Amazon S3 User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * Sets the value of the Tag property for this object.
         *
         * @param tag
         *        The new value for the Tag property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tag(S3Tag tag);

        /**
         * Sets the value of the Tag property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3Tag.Builder} avoiding the need to
         * create one manually via {@link S3Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Tag.Builder#build()} is called immediately and its result is
         * passed to {@link #tag(S3Tag)}.
         * 
         * @param tag
         *        a consumer that will call methods on {@link S3Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tag(S3Tag)
         */
        default Builder tag(Consumer<S3Tag.Builder> tag) {
            return tag(S3Tag.builder().applyMutation(tag).build());
        }

        /**
         * <p>
         * A container for specifying rule filters. The filters determine the subset of objects that the rule applies
         * to. This element is required only if you specify more than one filter. For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify both a <code>Prefix</code> and a <code>Tag</code> filter, wrap these filters in an
         * <code>And</code> element.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify a filter based on multiple tags, wrap the <code>Tag</code> elements in an <code>And</code>
         * element.
         * </p>
         * </li>
         * </ul>
         * 
         * @param and
         *        A container for specifying rule filters. The filters determine the subset of objects that the rule
         *        applies to. This element is required only if you specify more than one filter. For example: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify both a <code>Prefix</code> and a <code>Tag</code> filter, wrap these filters in an
         *        <code>And</code> element.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify a filter based on multiple tags, wrap the <code>Tag</code> elements in an
         *        <code>And</code> element.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(ReplicationRuleAndOperator and);

        /**
         * <p>
         * A container for specifying rule filters. The filters determine the subset of objects that the rule applies
         * to. This element is required only if you specify more than one filter. For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify both a <code>Prefix</code> and a <code>Tag</code> filter, wrap these filters in an
         * <code>And</code> element.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify a filter based on multiple tags, wrap the <code>Tag</code> elements in an <code>And</code>
         * element.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link ReplicationRuleAndOperator.Builder}
         * avoiding the need to create one manually via {@link ReplicationRuleAndOperator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicationRuleAndOperator.Builder#build()} is called immediately
         * and its result is passed to {@link #and(ReplicationRuleAndOperator)}.
         * 
         * @param and
         *        a consumer that will call methods on {@link ReplicationRuleAndOperator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #and(ReplicationRuleAndOperator)
         */
        default Builder and(Consumer<ReplicationRuleAndOperator.Builder> and) {
            return and(ReplicationRuleAndOperator.builder().applyMutation(and).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String prefix;

        private S3Tag tag;

        private ReplicationRuleAndOperator and;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationRuleFilter model) {
            prefix(model.prefix);
            tag(model.tag);
            and(model.and);
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final S3Tag.Builder getTag() {
            return tag != null ? tag.toBuilder() : null;
        }

        public final void setTag(S3Tag.BuilderImpl tag) {
            this.tag = tag != null ? tag.build() : null;
        }

        @Override
        public final Builder tag(S3Tag tag) {
            this.tag = tag;
            return this;
        }

        public final ReplicationRuleAndOperator.Builder getAnd() {
            return and != null ? and.toBuilder() : null;
        }

        public final void setAnd(ReplicationRuleAndOperator.BuilderImpl and) {
            this.and = and != null ? and.build() : null;
        }

        @Override
        public final Builder and(ReplicationRuleAndOperator and) {
            this.and = and;
            return this;
        }

        @Override
        public ReplicationRuleFilter build() {
            return new ReplicationRuleFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
