/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for the Amazon S3 Storage Lens configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageLensConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StorageLensConfiguration.Builder, StorageLensConfiguration> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(StorageLensConfiguration::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<AccountLevel> ACCOUNT_LEVEL_FIELD = SdkField
            .<AccountLevel> builder(MarshallingType.SDK_POJO)
            .memberName("AccountLevel")
            .getter(getter(StorageLensConfiguration::accountLevel))
            .setter(setter(Builder::accountLevel))
            .constructor(AccountLevel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountLevel")
                    .unmarshallLocationName("AccountLevel").build()).build();

    private static final SdkField<Include> INCLUDE_FIELD = SdkField
            .<Include> builder(MarshallingType.SDK_POJO)
            .memberName("Include")
            .getter(getter(StorageLensConfiguration::include))
            .setter(setter(Builder::include))
            .constructor(Include::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Include")
                    .unmarshallLocationName("Include").build()).build();

    private static final SdkField<Exclude> EXCLUDE_FIELD = SdkField
            .<Exclude> builder(MarshallingType.SDK_POJO)
            .memberName("Exclude")
            .getter(getter(StorageLensConfiguration::exclude))
            .setter(setter(Builder::exclude))
            .constructor(Exclude::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclude")
                    .unmarshallLocationName("Exclude").build()).build();

    private static final SdkField<StorageLensDataExport> DATA_EXPORT_FIELD = SdkField
            .<StorageLensDataExport> builder(MarshallingType.SDK_POJO)
            .memberName("DataExport")
            .getter(getter(StorageLensConfiguration::dataExport))
            .setter(setter(Builder::dataExport))
            .constructor(StorageLensDataExport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataExport")
                    .unmarshallLocationName("DataExport").build()).build();

    private static final SdkField<Boolean> IS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsEnabled")
            .getter(getter(StorageLensConfiguration::isEnabled))
            .setter(setter(Builder::isEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEnabled")
                    .unmarshallLocationName("IsEnabled").build()).build();

    private static final SdkField<StorageLensAwsOrg> AWS_ORG_FIELD = SdkField
            .<StorageLensAwsOrg> builder(MarshallingType.SDK_POJO)
            .memberName("AwsOrg")
            .getter(getter(StorageLensConfiguration::awsOrg))
            .setter(setter(Builder::awsOrg))
            .constructor(StorageLensAwsOrg::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsOrg")
                    .unmarshallLocationName("AwsOrg").build()).build();

    private static final SdkField<String> STORAGE_LENS_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StorageLensArn")
            .getter(getter(StorageLensConfiguration::storageLensArn))
            .setter(setter(Builder::storageLensArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensArn")
                    .unmarshallLocationName("StorageLensArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ACCOUNT_LEVEL_FIELD,
            INCLUDE_FIELD, EXCLUDE_FIELD, DATA_EXPORT_FIELD, IS_ENABLED_FIELD, AWS_ORG_FIELD, STORAGE_LENS_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final AccountLevel accountLevel;

    private final Include include;

    private final Exclude exclude;

    private final StorageLensDataExport dataExport;

    private final Boolean isEnabled;

    private final StorageLensAwsOrg awsOrg;

    private final String storageLensArn;

    private StorageLensConfiguration(BuilderImpl builder) {
        this.id = builder.id;
        this.accountLevel = builder.accountLevel;
        this.include = builder.include;
        this.exclude = builder.exclude;
        this.dataExport = builder.dataExport;
        this.isEnabled = builder.isEnabled;
        this.awsOrg = builder.awsOrg;
        this.storageLensArn = builder.storageLensArn;
    }

    /**
     * <p>
     * A container for the Amazon S3 Storage Lens configuration ID.
     * </p>
     * 
     * @return A container for the Amazon S3 Storage Lens configuration ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A container for all the account-level configurations of your S3 Storage Lens configuration.
     * </p>
     * 
     * @return A container for all the account-level configurations of your S3 Storage Lens configuration.
     */
    public final AccountLevel accountLevel() {
        return accountLevel;
    }

    /**
     * <p>
     * A container for what is included in this configuration. This container can only be valid if there is no
     * <code>Exclude</code> container submitted, and it's not empty.
     * </p>
     * 
     * @return A container for what is included in this configuration. This container can only be valid if there is no
     *         <code>Exclude</code> container submitted, and it's not empty.
     */
    public final Include include() {
        return include;
    }

    /**
     * <p>
     * A container for what is excluded in this configuration. This container can only be valid if there is no
     * <code>Include</code> container submitted, and it's not empty.
     * </p>
     * 
     * @return A container for what is excluded in this configuration. This container can only be valid if there is no
     *         <code>Include</code> container submitted, and it's not empty.
     */
    public final Exclude exclude() {
        return exclude;
    }

    /**
     * <p>
     * A container to specify the properties of your S3 Storage Lens metrics export including, the destination, schema
     * and format.
     * </p>
     * 
     * @return A container to specify the properties of your S3 Storage Lens metrics export including, the destination,
     *         schema and format.
     */
    public final StorageLensDataExport dataExport() {
        return dataExport;
    }

    /**
     * <p>
     * A container for whether the S3 Storage Lens configuration is enabled.
     * </p>
     * 
     * @return A container for whether the S3 Storage Lens configuration is enabled.
     */
    public final Boolean isEnabled() {
        return isEnabled;
    }

    /**
     * <p>
     * A container for the Amazon Web Services organization for this S3 Storage Lens configuration.
     * </p>
     * 
     * @return A container for the Amazon Web Services organization for this S3 Storage Lens configuration.
     */
    public final StorageLensAwsOrg awsOrg() {
        return awsOrg;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the S3 Storage Lens configuration. This property is read-only and follows the
     * following format:
     * <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:storage-lens/<i>your-dashboard-name</i> </code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the S3 Storage Lens configuration. This property is read-only and
     *         follows the following format:
     *         <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:storage-lens/<i>your-dashboard-name</i> </code>
     */
    public final String storageLensArn() {
        return storageLensArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(accountLevel());
        hashCode = 31 * hashCode + Objects.hashCode(include());
        hashCode = 31 * hashCode + Objects.hashCode(exclude());
        hashCode = 31 * hashCode + Objects.hashCode(dataExport());
        hashCode = 31 * hashCode + Objects.hashCode(isEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(awsOrg());
        hashCode = 31 * hashCode + Objects.hashCode(storageLensArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageLensConfiguration)) {
            return false;
        }
        StorageLensConfiguration other = (StorageLensConfiguration) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(accountLevel(), other.accountLevel())
                && Objects.equals(include(), other.include()) && Objects.equals(exclude(), other.exclude())
                && Objects.equals(dataExport(), other.dataExport()) && Objects.equals(isEnabled(), other.isEnabled())
                && Objects.equals(awsOrg(), other.awsOrg()) && Objects.equals(storageLensArn(), other.storageLensArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageLensConfiguration").add("Id", id()).add("AccountLevel", accountLevel())
                .add("Include", include()).add("Exclude", exclude()).add("DataExport", dataExport())
                .add("IsEnabled", isEnabled()).add("AwsOrg", awsOrg()).add("StorageLensArn", storageLensArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "AccountLevel":
            return Optional.ofNullable(clazz.cast(accountLevel()));
        case "Include":
            return Optional.ofNullable(clazz.cast(include()));
        case "Exclude":
            return Optional.ofNullable(clazz.cast(exclude()));
        case "DataExport":
            return Optional.ofNullable(clazz.cast(dataExport()));
        case "IsEnabled":
            return Optional.ofNullable(clazz.cast(isEnabled()));
        case "AwsOrg":
            return Optional.ofNullable(clazz.cast(awsOrg()));
        case "StorageLensArn":
            return Optional.ofNullable(clazz.cast(storageLensArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("AccountLevel", ACCOUNT_LEVEL_FIELD);
        map.put("Include", INCLUDE_FIELD);
        map.put("Exclude", EXCLUDE_FIELD);
        map.put("DataExport", DATA_EXPORT_FIELD);
        map.put("IsEnabled", IS_ENABLED_FIELD);
        map.put("AwsOrg", AWS_ORG_FIELD);
        map.put("StorageLensArn", STORAGE_LENS_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StorageLensConfiguration, T> g) {
        return obj -> g.apply((StorageLensConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageLensConfiguration> {
        /**
         * <p>
         * A container for the Amazon S3 Storage Lens configuration ID.
         * </p>
         * 
         * @param id
         *        A container for the Amazon S3 Storage Lens configuration ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A container for all the account-level configurations of your S3 Storage Lens configuration.
         * </p>
         * 
         * @param accountLevel
         *        A container for all the account-level configurations of your S3 Storage Lens configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountLevel(AccountLevel accountLevel);

        /**
         * <p>
         * A container for all the account-level configurations of your S3 Storage Lens configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountLevel.Builder} avoiding the need
         * to create one manually via {@link AccountLevel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountLevel.Builder#build()} is called immediately and its
         * result is passed to {@link #accountLevel(AccountLevel)}.
         * 
         * @param accountLevel
         *        a consumer that will call methods on {@link AccountLevel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountLevel(AccountLevel)
         */
        default Builder accountLevel(Consumer<AccountLevel.Builder> accountLevel) {
            return accountLevel(AccountLevel.builder().applyMutation(accountLevel).build());
        }

        /**
         * <p>
         * A container for what is included in this configuration. This container can only be valid if there is no
         * <code>Exclude</code> container submitted, and it's not empty.
         * </p>
         * 
         * @param include
         *        A container for what is included in this configuration. This container can only be valid if there is
         *        no <code>Exclude</code> container submitted, and it's not empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(Include include);

        /**
         * <p>
         * A container for what is included in this configuration. This container can only be valid if there is no
         * <code>Exclude</code> container submitted, and it's not empty.
         * </p>
         * This is a convenience method that creates an instance of the {@link Include.Builder} avoiding the need to
         * create one manually via {@link Include#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Include.Builder#build()} is called immediately and its result is
         * passed to {@link #include(Include)}.
         * 
         * @param include
         *        a consumer that will call methods on {@link Include.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #include(Include)
         */
        default Builder include(Consumer<Include.Builder> include) {
            return include(Include.builder().applyMutation(include).build());
        }

        /**
         * <p>
         * A container for what is excluded in this configuration. This container can only be valid if there is no
         * <code>Include</code> container submitted, and it's not empty.
         * </p>
         * 
         * @param exclude
         *        A container for what is excluded in this configuration. This container can only be valid if there is
         *        no <code>Include</code> container submitted, and it's not empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclude(Exclude exclude);

        /**
         * <p>
         * A container for what is excluded in this configuration. This container can only be valid if there is no
         * <code>Include</code> container submitted, and it's not empty.
         * </p>
         * This is a convenience method that creates an instance of the {@link Exclude.Builder} avoiding the need to
         * create one manually via {@link Exclude#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Exclude.Builder#build()} is called immediately and its result is
         * passed to {@link #exclude(Exclude)}.
         * 
         * @param exclude
         *        a consumer that will call methods on {@link Exclude.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exclude(Exclude)
         */
        default Builder exclude(Consumer<Exclude.Builder> exclude) {
            return exclude(Exclude.builder().applyMutation(exclude).build());
        }

        /**
         * <p>
         * A container to specify the properties of your S3 Storage Lens metrics export including, the destination,
         * schema and format.
         * </p>
         * 
         * @param dataExport
         *        A container to specify the properties of your S3 Storage Lens metrics export including, the
         *        destination, schema and format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExport(StorageLensDataExport dataExport);

        /**
         * <p>
         * A container to specify the properties of your S3 Storage Lens metrics export including, the destination,
         * schema and format.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageLensDataExport.Builder} avoiding
         * the need to create one manually via {@link StorageLensDataExport#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageLensDataExport.Builder#build()} is called immediately and
         * its result is passed to {@link #dataExport(StorageLensDataExport)}.
         * 
         * @param dataExport
         *        a consumer that will call methods on {@link StorageLensDataExport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataExport(StorageLensDataExport)
         */
        default Builder dataExport(Consumer<StorageLensDataExport.Builder> dataExport) {
            return dataExport(StorageLensDataExport.builder().applyMutation(dataExport).build());
        }

        /**
         * <p>
         * A container for whether the S3 Storage Lens configuration is enabled.
         * </p>
         * 
         * @param isEnabled
         *        A container for whether the S3 Storage Lens configuration is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEnabled(Boolean isEnabled);

        /**
         * <p>
         * A container for the Amazon Web Services organization for this S3 Storage Lens configuration.
         * </p>
         * 
         * @param awsOrg
         *        A container for the Amazon Web Services organization for this S3 Storage Lens configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsOrg(StorageLensAwsOrg awsOrg);

        /**
         * <p>
         * A container for the Amazon Web Services organization for this S3 Storage Lens configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageLensAwsOrg.Builder} avoiding the
         * need to create one manually via {@link StorageLensAwsOrg#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageLensAwsOrg.Builder#build()} is called immediately and its
         * result is passed to {@link #awsOrg(StorageLensAwsOrg)}.
         * 
         * @param awsOrg
         *        a consumer that will call methods on {@link StorageLensAwsOrg.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsOrg(StorageLensAwsOrg)
         */
        default Builder awsOrg(Consumer<StorageLensAwsOrg.Builder> awsOrg) {
            return awsOrg(StorageLensAwsOrg.builder().applyMutation(awsOrg).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the S3 Storage Lens configuration. This property is read-only and follows
         * the following format:
         * <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:storage-lens/<i>your-dashboard-name</i> </code>
         * </p>
         * 
         * @param storageLensArn
         *        The Amazon Resource Name (ARN) of the S3 Storage Lens configuration. This property is read-only and
         *        follows the following format:
         *        <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:storage-lens/<i>your-dashboard-name</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLensArn(String storageLensArn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private AccountLevel accountLevel;

        private Include include;

        private Exclude exclude;

        private StorageLensDataExport dataExport;

        private Boolean isEnabled;

        private StorageLensAwsOrg awsOrg;

        private String storageLensArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageLensConfiguration model) {
            id(model.id);
            accountLevel(model.accountLevel);
            include(model.include);
            exclude(model.exclude);
            dataExport(model.dataExport);
            isEnabled(model.isEnabled);
            awsOrg(model.awsOrg);
            storageLensArn(model.storageLensArn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final AccountLevel.Builder getAccountLevel() {
            return accountLevel != null ? accountLevel.toBuilder() : null;
        }

        public final void setAccountLevel(AccountLevel.BuilderImpl accountLevel) {
            this.accountLevel = accountLevel != null ? accountLevel.build() : null;
        }

        @Override
        public final Builder accountLevel(AccountLevel accountLevel) {
            this.accountLevel = accountLevel;
            return this;
        }

        public final Include.Builder getInclude() {
            return include != null ? include.toBuilder() : null;
        }

        public final void setInclude(Include.BuilderImpl include) {
            this.include = include != null ? include.build() : null;
        }

        @Override
        public final Builder include(Include include) {
            this.include = include;
            return this;
        }

        public final Exclude.Builder getExclude() {
            return exclude != null ? exclude.toBuilder() : null;
        }

        public final void setExclude(Exclude.BuilderImpl exclude) {
            this.exclude = exclude != null ? exclude.build() : null;
        }

        @Override
        public final Builder exclude(Exclude exclude) {
            this.exclude = exclude;
            return this;
        }

        public final StorageLensDataExport.Builder getDataExport() {
            return dataExport != null ? dataExport.toBuilder() : null;
        }

        public final void setDataExport(StorageLensDataExport.BuilderImpl dataExport) {
            this.dataExport = dataExport != null ? dataExport.build() : null;
        }

        @Override
        public final Builder dataExport(StorageLensDataExport dataExport) {
            this.dataExport = dataExport;
            return this;
        }

        public final Boolean getIsEnabled() {
            return isEnabled;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public final StorageLensAwsOrg.Builder getAwsOrg() {
            return awsOrg != null ? awsOrg.toBuilder() : null;
        }

        public final void setAwsOrg(StorageLensAwsOrg.BuilderImpl awsOrg) {
            this.awsOrg = awsOrg != null ? awsOrg.build() : null;
        }

        @Override
        public final Builder awsOrg(StorageLensAwsOrg awsOrg) {
            this.awsOrg = awsOrg;
            return this;
        }

        public final String getStorageLensArn() {
            return storageLensArn;
        }

        public final void setStorageLensArn(String storageLensArn) {
            this.storageLensArn = storageLensArn;
        }

        @Override
        public final Builder storageLensArn(String storageLensArn) {
            this.storageLensArn = storageLensArn;
            return this;
        }

        @Override
        public StorageLensConfiguration build() {
            return new StorageLensConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
