/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container to specify the properties of your S3 Storage Lens metrics export, including the destination, schema, and
 * format.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageLensDataExport implements SdkPojo, Serializable,
        ToCopyableBuilder<StorageLensDataExport.Builder, StorageLensDataExport> {
    private static final SdkField<S3BucketDestination> S3_BUCKET_DESTINATION_FIELD = SdkField
            .<S3BucketDestination> builder(MarshallingType.SDK_POJO)
            .memberName("S3BucketDestination")
            .getter(getter(StorageLensDataExport::s3BucketDestination))
            .setter(setter(Builder::s3BucketDestination))
            .constructor(S3BucketDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketDestination")
                    .unmarshallLocationName("S3BucketDestination").build()).build();

    private static final SdkField<CloudWatchMetrics> CLOUD_WATCH_METRICS_FIELD = SdkField
            .<CloudWatchMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("CloudWatchMetrics")
            .getter(getter(StorageLensDataExport::cloudWatchMetrics))
            .setter(setter(Builder::cloudWatchMetrics))
            .constructor(CloudWatchMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchMetrics")
                    .unmarshallLocationName("CloudWatchMetrics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_DESTINATION_FIELD,
            CLOUD_WATCH_METRICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3BucketDestination s3BucketDestination;

    private final CloudWatchMetrics cloudWatchMetrics;

    private StorageLensDataExport(BuilderImpl builder) {
        this.s3BucketDestination = builder.s3BucketDestination;
        this.cloudWatchMetrics = builder.cloudWatchMetrics;
    }

    /**
     * <p>
     * A container for the bucket where the S3 Storage Lens metrics export will be located.
     * </p>
     * <note>
     * <p>
     * This bucket must be located in the same Region as the storage lens configuration.
     * </p>
     * </note>
     * 
     * @return A container for the bucket where the S3 Storage Lens metrics export will be located.</p> <note>
     *         <p>
     *         This bucket must be located in the same Region as the storage lens configuration.
     *         </p>
     */
    public final S3BucketDestination s3BucketDestination() {
        return s3BucketDestination;
    }

    /**
     * <p>
     * A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.
     * </p>
     * 
     * @return A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.
     */
    public final CloudWatchMetrics cloudWatchMetrics() {
        return cloudWatchMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketDestination());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchMetrics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageLensDataExport)) {
            return false;
        }
        StorageLensDataExport other = (StorageLensDataExport) obj;
        return Objects.equals(s3BucketDestination(), other.s3BucketDestination())
                && Objects.equals(cloudWatchMetrics(), other.cloudWatchMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageLensDataExport").add("S3BucketDestination", s3BucketDestination())
                .add("CloudWatchMetrics", cloudWatchMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3BucketDestination":
            return Optional.ofNullable(clazz.cast(s3BucketDestination()));
        case "CloudWatchMetrics":
            return Optional.ofNullable(clazz.cast(cloudWatchMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3BucketDestination", S3_BUCKET_DESTINATION_FIELD);
        map.put("CloudWatchMetrics", CLOUD_WATCH_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StorageLensDataExport, T> g) {
        return obj -> g.apply((StorageLensDataExport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageLensDataExport> {
        /**
         * <p>
         * A container for the bucket where the S3 Storage Lens metrics export will be located.
         * </p>
         * <note>
         * <p>
         * This bucket must be located in the same Region as the storage lens configuration.
         * </p>
         * </note>
         * 
         * @param s3BucketDestination
         *        A container for the bucket where the S3 Storage Lens metrics export will be located.</p> <note>
         *        <p>
         *        This bucket must be located in the same Region as the storage lens configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketDestination(S3BucketDestination s3BucketDestination);

        /**
         * <p>
         * A container for the bucket where the S3 Storage Lens metrics export will be located.
         * </p>
         * <note>
         * <p>
         * This bucket must be located in the same Region as the storage lens configuration.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link S3BucketDestination.Builder}
         * avoiding the need to create one manually via {@link S3BucketDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3BucketDestination.Builder#build()} is called immediately and
         * its result is passed to {@link #s3BucketDestination(S3BucketDestination)}.
         * 
         * @param s3BucketDestination
         *        a consumer that will call methods on {@link S3BucketDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3BucketDestination(S3BucketDestination)
         */
        default Builder s3BucketDestination(Consumer<S3BucketDestination.Builder> s3BucketDestination) {
            return s3BucketDestination(S3BucketDestination.builder().applyMutation(s3BucketDestination).build());
        }

        /**
         * <p>
         * A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.
         * </p>
         * 
         * @param cloudWatchMetrics
         *        A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchMetrics(CloudWatchMetrics cloudWatchMetrics);

        /**
         * <p>
         * A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchMetrics.Builder} avoiding the
         * need to create one manually via {@link CloudWatchMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #cloudWatchMetrics(CloudWatchMetrics)}.
         * 
         * @param cloudWatchMetrics
         *        a consumer that will call methods on {@link CloudWatchMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchMetrics(CloudWatchMetrics)
         */
        default Builder cloudWatchMetrics(Consumer<CloudWatchMetrics.Builder> cloudWatchMetrics) {
            return cloudWatchMetrics(CloudWatchMetrics.builder().applyMutation(cloudWatchMetrics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3BucketDestination s3BucketDestination;

        private CloudWatchMetrics cloudWatchMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageLensDataExport model) {
            s3BucketDestination(model.s3BucketDestination);
            cloudWatchMetrics(model.cloudWatchMetrics);
        }

        public final S3BucketDestination.Builder getS3BucketDestination() {
            return s3BucketDestination != null ? s3BucketDestination.toBuilder() : null;
        }

        public final void setS3BucketDestination(S3BucketDestination.BuilderImpl s3BucketDestination) {
            this.s3BucketDestination = s3BucketDestination != null ? s3BucketDestination.build() : null;
        }

        @Override
        public final Builder s3BucketDestination(S3BucketDestination s3BucketDestination) {
            this.s3BucketDestination = s3BucketDestination;
            return this;
        }

        public final CloudWatchMetrics.Builder getCloudWatchMetrics() {
            return cloudWatchMetrics != null ? cloudWatchMetrics.toBuilder() : null;
        }

        public final void setCloudWatchMetrics(CloudWatchMetrics.BuilderImpl cloudWatchMetrics) {
            this.cloudWatchMetrics = cloudWatchMetrics != null ? cloudWatchMetrics.build() : null;
        }

        @Override
        public final Builder cloudWatchMetrics(CloudWatchMetrics cloudWatchMetrics) {
            this.cloudWatchMetrics = cloudWatchMetrics;
            return this;
        }

        @Override
        public StorageLensDataExport build() {
            return new StorageLensDataExport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
