/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessGrantResponse extends S3ControlResponse implements
        ToCopyableBuilder<CreateAccessGrantResponse.Builder, CreateAccessGrantResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(CreateAccessGrantResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt")
                    .unmarshallLocationName("CreatedAt").build()).build();

    private static final SdkField<String> ACCESS_GRANT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessGrantId")
            .getter(getter(CreateAccessGrantResponse::accessGrantId))
            .setter(setter(Builder::accessGrantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantId")
                    .unmarshallLocationName("AccessGrantId").build()).build();

    private static final SdkField<String> ACCESS_GRANT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessGrantArn")
            .getter(getter(CreateAccessGrantResponse::accessGrantArn))
            .setter(setter(Builder::accessGrantArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantArn")
                    .unmarshallLocationName("AccessGrantArn").build()).build();

    private static final SdkField<Grantee> GRANTEE_FIELD = SdkField
            .<Grantee> builder(MarshallingType.SDK_POJO)
            .memberName("Grantee")
            .getter(getter(CreateAccessGrantResponse::grantee))
            .setter(setter(Builder::grantee))
            .constructor(Grantee::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grantee")
                    .unmarshallLocationName("Grantee").build()).build();

    private static final SdkField<String> ACCESS_GRANTS_LOCATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessGrantsLocationId")
            .getter(getter(CreateAccessGrantResponse::accessGrantsLocationId))
            .setter(setter(Builder::accessGrantsLocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsLocationId")
                    .unmarshallLocationName("AccessGrantsLocationId").build()).build();

    private static final SdkField<AccessGrantsLocationConfiguration> ACCESS_GRANTS_LOCATION_CONFIGURATION_FIELD = SdkField
            .<AccessGrantsLocationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("AccessGrantsLocationConfiguration")
            .getter(getter(CreateAccessGrantResponse::accessGrantsLocationConfiguration))
            .setter(setter(Builder::accessGrantsLocationConfiguration))
            .constructor(AccessGrantsLocationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsLocationConfiguration")
                    .unmarshallLocationName("AccessGrantsLocationConfiguration").build()).build();

    private static final SdkField<String> PERMISSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Permission")
            .getter(getter(CreateAccessGrantResponse::permissionAsString))
            .setter(setter(Builder::permission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permission")
                    .unmarshallLocationName("Permission").build()).build();

    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn")
            .getter(getter(CreateAccessGrantResponse::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn")
                    .unmarshallLocationName("ApplicationArn").build()).build();

    private static final SdkField<String> GRANT_SCOPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GrantScope")
            .getter(getter(CreateAccessGrantResponse::grantScope))
            .setter(setter(Builder::grantScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantScope")
                    .unmarshallLocationName("GrantScope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            ACCESS_GRANT_ID_FIELD, ACCESS_GRANT_ARN_FIELD, GRANTEE_FIELD, ACCESS_GRANTS_LOCATION_ID_FIELD,
            ACCESS_GRANTS_LOCATION_CONFIGURATION_FIELD, PERMISSION_FIELD, APPLICATION_ARN_FIELD, GRANT_SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createdAt;

    private final String accessGrantId;

    private final String accessGrantArn;

    private final Grantee grantee;

    private final String accessGrantsLocationId;

    private final AccessGrantsLocationConfiguration accessGrantsLocationConfiguration;

    private final String permission;

    private final String applicationArn;

    private final String grantScope;

    private CreateAccessGrantResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.accessGrantId = builder.accessGrantId;
        this.accessGrantArn = builder.accessGrantArn;
        this.grantee = builder.grantee;
        this.accessGrantsLocationId = builder.accessGrantsLocationId;
        this.accessGrantsLocationConfiguration = builder.accessGrantsLocationConfiguration;
        this.permission = builder.permission;
        this.applicationArn = builder.applicationArn;
        this.grantScope = builder.grantScope;
    }

    /**
     * <p>
     * The date and time when you created the access grant.
     * </p>
     * 
     * @return The date and time when you created the access grant.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ID of the access grant. S3 Access Grants auto-generates this ID when you create the access grant.
     * </p>
     * 
     * @return The ID of the access grant. S3 Access Grants auto-generates this ID when you create the access grant.
     */
    public final String accessGrantId() {
        return accessGrantId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the access grant.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the access grant.
     */
    public final String accessGrantArn() {
        return accessGrantArn;
    }

    /**
     * <p>
     * The user, group, or role to which you are granting access. You can grant access to an IAM user or role. If you
     * have added your corporate directory to Amazon Web Services IAM Identity Center and associated your Identity
     * Center instance with your S3 Access Grants instance, the grantee can also be a corporate directory user or group.
     * </p>
     * 
     * @return The user, group, or role to which you are granting access. You can grant access to an IAM user or role.
     *         If you have added your corporate directory to Amazon Web Services IAM Identity Center and associated your
     *         Identity Center instance with your S3 Access Grants instance, the grantee can also be a corporate
     *         directory user or group.
     */
    public final Grantee grantee() {
        return grantee;
    }

    /**
     * <p>
     * The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you
     * register the location. S3 Access Grants assigns the ID <code>default</code> to the default location
     * <code>s3://</code> and assigns an auto-generated ID to other locations that you register.
     * </p>
     * 
     * @return The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when
     *         you register the location. S3 Access Grants assigns the ID <code>default</code> to the default location
     *         <code>s3://</code> and assigns an auto-generated ID to other locations that you register.
     */
    public final String accessGrantsLocationId() {
        return accessGrantsLocationId;
    }

    /**
     * <p>
     * The configuration options of the grant location. The grant location is the S3 path to the data to which you are
     * granting access.
     * </p>
     * 
     * @return The configuration options of the grant location. The grant location is the S3 path to the data to which
     *         you are granting access.
     */
    public final AccessGrantsLocationConfiguration accessGrantsLocationConfiguration() {
        return accessGrantsLocationConfiguration;
    }

    /**
     * <p>
     * The type of access that you are granting to your S3 data, which can be set to one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READ</code> – Grant read-only access to the S3 data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WRITE</code> – Grant write-only access to the S3 data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READWRITE</code> – Grant both read and write access to the S3 data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionAsString}.
     * </p>
     * 
     * @return The type of access that you are granting to your S3 data, which can be set to one of the following
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READ</code> – Grant read-only access to the S3 data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WRITE</code> – Grant write-only access to the S3 data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READWRITE</code> – Grant both read and write access to the S3 data.
     *         </p>
     *         </li>
     * @see Permission
     */
    public final Permission permission() {
        return Permission.fromValue(permission);
    }

    /**
     * <p>
     * The type of access that you are granting to your S3 data, which can be set to one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READ</code> – Grant read-only access to the S3 data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WRITE</code> – Grant write-only access to the S3 data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READWRITE</code> – Grant both read and write access to the S3 data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionAsString}.
     * </p>
     * 
     * @return The type of access that you are granting to your S3 data, which can be set to one of the following
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READ</code> – Grant read-only access to the S3 data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WRITE</code> – Grant write-only access to the S3 data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READWRITE</code> – Grant both read and write access to the S3 data.
     *         </p>
     *         </li>
     * @see Permission
     */
    public final String permissionAsString() {
        return permission;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your
     * Identity Center instance. If the grant includes an application ARN, the grantee can only access the S3 data
     * through this application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with
     *         your Identity Center instance. If the grant includes an application ARN, the grantee can only access the
     *         S3 data through this application.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The S3 path of the data to which you are granting access. It is the result of appending the
     * <code>Subprefix</code> to the location scope.
     * </p>
     * 
     * @return The S3 path of the data to which you are granting access. It is the result of appending the
     *         <code>Subprefix</code> to the location scope.
     */
    public final String grantScope() {
        return grantScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(accessGrantId());
        hashCode = 31 * hashCode + Objects.hashCode(accessGrantArn());
        hashCode = 31 * hashCode + Objects.hashCode(grantee());
        hashCode = 31 * hashCode + Objects.hashCode(accessGrantsLocationId());
        hashCode = 31 * hashCode + Objects.hashCode(accessGrantsLocationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(grantScope());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessGrantResponse)) {
            return false;
        }
        CreateAccessGrantResponse other = (CreateAccessGrantResponse) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(accessGrantId(), other.accessGrantId())
                && Objects.equals(accessGrantArn(), other.accessGrantArn()) && Objects.equals(grantee(), other.grantee())
                && Objects.equals(accessGrantsLocationId(), other.accessGrantsLocationId())
                && Objects.equals(accessGrantsLocationConfiguration(), other.accessGrantsLocationConfiguration())
                && Objects.equals(permissionAsString(), other.permissionAsString())
                && Objects.equals(applicationArn(), other.applicationArn()) && Objects.equals(grantScope(), other.grantScope());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessGrantResponse").add("CreatedAt", createdAt()).add("AccessGrantId", accessGrantId())
                .add("AccessGrantArn", accessGrantArn()).add("Grantee", grantee())
                .add("AccessGrantsLocationId", accessGrantsLocationId())
                .add("AccessGrantsLocationConfiguration", accessGrantsLocationConfiguration())
                .add("Permission", permissionAsString()).add("ApplicationArn", applicationArn()).add("GrantScope", grantScope())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "AccessGrantId":
            return Optional.ofNullable(clazz.cast(accessGrantId()));
        case "AccessGrantArn":
            return Optional.ofNullable(clazz.cast(accessGrantArn()));
        case "Grantee":
            return Optional.ofNullable(clazz.cast(grantee()));
        case "AccessGrantsLocationId":
            return Optional.ofNullable(clazz.cast(accessGrantsLocationId()));
        case "AccessGrantsLocationConfiguration":
            return Optional.ofNullable(clazz.cast(accessGrantsLocationConfiguration()));
        case "Permission":
            return Optional.ofNullable(clazz.cast(permissionAsString()));
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "GrantScope":
            return Optional.ofNullable(clazz.cast(grantScope()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("AccessGrantId", ACCESS_GRANT_ID_FIELD);
        map.put("AccessGrantArn", ACCESS_GRANT_ARN_FIELD);
        map.put("Grantee", GRANTEE_FIELD);
        map.put("AccessGrantsLocationId", ACCESS_GRANTS_LOCATION_ID_FIELD);
        map.put("AccessGrantsLocationConfiguration", ACCESS_GRANTS_LOCATION_CONFIGURATION_FIELD);
        map.put("Permission", PERMISSION_FIELD);
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("GrantScope", GRANT_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessGrantResponse, T> g) {
        return obj -> g.apply((CreateAccessGrantResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAccessGrantResponse> {
        /**
         * <p>
         * The date and time when you created the access grant.
         * </p>
         * 
         * @param createdAt
         *        The date and time when you created the access grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ID of the access grant. S3 Access Grants auto-generates this ID when you create the access grant.
         * </p>
         * 
         * @param accessGrantId
         *        The ID of the access grant. S3 Access Grants auto-generates this ID when you create the access grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantId(String accessGrantId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the access grant.
         * </p>
         * 
         * @param accessGrantArn
         *        The Amazon Resource Name (ARN) of the access grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantArn(String accessGrantArn);

        /**
         * <p>
         * The user, group, or role to which you are granting access. You can grant access to an IAM user or role. If
         * you have added your corporate directory to Amazon Web Services IAM Identity Center and associated your
         * Identity Center instance with your S3 Access Grants instance, the grantee can also be a corporate directory
         * user or group.
         * </p>
         * 
         * @param grantee
         *        The user, group, or role to which you are granting access. You can grant access to an IAM user or
         *        role. If you have added your corporate directory to Amazon Web Services IAM Identity Center and
         *        associated your Identity Center instance with your S3 Access Grants instance, the grantee can also be
         *        a corporate directory user or group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantee(Grantee grantee);

        /**
         * <p>
         * The user, group, or role to which you are granting access. You can grant access to an IAM user or role. If
         * you have added your corporate directory to Amazon Web Services IAM Identity Center and associated your
         * Identity Center instance with your S3 Access Grants instance, the grantee can also be a corporate directory
         * user or group.
         * </p>
         * This is a convenience method that creates an instance of the {@link Grantee.Builder} avoiding the need to
         * create one manually via {@link Grantee#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Grantee.Builder#build()} is called immediately and its result is
         * passed to {@link #grantee(Grantee)}.
         * 
         * @param grantee
         *        a consumer that will call methods on {@link Grantee.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grantee(Grantee)
         */
        default Builder grantee(Consumer<Grantee.Builder> grantee) {
            return grantee(Grantee.builder().applyMutation(grantee).build());
        }

        /**
         * <p>
         * The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID when you
         * register the location. S3 Access Grants assigns the ID <code>default</code> to the default location
         * <code>s3://</code> and assigns an auto-generated ID to other locations that you register.
         * </p>
         * 
         * @param accessGrantsLocationId
         *        The ID of the registered location to which you are granting access. S3 Access Grants assigns this ID
         *        when you register the location. S3 Access Grants assigns the ID <code>default</code> to the default
         *        location <code>s3://</code> and assigns an auto-generated ID to other locations that you register.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsLocationId(String accessGrantsLocationId);

        /**
         * <p>
         * The configuration options of the grant location. The grant location is the S3 path to the data to which you
         * are granting access.
         * </p>
         * 
         * @param accessGrantsLocationConfiguration
         *        The configuration options of the grant location. The grant location is the S3 path to the data to
         *        which you are granting access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsLocationConfiguration(AccessGrantsLocationConfiguration accessGrantsLocationConfiguration);

        /**
         * <p>
         * The configuration options of the grant location. The grant location is the S3 path to the data to which you
         * are granting access.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AccessGrantsLocationConfiguration.Builder} avoiding the need to create one manually via
         * {@link AccessGrantsLocationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessGrantsLocationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #accessGrantsLocationConfiguration(AccessGrantsLocationConfiguration)}.
         * 
         * @param accessGrantsLocationConfiguration
         *        a consumer that will call methods on {@link AccessGrantsLocationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessGrantsLocationConfiguration(AccessGrantsLocationConfiguration)
         */
        default Builder accessGrantsLocationConfiguration(
                Consumer<AccessGrantsLocationConfiguration.Builder> accessGrantsLocationConfiguration) {
            return accessGrantsLocationConfiguration(AccessGrantsLocationConfiguration.builder()
                    .applyMutation(accessGrantsLocationConfiguration).build());
        }

        /**
         * <p>
         * The type of access that you are granting to your S3 data, which can be set to one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READ</code> – Grant read-only access to the S3 data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WRITE</code> – Grant write-only access to the S3 data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READWRITE</code> – Grant both read and write access to the S3 data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permission
         *        The type of access that you are granting to your S3 data, which can be set to one of the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READ</code> – Grant read-only access to the S3 data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WRITE</code> – Grant write-only access to the S3 data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READWRITE</code> – Grant both read and write access to the S3 data.
         *        </p>
         *        </li>
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder permission(String permission);

        /**
         * <p>
         * The type of access that you are granting to your S3 data, which can be set to one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READ</code> – Grant read-only access to the S3 data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WRITE</code> – Grant write-only access to the S3 data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READWRITE</code> – Grant both read and write access to the S3 data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permission
         *        The type of access that you are granting to your S3 data, which can be set to one of the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READ</code> – Grant read-only access to the S3 data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WRITE</code> – Grant write-only access to the S3 data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READWRITE</code> – Grant both read and write access to the S3 data.
         *        </p>
         *        </li>
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder permission(Permission permission);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated with your
         * Identity Center instance. If the grant includes an application ARN, the grantee can only access the S3 data
         * through this application.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center application associated
         *        with your Identity Center instance. If the grant includes an application ARN, the grantee can only
         *        access the S3 data through this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The S3 path of the data to which you are granting access. It is the result of appending the
         * <code>Subprefix</code> to the location scope.
         * </p>
         * 
         * @param grantScope
         *        The S3 path of the data to which you are granting access. It is the result of appending the
         *        <code>Subprefix</code> to the location scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantScope(String grantScope);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private String accessGrantId;

        private String accessGrantArn;

        private Grantee grantee;

        private String accessGrantsLocationId;

        private AccessGrantsLocationConfiguration accessGrantsLocationConfiguration;

        private String permission;

        private String applicationArn;

        private String grantScope;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessGrantResponse model) {
            super(model);
            createdAt(model.createdAt);
            accessGrantId(model.accessGrantId);
            accessGrantArn(model.accessGrantArn);
            grantee(model.grantee);
            accessGrantsLocationId(model.accessGrantsLocationId);
            accessGrantsLocationConfiguration(model.accessGrantsLocationConfiguration);
            permission(model.permission);
            applicationArn(model.applicationArn);
            grantScope(model.grantScope);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getAccessGrantId() {
            return accessGrantId;
        }

        public final void setAccessGrantId(String accessGrantId) {
            this.accessGrantId = accessGrantId;
        }

        @Override
        public final Builder accessGrantId(String accessGrantId) {
            this.accessGrantId = accessGrantId;
            return this;
        }

        public final String getAccessGrantArn() {
            return accessGrantArn;
        }

        public final void setAccessGrantArn(String accessGrantArn) {
            this.accessGrantArn = accessGrantArn;
        }

        @Override
        public final Builder accessGrantArn(String accessGrantArn) {
            this.accessGrantArn = accessGrantArn;
            return this;
        }

        public final Grantee.Builder getGrantee() {
            return grantee != null ? grantee.toBuilder() : null;
        }

        public final void setGrantee(Grantee.BuilderImpl grantee) {
            this.grantee = grantee != null ? grantee.build() : null;
        }

        @Override
        public final Builder grantee(Grantee grantee) {
            this.grantee = grantee;
            return this;
        }

        public final String getAccessGrantsLocationId() {
            return accessGrantsLocationId;
        }

        public final void setAccessGrantsLocationId(String accessGrantsLocationId) {
            this.accessGrantsLocationId = accessGrantsLocationId;
        }

        @Override
        public final Builder accessGrantsLocationId(String accessGrantsLocationId) {
            this.accessGrantsLocationId = accessGrantsLocationId;
            return this;
        }

        public final AccessGrantsLocationConfiguration.Builder getAccessGrantsLocationConfiguration() {
            return accessGrantsLocationConfiguration != null ? accessGrantsLocationConfiguration.toBuilder() : null;
        }

        public final void setAccessGrantsLocationConfiguration(
                AccessGrantsLocationConfiguration.BuilderImpl accessGrantsLocationConfiguration) {
            this.accessGrantsLocationConfiguration = accessGrantsLocationConfiguration != null ? accessGrantsLocationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder accessGrantsLocationConfiguration(AccessGrantsLocationConfiguration accessGrantsLocationConfiguration) {
            this.accessGrantsLocationConfiguration = accessGrantsLocationConfiguration;
            return this;
        }

        public final String getPermission() {
            return permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(Permission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getGrantScope() {
            return grantScope;
        }

        public final void setGrantScope(String grantScope) {
            this.grantScope = grantScope;
        }

        @Override
        public final Builder grantScope(String grantScope) {
            this.grantScope = grantScope;
            return this;
        }

        @Override
        public CreateAccessGrantResponse build() {
            return new CreateAccessGrantResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
