/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter that you can use to specify whether replica modification sync is enabled. S3 on Outposts replica
 * modification sync can help you keep object metadata synchronized between replicas and source objects. By default, S3
 * on Outposts replicates metadata from the source objects to the replicas only. When replica modification sync is
 * enabled, S3 on Outposts replicates metadata changes made to the replica copies back to the source object, making the
 * replication bidirectional.
 * </p>
 * <p>
 * To replicate object metadata modifications on replicas, you can specify this element and set the <code>Status</code>
 * of this element to <code>Enabled</code>.
 * </p>
 * <note>
 * <p>
 * You must enable replica modification sync on the source and destination buckets to replicate replica metadata changes
 * between the source and the replicas.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaModifications implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicaModifications.Builder, ReplicaModifications> {
    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(ReplicaModifications::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private ReplicaModifications(BuilderImpl builder) {
        this.status = builder.status;
    }

    /**
     * <p>
     * Specifies whether S3 on Outposts replicates modifications to object metadata on replicas.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReplicaModificationsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies whether S3 on Outposts replicates modifications to object metadata on replicas.
     * @see ReplicaModificationsStatus
     */
    public final ReplicaModificationsStatus status() {
        return ReplicaModificationsStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies whether S3 on Outposts replicates modifications to object metadata on replicas.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReplicaModificationsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies whether S3 on Outposts replicates modifications to object metadata on replicas.
     * @see ReplicaModificationsStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaModifications)) {
            return false;
        }
        ReplicaModifications other = (ReplicaModifications) obj;
        return Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicaModifications").add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicaModifications, T> g) {
        return obj -> g.apply((ReplicaModifications) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicaModifications> {
        /**
         * <p>
         * Specifies whether S3 on Outposts replicates modifications to object metadata on replicas.
         * </p>
         * 
         * @param status
         *        Specifies whether S3 on Outposts replicates modifications to object metadata on replicas.
         * @see ReplicaModificationsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicaModificationsStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies whether S3 on Outposts replicates modifications to object metadata on replicas.
         * </p>
         * 
         * @param status
         *        Specifies whether S3 on Outposts replicates modifications to object metadata on replicas.
         * @see ReplicaModificationsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicaModificationsStatus
         */
        Builder status(ReplicaModificationsStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaModifications model) {
            status(model.status);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReplicaModificationsStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ReplicaModifications build() {
            return new ReplicaModifications(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
