/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container element for the account-level Amazon S3 Storage Lens configuration.
 * </p>
 * <p>
 * For more information about S3 Storage Lens, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html">Assessing your storage activity and
 * usage with S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>. For a complete list of S3 Storage Lens metrics,
 * see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html">S3 Storage
 * Lens metrics glossary</a> in the <i>Amazon S3 User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountLevel implements SdkPojo, Serializable, ToCopyableBuilder<AccountLevel.Builder, AccountLevel> {
    private static final SdkField<ActivityMetrics> ACTIVITY_METRICS_FIELD = SdkField
            .<ActivityMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("ActivityMetrics")
            .getter(getter(AccountLevel::activityMetrics))
            .setter(setter(Builder::activityMetrics))
            .constructor(ActivityMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityMetrics")
                    .unmarshallLocationName("ActivityMetrics").build()).build();

    private static final SdkField<BucketLevel> BUCKET_LEVEL_FIELD = SdkField
            .<BucketLevel> builder(MarshallingType.SDK_POJO)
            .memberName("BucketLevel")
            .getter(getter(AccountLevel::bucketLevel))
            .setter(setter(Builder::bucketLevel))
            .constructor(BucketLevel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketLevel")
                    .unmarshallLocationName("BucketLevel").build()).build();

    private static final SdkField<AdvancedCostOptimizationMetrics> ADVANCED_COST_OPTIMIZATION_METRICS_FIELD = SdkField
            .<AdvancedCostOptimizationMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("AdvancedCostOptimizationMetrics")
            .getter(getter(AccountLevel::advancedCostOptimizationMetrics))
            .setter(setter(Builder::advancedCostOptimizationMetrics))
            .constructor(AdvancedCostOptimizationMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedCostOptimizationMetrics")
                    .unmarshallLocationName("AdvancedCostOptimizationMetrics").build()).build();

    private static final SdkField<AdvancedDataProtectionMetrics> ADVANCED_DATA_PROTECTION_METRICS_FIELD = SdkField
            .<AdvancedDataProtectionMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("AdvancedDataProtectionMetrics")
            .getter(getter(AccountLevel::advancedDataProtectionMetrics))
            .setter(setter(Builder::advancedDataProtectionMetrics))
            .constructor(AdvancedDataProtectionMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedDataProtectionMetrics")
                    .unmarshallLocationName("AdvancedDataProtectionMetrics").build()).build();

    private static final SdkField<DetailedStatusCodesMetrics> DETAILED_STATUS_CODES_METRICS_FIELD = SdkField
            .<DetailedStatusCodesMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("DetailedStatusCodesMetrics")
            .getter(getter(AccountLevel::detailedStatusCodesMetrics))
            .setter(setter(Builder::detailedStatusCodesMetrics))
            .constructor(DetailedStatusCodesMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatusCodesMetrics")
                    .unmarshallLocationName("DetailedStatusCodesMetrics").build()).build();

    private static final SdkField<StorageLensGroupLevel> STORAGE_LENS_GROUP_LEVEL_FIELD = SdkField
            .<StorageLensGroupLevel> builder(MarshallingType.SDK_POJO)
            .memberName("StorageLensGroupLevel")
            .getter(getter(AccountLevel::storageLensGroupLevel))
            .setter(setter(Builder::storageLensGroupLevel))
            .constructor(StorageLensGroupLevel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensGroupLevel")
                    .unmarshallLocationName("StorageLensGroupLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_METRICS_FIELD,
            BUCKET_LEVEL_FIELD, ADVANCED_COST_OPTIMIZATION_METRICS_FIELD, ADVANCED_DATA_PROTECTION_METRICS_FIELD,
            DETAILED_STATUS_CODES_METRICS_FIELD, STORAGE_LENS_GROUP_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ActivityMetrics activityMetrics;

    private final BucketLevel bucketLevel;

    private final AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics;

    private final AdvancedDataProtectionMetrics advancedDataProtectionMetrics;

    private final DetailedStatusCodesMetrics detailedStatusCodesMetrics;

    private final StorageLensGroupLevel storageLensGroupLevel;

    private AccountLevel(BuilderImpl builder) {
        this.activityMetrics = builder.activityMetrics;
        this.bucketLevel = builder.bucketLevel;
        this.advancedCostOptimizationMetrics = builder.advancedCostOptimizationMetrics;
        this.advancedDataProtectionMetrics = builder.advancedDataProtectionMetrics;
        this.detailedStatusCodesMetrics = builder.detailedStatusCodesMetrics;
        this.storageLensGroupLevel = builder.storageLensGroupLevel;
    }

    /**
     * <p>
     * A container element for S3 Storage Lens activity metrics.
     * </p>
     * 
     * @return A container element for S3 Storage Lens activity metrics.
     */
    public final ActivityMetrics activityMetrics() {
        return activityMetrics;
    }

    /**
     * <p>
     * A container element for the S3 Storage Lens bucket-level configuration.
     * </p>
     * 
     * @return A container element for the S3 Storage Lens bucket-level configuration.
     */
    public final BucketLevel bucketLevel() {
        return bucketLevel;
    }

    /**
     * <p>
     * A container element for S3 Storage Lens advanced cost-optimization metrics.
     * </p>
     * 
     * @return A container element for S3 Storage Lens advanced cost-optimization metrics.
     */
    public final AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics() {
        return advancedCostOptimizationMetrics;
    }

    /**
     * <p>
     * A container element for S3 Storage Lens advanced data-protection metrics.
     * </p>
     * 
     * @return A container element for S3 Storage Lens advanced data-protection metrics.
     */
    public final AdvancedDataProtectionMetrics advancedDataProtectionMetrics() {
        return advancedDataProtectionMetrics;
    }

    /**
     * <p>
     * A container element for detailed status code metrics.
     * </p>
     * 
     * @return A container element for detailed status code metrics.
     */
    public final DetailedStatusCodesMetrics detailedStatusCodesMetrics() {
        return detailedStatusCodesMetrics;
    }

    /**
     * <p>
     * A container element for S3 Storage Lens groups metrics.
     * </p>
     * 
     * @return A container element for S3 Storage Lens groups metrics.
     */
    public final StorageLensGroupLevel storageLensGroupLevel() {
        return storageLensGroupLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activityMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(bucketLevel());
        hashCode = 31 * hashCode + Objects.hashCode(advancedCostOptimizationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(advancedDataProtectionMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(detailedStatusCodesMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(storageLensGroupLevel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountLevel)) {
            return false;
        }
        AccountLevel other = (AccountLevel) obj;
        return Objects.equals(activityMetrics(), other.activityMetrics()) && Objects.equals(bucketLevel(), other.bucketLevel())
                && Objects.equals(advancedCostOptimizationMetrics(), other.advancedCostOptimizationMetrics())
                && Objects.equals(advancedDataProtectionMetrics(), other.advancedDataProtectionMetrics())
                && Objects.equals(detailedStatusCodesMetrics(), other.detailedStatusCodesMetrics())
                && Objects.equals(storageLensGroupLevel(), other.storageLensGroupLevel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountLevel").add("ActivityMetrics", activityMetrics()).add("BucketLevel", bucketLevel())
                .add("AdvancedCostOptimizationMetrics", advancedCostOptimizationMetrics())
                .add("AdvancedDataProtectionMetrics", advancedDataProtectionMetrics())
                .add("DetailedStatusCodesMetrics", detailedStatusCodesMetrics())
                .add("StorageLensGroupLevel", storageLensGroupLevel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivityMetrics":
            return Optional.ofNullable(clazz.cast(activityMetrics()));
        case "BucketLevel":
            return Optional.ofNullable(clazz.cast(bucketLevel()));
        case "AdvancedCostOptimizationMetrics":
            return Optional.ofNullable(clazz.cast(advancedCostOptimizationMetrics()));
        case "AdvancedDataProtectionMetrics":
            return Optional.ofNullable(clazz.cast(advancedDataProtectionMetrics()));
        case "DetailedStatusCodesMetrics":
            return Optional.ofNullable(clazz.cast(detailedStatusCodesMetrics()));
        case "StorageLensGroupLevel":
            return Optional.ofNullable(clazz.cast(storageLensGroupLevel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActivityMetrics", ACTIVITY_METRICS_FIELD);
        map.put("BucketLevel", BUCKET_LEVEL_FIELD);
        map.put("AdvancedCostOptimizationMetrics", ADVANCED_COST_OPTIMIZATION_METRICS_FIELD);
        map.put("AdvancedDataProtectionMetrics", ADVANCED_DATA_PROTECTION_METRICS_FIELD);
        map.put("DetailedStatusCodesMetrics", DETAILED_STATUS_CODES_METRICS_FIELD);
        map.put("StorageLensGroupLevel", STORAGE_LENS_GROUP_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountLevel, T> g) {
        return obj -> g.apply((AccountLevel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountLevel> {
        /**
         * <p>
         * A container element for S3 Storage Lens activity metrics.
         * </p>
         * 
         * @param activityMetrics
         *        A container element for S3 Storage Lens activity metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityMetrics(ActivityMetrics activityMetrics);

        /**
         * <p>
         * A container element for S3 Storage Lens activity metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActivityMetrics.Builder} avoiding the
         * need to create one manually via {@link ActivityMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActivityMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #activityMetrics(ActivityMetrics)}.
         * 
         * @param activityMetrics
         *        a consumer that will call methods on {@link ActivityMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityMetrics(ActivityMetrics)
         */
        default Builder activityMetrics(Consumer<ActivityMetrics.Builder> activityMetrics) {
            return activityMetrics(ActivityMetrics.builder().applyMutation(activityMetrics).build());
        }

        /**
         * <p>
         * A container element for the S3 Storage Lens bucket-level configuration.
         * </p>
         * 
         * @param bucketLevel
         *        A container element for the S3 Storage Lens bucket-level configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketLevel(BucketLevel bucketLevel);

        /**
         * <p>
         * A container element for the S3 Storage Lens bucket-level configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link BucketLevel.Builder} avoiding the need to
         * create one manually via {@link BucketLevel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BucketLevel.Builder#build()} is called immediately and its result
         * is passed to {@link #bucketLevel(BucketLevel)}.
         * 
         * @param bucketLevel
         *        a consumer that will call methods on {@link BucketLevel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketLevel(BucketLevel)
         */
        default Builder bucketLevel(Consumer<BucketLevel.Builder> bucketLevel) {
            return bucketLevel(BucketLevel.builder().applyMutation(bucketLevel).build());
        }

        /**
         * <p>
         * A container element for S3 Storage Lens advanced cost-optimization metrics.
         * </p>
         * 
         * @param advancedCostOptimizationMetrics
         *        A container element for S3 Storage Lens advanced cost-optimization metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedCostOptimizationMetrics(AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics);

        /**
         * <p>
         * A container element for S3 Storage Lens advanced cost-optimization metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdvancedCostOptimizationMetrics.Builder}
         * avoiding the need to create one manually via {@link AdvancedCostOptimizationMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdvancedCostOptimizationMetrics.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #advancedCostOptimizationMetrics(AdvancedCostOptimizationMetrics)}.
         * 
         * @param advancedCostOptimizationMetrics
         *        a consumer that will call methods on {@link AdvancedCostOptimizationMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedCostOptimizationMetrics(AdvancedCostOptimizationMetrics)
         */
        default Builder advancedCostOptimizationMetrics(
                Consumer<AdvancedCostOptimizationMetrics.Builder> advancedCostOptimizationMetrics) {
            return advancedCostOptimizationMetrics(AdvancedCostOptimizationMetrics.builder()
                    .applyMutation(advancedCostOptimizationMetrics).build());
        }

        /**
         * <p>
         * A container element for S3 Storage Lens advanced data-protection metrics.
         * </p>
         * 
         * @param advancedDataProtectionMetrics
         *        A container element for S3 Storage Lens advanced data-protection metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedDataProtectionMetrics(AdvancedDataProtectionMetrics advancedDataProtectionMetrics);

        /**
         * <p>
         * A container element for S3 Storage Lens advanced data-protection metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdvancedDataProtectionMetrics.Builder}
         * avoiding the need to create one manually via {@link AdvancedDataProtectionMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdvancedDataProtectionMetrics.Builder#build()} is called
         * immediately and its result is passed to {@link #advancedDataProtectionMetrics(AdvancedDataProtectionMetrics)}.
         * 
         * @param advancedDataProtectionMetrics
         *        a consumer that will call methods on {@link AdvancedDataProtectionMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedDataProtectionMetrics(AdvancedDataProtectionMetrics)
         */
        default Builder advancedDataProtectionMetrics(
                Consumer<AdvancedDataProtectionMetrics.Builder> advancedDataProtectionMetrics) {
            return advancedDataProtectionMetrics(AdvancedDataProtectionMetrics.builder()
                    .applyMutation(advancedDataProtectionMetrics).build());
        }

        /**
         * <p>
         * A container element for detailed status code metrics.
         * </p>
         * 
         * @param detailedStatusCodesMetrics
         *        A container element for detailed status code metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedStatusCodesMetrics(DetailedStatusCodesMetrics detailedStatusCodesMetrics);

        /**
         * <p>
         * A container element for detailed status code metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetailedStatusCodesMetrics.Builder}
         * avoiding the need to create one manually via {@link DetailedStatusCodesMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetailedStatusCodesMetrics.Builder#build()} is called immediately
         * and its result is passed to {@link #detailedStatusCodesMetrics(DetailedStatusCodesMetrics)}.
         * 
         * @param detailedStatusCodesMetrics
         *        a consumer that will call methods on {@link DetailedStatusCodesMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detailedStatusCodesMetrics(DetailedStatusCodesMetrics)
         */
        default Builder detailedStatusCodesMetrics(Consumer<DetailedStatusCodesMetrics.Builder> detailedStatusCodesMetrics) {
            return detailedStatusCodesMetrics(DetailedStatusCodesMetrics.builder().applyMutation(detailedStatusCodesMetrics)
                    .build());
        }

        /**
         * <p>
         * A container element for S3 Storage Lens groups metrics.
         * </p>
         * 
         * @param storageLensGroupLevel
         *        A container element for S3 Storage Lens groups metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLensGroupLevel(StorageLensGroupLevel storageLensGroupLevel);

        /**
         * <p>
         * A container element for S3 Storage Lens groups metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageLensGroupLevel.Builder} avoiding
         * the need to create one manually via {@link StorageLensGroupLevel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageLensGroupLevel.Builder#build()} is called immediately and
         * its result is passed to {@link #storageLensGroupLevel(StorageLensGroupLevel)}.
         * 
         * @param storageLensGroupLevel
         *        a consumer that will call methods on {@link StorageLensGroupLevel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageLensGroupLevel(StorageLensGroupLevel)
         */
        default Builder storageLensGroupLevel(Consumer<StorageLensGroupLevel.Builder> storageLensGroupLevel) {
            return storageLensGroupLevel(StorageLensGroupLevel.builder().applyMutation(storageLensGroupLevel).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ActivityMetrics activityMetrics;

        private BucketLevel bucketLevel;

        private AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics;

        private AdvancedDataProtectionMetrics advancedDataProtectionMetrics;

        private DetailedStatusCodesMetrics detailedStatusCodesMetrics;

        private StorageLensGroupLevel storageLensGroupLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountLevel model) {
            activityMetrics(model.activityMetrics);
            bucketLevel(model.bucketLevel);
            advancedCostOptimizationMetrics(model.advancedCostOptimizationMetrics);
            advancedDataProtectionMetrics(model.advancedDataProtectionMetrics);
            detailedStatusCodesMetrics(model.detailedStatusCodesMetrics);
            storageLensGroupLevel(model.storageLensGroupLevel);
        }

        public final ActivityMetrics.Builder getActivityMetrics() {
            return activityMetrics != null ? activityMetrics.toBuilder() : null;
        }

        public final void setActivityMetrics(ActivityMetrics.BuilderImpl activityMetrics) {
            this.activityMetrics = activityMetrics != null ? activityMetrics.build() : null;
        }

        @Override
        public final Builder activityMetrics(ActivityMetrics activityMetrics) {
            this.activityMetrics = activityMetrics;
            return this;
        }

        public final BucketLevel.Builder getBucketLevel() {
            return bucketLevel != null ? bucketLevel.toBuilder() : null;
        }

        public final void setBucketLevel(BucketLevel.BuilderImpl bucketLevel) {
            this.bucketLevel = bucketLevel != null ? bucketLevel.build() : null;
        }

        @Override
        public final Builder bucketLevel(BucketLevel bucketLevel) {
            this.bucketLevel = bucketLevel;
            return this;
        }

        public final AdvancedCostOptimizationMetrics.Builder getAdvancedCostOptimizationMetrics() {
            return advancedCostOptimizationMetrics != null ? advancedCostOptimizationMetrics.toBuilder() : null;
        }

        public final void setAdvancedCostOptimizationMetrics(
                AdvancedCostOptimizationMetrics.BuilderImpl advancedCostOptimizationMetrics) {
            this.advancedCostOptimizationMetrics = advancedCostOptimizationMetrics != null ? advancedCostOptimizationMetrics
                    .build() : null;
        }

        @Override
        public final Builder advancedCostOptimizationMetrics(AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics) {
            this.advancedCostOptimizationMetrics = advancedCostOptimizationMetrics;
            return this;
        }

        public final AdvancedDataProtectionMetrics.Builder getAdvancedDataProtectionMetrics() {
            return advancedDataProtectionMetrics != null ? advancedDataProtectionMetrics.toBuilder() : null;
        }

        public final void setAdvancedDataProtectionMetrics(AdvancedDataProtectionMetrics.BuilderImpl advancedDataProtectionMetrics) {
            this.advancedDataProtectionMetrics = advancedDataProtectionMetrics != null ? advancedDataProtectionMetrics.build()
                    : null;
        }

        @Override
        public final Builder advancedDataProtectionMetrics(AdvancedDataProtectionMetrics advancedDataProtectionMetrics) {
            this.advancedDataProtectionMetrics = advancedDataProtectionMetrics;
            return this;
        }

        public final DetailedStatusCodesMetrics.Builder getDetailedStatusCodesMetrics() {
            return detailedStatusCodesMetrics != null ? detailedStatusCodesMetrics.toBuilder() : null;
        }

        public final void setDetailedStatusCodesMetrics(DetailedStatusCodesMetrics.BuilderImpl detailedStatusCodesMetrics) {
            this.detailedStatusCodesMetrics = detailedStatusCodesMetrics != null ? detailedStatusCodesMetrics.build() : null;
        }

        @Override
        public final Builder detailedStatusCodesMetrics(DetailedStatusCodesMetrics detailedStatusCodesMetrics) {
            this.detailedStatusCodesMetrics = detailedStatusCodesMetrics;
            return this;
        }

        public final StorageLensGroupLevel.Builder getStorageLensGroupLevel() {
            return storageLensGroupLevel != null ? storageLensGroupLevel.toBuilder() : null;
        }

        public final void setStorageLensGroupLevel(StorageLensGroupLevel.BuilderImpl storageLensGroupLevel) {
            this.storageLensGroupLevel = storageLensGroupLevel != null ? storageLensGroupLevel.build() : null;
        }

        @Override
        public final Builder storageLensGroupLevel(StorageLensGroupLevel storageLensGroupLevel) {
            this.storageLensGroupLevel = storageLensGroupLevel;
            return this;
        }

        @Override
        public AccountLevel build() {
            return new AccountLevel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
