/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataAccessRequest extends S3ControlRequest implements
        ToCopyableBuilder<GetDataAccessRequest.Builder, GetDataAccessRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(GetDataAccessRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Target")
            .getter(getter(GetDataAccessRequest::target))
            .setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("target")
                    .unmarshallLocationName("target").build()).build();

    private static final SdkField<String> PERMISSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Permission")
            .getter(getter(GetDataAccessRequest::permissionAsString))
            .setter(setter(Builder::permission))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("permission")
                    .unmarshallLocationName("permission").build()).build();

    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationSeconds")
            .getter(getter(GetDataAccessRequest::durationSeconds))
            .setter(setter(Builder::durationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("durationSeconds")
                    .unmarshallLocationName("durationSeconds").build()).build();

    private static final SdkField<String> PRIVILEGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Privilege")
            .getter(getter(GetDataAccessRequest::privilegeAsString))
            .setter(setter(Builder::privilege))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("privilege")
                    .unmarshallLocationName("privilege").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetType")
            .getter(getter(GetDataAccessRequest::targetTypeAsString))
            .setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetType")
                    .unmarshallLocationName("targetType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            TARGET_FIELD, PERMISSION_FIELD, DURATION_SECONDS_FIELD, PRIVILEGE_FIELD, TARGET_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String target;

    private final String permission;

    private final Integer durationSeconds;

    private final String privilege;

    private final String targetType;

    private GetDataAccessRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.target = builder.target;
        this.permission = builder.permission;
        this.durationSeconds = builder.durationSeconds;
        this.privilege = builder.privilege;
        this.targetType = builder.targetType;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the S3 Access Grants instance.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the S3 Access Grants instance.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The S3 URI path of the data to which you are requesting temporary access credentials. If the requesting account
     * has an access grant for this data, S3 Access Grants vends temporary access credentials in the response.
     * </p>
     * 
     * @return The S3 URI path of the data to which you are requesting temporary access credentials. If the requesting
     *         account has an access grant for this data, S3 Access Grants vends temporary access credentials in the
     *         response.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * The type of permission granted to your S3 data, which can be set to one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READ</code> – Grant read-only access to the S3 data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WRITE</code> – Grant write-only access to the S3 data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READWRITE</code> – Grant both read and write access to the S3 data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionAsString}.
     * </p>
     * 
     * @return The type of permission granted to your S3 data, which can be set to one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READ</code> – Grant read-only access to the S3 data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WRITE</code> – Grant write-only access to the S3 data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READWRITE</code> – Grant both read and write access to the S3 data.
     *         </p>
     *         </li>
     * @see Permission
     */
    public final Permission permission() {
        return Permission.fromValue(permission);
    }

    /**
     * <p>
     * The type of permission granted to your S3 data, which can be set to one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READ</code> – Grant read-only access to the S3 data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WRITE</code> – Grant write-only access to the S3 data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READWRITE</code> – Grant both read and write access to the S3 data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionAsString}.
     * </p>
     * 
     * @return The type of permission granted to your S3 data, which can be set to one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READ</code> – Grant read-only access to the S3 data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WRITE</code> – Grant write-only access to the S3 data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READWRITE</code> – Grant both read and write access to the S3 data.
     *         </p>
     *         </li>
     * @see Permission
     */
    public final String permissionAsString() {
        return permission;
    }

    /**
     * <p>
     * The session duration, in seconds, of the temporary access credential that S3 Access Grants vends to the grantee
     * or client application. The default value is 1 hour, but the grantee can specify a range from 900 seconds (15
     * minutes) up to 43200 seconds (12 hours). If the grantee requests a value higher than this maximum, the operation
     * fails.
     * </p>
     * 
     * @return The session duration, in seconds, of the temporary access credential that S3 Access Grants vends to the
     *         grantee or client application. The default value is 1 hour, but the grantee can specify a range from 900
     *         seconds (15 minutes) up to 43200 seconds (12 hours). If the grantee requests a value higher than this
     *         maximum, the operation fails.
     */
    public final Integer durationSeconds() {
        return durationSeconds;
    }

    /**
     * <p>
     * The scope of the temporary access credential that S3 Access Grants vends to the grantee or client application.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Default</code> – The scope of the returned temporary access token is the scope of the grant that is closest
     * to the target scope.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Minimal</code> – The scope of the returned temporary access token is the same as the requested target scope
     * as long as the requested scope is the same as or a subset of the grant scope.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privilege} will
     * return {@link Privilege#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #privilegeAsString}.
     * </p>
     * 
     * @return The scope of the temporary access credential that S3 Access Grants vends to the grantee or client
     *         application. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Default</code> – The scope of the returned temporary access token is the scope of the grant that is
     *         closest to the target scope.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Minimal</code> – The scope of the returned temporary access token is the same as the requested
     *         target scope as long as the requested scope is the same as or a subset of the grant scope.
     *         </p>
     *         </li>
     * @see Privilege
     */
    public final Privilege privilege() {
        return Privilege.fromValue(privilege);
    }

    /**
     * <p>
     * The scope of the temporary access credential that S3 Access Grants vends to the grantee or client application.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Default</code> – The scope of the returned temporary access token is the scope of the grant that is closest
     * to the target scope.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Minimal</code> – The scope of the returned temporary access token is the same as the requested target scope
     * as long as the requested scope is the same as or a subset of the grant scope.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privilege} will
     * return {@link Privilege#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #privilegeAsString}.
     * </p>
     * 
     * @return The scope of the temporary access credential that S3 Access Grants vends to the grantee or client
     *         application. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Default</code> – The scope of the returned temporary access token is the scope of the grant that is
     *         closest to the target scope.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Minimal</code> – The scope of the returned temporary access token is the same as the requested
     *         target scope as long as the requested scope is the same as or a subset of the grant scope.
     *         </p>
     *         </li>
     * @see Privilege
     */
    public final String privilegeAsString() {
        return privilege;
    }

    /**
     * <p>
     * The type of <code>Target</code>. The only possible value is <code>Object</code>. Pass this value if the target
     * data that you would like to access is a path to an object. Do not pass this value if the target data is a bucket
     * or a bucket and a prefix.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link S3PrefixType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of <code>Target</code>. The only possible value is <code>Object</code>. Pass this value if the
     *         target data that you would like to access is a path to an object. Do not pass this value if the target
     *         data is a bucket or a bucket and a prefix.
     * @see S3PrefixType
     */
    public final S3PrefixType targetType() {
        return S3PrefixType.fromValue(targetType);
    }

    /**
     * <p>
     * The type of <code>Target</code>. The only possible value is <code>Object</code>. Pass this value if the target
     * data that you would like to access is a path to an object. Do not pass this value if the target data is a bucket
     * or a bucket and a prefix.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link S3PrefixType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of <code>Target</code>. The only possible value is <code>Object</code>. Pass this value if the
     *         target data that you would like to access is a path to an object. Do not pass this value if the target
     *         data is a bucket or a bucket and a prefix.
     * @see S3PrefixType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(privilegeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataAccessRequest)) {
            return false;
        }
        GetDataAccessRequest other = (GetDataAccessRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(target(), other.target())
                && Objects.equals(permissionAsString(), other.permissionAsString())
                && Objects.equals(durationSeconds(), other.durationSeconds())
                && Objects.equals(privilegeAsString(), other.privilegeAsString())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataAccessRequest").add("AccountId", accountId()).add("Target", target())
                .add("Permission", permissionAsString()).add("DurationSeconds", durationSeconds())
                .add("Privilege", privilegeAsString()).add("TargetType", targetTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "Permission":
            return Optional.ofNullable(clazz.cast(permissionAsString()));
        case "DurationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        case "Privilege":
            return Optional.ofNullable(clazz.cast(privilegeAsString()));
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x-amz-account-id", ACCOUNT_ID_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("permission", PERMISSION_FIELD);
        map.put("durationSeconds", DURATION_SECONDS_FIELD);
        map.put("privilege", PRIVILEGE_FIELD);
        map.put("targetType", TARGET_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataAccessRequest, T> g) {
        return obj -> g.apply((GetDataAccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDataAccessRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID of the S3 Access Grants instance.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The S3 URI path of the data to which you are requesting temporary access credentials. If the requesting
         * account has an access grant for this data, S3 Access Grants vends temporary access credentials in the
         * response.
         * </p>
         * 
         * @param target
         *        The S3 URI path of the data to which you are requesting temporary access credentials. If the
         *        requesting account has an access grant for this data, S3 Access Grants vends temporary access
         *        credentials in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The type of permission granted to your S3 data, which can be set to one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READ</code> – Grant read-only access to the S3 data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WRITE</code> – Grant write-only access to the S3 data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READWRITE</code> – Grant both read and write access to the S3 data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permission
         *        The type of permission granted to your S3 data, which can be set to one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READ</code> – Grant read-only access to the S3 data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WRITE</code> – Grant write-only access to the S3 data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READWRITE</code> – Grant both read and write access to the S3 data.
         *        </p>
         *        </li>
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder permission(String permission);

        /**
         * <p>
         * The type of permission granted to your S3 data, which can be set to one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READ</code> – Grant read-only access to the S3 data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WRITE</code> – Grant write-only access to the S3 data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READWRITE</code> – Grant both read and write access to the S3 data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permission
         *        The type of permission granted to your S3 data, which can be set to one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READ</code> – Grant read-only access to the S3 data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WRITE</code> – Grant write-only access to the S3 data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READWRITE</code> – Grant both read and write access to the S3 data.
         *        </p>
         *        </li>
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder permission(Permission permission);

        /**
         * <p>
         * The session duration, in seconds, of the temporary access credential that S3 Access Grants vends to the
         * grantee or client application. The default value is 1 hour, but the grantee can specify a range from 900
         * seconds (15 minutes) up to 43200 seconds (12 hours). If the grantee requests a value higher than this
         * maximum, the operation fails.
         * </p>
         * 
         * @param durationSeconds
         *        The session duration, in seconds, of the temporary access credential that S3 Access Grants vends to
         *        the grantee or client application. The default value is 1 hour, but the grantee can specify a range
         *        from 900 seconds (15 minutes) up to 43200 seconds (12 hours). If the grantee requests a value higher
         *        than this maximum, the operation fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);

        /**
         * <p>
         * The scope of the temporary access credential that S3 Access Grants vends to the grantee or client
         * application.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Default</code> – The scope of the returned temporary access token is the scope of the grant that is
         * closest to the target scope.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Minimal</code> – The scope of the returned temporary access token is the same as the requested target
         * scope as long as the requested scope is the same as or a subset of the grant scope.
         * </p>
         * </li>
         * </ul>
         * 
         * @param privilege
         *        The scope of the temporary access credential that S3 Access Grants vends to the grantee or client
         *        application. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Default</code> – The scope of the returned temporary access token is the scope of the grant that
         *        is closest to the target scope.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Minimal</code> – The scope of the returned temporary access token is the same as the requested
         *        target scope as long as the requested scope is the same as or a subset of the grant scope.
         *        </p>
         *        </li>
         * @see Privilege
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Privilege
         */
        Builder privilege(String privilege);

        /**
         * <p>
         * The scope of the temporary access credential that S3 Access Grants vends to the grantee or client
         * application.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Default</code> – The scope of the returned temporary access token is the scope of the grant that is
         * closest to the target scope.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Minimal</code> – The scope of the returned temporary access token is the same as the requested target
         * scope as long as the requested scope is the same as or a subset of the grant scope.
         * </p>
         * </li>
         * </ul>
         * 
         * @param privilege
         *        The scope of the temporary access credential that S3 Access Grants vends to the grantee or client
         *        application. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Default</code> – The scope of the returned temporary access token is the scope of the grant that
         *        is closest to the target scope.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Minimal</code> – The scope of the returned temporary access token is the same as the requested
         *        target scope as long as the requested scope is the same as or a subset of the grant scope.
         *        </p>
         *        </li>
         * @see Privilege
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Privilege
         */
        Builder privilege(Privilege privilege);

        /**
         * <p>
         * The type of <code>Target</code>. The only possible value is <code>Object</code>. Pass this value if the
         * target data that you would like to access is a path to an object. Do not pass this value if the target data
         * is a bucket or a bucket and a prefix.
         * </p>
         * 
         * @param targetType
         *        The type of <code>Target</code>. The only possible value is <code>Object</code>. Pass this value if
         *        the target data that you would like to access is a path to an object. Do not pass this value if the
         *        target data is a bucket or a bucket and a prefix.
         * @see S3PrefixType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3PrefixType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The type of <code>Target</code>. The only possible value is <code>Object</code>. Pass this value if the
         * target data that you would like to access is a path to an object. Do not pass this value if the target data
         * is a bucket or a bucket and a prefix.
         * </p>
         * 
         * @param targetType
         *        The type of <code>Target</code>. The only possible value is <code>Object</code>. Pass this value if
         *        the target data that you would like to access is a path to an object. Do not pass this value if the
         *        target data is a bucket or a bucket and a prefix.
         * @see S3PrefixType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3PrefixType
         */
        Builder targetType(S3PrefixType targetType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private String target;

        private String permission;

        private Integer durationSeconds;

        private String privilege;

        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataAccessRequest model) {
            super(model);
            accountId(model.accountId);
            target(model.target);
            permission(model.permission);
            durationSeconds(model.durationSeconds);
            privilege(model.privilege);
            targetType(model.targetType);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getPermission() {
            return permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(Permission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final String getPrivilege() {
            return privilege;
        }

        public final void setPrivilege(String privilege) {
            this.privilege = privilege;
        }

        @Override
        public final Builder privilege(String privilege) {
            this.privilege = privilege;
            return this;
        }

        @Override
        public final Builder privilege(Privilege privilege) {
            this.privilege(privilege == null ? null : privilege.toString());
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(S3PrefixType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDataAccessRequest build() {
            return new GetDataAccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
